<?php
    $host = 'localhost';
    $dbname = 'devaem_orcamento_participativo_pesquisa';
    $username = 'devaem_orcamento_participativo_pesquisa';
    $password = 'devaem_orcamento_participativo_pesquisa';
    
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
        $opcoes = $pdo->query("SELECT answer FROM wH2O1iu9h_ayspoll_answers");

        $opArray = [];
        while ($op = $opcoes->fetch(PDO::FETCH_ASSOC)) {
            $opArray[] = $op['answer'];
        }

        $opArray = array_map('trim', $opArray);
        $palavrass = $opArray;
        $encontrado = false;
    
        function localizarPalavras(array $palavras, string $texto): array {
            $encontradass = [];
        
            // Normaliza o texto (sem acento, lowercase)
            $textoNormalizado = normalizar($texto);
        
            foreach ($palavras as $palavra) {
                $palavraNormalizada = normalizar($palavra);
        
                if (stripos($textoNormalizado, $palavraNormalizada) !== false) {
                    $encontradass[] = $palavra;
                }
            }
        
            return $encontradass;
        }
        
        function normalizar(string $texto): string {
            // Remove acentos e converte para minúsculas
            $texto = mb_strtolower($texto, 'UTF-8');
            $texto = preg_replace('/[áàãâä]/u', 'a', $texto);
            $texto = preg_replace('/[éèêë]/u', 'e', $texto);
            $texto = preg_replace('/[íìîï]/u', 'i', $texto);
            $texto = preg_replace('/[óòõôö]/u', 'o', $texto);
            $texto = preg_replace('/[úùûü]/u', 'u', $texto);
            $texto = preg_replace('/[ç]/u', 'c', $texto);
            return $texto;
        }
    
        /*
        $stmt = $pdo->query("SELECT * FROM poll_results_export__5_ ORDER BY id ASC");

        $x = 1;
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            //echo "ID: " . $row['id'] . "<br>";
            //echo "answer: " . $row['answer'] . "<br>";
            //echo "vote_date: " . $row['vote_date'] . "<br><br>";
        
            // Garantindo que 'answer' é uma string antes de fazer a busca
            $answer = (string) $row['answer'];
        
            // Verifica se alguma palavra está presente
            $encontradas = array_filter($palavrass, function ($p) use ($answer) { return stripos($answer, $p) !== false; });
    
    
            $reports = $pdo->prepare("SELECT id, vote_date, multi_answer_id FROM wH2O1iu9h_ayspoll_reports WHERE vote_date = ?");
            $reports->execute([$row['vote_date']]);
            $report = $reports->fetch(PDO::FETCH_ASSOC);
            
            if($report['multi_answer_id'] == "[]"){ 
                echo "<b style='color:red'>(".$x.") ID: ". $row['id'] ."</b><br>";
                echo "<b style='color:red'>answer: ". $row['answer'] ."</b><br>";
                echo "<b style='color:red'>vote_date: ". $row['vote_date'] ."</b><br>";
        
                $resultado = localizarPalavras($opArray, $row['answer']);

                if (!empty($resultado) && is_array($resultado)) {
                    echo '<b>Palavras encontradas:</b><br> <a style="color:green">["' . implode('", "', $resultado) . '"]</a><br>';
                    
                    // Array com os nomes a serem buscados
                    $noms = '["' . implode('","', $resultado) . '"]';
                    $noms = json_decode($noms, true);
                    
                    // Monta os placeholders para a cláusula IN (?, ?, ?)
                    $placeholders = rtrim(str_repeat('?,', count($noms)), ',');
                    
                    $categorias = $pdo->prepare("SELECT id, answer FROM wH2O1iu9h_ayspoll_answers WHERE answer IN ($placeholders)");
                    $categorias->execute($noms);
                    $resultados = $categorias->fetchAll(PDO::FETCH_ASSOC);

                    $results_id = [];
                    foreach ($resultados as $linha) {
                        $results_id[] = $linha['id'];
                    }
                    $valores_corrigidos = '["' . implode('","', $results_id) . '"]';

                    echo "UPDATE wH2O1iu9h_ayspoll_reports SET multi_answer_id = '{$valores_corrigidos}' WHERE id = '{$report['id']}'; <br>";
                    
                } else {
                    echo "<b>Nenhuma palavra encontrada.</b><br>";
                }

                echo "<hr>";
                $x++;
            }

            //echo "<hr>";
        }*/
        
        
        
        /*
        $stmt = $pdo->query("SELECT * FROM wH2O1iu9h_ayspoll_reports ORDER BY id ASC");
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $row['other_info'] = json_decode($row['other_info'], true);
            $regiao = $row['other_info']['Região'];
            
            echo "Região: " . $regiao . "<br>";
            echo "multi_answer_id: " . $row['multi_answer_id'] . "<br>";
            
            
            echo "<hr>";
        }
        */
        
        
        
        
        
        function getGategoria($pdo, $id) {
            $stmt = $pdo->prepare("SELECT answer FROM wH2O1iu9h_ayspoll_answers WHERE id = :id LIMIT 1");
            $stmt->execute(['id' => $id]);
            $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
            return $resultado ? $resultado['answer'] : $id;
        }
        
        
        
    $stmt = $pdo->query("SELECT * FROM wH2O1iu9h_ayspoll_reports ORDER BY id ASC");
    //$stmt = $pdo->query("SELECT * FROM dados_sem_edicao ORDER BY id ASC");

  
  

$contagem = []; // [regiao][id] => qtd
$totalPorRegiao = []; // [regiao] => total de IDs
$totalGeral = 0; // total geral de IDs
$totalPorIDGeral = []; // [id] => total geral por ID

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $other_info = json_decode($row['other_info'], true);
    $multi_answer_ids = json_decode($row['multi_answer_id'], true);

    if (!is_array($other_info) || !isset($other_info['Região']) || !is_array($multi_answer_ids)) {
        continue;
    }

    $regiao = $other_info['Região'];

    if (!isset($contagem[$regiao])) {
        $contagem[$regiao] = [];
        $totalPorRegiao[$regiao] = 0;
    }

    foreach ($multi_answer_ids as $id) {
        // Por região
        if (!isset($contagem[$regiao][$id])) {
            $contagem[$regiao][$id] = 0;
        }
        $contagem[$regiao][$id]++;
        $totalPorRegiao[$regiao]++;

        // Total geral
        if (!isset($totalPorIDGeral[$id])) {
            $totalPorIDGeral[$id] = 0;
        }
        $totalPorIDGeral[$id]++;
        $totalGeral++;
    }
}

// Ordenar regiões
ksort($contagem);

// Mostrar contagem por região
foreach ($contagem as $regiao => $ids) {
    echo "<h3>$regiao</h3><ul>";

    foreach ($ids as $id => $qtd) {
        $porcentagemLocal = ($qtd / $totalPorRegiao[$regiao]) * 100;
        $porcentagemGeral = ($qtd / $totalGeral) * 100;

        //echo "<li>".getGategoria($pdo, $id)." recebeu $qtd votos — <strong>" . number_format($porcentagemLocal, 2) . "%</strong> da região, <strong>" . number_format($porcentagemGeral, 2) . "%</strong> do total</li>";
        echo "<li>".getGategoria($pdo, $id)." recebeu $qtd votos — <strong>" . number_format($porcentagemLocal, 2) . "%</strong> da região</li>";
    }

    echo "</ul><strong>Total de votos na $regiao: {$totalPorRegiao[$regiao]}</strong><hr>";
}

// Total geral
echo "<h2>Total geral de votos em todas as regiões: $totalGeral</h2>";

// Top 3 geral
arsort($totalPorIDGeral);
$top3 = array_slice($totalPorIDGeral, 0, 3, true);

echo "<h2>Top 3 opções mais votadas no geral:</h2><ul>";
foreach ($top3 as $id => $qtd) {
    $porcentagem = ($qtd / $totalGeral) * 100;
    echo "<li>".getGategoria($pdo, $id)." recebeu $qtd votos — <strong>" . number_format($porcentagem, 2) . "%</strong> do total geral</li>";
}
echo "</ul>";

// Porcentagem geral por ID
echo "<h2>Porcentagem geral de todos os votos:</h2><ul>";
foreach ($totalPorIDGeral as $id => $qtd) {
    $porcentagemGeral = ($qtd / $totalGeral) * 100;
    echo "<li> (".$qtd.") - ".getGategoria($pdo, $id).": <strong>" . number_format($porcentagemGeral, 2) . "%</strong> do total geral</li>";
}
echo "</ul>";


        
        
        
        
        
        
        
        
        
        
    } catch (PDOException $e) {
        echo "Erro: " . $e->getMessage();
    }
?>