(function ($) {
    'use strict';
    $(document).find('.ays-show-results').on('click', function (e) {
        $(document).find('#ays-results-modal').fadeIn();
        $(document).find('div.ays-poll-preloader').css('display', 'flex');

        var $this = $(this);
        var readStatus = $this.parents('tr').find("td .unread-result-badge");
        var rangeAnswer = '';
        if ($(this).attr('data-poll-type') && $(this).attr('data-poll-type') == 'range') {
            rangeAnswer = $(this).text();
        }

        $('li.toplevel_page_poll-maker-ays .apm-badge.badge-danger').each(function () {
            var $unreadCounter = $(this);

            if ($unreadCounter.text() != 0) {
                if(readStatus.hasClass('unread-result')){
                    var counter = +$unreadCounter.text();
                    counter--;
                    if(counter == 0){
                        $unreadCounter.hide();
                    }
                    $unreadCounter.text(counter);
                }
            }
            else{
                $unreadCounter.hide();
            }
        });
        
        if(readStatus.hasClass('unread-result')){
            readStatus.removeClass('unread-result');
        }

        $(this).css('font-weight' , 'normal');
        $(this).parent().css('font-weight' , 'normal');
        $(this).parent().siblings().css('font-weight' , 'normal');
        var result = $(this).data('result');
        var action = 'apm_show_results';
        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            dataType: 'json',
            method: "post",
            data: {
                result: result,
                action: action,
                is_details: 1,
                rangeAnswer: rangeAnswer
            },
            success: function(response) {
                if (response.status === true) {
                    $('table#ays-results-table').html(response.rows);
                    $(document).find('div.ays-poll-preloader').css('display', 'none');
                }
            }
        });
        e.preventDefault();
    });
    $(document).find('.unread-result-badge.unread-result').on('click', function (e) {

        $('li.toplevel_page_poll-maker-ays .apm-badge.badge-danger').each(function () {
            var $unreadCounter = $(this);

            if ($unreadCounter.text() != '') {
                var counter = +$unreadCounter.text();
                counter--;
                $unreadCounter.text(counter);
            }
        });

        var $this = $(this);
        var $thisRow = $this.parent().parent();
        $thisRow.addClass('pending');
        var result = $thisRow.find('.answer_id>a').attr('data-result');
        var action = 'apm_show_results';
        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            dataType: 'json',
            method: "post",
            data: {
                result: result,
                action: action,
                is_details: 0
            },
            success: function(res) {
                $thisRow.removeClass('pending');
                if (res.status) {
                    $this.removeClass('unread-result').parent().parent().find('td').css('font-weight', '');
                }
            },
            error: function() {
                $thisRow.removeClass('pending');
            }
        });
        e.preventDefault();
    });
    $(document).find('#ays-close-results').on('click', function () {
        $(document).find('#ays-results-modal').fadeOut();
    });

    $(document).keydown(function(event) {
        if (event.which == 27) {
            var resultsModal = $(document).find('#ays-results-modal:visible');
            var exportModal = $(document).find('.ays-modal#poll_export_filters:visible');
            var closeResultsButton = $(document).find('#ays-close-results');
            var closeExportsButton = $('.ays-close');

            if (resultsModal.length > 0) {
                closeResultsButton.trigger('click');
            } else if (exportModal.length > 0) {
                closeExportsButton.trigger('click');
            }
        }
    });

    $(document).on('click', function(e) {
        var resultsModal = $(document).find('#ays-results-modal:visible');
        var exportModal = $(document).find('.ays-modal#poll_export_filters:visible');
        var closeResultsButton = $(document).find('#ays-close-results');
        var closeExportsButton = $('.ays-close');

        if ($(e.target).is(resultsModal) ) {
            closeResultsButton.trigger('click');
        } else if ($(e.target).is(exportModal)) {
            closeExportsButton.trigger('click');
        }
    });

    // Quick poll submit function
    $(document).find('#ays-save-quick-poll').on('click', function (e) {
        var $this = $(this);
        var title = $(document).find('#ays-quick-poll-title').val();

        $this.attr('disabled', true);
        $this.addClass('quick-poll-save-disabled');
        if (title == '') {
            swal.fire({
                type: 'error',
                html: "<h2>Poll title can't be empty.</h2>",
                onAfterClose: function() {
                    $this.removeClass('quick-poll-save-disabled');
                    $this.attr('disabled', false);
                }
            });

            return false;
        }

        var questions = $(document).find('#ays-quick-poll-question').val();
        var answersArr = $(document).find('.quick_poll_answer');

        for (var i = 0; i < answersArr.length; i++) {
            if (answersArr.eq(i).val() == '') {
                swal.fire({
                    type: 'error',
                    html: '<h2>You must fill all answers</h2>',
                    onAfterClose: function() {
                        $this.removeClass('quick-poll-save-disabled');
                        $this.attr('disabled', false);
                    }
                });
                return false;
            } else {
                answersArr[i] = answersArr.eq(i).val();
            }
        }

        var allowAnonimity = $(document).find('#allow_anonimity_switch').is(':checked') ? 1 : 0;
        var allowMultivote = $(document).find('#allow_multivote_switch').is(':checked') ? 'on' : 'off';

        if (allowMultivote == 'on') {
            var multivote_min_count = $(document).find('#quick-poll-multivote-min-count').val();
            var multivote_max_count = $(document).find('#quick-poll-multivote-max-count').val();
        } else {
            var multivote_min_count = 1;
            var multivote_max_count = 1;
        }

        var wp_nonce = $(document).find('#ays_poll_ajax_quick_poll_nonce').val();
        var showTitle = $(document).find('#quick-poll-show-title').is(':checked') ? 'on' : 'off';


        var quickPollFormData = $('#ays-quick-poll-form').serializeFormJSON();
        quickPollFormData.action = 'ays_poll_maker_quick_start';
        quickPollFormData['quick-poll-show-title'] = showTitle;
        quickPollFormData._ajax_nonce = wp_nonce;

        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            method: 'post',
            dataType: 'json',
            data: quickPollFormData,
            success: function (response) {
                $(document).find('div.ays-poll-preloader').css('display', 'none');

                if (response.status == true) {
                    $(document).find('#ays-quick-poll-form')[0].reset();
                    $(document).find('#ays-poll-quick-create .ays-modal-content').addClass('animated bounceOutRight');
                    $(document).find('#ays-poll-quick-create').modal('hide');
                    swal({
                        title: '<strong>Great job</strong>',
                        type: 'success',
                        html: '<p>Your Poll is Created!<br>Copy the generated shortcode and paste it into any post or page to display Poll.</p><input type="text" id="quick_poll_shortcode" onClick="this.setSelectionRange(0, this.value.length)" readonly value="[ays_poll id=&quot;' + response.poll_id + '&quot;]" /><p style="margin-top:1rem;">For more detailed configuration visit <a href="admin.php?page=poll-maker-ays&action=edit&poll=' + response.poll_id + '">edit poll page.</a></p>',
                        showCloseButton: true,
                        focusConfirm: false,
                        confirmButtonText: '<i class="ays_poll_fas ays_poll_fa_thumbs_up "></i> Done',
                        confirmButtonAriaLabel: 'Thumbs up, Done',
                        onAfterClose: function() {
                            $(document).find('#ays-poll-quick-create').removeClass('animated bounceOutRight');
                            $(document).find('#ays-poll-quick-create').css('display', 'none');
                            window.location.href = "admin.php?page=poll-maker-ays";
                            location.reload();
                        }
                    })
                }
            }
        })
    
    })

    // AV export-filters

    $(document).on('change.select2', '#poll_id-filter', function(e) {
        $('#ays_poll_export_answers_filter').submit();
        e.preventDefault();
    });

    $(document).find('#ays_poll_export_answers_filter').on('submit', function(e) {
        e.preventDefault();
        var $this = $('#poll_export_filters');
        $this.find('div.ays-poll-preloader').css('display', 'flex');
        var action = 'ays_poll_results_export_file';
        var poll_id = $('#poll_id-filter').val();

        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            dataType: 'json',
            method: "post",
            data: { 
                action: action,
                poll_id: poll_id
            },
            success: function(response) {
                if (response.status) {
                    $this.find(".export_results_count span").text(response.count);
                }
                $this.find('div.ays-poll-preloader').css('display', 'none');
            }
        });
    });

    $(document).find('.poll_results_export-action').on('click', function(e) {
        e.preventDefault();
        var $this = $('#poll_export_filters');
        $this.find('div.ays-poll-preloader').css('display', 'flex');
        var action = 'ays_poll_results_export_file';
        var poll_id = $('#poll_id-filter').val();

        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            dataType: 'json',
            method: "post",
            data: { 
                action: action,
                poll_id: poll_id
            },
            success: function(response) {
                if (response.status) {
                    window.location.href = $('#download').attr('href');
                }
                $this.find('div.ays-poll-preloader').css('display', 'none');
            }
        });
    });
    $(document).find('.poll_results_export-action-xlsx').on('click', function(e) {
        e.preventDefault();
        var $this = $('#poll_export_filters');
        $this.find('div.ays-poll-preloader').css('display', 'flex');
        var action = 'ays_poll_results_export_file_xlsx';
        var poll_id = $('#poll_id-filter').val();

        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            dataType: 'json',
            method: "post",
            data: { 
                action: action,
                poll_id: poll_id
            },
            success: function(response) {
                if (response.status) {
                    var options = {
                        fileName: "poll_results_export",
                        header: true
                    };
                    var tableData = [{
                        "sheetName": "Poll results",
                        "data": response.data
                    }];
                    Jhxlsx.export(tableData, options);
                    $this.find('div.ays-poll-preloader').css('display', 'none');
                }
            }
        });
    });

    var pollSel2;

    $(document).find('.ays-poll-export-filters').on('click', function(e) {
        var $this = $('#poll_export_filters');
        $this.find('div.ays-poll-preloader').css('display', 'flex');
        $this.aysModal('show');
        e.preventDefault();
        var action = 'ays_poll_show_filters';
        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            method: 'post',
            dataType: 'json',
            data: {
               action: action
            },
            success: function(res) {
                $this.find('div.ays-poll-preloader').css('display', '');
                var newPollSelect = "";

                for (var q in res.polls) {
                    newPollSelect += '<option value="'+ res.polls[q].id +'">'+ res.polls[q].title +'</option>';
                }

                var pollSel = $this.find('#poll_id-filter').html(newPollSelect);
                pollSel2 = pollSel.select2({
                    dropdownParent: $this,
                    closeOnSelect: true,
                    allowClear: false
                });
                
                $(document).on('click', '.select2-selection__choice__remove', function(){
                    pollSel2.select2("close");
                });
                
                $this.find(".export_results_count span").text(res.count);
                $this.find('.ays-modal-body').show();
            },
            error: function() {
                swal.fire({
                    type: 'info',
                    html: "<h2>Can't load resource.</h2><br><h6>Maybe something went wrong.</h6>"
                }).then(function(res){
                    $(document).find('#ays-export-filters div.ays-poll-preloader').css('display', 'none');
                    $this.aysModal('hide');
                });
            }
        });
    });

    $(document).on('click', '.ays_pollid_clear', function(){
        pollSel2.val(null).trigger('change');
        return false;
    });

    // Zapier test data send
    $("#testZapier").on('click', function () {
        var AysPoll = {};
        var $this = $(this);
        $this.prop('disabled', true);
        $("#testZapierFields").find("input").each(function () {
            if ($(this).prop('checked')) {
                switch ($(this).val()) {
                    case "ays_user_name":
                        AysPoll[$(this).val()] = "John Smith";
                        break;
                    case "ays_user_email":
                        AysPoll[$(this).val()] = "john_smith@example.com";
                        break;
                    case "ays_user_phone":
                        AysPoll[$(this).val()] = "+123123123";
                        break;
                    default:
                        AysPoll[$(this).val()] = "Test data";
                        break;
                }
            }
        });
        $.ajax({
            url: $this.attr('data-url'),
            dataType: 'json',
            method: "post",
            data: {
                "AysPoll": JSON.stringify(AysPoll)
            },
            success: function (response) {
                $this.prop('disabled', false);
                if (response.status) {
                    $this.removeClass('btn-outline-secondary').addClass('btn-success').text('Successfully sent')
                } else {
                    $this.removeClass('btn-outline-secondary').addClass('btn-danger').text('Failed')
                }
            },
            error: function () {
                $this.prop('disabled', false).removeClass('btn-outline-secondary').addClass('btn-danger').text('Failed')
            }
        });
    });

    //Slack Integration

    $(document).on('click', '#slackOAuthGetToken', function () {
        var clientId = $("#ays_slack_client").val(),
            clientSecret = $("#ays_slack_secret").val(),
            clientCode = $(this).attr('data-code'),
            successText = $(this).attr('data-success');
        if (clientId == '' || clientSecret == "" || clientCode == "") {
            return false;
        }
        $('#ays_submit').prop('disabled', true);
        $.ajax({
            url: "https://slack.com/api/oauth.access",
            method: "post",
            data: {
                client_id: clientId,
                client_secret: clientSecret,
                code: clientCode
            },
            success: function (res) {
                $('#slackOAuthGetToken')
                    .text(successText)
                    .toggleClass('btn-secondary btn-success pointer-events-none');
                $('#ays_slack_token').val(res.access_token);
                $('#ays_submit').prop('disabled', false);
            }
        });
    });

    // Request approve button 
    $(document).find('.ays_poll_approve_button').on('click', function(e) {
        e.preventDefault();
        var $this = $(this);
        var request_id = $(this).attr('data-id');
        var action = 'ays_poll_add_request';
        $.ajax({
            type: "POST",
            url: apm_ajax_obj.ajaxUrl,
            data: {
                id: request_id,
                action: action,
            },
            dataType: "json",
            success: function (response) {
                if (response.status) {
                    var changeButton = $this.parent().html(response.data);
                }
                else{
                    swal.fire({
                        type: 'info',
                        html: "<h2>Can't load resource.</h2><br><h6>Maybe something went wrong.</h6>"
                    });
                }
            },
            error: function() {
                swal.fire({
                    type: 'info',
                    html: "<h2>Can't load resource.</h2><br><h6>Maybe something went wrong.</h6>"
                });
            }
        });
    });

    //Google sheet Integration
    $(document).on('click', '#ays_poll_google_get_token', function () {
        var $this = $(this);
        var gClientId = $("#ays_poll_google_client").val(),
            gClientSecret = $("#ays_poll_google_secret").val(),
            gCallBackUrl = $("#ays_poll_google_redirect").val(),
            gCode = $("#ays_poll_google_token").val();
        if (gClientId == '' || gClientSecret == "" || gCallBackUrl == "") {
            return false;
        }
        $.ajax({
            type: 'post',
            url: "https://accounts.google.com/o/oauth2/token",
            contentType: 'application/x-www-form-urlencoded; charset=utf-8',
            data: {
                grant_type: 'authorization_code',               
                client_id: gClientId,
                code: gCode,
                client_secret: gClientSecret,                
                redirect_uri: gCallBackUrl,                
                scope: 'https://www.googleapis.com/auth/spreadsheets'               
            },
            success: function (res) {
                $('#ays_poll_get_token').val(res.access_token);
                $('#ays_poll_get_refresh_token').val(res.refresh_token);
                $this.parent().append("<span style='margin-left: 15px;'>Token Given</span>");
                $this.prop("disabled" , true);
                $(document).find("#ays_poll_googleOAuth2").prop("disabled" , true);
            }
        });
    });

    // Xcho
    $(document).find('.cat-filter-apply').on('click', function(e){
        e.preventDefault();
        var catFilter = $(document).find('select[name="filterby"]').val();

        var link = location.href;
        if( catFilter != '' ){
            catFilter = "&filterby="+catFilter;
            document.location.href = link+catFilter;
        }else{
            var linkModifiedStart = link.split('?')[0];
            var linkModified = link.split('?')[1].split('&');
            for(var i = 0; i < linkModified.length; i++){
                if(linkModified[i].split("=")[0] == "filterby"){
                    linkModified.splice(i, 1);
                }
            }
            linkModified = linkModified.join('&');
            document.location.href = linkModifiedStart + "?" + linkModified;
        }
    });
    
    $(document).find('input[class*="cat-filter-apply-user-"').on('click', function(e){
        e.preventDefault();
        var catFilter = $(this).parents("#poll-filter-div").find('select[name="orderbyuser"]').val();

        var link = location.href;
        if( catFilter != '' ){
            catFilter = "&orderbyuser="+catFilter;
            document.location.href = link+catFilter;
        }else{
            var linkModifiedStart = link.split('?')[0];
            var linkModified = link.split('?')[1].split('&');
            for(var i = 0; i < linkModified.length; i++){
                if(linkModified[i].split("=")[0] == "orderbyuser"){
                    linkModified.splice(i, 1);
                }
            }
            linkModified = linkModified.join('&');
            document.location.href = linkModifiedStart + "?" + linkModified;
        }
    });
    
    $(document).find('#ays_poll_import_answers').on('change', function () {
        var answerData = $('#ays_poll_import_answers').prop('files')[0];
        var loader = $(document).find("span.ays_add_answer_loader");
        var formData = new FormData();
        var $this = $(this);
        $this.parent().css('position' , 'relative');
        loader.css('position' , 'absolute');
        loader.css('right' , '38%');
        loader.css('top' , '0');
        loader.show();
        $this.siblings('label.ays_add_answer_label').css("opacity" , 0.1);
        if(typeof(answerData) != "undefined"){
            formData.append('ays_poll_import_answers', answerData);
            formData.append('action', 'ays_import_answers');
        }
        $.ajax({
            url: apm_ajax_obj.ajaxUrl,
            type: "post",
            contentType: false,
            processData: false,
            data: formData,
            dataType: 'json',
            success: function (res) {
                var tableCont = $(document).find("table#ays-answers-table");
                var aysRedirectChekbox = $(document).find('input[type="checkbox"]#ays_redirect_after_submit');
                var aysFakeVotes = $(document).find('input[type="checkbox"]#ays_add_f_votes');
                var answersCount = $(document).find('#ays_poll_answers_count').val();
                var id = 1 + parseInt(answersCount);
                var aysRedirectChekboxClass = '';
                var aysFakeVotesClass = '';
                if(aysRedirectChekbox.prop('checked') == false){
                    aysRedirectChekboxClass = 'ays_poll_display_none';
                }
                if(aysFakeVotes.prop('checked') == false){
                    aysFakeVotesClass = 'ays_poll_display_none';
                }
                var importedAnsers = "";
                if(res.status){
                    if(res.results.length > 0){
                        for (var answer of res.results){
                            importedAnsers += '<tr class="ays-answer-row ui-state-default ays-imported-answers">';
                                importedAnsers += '<td class="ays-sort"><i class="ays_poll_fas ays_poll_fa_arrows" aria-hidden="true"></i></td>';
                                importedAnsers += '<td>';
                                    importedAnsers += '<input type="text" class="ays-text-input ays-answer-value" name="ays-poll-answers[]" data-id="'+id+'" value="'+answer+'">';
                                    importedAnsers += '<input type="hidden" name="ays-poll-answers-ids[]" data-id="'+id+'" value="0">';
                                 importedAnsers += '</td>';
                                importedAnsers += '<td class="ays-answer-redirect-row '+ aysRedirectChekboxClass +' ">';
                                    importedAnsers += '<input type="text" class="ays-text-input ays_redirect_active" id="ays_submit_redirect_url_'+id+'" name="ays_submit_redirect_url[]" />';
                                importedAnsers += '</td>';
                                importedAnsers += '<td class="ays-f-votes-row '+ aysFakeVotesClass +' ">';
                                    importedAnsers += '<input type="number" class="ays-text-input ays_f_votes_active" id="ays_f_votes_count_'+id+'" name="ays_f_votes_count[]" value="0"/>';
                                importedAnsers += '</td>';
                                importedAnsers += '<td>';
                                    importedAnsers += '<label class="ays-label" for="ays-answer">';
                                        importedAnsers += '<a style="" class="add-answer-image">'+ pollLangObj.add +'</a>';
                                    importedAnsers += '</label>';
                                    importedAnsers += '<div class="ays-answer-image-container ays-answer-image-container-div" style="display:none;">';
                                        importedAnsers += '<span class="ays-remove-answer-img"></span>';
                                        importedAnsers += '<img src="" class="ays-answer-img"/>';
                                        importedAnsers += '<input type="hidden" name="apm-answers-images[]" class="ays-answer-image-path" value=""/>';
                                    importedAnsers += '</div>';
                                importedAnsers += '</td>';
                                importedAnsers += '<td>';
                                    importedAnsers += '<a href="javascript:void(0)" class="ays-delete-answer">';
                                    importedAnsers += '</a>';
                                importedAnsers += '</td>';
                            importedAnsers += '</tr>';
                        }
                    }
                    tableCont.append(importedAnsers);
                    var answersRow = $(document).find('#ays-answers-table tbody tr.ays-answer-row');
                    var index = 1;
                    if (answersRow.length > 0) {
                        answersRow.each(function () {
                            if ($(this).hasClass('even')) {
                                $(this).removeClass('even');
                            }
                            var className = ((index % 2) === 0) ? 'even' : '';
                            index++;
                            $(this).addClass(className);
                        });
                    }                    
                    loader.html(res.image);
                    setTimeout(function(){
                        if(answersRow.hasClass('ays-imported-answers')){
                            answersRow.animate({opacity: 1});
                            answersRow.removeClass('ays-imported-answers');
                        }
                    }, 500);

                }
                $this.siblings('label.ays_add_answer_label').css("opacity" , 1);
                loader.hide();
                var importCont = $(document).find("div#ays_answer_import_message");
                if(res.message != ''){
                    var messageColor = '';
                    if(res.status){
                        messageColor = 'ays_poll_import_message_true';
                    }
                    else{
                        messageColor = 'ays_poll_import_message_false';
                    }
                    var resultMessage = "<blockquote class="+messageColor+">"+res.message+"</blockquote>";
                    importCont.html(resultMessage);
                }

                $this.val(null);
            }
        })
    });

//Get Only selected post types(AV)
        $(document).find('#ays_poll_posts').select2({
            placeholder: "Select page",
            allowClear: true,
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: apm_ajax_obj.ajaxUrl,
                dataType: 'json',
                data: function (params) {
                    var checkedUsers = $(document).find('#ays_poll_post_types').val();
                    return {
                        action: 'ays_poll_admin_ajax',
                        function: 'ays_poll_get_selected_posts',
                        q: params.term,
                        val: checkedUsers,
                        page: params.page
                    };
                },
            }
        });

})(jQuery)
