<div id="tab5" class="ays-poll-tab-content <?= $active_tab == 'tab5' ? 'ays-poll-tab-content-active' : ''; ?>">
    <div class="ays-poll-accordion-options-main-container">
        <div class="ays-poll-accordion-header">
            <?php echo $poll_acordion_svg_html; ?>
            <p class="ays-subtitle"><?= __('Limitation of Users', "poll-maker"); ?></p>
        </div>
        <hr class="ays-poll-bolder-hr" />
        <div class="ays-poll-accordion-body">
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for="apm_limit_users">
                        <?= __('Maximum number of attempts per user', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                        title="<?= __('After enabling this option, you can manage the counts of the attempts per user for passing the poll.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" id="apm_limit_users" name="apm_limit_users" class="ays_toggle_checkbox" value="on" <?= (isset($options['limit_users']) && $options['limit_users']) ? 'checked' : ''; ?>/>
                </div>
                <div class="col-sm-8 ays_divider_left ays_toggle_target" style="<?= (isset($options['limit_users']) && $options['limit_users']) ? '' : 'display:none'; ?>">
                    <div class="ays-limitation-options w-100">
                        <!-- Limitation method -->
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_redirect_method">
                                    <?= __('Detects users by', "poll-maker"); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-html="true" data-placement="top" title="<p style='margin-bottom:3px;'><?php echo __( 'Choose the method of detection of the user:' , "poll-maker" ); ?>
                                    <p style='padding-left:10px;margin-bottom:3px;'><strong><?php echo __( 'By IP', "poll-maker" ); ?></strong> <?php echo __( ' - Detect the users by their IP addresses and limit them. It will work both for guests and registered users. Note: in general, IP is not a static variable, it is constantly changing when the user changes his location/ WIFI/ Internet provider.' , "poll-maker" ); ?></p>
                                    <p style='padding-left:10px;margin-bottom:3px;'><strong><?php echo __( 'By User ID', "poll-maker" ); ?></strong><?php echo __( ' - Detect the users by their WP User IDs and limit them. It will work only for registered users. Recommended using this method to get more reliable results.', "poll-maker" ); ?></p>
                                    <p style='padding-left:10px;margin-bottom:3px;'><strong><?php echo __( 'By Cookie ', "poll-maker" ); ?></strong><?php echo __( ' - Detect te users by their browser cookies and limit them.  It will work both for guests and registered users.', "poll-maker" ); ?></p>
                                    <p style='padding-left:10px;margin-bottom:3px;'><strong><?php echo __( 'By Cookie and IP ', "poll-maker" ); ?></strong><?php echo __( ' - Detect te users both by their browser cookies and IP addresses and limit them. It will work both for guests and registered users.', "poll-maker" ); ?></p>"
                                    >
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-9">
                                <div class="ays-poll-sel-fields d-flex p-0">
                                    <div class="ays-poll-check-box mr-2 ays_poll_loader">
                                        <input type="radio" id="ays_limit_method_ip" name="ays_limit_method"
                                            value="ip" <?= (!empty($options['limit_users_method']) && $options['limit_users_method'] == 'ip') || empty($options['limit_users_method']) ? "checked" : "" ?> />
                                        <label class="form-check-label"
                                            for="ays_limit_method_ip"><?= __('IP', "poll-maker"); ?> </label>
                                    </div>
                                    <div class="ays-poll-check-box mr-2 ays_poll_loader">
                                        <input type="radio" id="ays_limit_method_user" name="ays_limit_method"
                                            value="user" <?= !empty($options['limit_users_method']) && $options['limit_users_method'] == 'user' ? "checked" : "" ?> />
                                        <label class="form-check-label"
                                            for="ays_limit_method_user"><?= __('User ID', "poll-maker"); ?> </label>
                                    </div>
                                    <div class="ays-poll-check-box mr-2 ays_poll_loader">
                                        <input type="radio" id="ays_limit_method_cookie" name="ays_limit_method"
                                            value="cookie" <?= !empty($options['limit_users_method']) && $options['limit_users_method'] == 'cookie' ? "checked" : "" ?> />
                                        <label class="form-check-label"
                                            for="ays_limit_method_cookie"><?= __('Cookie', "poll-maker"); ?> </label>
                                    </div>
                                    <div class="ays-poll-check-box mr-2 ays_poll_loader">
                                        <input type="radio" id="ays_limit_method_cookie_ip" name="ays_limit_method"
                                            value="cookie_ip" <?= !empty($options['limit_users_method']) && $options['limit_users_method'] == 'cookie_ip' ? "checked" : "" ?> />
                                        <label class="form-check-label"
                                            for="ays_limit_method_cookie_ip"><?= __('Cookie and IP', "poll-maker"); ?> </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr/>
                        <!-- Limitation redirect url -->
                        <div class="form-group row d-flex">
                            <div class="col-sm-3">
                                <label for="ays_redirect_url">
                                    <?= __('Redirect URL', "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                    title="<?= __('Enable redirection to the custom URL for those who have already passed the poll under the given conditions.', "poll-maker"); ?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" name="ays_redirect_url" id="ays_redirect_url"
                                    class="ays-text-input"
                                    value="<?= (isset($options['redirect_url'])) ? $options['redirect_url'] : ''; ?>"/>
                                <p class="ays_poll_small_hint_text_for_message_variables" style="margin-top:3px;font-size:12px">
                                    <span><?php echo __( "Note: If the redirect delay is set to 0, the redirection will be disabled." , "poll-maker" ); ?></span>
                                </p>
                            </div>
                        </div>
                        <hr/>
                        <!-- Limitation redirect delay -->
                        <div class="form-group row d-flex">
                            <div class="col-sm-3">
                                <label for="ays_redirection_delay">
                                    <?= __('Redirect delay (sec)', "poll-maker"); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                    title="<?= __('Choose the redirection delay in seconds. If you set it to 0, the redirection will be disabled.', "poll-maker"); ?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-9">
                                <input type="number" name="ays_redirection_delay" id="ays_redirection_delay"
                                    class="ays-text-input"
                                    value="<?= (isset($options['redirection_delay'])) ? $options['redirection_delay'] : 0; ?>"/>
                            </div>
                        </div>
                        <hr/>
                        <div class="form-group row d-flex">
                            <div class="col-sm-3">
                                <label for="ays_attempts_count">
                                    <?php echo __('Attempts count',"poll-maker")?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the count of the attempts per user for passing the poll.',"poll-maker")?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-9">
                                <input type="number" min="1" name="ays_attempts_count" id="ays_attempts_count" class="ays-enable-timerl ays-text-input"
                                    value="<?php echo $attempts_count; ?>">
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row ays_toggle_parent">
                            <div class="col-sm-3">
                                <label for="ays_enable_vote_limitation">
                                    <?php echo __('Set custom session', "poll-maker")?>
                                    <a class="ays_help" data-toggle="tooltip" title='<?php echo __('If you enable this feature, you can select the frequency the users can have access to the poll after selected attempts count. For example, if you give a 1-day value to the session period, the user will have access to the poll "attempts count" times in 1-day.' , "poll-maker")?>'>
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" 
                                    class="ays-enable-timer1 ays_toggle_checkbox" id="ays_enable_vote_limitation"
                                    name="ays_enable_vote_limitation" 
                                    value="on" 
                                    <?php echo  $enable_vote_limitation ? "checked" : ""; ?> />
                            </div>
                            <div class="col-sm-8 ays_toggle_target ays_divider_left <?php echo ($enable_vote_limitation) ? '' : 'display_none'; ?>">
                                <div class="form-group row">
                                    <div class="col-sm-3">
                                        <label for="ays_vote_limitation">
                                            <?php echo __('Session Period' , "poll-maker")?>
                                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the time for one session.' , "poll-maker")?>">
                                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <div class="col-sm-5">
                                        <input type="number" name="ays_vote_limitation" id="ays_vote_limitation" class="ays-enable-timerl ays-text-input" value="<?php echo $ays_vote_limitation ;?>">
                                        
                                    </div>
                                    <div class="col-sm-4">
                                        <select name="ays_vote_limitation_time_period" id="ays_vote_limitation_period">
                                            <?php 
                                                foreach ($default_limit_time_period as $key => $limit_time_period) {
                                                    $selected = '';
                                                    if($key == $ays_vote_limitation_time_period){
                                                        $selected = 'selected';
                                                    }else{
                                                        $selected = '';
                                                    }
                                            ?>
                                                    <option value="<?php echo $key; ?>" <?php echo $selected; ?>>
                                                        <?php echo $limit_time_period; ?>
                                                    </option>
                                            <?php
                                                }
                                            ?>
                                        </select>
                                    </div>                            
                                </div> 
                            </div>
                        </div> <!-- Allow to vote once per session -->
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_see_result_show">
                                    <?= __('See results', "poll-maker"); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-html="true" data-placement="top"
                                        title="<p style='margin-bottom:3px;'><?= esc_attr(__( 'Display the live results of the poll to those who have already passed the poll under the given conditions. There are two ways of displaying the results:' , 'poll-maker' )); ?>
                                        <p style='padding-left:10px;margin-bottom:3px;'><strong><?= esc_attr(__( 'After clicking on the button:', 'poll-maker' )); ?></strong> <?= esc_attr(__( '- It will show the results after clicking on the See Results button.' , 'poll-maker' )); ?></p>
                                        <p style='padding-left:10px;margin-bottom:3px;'><strong><?= esc_attr(__( 'Directly:', 'poll-maker' )); ?></strong><?= esc_attr(__( ' - It will show the results immediately.', 'poll-maker' )); ?></p>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-9 row">
                                <div class="col-sm-2" style="height: 41px;">
                                    <input type="checkbox" id="ays_see_result_show" name="ays_see_result_show" class="ays_poll_show_hide_buttons" value="on" <?php echo $poll_see_result_button; ?>>
                                </div>
                                <div class="col-sm-10 ays-poll-sel-fields <?php echo $poll_see_result_button_cont; ?>" id="ays_poll_show_hide_button">
                                    <div class="ays-poll-check-box mr-2 ays_poll_loader">
                                        <input type="radio" id="ays_see_result_button_show" name="ays_poll_see_result_show" class="ays_poll_show_hide_buttons" value="ays_see_result_button" <?php echo $poll_see_result_botton_show?>>
                                        <label for="ays_see_result_button_show" class="form-check-label"><?= __('After clicking on the button', "poll-maker"); ?></label>
                                    </div>
                                    <div class="ays-poll-check-box mr-2 ays_poll_loader">
                                        <input type="radio" id="ays_see_result_button_hide" name="ays_poll_see_result_show" class="ays_poll_show_hide_buttons" value="ays_see_result_immediately" <?php echo $poll_see_result_immediately?>>
                                        <label for="ays_see_result_button_hide" class="form-check-label"><?= __('Directly', "poll-maker"); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div><!-- See result show type-->
                        <hr/>
                        <!-- Limitation message -->
                        <div class="form-group row d-flex">
                            <div class="col-sm-3">
                                <label for="ays_limitation_message">
                                    <?= __('Message', "poll-maker"); ?>
                                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __('Write the message for those who have already passed the poll under the given conditions.', "poll-maker"); ?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-9">
                                <?php
                                $content   = isset($options['limitation_message']) ? stripslashes($options['limitation_message']) : $default_options['limitation_message'];
                                $editor_id = 'ays_limitation_message';
                                $settings  = array(
                                    'editor_height'  => $poll_wp_editor_height,
                                    'textarea_name'  => 'ays_limitation_message',
                                    'editor_class'   => 'ays-textarea',
                                    'media_elements' => false
                                );
                                wp_editor($content, $editor_id, $settings);
                                ?>
                            </div>
                        </div>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_dont_show_poll_container_attempts">
                                    <?php echo esc_attr( __("Don't show poll", "poll-maker") ); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Enable this option and the poll container will be hidden on the front-end if the user has reached the maximum attempts count for the poll.", "poll-maker"); ?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-9 form-group ays_toggle_parent row">
                                <div class="col-sm-1">
                                    <input type="checkbox" class='ays_toggle_checkbox' id="ays_dont_show_poll_container_attempts" name="ays_dont_show_poll_container_attempts" value="on" <?php echo ($dont_show_poll_container_attempts) ? 'checked' : ''; ?>/>
                                </div>
                                <div class="col-sm-11 ays_divider_left ays_toggle_target <?php echo $dont_show_poll_container_attempts ? '' : 'display_none'; ?>">
                                    <blockquote class="dont_show_poll_container_attempts_blockquote_message"><?php echo __("Note:  If you have enabled this option and the poll taker has reached the attempts count, the redirection option will not work for the poll.", "poll-maker"); ?></blockquote>
                                </div>
                            </div>
                        </div> <!-- Dont show poll | Maximum number of attempts per user -->
                    </div>
                </div>
            </div> <!-- Maximum number of attempts per user -->
            <hr/>
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for="ays_enable_logged_users">
                        <?= __('Only for logged in users', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                        title="<?= __('After enabling this option, only logged-in users will be able to pass the poll.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" id="ays_enable_logged_users" class="ays_toggle_checkbox" name="ays_enable_logged_users" value="on" <?php echo (((isset($options['enable_logged_users']) && $options['enable_logged_users'] == 1)) || (isset($options['enable_restriction_pass']) && $options['enable_restriction_pass'] == 1)) ? 'checked' : ''; ?> <?= (isset($options['enable_restriction_pass']) &&
                                        $options['enable_restriction_pass'] == 1) ? 'disabled' : ''; ?>/>
                </div>
                <div class="if-logged-in col-sm-8 ays_toggle_target " style="<?php echo (((isset($options['enable_logged_users']) && $options['enable_logged_users'] == 1)) || (isset($options['enable_restriction_pass']) && $options['enable_restriction_pass'] == 1)) ? 'display:block;' : 'display:none;'; ?>">
                    <div class="d-flex w-100">
                        <div class="col-sm-3">
                            <label for="ays_logged_in_message">
                                <?= __('Message', "poll-maker"); ?>
                                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                title="<?= __('Write the message for unauthorized users.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <?php
                            $content   = !empty($options['enable_logged_users_message']) ? stripslashes($options['enable_logged_users_message']) : $default_options['enable_logged_users_message'];
                            $editor_id = 'ays_logged_in_message';
                            $settings  = array(
                                'editor_height'  => $poll_wp_editor_height,
                                'textarea_name'  => 'ays_enable_logged_users_message',
                                'editor_class'   => 'ays-textarea',
                                'media_elements' => false
                            );
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </div>
                    </div>
                    <hr/>                        
                    <div class="form-group d-flex">
                        <div class="col-sm-3">
                            <label for="ays_show_login_form">
                                <?php echo __('Show Login form',"poll-maker")?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable to show the login form.',"poll-maker")?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_show_login_form" name="ays_show_login_form" value="on" <?php echo ($show_login_form && $options['enable_logged_users'] == 1) ? 'checked' : ''; ?>/>
                        </div>
                    </div>
                </div>
            </div> <!-- Only for logged in users -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays_enable_restriction_pass">
                        <?= __('Only for selected user role', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                        title="<?= __('After enabling this option, only the user roles mentioned in the list will be able to pass the poll.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" id="ays_enable_restriction_pass" name="ays_enable_restriction_pass"
                        value="on" <?= (isset($options['enable_restriction_pass']) &&
                                        $options['enable_restriction_pass'] == 1) ? 'checked' : ''; ?>/>
                </div>
                <div class="if-users-roles col-sm-8 ays_divider_left" style="<?= (isset($options['enable_restriction_pass']) && $options['enable_restriction_pass'] == 1) ? 'display: block;' : 'display: none;'; ?>/>">
                    <div class="form-group d-flex w-100">
                        <div class="col-sm-3">
                            <label for="ays_users_roles">
                                <?= __('User role', "poll-maker"); ?></label>
                        </div>
                        <div class="col-sm-9">
                            <select name="ays_users_roles[]" multiple id="ays_users_roles" class="ays-select">
                                <?php
                                $selected_roles = isset($options['user_role']) && !empty($options['user_role']) ? explode(',', $options['user_role']) : array();
                                foreach ( $ays_users_roles as $key => $user_role ) {
                                    echo "<option value='" . $key . "' " . (in_array($key, $selected_roles) ? 'selected' : '') . ">" . $user_role['name'] . "</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <hr> 
                    <div class="form-group d-flex w-100">
                        <div class="col-sm-3">
                            <label for="restriction_pass_message">
                                <?= __('Message', "poll-maker"); ?>
                                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                title="<?= __('Write the message for those who aren’t included in the list.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <?php
                            $content   = !empty($options['restriction_pass_message']) ? stripslashes($options['restriction_pass_message']) : $default_options['restriction_pass_message'];
                            $editor_id = 'restriction_pass_message';
                            $settings  = array(
                                'editor_height'  => $poll_wp_editor_height,
                                'textarea_name'  => 'restriction_pass_message',
                                'editor_class'   => 'ays-textarea',
                                'media_elements' => false
                            );
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </div>
                    </div>
                </div>
            </div> <!-- Only for selected user role -->
            <hr> 
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for="ays_enable_tackers_count">
                        <?php echo __('Limitation count of takers', "poll-maker")?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('You can choose how many users can pass the poll.',"poll-maker")?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" class="ays-enable-timer1 ays_toggle_checkbox" id="ays_enable_tackers_count"
                        name="ays_enable_tackers_count" value="on" <?php echo $enable_tackers_count ? 'checked' : ''; ?>/>
                </div>
                <div class="col-sm-8 ays_toggle_target ays_divider_left <?php echo $enable_tackers_count ? '' : 'display_none'; ?>">
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_tackers_count">
                                <?php echo __('Count',"poll-maker")?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The number of users who can pass the poll.',"poll-maker")?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="number" name="ays_tackers_count" id="ays_tackers_count" class="ays-enable-timerl ays-text-input"
                                value="<?php echo $tackers_count; ?>">
                        </div>
                    </div>
                </div>
            </div> <!-- Limitation count of takers --> 
            <hr>
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for="ays_enable_password">
                        <?php echo __('Password for passing Poll', "poll-maker")?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose a password for users to pass the poll.' , "poll-maker")?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" class="ays-enable-timer1 ays_toggle_checkbox" id="ays_enable_password"
                        name="ays_enable_password" value="on" <?php echo $enable_password == 'on' ? 'checked' : ''; ?>/>
                </div>
                <div class="col-sm-8 ays_toggle_target ays_divider_left <?php echo $enable_password == 'on' ? '' : 'display_none'; ?>">
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_password_poll">
                                <?php echo __('Password' , "poll-maker")?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Write your password.' , "poll-maker")?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="text" name="ays_password_poll" id="ays_password_poll" class="ays-enable-timerl ays-text-input"
                                value="<?php echo $password_poll; ?>">
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_poll_enable_password_visibility">
                                <?php echo __('Enable toggle password visibility',"poll-maker"); ?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Tick the option, and it will let you enable and disable password visibility in a password input field.',"poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_password_visibility" name="ays_poll_enable_password_visibility" value="on" <?php echo $poll_enable_password_visibility ? 'checked' : ''; ?>/>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_poll_password">
                                <?php echo __('Message' , "poll-maker")?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Write your password.' , "poll-maker")?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        
                        <div class="col-sm-9">
                            <?php 
                                $content   = $poll_password_message;
                                $editor_id = 'ays-poll-password-message';
                                $settings  = array('editor_height' => $poll_wp_editor_height, 'textarea_name' => 'ays_poll_password_message', 'editor_class' => 'ays-textarea', 'media_elements' => false);
                                wp_editor($content, $editor_id, $settings);
                            ?>
                        </div>
                    </div>
                </div>

            </div> <!-- Password for passing Poll -->
            <hr>
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for="enable_limit_by_country">
                        <?php echo __('Limit by country', "poll-maker")?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __(' After enabling this option, the given poll will not be available in the selected country.' , "poll-maker")?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" class="ays-enable-timer1 ays_toggle_checkbox" id="enable_limit_by_country" name="ays_enable_limit_by_country" value="on" <?php echo  ($enable_limit_by_country) ? 'checked': '';?> />
                </div>
                <div class="col-sm-8 ays_toggle_target ays_divider_left <?php echo ($enable_limit_by_country) ? '' : 'display_none'; ?>">
                    <select name="ays_poll_limit_countrys[]" class="ays-text-input ays-text-input-short" id="ays_poll_limit_countrys" multiple>
                        <?php
                        foreach ($countries as $country_key => $country) {
                            $selected = '';
                            if (is_array($limit_countrys)) {
                                $selected = in_array($country_key, $limit_countrys) ? 'selected' : '';
                            } else {
                                $selected = ($country_key == $limit_countrys) ? 'selected' : '';
                            }
                        ?>
                            <option value="<?php echo $country_key; ?>" <?php echo $selected; ?>><?php echo $country[1]; ?></option>
                        <?php } ?>

                    </select>
                </div>
            </div> <!-- Limit by country -->
            <hr>
        </div>
    </div>
</div>