<?php
    require_once( POLL_MAKER_ADMIN_PATH . "/partials/popups/actions/poll-maker-popup-actions-options.php" );
?>
<div class="wrap">
    <div class="ays-poll-heading-box">
        <div class="ays-poll-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank" style="text-decoration: none;font-size: 13px;">
                <i class="ays_poll_fas ays_fa_file_text"></i>
                <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "poll-maker"); ?></span>
            </a>
        </div>
    </div>
    <div class="container-fluid">
        <form class="ays-poll-popup-form" id="ays-poll-popup-form" method="post">
            <h1><?php echo $heading; ?></h1>
            <hr/>
            <div id="tab1" class="ays-poll-tab-content ays-poll-tab-content-active">
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="<?php echo $html_name_prefix; ?>status">
                            <?php echo __('Enable popup',"poll-maker")?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Turn on the popup for the website based on your configured options.', "poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type="checkbox" id="<?php echo $html_name_prefix; ?>status" name="<?php echo $html_name_prefix; ?>status" value="on" <?php echo $status == 'published' ? 'checked' : ''; ?>/>
                    </div>
                </div> <!-- Publish/Unpublish popup -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays-title">
                            <?php echo __("Title", "poll-maker"); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Give a title to your popup.","poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type="text" class="ays-text-input" id="ays-title" name="<?php echo $html_name_prefix; ?>title" value="<?php echo $title; ?>" />
                    </div>
                </div> <!-- Title -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays-category">
                            <?php echo __("Select Poll", "poll-maker"); ?>
                            <a class="ays_help" data-toggle="tooltip" data-html="true" title="<?php
                                echo htmlspecialchars( sprintf(
                                    __("Choose the poll which you want to display within the popup from your already created list.","poll-maker"),
                                    "<strong>",
                                    "</strong>"
                                ) );
                            ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <select id="ays-select-popup-poll-id" name="<?php echo $html_name_prefix; ?>poll_id">
                            <?php
                          $selected = "";
                          foreach ( $polls as $key => $poll ):
                              if( $poll_id == $poll["id"] ){
                                  $selected = "selected";
                              }else{
                                  $selected = "";
                              }
                              ?>
                              <option value="<?php echo $poll["id"]; ?>" <?php echo $selected; ?>><?php echo $poll["title"]; ?></option>
                          <?php
                          endforeach;
                            ?>
                        </select>
                    </div>
                    
                </div> <!-- Poll Id -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_popup_poll_width">
                            <?php echo __("Popup width", "poll-maker"); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Specify the width of your popup in pixels.","poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <div>
                            <input type="number" class="ays-text-input ays-text-input-short" id="ays_popup_poll_width" name="ays_popup_poll_width" value="<?php echo $popup_poll_width; ?>"/>
                        </div>
                    </div>
                </div> <!-- Poll width -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_popup_poll_height">
                            <?php echo __("Popup height", "poll-maker"); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Specify the height of your popup in pixels.","poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <div>
                            <input type="number" class="ays-text-input ays-text-input-short" id="ays_popup_poll_height" name="ays_popup_poll_height" value="<?php echo $popup_poll_height; ?>"/>
                        </div>
                    </div>
                </div> <!-- Poll height -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label>
                            <span><?php echo __("Show on ", "poll-maker"); ?></span>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Select on which pages of your website you need the popup to be loaded. For the Except and Selected options, you can choose specific posts and post types.", "poll-maker") ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <label class="ays_poll_loader">
                            <input type="radio" class="ays-poll-popup-show-where" name="<?php echo $html_name_prefix; ?>poll_show_all" value="all" <?php echo $show_all == "all" ? "checked" : ""; ?> />
                            <span><?php echo __("All pages", "poll-maker"); ?></span>
                        </label>
                        <label class="ays_poll_loader">
                            <input type="radio" class="ays-poll-popup-show-where" name="<?php echo $html_name_prefix; ?>poll_show_all" value="except" <?php echo $show_all == "except" ? "checked" : ""; ?>/>
                            <span><?php echo __("Except", "poll-maker"); ?></span>
                        </label>
                        <label class="ays_poll_loader">
                            <input type="radio" class="ays-poll-popup-show-where" name="<?php echo $html_name_prefix; ?>poll_show_all" value="selected" <?php echo $show_all == "selected" ? "checked" : ""; ?>/>
                            <span><?php echo __("Selected", "poll-maker"); ?></span>
                        </label>
                    </div>
                </div>
                <div class="ays-field ays_poll_view_place_tr <?php echo $show_all == "all" ? "display_none" : ""; ?>">
                    <hr/>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_poll_post_types"><?php echo __("Post type", "poll-maker"); ?></label>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Select the post type from the box. You have to enter 3 or more characters here.", "poll-maker") ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </div>
                        <div class="col-sm-9">
                            <select name="ays_poll_except_post_types[]" id="ays_poll_post_types" class="form-control" multiple="multiple">
                                <?php
                                    foreach ($all_post_types as $post_type) {
                                        if($except_post_types) {
                                            $checked = (in_array($post_type->name, $except_post_types)) ? "selected" : "";
                                        }else{
                                            $checked = "";
                                        }
                                        echo "<option value='" . $post_type->name . "' {$checked}>{$post_type->label}</option>";
                                    }
                                ?>
                            </select>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_poll_posts"><?php echo __("Posts", "poll-maker"); ?></label>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Select the posts from the box. You have to enter 3 or more characters here.", "poll-maker") ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </div>
                        <div class="col-sm-9">
                            <select name="ays_poll_except_posts[]" id="ays_poll_posts" class="form-control" multiple="multiple">
                                <?php
                                    foreach ( $posts as $post ) {
                                        $checked = (is_array($except_posts) && in_array($post->ID, $except_posts)) ? "selected" : "";
                                        echo "<option value=" . $post->ID . " {$checked}>{$post->post_title}</option>";
                                    }
                                ?>
                            </select>
                        </div>
                    </div>
                    <hr/>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_poll_show_on_home_page">
                                <span><?php echo __("Show on Home page", "poll-maker"); ?></span>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __("If the checkbox is ticked, then the popup will be loaded on the Home page, too, in addition to the values given above.", "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <p class="onoffswitch">
                                <input type="checkbox" name="ays_poll_show_on_home_page" class="onoffswitch-checkbox" id="ays_poll_show_on_home_page" <?php echo ($show_on_home_page == "on") ? "checked" : "" ?> >
                            </p>
                        </div>
                     </div>
                </div>
                <hr>
                <div class="popup_poll_position_block">
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="<?php echo $this->plugin_name; ?>-popup-position">
                                <span><?php echo __("Popup position", "poll-maker"); ?></span>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Specify the position of the popup on the screen.", "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <table id="ays-poll-popup-position-table">
                                <tr>
                                    <td data-value="left-top" data-id="1" style="<?php echo $popup_position == "left-top" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                    <td data-value="top-center" data-id="2" style="<?php echo $popup_position == "top-center" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                    <td data-value="right-top" data-id="3" style="<?php echo $popup_position == "right-top" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                </tr>
                                <tr>
                                    <td data-value="left-center" data-id="4" style="<?php echo $popup_position == "left-center" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                    <td data-value="center-center" data-id="5" style="<?php echo $popup_position == "center-center" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                    <td data-value="right-center" data-id="6" style="<?php echo $popup_position == "right-center" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                </tr>
                                <tr>
                                    <td data-value="left-bottom" data-id="7" style="<?php echo $popup_position == "left-bottom" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                    <td data-value="center-bottom" data-id="8" style="<?php echo $popup_position == "center-bottom" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                    <td data-value="right-bottom" data-id="9" style="<?php echo $popup_position == "right-bottom" ? "background-color: #a2d6e7" : ""; ?>"></td>
                                </tr>
                            </table>
                            <input type="hidden" name="<?php echo $html_name_prefix; ?>poll_popup_position" id="ays-poll-popup-position-val" value="<?php echo $popup_position; ?>" >
                        </div>
                    </div>
                    <hr class="ays_pb_hr_hide <?php echo $popup_position == "center-center" ? "display_none" : ""; ?>"/>
                    <div id="popupMargin" class="form-group row <?php echo $popup_position == "center-center" ? "display_none" : ""; ?>">
                        <div class="col-sm-3">
                            <label for="<?php echo $this->plugin_name; ?>-pb_margin">
                                <span><?php echo __("Popup margin", "poll-maker"); ?>(px)</span>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Specify the popup margin in pixels. It accepts only numerical values.", "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="number" id="<?php echo $this->plugin_name; ?>-popup_margin" name="<?php echo $html_name_prefix; ?>poll_popup_margin"  class="ays-text-input-short"  value="<?php echo $popup_margin; ?>" />
                        </div>
                    </div>
                </div>
                <hr>
                <!-- Popup Trigger start  -->
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="<?php echo $html_name_prefix; ?>poll_popup_trigger">
                            <span> <?php echo __('Popup trigger', "poll-maker"); ?></span>
                                <a class="ays_help" data-toggle="tooltip" data-html="true"
                                title="<?php
                                    echo __('Choose when to show the popup on the website.',"poll-maker") .
                                    "<ul style='list-style-type: circle;padding-left: 20px;'>".
                                        "<li>". __('On page load - popup will be shown as soon as the page is loaded.',"poll-maker") ."</li>".
                                        "<li>". __('On click - popup will be shown when the user clicks on the assigned CSS element(s). Select CSS element with the help of CSS selector(s) option.',"poll-maker") ."</li>".
                                        "<li>". __('On Exit - the popup will show up as soon as the user wants to leave the page.',"poll-maker") ."</li>".
                                    "</ul>";
                                ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <select id="<?php echo $html_name_prefix; ?>poll_popup_trigger" class="ays-text-input ays_poll_aysDropdown" name="<?php echo $html_name_prefix; ?>poll_popup_trigger">
                            <?php
                                foreach ($trigger_type_arr as $trigger_type_key => $trigger_type_val):
                                    if($popup_trigger_type == $trigger_type_key):
                                        $selected = 'selected';
                                    else:
                                        $selected = '';
                                    endif;
                            ?>
                                <option value="<?php echo $trigger_type_key; ?>" <?php echo $selected; ?>><?php echo $trigger_type_val; ?></option>
                            <?php
                                endforeach;
                            ?>
                        </select>
                    </div>
                </div>
                <hr class="<?php echo $popup_trigger_type == 'on_load' ||  $popup_trigger_type == 'on_exit' ? 'display_none_not_important' : '' ?>"/>
                <div class="form-group row ays-poll-popup-selector <?php echo $popup_trigger_type == 'on_load' ||  $popup_trigger_type == 'on_exit' ? 'display_none_not_important' : '' ?> ">
                    <div class="col-sm-3">
                        <label for="<?php echo $html_name_prefix; ?>poll_popup_selector">
                    <span>
                        <?php echo __('CSS selector(s) for trigger click', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Add your preferred CSS selector(s) if you have given “On click” or “Both” value to the “Popup trigger” option. For example #mybutton or .mybutton.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </span>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type="text" id="<?php echo $html_name_prefix; ?>poll_popup_selector" name="<?php echo $html_name_prefix; ?>poll_popup_selector"  class="ays-text-input" value="<?php echo $popup_selector; ?>" placeholder="#myButtonId, .myButtonClass, .myButton" />
                    </div>
                </div>
                <!-- Popup Trigger end  -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_poll_popup_bg_color">
                            <span><?php echo __("Popup background color", "poll-maker"); ?></span>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Specify the background color of your popup.", "poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type="text" class="ays-text-input" id='ays_poll_popup_bg_color' name='ays_poll_popup_bg_color' data-alpha="true" value="<?php echo $poll_popup_bg_color; ?>"/>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_poll_hide_popup">
                            <span><?php echo __("Hide popup after one submission", "poll-maker"); ?></span>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __("By enabling the option, the popup will not be shown as soon as a visitor submits the poll.", "poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type="checkbox" name="ays_poll_hide_popup" class="" id="ays_poll_hide_popup" <?php echo ($hide_popup == "on") ? "checked" : ""  ?>>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_poll_enable_popup_full_screen_mode">
                            <?php echo __('Enable full-screen mode',"poll-maker")?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Allow the popup to enter full-screen mode by pressing the icon located in the top-right corner of the popup container.',"poll-maker")?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type="checkbox"
                               class="ays-enable-timer1"
                               id="ays_poll_enable_popup_full_screen_mode"
                               name="ays_poll_enable_popup_full_screen_mode"
                               value="on"
                               <?php echo $poll_popup_full_screen;?>/>
                    </div>
                </div> <!-- Open Full Screen Mode -->
            </div>
            <hr/>
            
            <input type="hidden" name="<?php echo $html_name_prefix; ?>author_id" value="<?php echo $author_id; ?>">
            <input type="hidden" name="<?php echo $html_name_prefix; ?>date_created" value="<?php echo $date_created; ?>">
            <input type="hidden" name="<?php echo $html_name_prefix; ?>date_modified" value="<?php echo $date_modified; ?>">
            <?php
                wp_nonce_field("popup_poll_action", "popup_poll_action");
                $other_attributes_save = array();
                submit_button(__("Save and close", "poll-maker"), "primary ays-button ays-loader-banner ays-apply-all", "ays_poll_popup_submit", false, $other_attributes_save);
                $other_attributes_apply = array(
                    'id' => 'ays_poll_popup_apply',
                    'title' => 'Ctrl + s',
                    'data-toggle' => 'tooltip',
                    'data-delay'=> '{"show":"1000"}'
                );
                submit_button(__("Save", "poll-maker"), "ays-button ays-loader-banner ays-apply-all", "ays_poll_popup_apply", false, $other_attributes_apply);
                echo $loader_iamge;
            ?>
        </form>
    </div>
</div>
