<?php
global $ays_poll_db_version;
$ays_poll_db_version = '7.8.2';
/**
 * Fired during plugin activation
 *
 * @link       https://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Poll_Maker_Ays
 * @subpackage Poll_Maker_Ays/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Poll_Maker_Ays
 * @subpackage Poll_Maker_Ays/includes
 * @author     Poll Maker Team <info@ays-pro.com>
 */
class Poll_Maker_Ays_Activator {

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.0
     */
    public static function activate() {
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        global $wpdb;
        if (is_multisite()) {
            // Get all blog ids
            $blog_ids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");
            
            foreach ($blog_ids as $blog_id) {
                switch_to_blog($blog_id);
                self::create_tables();
                restore_current_blog();
            }
        } else {
            self::create_tables();
        }

    }

    private static function create_tables() {
        global $wpdb;
        $polls_table      = $wpdb->prefix . 'ayspoll_polls';
        $cats_table       = $wpdb->prefix . 'ayspoll_categories';
        $answers_table    = $wpdb->prefix . 'ayspoll_answers';
        $reports_table    = $wpdb->prefix . 'ayspoll_reports';
        $formfields_table = $wpdb->prefix . 'ayspoll_formfields';
        $settings_table   = $wpdb->prefix . 'ayspoll_settings';
        $requests_table   = $wpdb->prefix . 'ayspoll_requests';
        $popup_poll_table = $wpdb->prefix . 'ayspoll_popup_poll';
        $charset_collate  = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE `".$polls_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            author_id INT(16) UNSIGNED NOT NULL DEFAULT '0',
            post_id INT(16) UNSIGNED DEFAULT NULL,
            title VARCHAR(255) NOT NULL,
            description TEXT NOT NULL,
            question TEXT NOT NULL,
            type VARCHAR(64) NOT NULL,
            view_type VARCHAR(64) NOT NULL,
            categories VARCHAR(255) NOT NULL,
            image TEXT DEFAULT '',
            show_title INT(1) DEFAULT 1,
            styles TEXT DEFAULT '',
            custom_css TEXT DEFAULT '',
            theme_id INT(5) DEFAULT 1,
            answer_message TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$polls_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$cats_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            title VARCHAR(255) NOT NULL,
            description TEXT NOT NULL,
            options TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$cats_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$answers_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            poll_id INT(11) UNSIGNED NOT NULL,
            answer TEXT NOT NULL,
            votes INT(11) NOT NULL,
            answer_img TEXT DEFAULT '',
            ordering INT(11) NOT NULL DEFAULT 1,
            redirect TEXT DEFAULT '', 
            user_added INT(1) DEFAULT 0,
            show_user_added INT(1) DEFAULT 1,
            fake_votes INT(11) NOT NULL,
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$answers_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$reports_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            answer_id INT(11) UNSIGNED NOT NULL,
            user_ip VARCHAR(255) NOT NULL,
            user_id INT(11) DEFAULT 0,
            vote_date DATETIME NOT NULL,
            user_email VARCHAR(255) NOT NULL,
            other_info TEXT DEFAULT '',
            unread  INT(1) DEFAULT 1,
            multi_answer_id  TEXT DEFAULT '',
            poll_id INT(11) UNSIGNED NOT NULL,
            country TEXT NOT NULL DEFAULT '',
            answer_value TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$reports_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$formfields_table."` (
            id INT(16) UNSIGNED NOT NULL AUTO_INCREMENT,
            name VARCHAR(255) NOT NULL,
            type VARCHAR(255) NOT NULL,
            slug VARCHAR(255) NOT NULL,
            sendgrid TEXT DEFAULT '',
            published TINYINT UNSIGNED NOT NULL,
            options TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$formfields_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `" . $settings_table . "` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `meta_key` TEXT NULL DEFAULT NULL,
            `meta_value` TEXT NULL DEFAULT NULL,
            `note` TEXT NULL DEFAULT NULL,
            `options` TEXT NULL DEFAULT NULL,
            PRIMARY KEY (`id`)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$settings_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `" . $requests_table . "` (
            `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `poll_id` INT(11) UNSIGNED DEFAULT NULL,
            `user_id` INT(11) DEFAULT 0,
            `user_ip` VARCHAR(256) NOT NULL,
            `title` VARCHAR(256) NOT NULL,
            `question` TEXT NOT NULL,
            `answers` TEXT NOT NULL,
            `category_type` VARCHAR(64) NOT NULL,
            `request_date` DATETIME NOT NULL,
            `unread`  INT(1) DEFAULT 1,
            `approved`  INT(1) DEFAULT 0,
            `category_id`  INT(1) DEFAULT 1,
            `options` TEXT NULL DEFAULT NULL,
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$requests_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `" . $popup_poll_table . "` (
            `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `poll_id` INT(11) UNSIGNED NOT NULL DEFAULT '0',
            `title` TEXT NOT NULL,
            `show_all` VARCHAR(20) NOT NULL,
            `status` VARCHAR(256) NOT NULL DEFAULT 'published',
            `trash_status` VARCHAR(256) NOT NULL DEFAULT '',
            `author_id` INT(11) UNSIGNED NOT NULL DEFAULT '0',
            `date_created` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
            `date_modified` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
            `options` TEXT NOT NULL DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$popup_poll_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        // AV added Poll id for report table
        $answers_table = $wpdb->prefix . 'ayspoll_answers';
        $report_table = $wpdb->prefix . 'ayspoll_reports';
        $polls_table = $wpdb->prefix . 'ayspoll_polls';

        $answ_id = $wpdb->get_results("SELECT DISTINCT answer_id FROM $report_table", 'ARRAY_A');
        if (isset($answ_id) && !empty($answ_id)) {
            $answer_ids = '';
            foreach ($answ_id as $key => $value) {
                if ($key == count($answ_id) - 1 ) {
                    $answer_ids .=  $value['answer_id'];
                }else{
                    $answer_ids .=  $value['answer_id'].',';
                }
            }
            $answ_poll_id = $wpdb->get_results("SELECT poll_id, id AS 'answ_id' FROM $answers_table WHERE id IN (".$answer_ids.")", 'ARRAY_A');

            if($answ_poll_id > 0){
                foreach ($answ_poll_id as $ap_key => $ap_value) {
                    $poll_result = $wpdb->update(
                        $report_table,
                        array(
                            'poll_id'     => $ap_value['poll_id']
                        ),
                        array('answer_id' => $ap_value['answ_id']),
                        array(
                            '%d'
                        ),
                        array('%d')
                    );
                }
            }
        }

        $polls_sql = "SELECT id, styles, author_id FROM ". $polls_table;
        $polls = $wpdb->get_results( $polls_sql, "ARRAY_A" );
        foreach( $polls as $poll){
            
            $poll_id = intval( $poll['id'] );
            $options = isset( $poll['styles'] ) ? json_decode( $poll['styles'], true ) : array();
            $author = isset( $options['author'] ) ? $options['author'] : array();
            $author_id = isset( $author['id'] ) ? intval( $author['id'] ) : 0;
            
            $wpdb->update(
                $polls_table,
                array(
                    'author_id'   => $author_id
                ),
                array('id' => $poll_id),
                array('%d'),
                array('%d')
            );
        }

    }

    private static function insert_default_values() {
        global $wpdb;
        $answers_table = $wpdb->prefix . 'ayspoll_answers';
        $polls_table   = $wpdb->prefix . 'ayspoll_polls';
        $cats_table    = $wpdb->prefix . 'ayspoll_categories';
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $cat_count     = $wpdb->get_var("SELECT COUNT(id) FROM $cats_table");

        if (0 == $cat_count) {
            $wpdb->insert($cats_table, array('title' => 'Uncategorized', 'description' => 'Default poll category'));
        }

        $poll_create_author  = get_current_user_id();
        $user = get_userdata($poll_create_author);
        $poll_author = array();
        if ( ! is_null( $user ) && $user ) {
            $poll_author = array(
                'id' => $user->ID."",
                'name' => $user->data->display_name
            );
        }

		$author = json_encode($poll_author, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_HEX_QUOT);
		$author = str_replace('"', '\\"', $author);

        $polls_count = $wpdb->get_var("SELECT COUNT(id) FROM $polls_table");

        if (0 == $polls_count) {
            $wpdb->insert($polls_table, array(
                'author_id'   => $poll_create_author,
                'title'       => 'Default choosing',
                'description' => 'Default choosing type ',
                'question'    => 'Did you like our plugin?',
                'type'        => 'choosing',
                'categories'  => ',1,',
				'styles'      => '{"randomize_answers":"off","main_color":"#0C6291","text_color":"#0C6291","button_text_color":"#FBFEF9","button_bg_color":"#0C6291","icon_color":"#0C6291","icon_size":24,"width":0,"width_for_mobile":0,"poll_min_height":"","btn_text":"Vote","border_style":"ridge","border_radius":"0","border_width":"2","box_shadow_color":"#000000","poll_box_shadow_x_offset":0,"poll_box_shadow_y_offset":0,"poll_box_shadow_z_offset":15,"enable_background_gradient":"off","background_gradient_color_1":"#103251","background_gradient_color_2":"#607593","poll_gradient_direction":"vertical","poll_question_size_pc":"16","poll_question_size_mobile":"16","poll_question_image_height":"","poll_question_image_object_fit":"cover","poll_mobile_max_width":"","poll_buttons_size":"medium","poll_buttons_font_size":"17","poll_buttons_mobile_font_size":"17","poll_buttons_left_right_padding":"20","poll_buttons_top_bottom_padding":"10","poll_buttons_border_radius":"3","poll_buttons_width":"","enable_box_shadow":"off","bg_color":"#FBFEF9","answer_bg_color":"#FBFEF9","answer_border_side":"all_sides","answer_font_size":"16","poll_answer_font_size_mobile":"16","poll_answer_object_fit":"cover","poll_answer_padding":"10","poll_answer_margin":"10","poll_answer_border_radius":0,"poll_answer_icon_check":"off","poll_answer_icon":"radio","poll_answer_view_type":"list","poll_answer_enable_box_shadow":"off","poll_answer_box_shadow_color":"#000000","poll_answer_box_shadow_x_offset":0,"poll_answer_box_shadow_y_offset":0,"poll_answer_box_shadow_z_offset":10,"title_bg_color":"rgba(255,255,255,0)","poll_title_font_size":"20","poll_title_font_size_mobile":"20","bg_image":false,"enable_answer_style":"on","hide_results":0,"hide_result_message":0,"hide_results_text":"Thanks for your answer!","allow_not_vote":0,"show_social":0,"load_effect":"load_gif","load_gif":"plg_default","limit_users":0,"limitation_message":"","redirect_url":"","redirection_delay":0,"user_role":"","enable_restriction_pass":0,"restriction_pass_message":"","enable_logged_users":0,"enable_logged_users_message":"","notify_email_on":0,"notify_email":"","result_sort_type":"none","create_date":"' . current_time('mysql') . '","author":"' . $author . '","redirect_users":0,"redirect_after_vote_url":"","redirect_after_vote_delay":0,"published":1,"enable_pass_count":"on","activeInterval":"2019-05-30","activeIntervalSec":"","deactiveInterval":"2019-05-30","deactiveIntervalSec":"","active_date_message":"","active_date_check":"","enable_restart_button":0,"enable_vote_btn":1,"disable_answer_hover": 0,"logo_image":"","poll_enable_logo_url":"off","poll_logo_title":"","poll_logo_url":"","custom_class":"","enable_poll_title_text_shadow":"off","poll_title_text_shadow":"rgba(255,255,255,0)","poll_title_text_shadow_x_offset":2,"poll_title_text_shadow_y_offset":2,"poll_title_text_shadow_z_offset":0,"poll_allow_multivote":"off","multivote_answer_min_count":"1","poll_allow_multivote_count":"1","poll_direction":"ltr","show_create_date":0,"show_author":0,"ays_poll_show_timer":0,"ays_show_timer_type":"countdown","show_result_btn_see_schedule":"with_see","active_date_message_soon":"","show_result_btn_schedule":0,"dont_show_poll_cont":"off","see_res_btn_text":"See Results","enable_asnwers_sound":"off","poll_vote_reason":"off","enable_view_more_button":"off","poll_view_more_button_count":0,"answer_sort_type":"default","show_answers_numbering":"none","result_message":"","poll_social_buttons_heading":"","poll_show_social_ln":"on","poll_show_social_fb":"on","poll_show_social_tr":"on","poll_show_social_vk":"off","limit_users_method":"ip","show_votes_count":1,"show_res_percent":1,"show_login_form":"off","info_form":0,"fields":"apm_name,apm_email,apm_phone","required_fields":"apm_email","info_form_title":"","enable_mailchimp":"off","redirect_after_submit":0,"mailchimp_list":"","users_role":"[]","poll_bg_image_position":"center center","poll_bg_img_in_finish_page":"off","ays_add_post_for_poll":"off","result_in_rgba":"off","show_passed_users":"off","see_result_button":"on","see_result_radio":"ays_see_result_button","loader_font_size":"64","effect_message":"","poll_allow_collecting_users_data":"off","poll_every_answer_redirect_delay":"","poll_enable_answer_image_after_voting":"off","poll_enable_answer_redirect_delay":"off","poll_show_passed_users_count":3,"poll_allow_answer":"off","poll_allow_answer_require":"off","poll_answer_image_height":"150","poll_answer_image_height_for_mobile":"150","poll_answer_image_border_radius":"0","poll_title_alignment":"center","poll_title_alignment_mobile":"center","poll_text_type_length_enable":"off","poll_text_type_limit_type":"characters","poll_text_type_limit_length":"","poll_text_type_limit_message":"off","poll_text_type_placeholder":"Your answer","poll_text_type_width":"","poll_text_type_width_type":"percent","poll_enable_password":"off","poll_password":"","poll_enable_password_visibility":"off","poll_password_message":"","display_fields_labels":"off","autofill_user_data":"off","poll_logo_url_new_tab":"off","poll_create_author":' . $poll_create_author . ',"enable_social_links":"off","poll_social_links_heading":"","social_links":{"linkedin_link":"","facebook_link":"","twitter_link":"","vkontakte_link":"","youtube_link":""},"show_chart_type":"default_bar_chart","show_chart_type_google_height":"400","border_color":"#0C6291"}',
                'theme_id'    => 1,
            ));
            $last_insert = $wpdb->insert_id;
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'It was a mistake'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'There was nothing special'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'Everything\'s ok'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'I enjoyed it'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'It\'s amazing'));

            // $wpdb->insert($polls_table, array(
            //     'author_id'   => $poll_create_author,
            //     'title'       => 'Default rating',
            //     'description' => 'Default rating type ',
            //     'question'    => 'Did you like our plugin?',
            //     'type'        => 'rating',
            //     'view_type'   => 'star',
            //     'categories'  => ',1,',
            //     'styles'      => '{"main_color":"#0C6291","text_color":"#0C6291","button_text_color":"#FBFEF9","button_bg_color":"#0C6291","icon_color":"#0C6291","icon_size":24,"width":0,"btn_text":"Vote","border_style":"ridge","bg_color":"#FBFEF9","answer_bg_color":"rgba(255,255,255,0)","answer_border_side":"all_sides","title_bg_color":"rgba(255,255,255,0)","width_for_mobile":0,"see_res_btn_text":"See Results","border_radius":"0","border_width":"1","box_shadow_color":"#000000","enable_box_shadow":"off","poll_box_shadow_x_offset":0,"poll_box_shadow_y_offset":0,"poll_box_shadow_z_offset":15,"enable_answer_style":"","bg_image":false,"info_form":0,"fields":"apm-name,apm-email,apm_phone","required_fields":"apm-name,apm-email,apm_phone","info_form_title":"","hide_results":0,"hide_results_questions":0,"hide_result_message":0,"hide_results_text":"","result_message":"","allow_not_vote":0,"show_social":0,"poll_social_buttons_heading":"","poll_show_social_ln":"on","poll_show_social_fb":"on","poll_show_social_tr":"on","poll_show_social_vk":"off","enable_social_links":"off","poll_social_links_heading":"","social_links":{"linkedin_link":"","facebook_link":"","twitter_link":"","vkontakte_link":"","youtube_link":""},"load_effect":"load_gif","load_gif":"plg_pro1","custom_load":false,"limit_users":0,"limit_users_method":"ip","limitation_message":"","dont_show_poll_container_attempts":"off","redirect_url":false,"redirection_delay":0,"user_role":"","enable_restriction_pass":0,"restriction_pass_message":"","enable_logged_users":0,"enable_logged_users_message":"","notify_email_on":0,"notify_email":"","published":1,"enable_pass_count":"on","result_sort_type":"none","create_date":"' . current_time('mysql') . '","redirect_users":0,"redirect_after_vote_url":false,"redirect_after_vote_delay":0,"activeInterval":"2019-05-30","activeIntervalSec":"","deactiveInterval":"2019-05-30","deactiveIntervalSec":"","active_date_message":"","active_date_message_soon":"","vote_reason":0,"show_result_view":"standart","active_date_check":"","enable_restart_button":0,"enable_vote_btn":1,"show_votes_count":1,"attempts_count":"1","allow_anonymity":0,"show_create_date":0,"show_author":0,"show_res_percent":1,"show_result_btn_schedule":0,"ays_poll_show_timer":0,"ays_show_timer_type":"countdown","show_result_btn_see_schedule":"with_see","show_login_form":"off","user_add_answer":0,"add_answer_show_up":1,"versus_icon_type":"default","versus_icon_position":"center","versus_answers_label":0,"result_in_rgba":0,"enable_mailchimp":"off","enable_background_gradient":"off","background_gradient_color_1":"#103251","background_gradient_color_2":"#607593","poll_gradient_direction":"vertical","redirect_after_submit":0,"mailchimp_list":"","poll_direction":"ltr","poll_allow_multivote":"off","multivote_answer_min_count":"1","poll_allow_multivote_count":"1","monitor_list":"","enable_monitor":"off","slack_conversation":"","enable_slack":"off","active_camp_list":"","active_camp_automation":"","enable_active_camp":"off","enable_zapier":"off","randomize_answers":"off","enable_asnwers_sound":"off","enable_password":"off","password_poll":"","poll_password_message":"Please enter password","poll_enable_password_visibility":"off","background_size":"cover","disable_answer_hover":0,"custom_class":"","enable_poll_title_text_shadow":"off","poll_title_text_shadow":"rgba(255,255,255,0)","poll_title_text_shadow_x_offset":2,"poll_title_text_shadow_y_offset":2,"poll_title_text_shadow_z_offset":0,"poll_bg_image_position":"center center","poll_bg_img_in_finish_page":"off","ays_add_post_for_poll":"off","show_answer_message":"off","show_answers_caption":"on","enable_vote_limitation":"off","vote_limitation":"","limitation_time_period":"minute","enable_tackers_count":"off","tackers_count":"","ays_enable_mail_user":"off","vote_notification_email_msg":"","show_answers_icon":"off","answers_icon":"radio","buttons_size":"medium","buttons_font_size":"17","poll_buttons_mobile_font_size":"17","buttons_left_right_padding":"20","buttons_top_bottom_padding":"10","buttons_border_radius":"3","redirect_after_submit_drpdwn":0,"user_add_answer_dropdown":0,"enable_google_sheets":"off","spreadsheet_id":"","enable_view_more_button":"off","poll_view_more_button_count":0,"poll_min_height":"","answer_sort_type":"default","answer_font_size":"16","poll_answer_font_size_mobile":"16","show_passed_users":"off","logo_image":"","allow_collect_user_info":"off","poll_send_mail_type":"custom","poll_sendgrid_email_from":"","poll_sendgrid_email_name":"","poll_sendgrid_template_id":"","enable_limit_by_country":"off","limit_country":"AD","show_votes_before_voting":"off","show_votes_before_voting_by":"by_count","fake_votes":"off","dont_show_poll_cont":"off","see_result_button":"on","see_result_radio":"ays_see_result_button","loader_font_size":"","show_answers_numbering":"none","effect_message":"","enable_mad_mimi":"off","mad_mimi_list":"","poll_show_passed_users_count":3,"question_font_size":16,"question_font_size_mobile":16,"poll_question_image_height":"","poll_mobile_max_width":"","poll_title_font_size":"18","poll_title_font_size_mobile":"20","poll_title_alignment":"center","poll_enable_answer_image_after_voting":"off","poll_text_type_length_enable":"off","poll_text_type_limit_type":"characters","poll_text_type_limit_length":"","poll_text_type_limit_message":"off","poll_text_type_placeholder":"Your answer","poll_text_type_width":"","poll_text_type_width_type":"percent","answers_padding":10,"answers_margin":10,"answers_border":"on","answers_border_width":1,"answers_border_style":"solid","answers_border_color":"","answers_box_shadow":"off","answers_box_shadow_color":"#000","poll_answer_box_shadow_x_offset":0,"poll_answer_box_shadow_y_offset":0,"poll_answer_box_shadow_z_offset":10,"ans_img_height":"150","poll_answer_image_height_for_mobile":"150","ans_img_caption_style":"outside","ans_img_caption_position":"bottom","answers_font_size":"15","answers_object_fit":"cover","answers_grid_column":"2","answers_border_radius":"0","enable_getResponse":"off","getResponse_list":"","enable_mailerLite":"off","mailerLite_group_id":"","enable_convertKit":"off","poll_convertKit_form_id":"","enable_recaptcha":"off","poll_logo_url":"","poll_enable_logo_url":"off","poll_logo_url_new_tab":"off","poll_logo_title":"","poll_send_mail_to_site_admin":"on","poll_mail_message_admin":"","poll_admin_email_subject":"","poll_email_configuration_from_email":"","poll_email_configuration_from_name":"","poll_email_configuration_from_subject":"","poll_email_configuration_replyto_email":"","poll_email_configuration_replyto_name":"","display_fields_labels":"off","autofill_user_data":"off","poll_create_author":' . $poll_create_author . '}',
            //     'theme_id'    => 1,
            // ));
            // $last_insert = $wpdb->insert_id;
            // $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '1'));
            // $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '2'));
            // $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '3'));
            // $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '4'));
            // $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '5'));
        }

        $metas = array(
            "user_roles",
            "mailchimp",
            "monitor",
            "slack",
            "active_camp",
            "zapier",
            "leaderboard",
            "google_sheet",
            "sendgrid",
            "poll_default_options",
            "options",
            "mad_mimi",
            "get_response",
            "mailerLite",
            "recaptcha",
            "convertKit",
            "category_leaderboard",
            "fields_placeholders"
        );
        
        foreach($metas as $meta_key){
            $meta_val = "";
            if($meta_key == "user_roles"){
                $meta_val = json_encode(array('administrator'));
            }
            $sql = "SELECT COUNT(*) FROM `".$settings_table."` WHERE `meta_key` = '".$meta_key."'";
            $result = $wpdb->get_var($sql);
            if(intval($result) == 0){
                $result = $wpdb->insert(
                    $settings_table,
                    array(
                        'meta_key'    => $meta_key,
                        'meta_value'  => $meta_val,
                        'note'        => "",
                        'options'     => ""
                    ),
                    array( '%s', '%s', '%s', '%s' )
                );
            }
        }
    }

    public static function ays_poll_update_db_check() {
        global $ays_poll_db_version, $wpdb;

        if (is_multisite()) {
            $blog_ids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");
            foreach ($blog_ids as $blog_id) {
                switch_to_blog($blog_id);
                
                $current_version = get_blog_option($blog_id, 'ays_poll_db_version', '0');
                
                if ($current_version != $ays_poll_db_version) {
                    self::activate();
                    self::insert_default_values();
                    update_blog_option($blog_id, 'ays_poll_db_version', $ays_poll_db_version);
                    
                    if ($current_version === '0') {
                        update_blog_option($blog_id, 'ays_poll_maker_first_time_activation_page', true);
                        update_blog_option($blog_id, 'ays_poll_maker_poll_creation_challange', true);
                    }
                }
                
                restore_current_blog();
            }
        } else {
            $is_plugin_downloaded = get_option('ays_poll_db_version', false) === false;

            if ($is_plugin_downloaded) {
                update_option('ays_poll_maker_first_time_activation_page', true);
                update_option('ays_poll_maker_poll_creation_challange', true);
            }

            if (get_site_option('ays_poll_db_version') != $ays_poll_db_version) {
                self::activate();
                update_site_option('ays_poll_db_version', $ays_poll_db_version);
                self::insert_default_values();
            }
        }
    }
}