<?php
ob_start();

class Pma_Categories_List_Table extends WP_List_Table {
	private $plugin_name;
	private $title_length;

	/** Class constructor */
	public function __construct( $plugin_name ) {
		$this->plugin_name = $plugin_name;
		$this->title_length = Poll_Maker_Ays_Admin::get_listtables_title_length('categories');
		parent::__construct(array(
			'singular' => __('Category', "poll-maker"), //singular name of the listed records
			'plural'   => __('Categories', "poll-maker"), //plural name of the listed records
			'ajax'     => false, //does this table support ajax?
		));
		add_action('admin_notices', array($this, 'poll_category_notices'));

	}

	/**
	 * Retrieve customers data from the database
	 *
	 * @param int $per_page
	 * @param int $page_number
	 *
	 * @return mixed
	 */
	public static function get_poll_categories( $per_page = 20, $page_number = 1, $search = '' ) {

		global $wpdb;

		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_categories";

		if( $search != '' ){
            $where[] = $search;
        }

		// Get where condition to filter
		$where = self::get_where_condition();
		$sql .= $where;
		

		if (!empty($_REQUEST['orderby'])) {
			$sql .= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
			$sql .= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' DESC';
		} else {
			$sql .= ' ORDER BY id DESC';
		}

		$sql .= " LIMIT $per_page";
		$sql .= ' OFFSET ' . ($page_number - 1) * $per_page;

		$result = $wpdb->get_results($sql, 'ARRAY_A');

		return $result;
	}

	public function get_poll_category( $id ) {
		global $wpdb;

		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_categories WHERE id=" . absint(intval($id));

		$result = $wpdb->get_row($sql, 'ARRAY_A');

		return $result;
	}

	public function add_edit_poll_category( $data, $id = null, $ays_change_type = "" ) {
		global $wpdb;
		$cats_table = $wpdb->prefix . 'ayspoll_categories';

		if (isset($data["poll_category_action"]) && wp_verify_nonce($data["poll_category_action"], 'poll_category_action')) {
			$title       = stripslashes(sanitize_text_field($data['ays_title']));
			$description = stripslashes(sanitize_textarea_field($data['ays_description']));
			$skip_poll   = sanitize_text_field($data['ays_poll_allow_skip']);
			$next_text   = sanitize_text_field($data['ays_poll_next_text']);
			$allow_autonext = (isset($data['ays_poll_allow_autonext']) && $data['ays_poll_allow_autonext'] != '') ? $data['ays_poll_allow_autonext'] : '';
			$previous_text = (isset($data['ays_poll_previous_text']) && $data['ays_poll_previous_text'] != '') ? $data['ays_poll_previous_text'] : '';
			// ==== ADDED NEW ====
			$default_message = 'The polls that belong to this category are expired or unpublished';
			$exp_message = (isset($data['ays_poll_cat_message']) && $data['ays_poll_cat_message'] != '') ? stripslashes( wp_kses_post($data['ays_poll_cat_message']) ) : $default_message;
			// $exp_message = (isset($data['ays_poll_cat_message']) && $data['ays_poll_cat_message'] != '') ? sanitize_text_field($data['ays_poll_cat_message']) : $default_message;

			// Previous Button Disabel 
			$poll_disable_prev = isset($data['ays_poll_disable_prev_button']) && $data['ays_poll_disable_prev_button'] == 'on' ? 'on' : 'off'; 
			// ==== ====
			$options     = array(
				"allow_skip"        => $skip_poll,
				"next_text"         => $next_text,
				"previous_text"     => $previous_text,
				'allow_autonext'    => $allow_autonext,
				"exp_message"       => $exp_message,
				"poll_disable_prev" => $poll_disable_prev
			);
			if ($id == null) {
				$result  = $wpdb->insert(
					$cats_table,
					array(
						'title'       => $title,
						'description' => $description,
						'options'     => json_encode($options, true),
					),
					array('%s', '%s', '%s')
				);
				$message = 'created';
				$last_id = $wpdb->insert_id;
			} else {
				$result  = $wpdb->update(
					$cats_table,
					array(
						'title'       => $title,
						'description' => $description,
						'options'     => json_encode($options, true),
					),
					array('id' => $id),
					array('%s', '%s', '%s'),
					array('%d')
				);
				$message = 'updated';
			}

			if ($result >= 0) {
				if ('' != $ays_change_type) {
					// $url = esc_url_raw(remove_query_arg(false)) . '&status=' . $message;
					if($id == null){
						$url = esc_url_raw( add_query_arg( array(
							"action"    	 => "edit",
							"poll_category"  => $last_id,
							"status"    	 => $message
						) ) );
					}
					else{
						$url = esc_url_raw( remove_query_arg(false) ) . '&status=' . $message;
					}
					wp_redirect($url);
				} else {
					$url = esc_url_raw(remove_query_arg(array('action', 'poll_category'))) . '&status=' . $message;
					wp_redirect($url);
				}
			}
		}
	}

	/**
	 * Delete a customer record.
	 *
	 * @param int $id customer ID
	 */
	public static function delete_poll_categories( $id ) {
		global $wpdb;
		$wpdb->delete(
			"{$wpdb->prefix}ayspoll_categories",
			array('id' => $id),
			array('%d')
		);
	}

	/**
	 * Returns the count of records in the database.
	 *
	 * @return null|string
	 */
	public static function record_count() {
		global $wpdb;
		$filter = array();
		$cat_table = esc_sql($wpdb->prefix."ayspoll_categories");
		$sql = "SELECT COUNT(*) FROM ".$cat_table;

        $search = ( isset( $_REQUEST['s'] ) ) ? sanitize_text_field( $_REQUEST['s'] ) : false;
        if( $search ){
            $filter[] = sprintf(" title LIKE '%%%s%%' ", esc_sql( $wpdb->esc_like( $search ) ) );
        }

        if(count($filter) !== 0){
            $sql .= " WHERE ".implode(" AND ", $filter);
        }

		return $wpdb->get_var($sql);
	}

	/** Text displayed when no customer data is available */
	public function no_items() {
		_e('There are no poll categories yet.', "poll-maker");
	}

	/**
	 * Render a column when no column specific method exist.
	 *
	 * @param array $item
	 * @param string $column_name
	 *
	 * @return mixed
	 */
	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'title':
			case 'description':
			case 'polls':
				return $item[$column_name];
				break;
			case 'id':
				return $item[$column_name];
				break;
			default:
				return print_r($item, true); //Show the whole array for troubleshooting purposes
		}
	}

	/**
	 * Render the bulk edit checkbox
	 *
	 * @param array $item
	 *
	 * @return string
	 */
	function column_cb( $item ) {
		if(intval($item['id']) === 1){
            return;
        }
		return sprintf(
			'<input type="checkbox" name="bulk-delete[]" value="%s">', $item['id']
		);
	}

	function column_shortcode( $item ) {
		return sprintf('<input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="[ays_poll cat_id=%s]" />', $item["id"]);
	}

	/**
	 * Method for name column
	 *
	 * @param array $item an array of DB data
	 *
	 * @return string
	 */
	function column_title( $item ) {
		$delete_nonce = wp_create_nonce($this->plugin_name . '-delete-poll-category');

		// $title = sprintf('<a href="?page=%s&action=%s&poll_category=%d"><strong>' . $item['title'] . '</strong></a>', esc_attr($_REQUEST['page']), 'edit', absint($item['id']));
		$category_title = stripslashes(esc_attr($item['title']));

		$categories_title_length = intval( $this->title_length );

		$restitle = Poll_Maker_Ays_Admin::ays_restriction_string("word", $category_title, $categories_title_length);
		
		$title = sprintf('<a href="?page=%s&action=%s&poll_category=%d"><strong>%s</strong></a>', esc_attr($_REQUEST['page']), 'edit', absint($item['id']) ,$restitle);

		$actions = array(
			'edit'   => sprintf('<a href="?page=%s&action=%s&poll_category=%d">' . __('Edit', "poll-maker") . '</a>', esc_attr($_REQUEST['page']), 'edit', absint($item['id'])),
			// 'delete' => sprintf('<a href="?page=%s&action=%s&poll_category=%s&_wpnonce=%s">' . __('Delete', "poll-maker") . '</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce),
		);

		if(intval($item['id']) !== 1){
            $actions['delete'] = sprintf('<a href="?page=%s&action=%s&poll_category=%s&_wpnonce=%s">' . __('Delete', "poll-maker") . '</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce);
        }

		return $title . $this->row_actions($actions);
	}

	/**
	 *  Associative array of columns
	 *
	 * @return array
	 */
	function get_columns() {
		$columns = array(
			'cb'          => '<input type="checkbox">',
			'title'       => __('Title', "poll-maker"),
			'description' => __('Description', "poll-maker"),
			'shortcode'   => __('ShortCode', "poll-maker"),
			'polls'       => __('Polls', "poll-maker"),
			'id'          => __('ID', "poll-maker"),
		);

		return $columns;
	}

	/**
	 * Columns to make sortable.
	 *
	 * @return array
	 */
	public function get_sortable_columns() {
		$sortable_columns = array(
			'title' => array('title', true),
			'id'    => array('id', true),
		);

		return $sortable_columns;
	}

	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		$actions = array(
			'bulk-delete' => __('Delete', "poll-maker"),
		);

		return $actions;
	}

	/**
	 * Handles data query and filter, sorting, and pagination.
	 */
	public function prepare_items() {

		$this->_column_headers = $this->get_column_info();

		/** Process bulk action */
		$this->process_bulk_action();

		$per_page     = $this->get_items_per_page('poll_cats_per_page', 20);
		$current_page = $this->get_pagenum();
		$total_items  = self::record_count();

		$this->set_pagination_args(array(
			'total_items' => $total_items, //WE have to calculate the total number of items
			'per_page'    => $per_page, //WE have to determine how many items to show on a page
		));

		$search = ( isset( $_REQUEST['s'] ) ) ? sanitize_text_field( $_REQUEST['s'] ) : false;

        $do_search = ( $search ) ? sprintf(" title LIKE '%%%s%%' ", $search ) : '';

		$this->items = self::get_poll_categories($per_page, $current_page, $do_search);

	}

	public function process_bulk_action() {
		//Detect when a bulk action is being triggered...
		if ('delete' === $this->current_action()) {

			// In our file that handles the request, verify the nonce.
			$nonce = esc_attr($_REQUEST['_wpnonce']);

			if (!wp_verify_nonce($nonce, $this->plugin_name . '-delete-poll-category')) {
				die('Go get a life script kiddies');
			} else {
				self::delete_poll_categories(absint($_GET['poll_category']));

				// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
				// add_query_arg() return the current url

				$url = esc_url_raw(remove_query_arg(['action', 'poll_category', '_wpnonce'])) . '&status=deleted';
				wp_redirect($url);
			}

		}

		// If the delete bulk action is triggered
		if ((isset($_POST['action']) && 'bulk-delete' == $_POST['action'])
		    || (isset($_POST['action2']) && 'bulk-delete' == $_POST['action2'])
		) {

			$delete_ids = esc_sql($_POST['bulk-delete']);

			// loop over the array of record IDs and delete them
			foreach ( $delete_ids as $id ) {
				self::delete_poll_categories($id);

			}

			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
			// add_query_arg() return the current url
			$url = esc_url_raw(remove_query_arg(['action', 'poll_category', '_wpnonce'])) . '&status=deleted';
			wp_redirect($url);
		}
	}

	public function poll_category_notices() {
		$status = (isset($_REQUEST['status'])) ? sanitize_text_field($_REQUEST['status']) : '';

		if (empty($status)) {
			return;
		}

		if ('created' == $status) {
			$updated_message = esc_html(__('Poll category created.', "poll-maker"));
		} elseif ('updated' == $status) {
			$updated_message = esc_html(__('Poll category saved.', "poll-maker"));
		} elseif ('deleted' == $status) {
			$updated_message = esc_html(__('Poll category deleted.', "poll-maker"));
		}

		if (empty($updated_message)) {
			return;
		}

		?>
        <div class="notice notice-success is-dismissible">
            <p> <?php echo $updated_message; ?> </p>
        </div>
		<?php
	}

	public static function get_where_condition(){
		global $wpdb;

        $where = array();
        $sql = '';
 
		// Search by title
		$search = ( isset( $_REQUEST['s'] ) ) ? esc_sql( sanitize_text_field( $_REQUEST['s'] ) ) : false;
        if( $search ){
            $where[] = sprintf("title LIKE '%%%s%%'", esc_sql( $wpdb->esc_like( $search ) ) );
        }

		if( !empty($where) ){
			$sql = " WHERE " . implode( " AND ", $where );
		}
		
		return $sql;
    }


	function column_polls( $item ) {
        global $wpdb;
        $polls_table    = $wpdb->prefix ."ayspoll_polls";
        $categories_table = $wpdb->prefix . "ayspoll_categories";

        $sql = "SELECT COUNT(*)
                FROM " . $categories_table . " c
                JOIN " . $polls_table . " p
                    ON FIND_IN_SET(c.id, p.categories )
                WHERE c.id = " . esc_sql( absint( $item['id'] ) );
        $result = $wpdb->get_var($sql);
        
        if ( isset($result) && $result > 0 ) {
            $result = sprintf( '<a href="?page=%s&filterby=%d" target="_blank">%s</a>', 'poll-maker-ays', $item['id'], $result );
        }

        return "<p style='font-size:14px;'>" . $result . "</p>";
	}

}