<?php
ob_start();
class Pma_Formfields_List_Table extends WP_List_Table {
    private $plugin_name;
    /** Class constructor */
    public function __construct($plugin_name) {
        $this->plugin_name = $plugin_name;
        parent::__construct([
            'singular' => __('Poll Formfield', "poll-maker"), //singular name of the listed records
            'plural' => __('Poll Formfields', "poll-maker"), //plural name of the listed records
            'ajax' => false, //does this table support ajax?
        ]);
        add_action('admin_notices', array($this, 'poll_formfield_notices'));
    }

    /**
     * Retrieve customers data from the database
     *
     * @param int $per_page
     * @param int $page_number
     *
     * @return mixed
     */
    public static function get_poll_formfields($per_page = 20, $page_number = 1) {

        global $wpdb;

        $sql = "SELECT * FROM {$wpdb->prefix}ayspoll_formfields";

        if (!empty($_REQUEST['orderby'])) {
            $sql .= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
            $sql .= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' DESC';
        } else {
            $sql .= ' ORDER BY id DESC';
        }

        $sql .= " LIMIT $per_page";
        $sql .= ' OFFSET ' . (($page_number - 1) * $per_page);

        $result = $wpdb->get_results($sql, 'ARRAY_A');

        return $result;
    }

    public function get_new_slug_id() {
        global $wpdb;
        $sql = "SELECT id FROM {$wpdb->prefix}ayspoll_formfields ORDER BY id DESC LIMIT 1";
        $new_id = $wpdb->get_var($sql);
        return ++$new_id;
    }

    public function add_edit_poll_formfield($data, $id = null, $ays_change_type = "") {
        global $wpdb;
        $poll_formfield_table = $wpdb->prefix . 'ayspoll_formfields';

        if (isset($data["poll_formfield_action"]) && wp_verify_nonce($data["poll_formfield_action"], 'poll_formfield_action')) {
            $name = stripslashes(sanitize_text_field($data['ays_name']));
            $slug = stripslashes($data['ays_slug']);
            $type = stripslashes($data['ays_poll_formfield_type']);
            $publish = absint(intval($data['ays_publish']));

            // SendGrid subtitution tags  
            $sendgrid = ( isset($data['ays_sendgrid_subtitution_tags']) && $data['ays_sendgrid_subtitution_tags'] != '' ) ? stripslashes($data['ays_sendgrid_subtitution_tags']) : '';

            $message = '';
            $options = '';
            if($data['ays_poll_formfield_type'] == "select"){
                $options = trim(stripslashes(sanitize_text_field($data['ays_poll_attr_options'] )), ';');
            }elseif($data['ays_poll_formfield_type'] == "checkbox"){
                $options = stripslashes(htmlspecialchars($data['ays_poll_attr_description'] ));
            }
            if ($id == 0) {
                $result = $wpdb->insert(
                    $poll_formfield_table,
                    array(
                        'name'      => $name,
                        'slug'      => $slug,
                        'type'      => $type,
                        'published' => $publish,
                        'sendgrid'  => $sendgrid,
                        'options'   => $options,
                    ),
                    array(
                        '%s', // name
                        '%s', // slug
                        '%s', // type
                        '%d', // published
                        '%s', // sendgrid
                        '%s', // options
                    )
                );
                $message = 'created';
                $last_id = $wpdb->insert_id;
            } else {
                $result = $wpdb->update(
                    $poll_formfield_table,
                    array(
                        'name'      => $name,
                        'slug'      => $slug,
                        'type'      => $type,
                        'published' => $publish,
                        'sendgrid'  => $sendgrid,
                        'options'   => $options,
                    ),
                    array('id' => $id),
                    array(
                        '%s', // name
                        '%s', // slug
                        '%s', // type
                        '%d', // published
                        '%s', // sendgrid
                        '%s', // options
                    ),
                    array('%d')
                );
                $message = 'updated';
            }

            if ($result >= 0) {
                if ($ays_change_type != '') {
                    if($id == null){ 
                        $url = esc_url_raw(add_query_arg(array(
                            "action"    	 => "edit",
                            "poll_formfield"  => $last_id,
                            "status"    	 => $message
                        )));
                    } else{
						$url = esc_url_raw( remove_query_arg(false) ) . '&status=' . $message;
					}
                    wp_redirect($url);
                } else {
                    $url = esc_url_raw(remove_query_arg(['action', 'question'])) . '&status=' . $message;
                    wp_redirect($url);
                }
            }
        }
    }

    /**
     * Delete a customer record.
     *
     * @param int $id customer ID
     */
    public static function delete_poll_formfields($id) {
        global $wpdb;
        $wpdb->delete(
            "{$wpdb->prefix}ayspoll_formfields",
            ['id' => $id],
            ['%d']
        );
    }

    /**
     * Returns the count of records in the database.
     *
     * @return null|string
     */
    public static function record_count() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_formfields";

        return $wpdb->get_var($sql);
    }

    /** Text displayed when no customer data is available */
    public function no_items() {
        _e('There are no Form Custom Fields yet.', "poll-maker");
    }

    /**
     * Render a column when no column specific method exist.
     *
     * @param array $item
     * @param string $column_name
     *
     * @return mixed
     */
    public function column_default($item, $column_name) {
        switch ($column_name) {
        case 'name':
        case 'slug':
        case 'type':
        case 'published':
        case 'id':
            return $item[$column_name];
            break;
        default:
            return print_r($item, true); //Show the whole array for troubleshooting purposes
        }
    }

    /**
     * Render the bulk edit checkbox
     *
     * @param array $item
     *
     * @return string
     */
    function column_cb($item) {
        return sprintf(
            '<input type="checkbox" name="bulk-delete[]" value="%s" />', $item['id']
        );
    }

    /**
     * Method for slug column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_slug($item) {
        return sprintf('<input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%s" />', $item["slug"]);
    }

    /**
     * Method for name column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_name($item) {
        $delete_nonce = wp_create_nonce($this->plugin_name . '-delete-poll-formfield');

        $title = sprintf('<a href="?page=%s&action=%s&poll_formfield=%d"><strong>' . $item['name'] . '</strong></a>', esc_attr($_REQUEST['page']), 'edit', absint($item['id']));

        $actions = [
            'edit' => sprintf('<a href="?page=%s&action=%s&poll_formfield=%d">' . __('Edit', "poll-maker") . '</a>', esc_attr($_REQUEST['page']), 'edit', absint($item['id'])),
            'delete' => sprintf('<a href="?page=%s&action=%s&poll_formfield=%s&_wpnonce=%s">' . __('Delete', "poll-maker") . '</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce),
        ];

        return $title . $this->row_actions($actions);
    }

    function column_published($item) {
        switch ($item['published']) {
        case "1":
            return '<span class="ays-publish-status">' . __('Published', "poll-maker") . '</span>';
            break;
        case "0":
            return '<span class="ays-publish-status">' . __('Unpublished', "poll-maker") . '</span>';
            break;
        }
    }

    /**
     *  Associative array of columns
     *
     * @return array
     */
    function get_columns() {
        $columns = [
            'cb' => '<input type="checkbox" />',
            'name' => __('Name', "poll-maker"),
            'slug' => __('Slug', "poll-maker"),
            'type' => __('Type', "poll-maker"),
            'published' => __('Status', "poll-maker"),
            'id' => __('ID', "poll-maker"),
        ];

        return $columns;
    }

    /**
     * Columns to make sortable.
     *
     * @return array
     */
    public function get_sortable_columns() {
        $sortable_columns = array(
            'name' => array('title', true),
            'type' => array('type', true),
            'published' => array('published', true),
            'id' => array('id', true),
        );

        return $sortable_columns;
    }

    /**
     * Returns an associative array containing the bulk action
     *
     * @return array
     */
    public function get_bulk_actions() {
        $actions = [
            'bulk-delete' => __('Delete', "poll-maker"),
        ];

        return $actions;
    }

    /**
     * Handles data query and filter, sorting, and pagination.
     */
    public function prepare_items() {

        $this->_column_headers = $this->get_column_info();

        /** Process bulk action */
        $this->process_bulk_action();

        $per_page = $this->get_items_per_page('poll_formfields_per_page', 20);
        $current_page = $this->get_pagenum();
        $total_items = self::record_count();

        $this->set_pagination_args([
            'total_items' => $total_items, //WE have to calculate the total number of items
            'per_page' => $per_page, //WE have to determine how many items to show on a page
        ]);

        $this->items = self::get_poll_formfields($per_page, $current_page);
    }
    public function get_formfield_by_id($formfield_id) {
        global $wpdb;
        $sql = "SELECT * FROM {$wpdb->prefix}ayspoll_formfields where `id`=" . absint(intval($formfield_id));
        $result = $wpdb->get_row($sql, 'ARRAY_A');
        return $result;
    }

    public function process_bulk_action() {

        //Detect when a bulk action is being triggered...
        if ('delete' === $this->current_action()) {

            // In our file that handles the request, verify the nonce.
            $nonce = esc_attr($_REQUEST['_wpnonce']);

            if (!wp_verify_nonce($nonce, $this->plugin_name . '-delete-poll-formfield')) {
                die('Go get a life script kiddies');
            } else {
                self::delete_poll_formfields(absint($_GET['poll_formfield']));

                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"
                // add_query_arg() return the current url

                $url = esc_url_raw(remove_query_arg(['action', 'poll_formfield', '_wpnonce'])) . '&status=deleted';
                wp_redirect($url);
            }

        }

        // If the delete bulk action is triggered
        if ((isset($_POST['action']) && $_POST['action'] == 'bulk-delete') || (isset($_POST['action2']) && $_POST['action2'] == 'bulk-delete')) {

            $delete_ids = esc_sql($_POST['bulk-delete']);

            // loop over the array of record IDs and delete them
            foreach ($delete_ids as $id) {
                self::delete_poll_formfields($id);

            }

            // esc_url_raw() is used to prevent converting ampersand in url to "#038;"
            // add_query_arg() return the current url
            $url = esc_url_raw(remove_query_arg(['action', 'poll_formfield', '_wpnonce'])) . '&status=deleted';
            wp_redirect($url);
        }
    }

    public function poll_formfield_notices() {
        $status = (isset($_REQUEST['status'])) ? sanitize_text_field($_REQUEST['status']) : '';

        if (empty($status)) {
            return;
        }

        if ('created' == $status) {
            $updated_message = esc_html(__('Poll Formfield created.', "poll-maker"));
        } elseif ('updated' == $status) {
            $updated_message = esc_html(__('Poll Formfield saved.', "poll-maker"));
        } elseif ('deleted' == $status) {
            $updated_message = esc_html(__('Poll Formfield deleted.', "poll-maker"));
        }

        if (empty($updated_message)) {
            return;
        }

        ?>
        <div class="notice notice-success is-dismissible">
            <p> <?php echo $updated_message; ?> </p>
        </div>
        <?php
}
}