<?php
ob_start();

class Pma_Requests_List_Table extends WP_List_Table {
	private $plugin_name;

	/** Class constructor */
	public function __construct( $plugin_name ) {
		$this->plugin_name = $plugin_name;
		parent::__construct(array(
			'singular' => __('Request', "poll-maker"), //singular name of the listed records
			'plural'   => __('Requests', "poll-maker"), //plural name of the listed records
			'ajax'     => false, //does this table support ajax?
		));
		add_action('admin_notices', array($this, 'results_notices'));

	}

	/**
	 * Retrieve customers data from the database
	 *
	 * @param int $per_page
	 * @param int $page_number
	 *
	 * @return mixed
	 */
	public static function get_reports( $per_page = 20, $page_number = 1 ) {

		global $wpdb;

		$requests_table = $wpdb->prefix . 'ayspoll_requests';

        $sql = "SELECT * FROM ".$requests_table;

		if (!empty($_REQUEST['orderby'])) {
			$sql .= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
			$sql .= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' DESC';
		} else {
			$sql .= ' ORDER BY id DESC';
		}

		$sql .= " LIMIT $per_page";
		$sql .= ' OFFSET ' . ($page_number - 1) * $per_page;

		$result = $wpdb->get_results($sql, 'ARRAY_A');

		return $result;
	}

	public function get_report_by_id( $id ) {
		global $wpdb;

		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_reports WHERE id=" . absint(intval($id));

		$result = $wpdb->get_row($sql, 'ARRAY_A');

		return $result;
	}

	public static function ays_poll_add_bulk_approve($id) {
    	error_reporting(0);
        global $wpdb;
        $polls_table    = $wpdb->prefix . 'ayspoll_polls';
        $answers_table  = $wpdb->prefix . 'ayspoll_answers';
        $requests_table = $wpdb->prefix . 'ayspoll_requests';
        
	        if ($id == null) {
		    	return false;
	        }
	        $sql = "SELECT * FROM {$requests_table} WHERE id = ".$id;
	        $results = $wpdb->get_row($sql,'ARRAY_A');

	        $poll_title = (isset($results['title']) && $results['title'] != '') ? $results['title'] : __( "Default title" , "poll-maker" );
	        $question   = (isset($results['question']) && $results['question'] != '') ? $results['question'] : '';
	        $answers    = (isset($results['answers']) && ! empty($results['answers'])) ? json_decode($results['answers']) : array();
			$cat_ids    = (isset($results['category_id'])) && $results['category_id'] != 1 ? ',1,'.strval($results['category_id']).',' : ',1,';
	        $styles = Poll_Maker_Ays_Admin::ays_poll_generate_default_options();

	        $user_id = get_current_user_id();
			$user = get_userdata($user_id);
			$author_id = $user->ID;

	        $poll_res = $wpdb->insert(
	        	$polls_table, 
	        	array(
	                'title'       => $poll_title,
	                'author_id'   => $author_id,
					'description' => '',
					'categories'  => $cat_ids,
					'image'       => '',
					'question'    => $question,
					'type'        => 'choosing',
					'view_type'   => 'list',
					'show_title'  => 1,
					'styles'      => json_encode($styles),
					'custom_css'  => '',
					'theme_id'    => 1,
	            ),
	            array(
					'%s', // title
					'%d', // author_id
					'%s', // description
					'%s', // categories
					'%s', // image
					'%s', // question
					'%s', // type
					'%s', // view_type
					'%d', // show_title
					'%s', // styles
					'%s', // custom_css
					'%d', // theme_id
				)
            );

            $poll_id = $wpdb->insert_id;

            if (! empty($answers)) {
	        	foreach ( $answers as $key => $answer ) {
					if (empty($answer)) {
						continue;
					}

					$ans_res = $wpdb->insert(
						$answers_table,
						array(
							'poll_id' => $poll_id,
							'answer'  => wp_filter_kses($answer),
							'votes'   => 0,
						),
						array(
							'%d', // poll_id
							'%s', // answer
							'%d', // votes
						)
					);

				}
	        }

	        $update_approved_val = $wpdb->update(
                $requests_table,
                array( 
                	'approved' => 1,
                	'poll_id'  => $poll_id,
                 ),
                array( 'id' => $id ),
                array( 
                	'%d', // approved
                	'%d', // poll_id
                ),
                array( '%d' )
            );

	}

	/**
	 * Delete a customer record.
	 *
	 * @param int $id customer ID
	 */
	public static function delete_requests( $id ) {
		global $wpdb;
		$wpdb->delete(
			"{$wpdb->prefix}ayspoll_requests",
			array('id' => $id),
			array('%d')
		);
	}

	/**
	 * Mark as read a result record.
	 *
	 * @param int $id result ID
	 */
	public function mark_as_unread() {
        global $wpdb;
        $results_table = $wpdb->prefix . "ayspoll_requests";

        $res = $wpdb->update(
            $results_table,
            array('unread' => 0),
            array('unread' => 1),
            array('%d'),
            array('%d')
        );
        if ($res) {
            return true;
        }
    }


	/** Text displayed when no customer data is available */
	public function no_items() {
		_e('There are no results yet.', "poll-maker");
	}

	/**
	 * Render a column when no column specific method exist.
	 *
	 * @param array $item
	 * @param string $column_name
	 *
	 * @return mixed
	 */
	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'title':
			case 'request_date':
			case 'approve_poll':
			case 'unread':
			case 'user_id':
			case 'user_name':
			case 'id':
				return $item[$column_name];
				break;	
			default:
				return print_r($item, true); //Show the whole array for troubleshooting purposes
				break;
		}
	}

	/**
	 * Render the bulk edit checkbox
	 *
	 * @param array $item
	 *
	 * @return string
	 */
	function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="bulk-action[]" value="%s">', $item['id']
		);
	}

	/**
	 * Method for name column
	 *
	 * @param array $item an array of DB data
	 *
	 * @return string
	 */

	function column_title( $item ) {
		global $wpdb;
		$delete_nonce = wp_create_nonce($this->plugin_name . '-delete-result');

		$res = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_requests WHERE id={$item['id']}", "ARRAY_A");

		$title   = sprintf('<a href="?page=%s-each&poll=%d&title=%s">' . stripslashes($res['title']) . '</a>', esc_attr($_REQUEST['page']), absint($item['id']), stripslashes($res['title']));
		$actions = [
			'edit' => sprintf('<a href="?page=%s-each&poll=%d&title=%s">' . __("View", "poll-maker") . '</a>', esc_attr($_REQUEST['page']), absint($item['id']), stripslashes($res['title'])),
			'delete' => sprintf('<a href="?page=%s&action=%s&result=%s&_wpnonce=%s">%s</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce , __( 'Delete' , "poll-maker" ) ),
		];

		return $title . $this->row_actions($actions);
	}

    function column_unread($item) {
        global $wpdb;
        $sql = "SELECT `unread` FROM {$wpdb->prefix}ayspoll_requests WHERE `unread` = 1 AND `id` = ".$item['id'];
        $result = intval($wpdb->get_row($sql, "ARRAY_A"));
        $unread = ($result == 1) ? "unread-result" : "";

        return "<div class='unread-result-badge ".$unread."'></div>";
    }

    function column_user_name($item) {
		$user = get_user_by('id', $item['user_id']);

        if (gettype($user) == 'boolean') {
        	$user_name = __("Guest", "poll-maker");
        }else{
        	$user_name = $user->data->display_name;
        }
		return $user_name;
    }

    public function ays_get_poll_by_id( $id ) {
		global $wpdb;

		$sql  = "SELECT * FROM {$wpdb->prefix}ayspoll_polls WHERE id=" . absint(intval($id));
		$poll = $wpdb->get_row($sql, 'ARRAY_A');
		if (empty($poll)) {
			return false;
		}else {
			return true;
		}

		return $poll;
	}

	function column_approve_poll( $item ) {
		$request_id = (isset($item['id']) && $item['id'] != null) ? absint(intval($item['id'])) : null;
		if ($request_id == null) {
			return false;
		}
		$approved = (isset($item['approved']) && $item['approved'] == 1 ) ? true : false;
		$poll_id  = (isset($item['poll_id']) && $item['poll_id'] != null) ? absint(intval($item['poll_id'])) : null;

		if ($approved) {
			if ($poll_id != null) {
				$check_if_poll_exists = $this->ays_get_poll_by_id($poll_id);
				if ($check_if_poll_exists) {
					return sprintf('<a href="?page=%s&action=%s&poll=%s" target="_blank">%s</a>', 'poll-maker-ays', 'edit', absint($poll_id) , __( 'Go to Poll' , "poll-maker" ) );
				}else{
					return sprintf('<input type="button" class="button primary ays_poll_approve_button" value="%s" data-id="%d" data-type="%s" />', __("Create Again", "poll-maker") , $request_id , "create" );
				}
			}
		}else{
			return sprintf('<input type="button" class="button primary ays_poll_approve_button" value="%s" data-id="%d" data-type="%s" />', __("Approve", "poll-maker") , $request_id , "approve" );
		}
	}

	/**
	 *  Associative array of columns
	 *
	 * @return array
	 */
	function get_columns() {
		$columns = array(
			'cb'           	=> '<input type="checkbox" />',
			'title'        	=> __('Title', "poll-maker"),
			'user_name'     => __('User Name', "poll-maker"),
			'request_date'  => __('Date', "poll-maker" ),
			'user_id'       => __('User id', "poll-maker"),
			'unread'      	=> __('Status', "poll-maker"),
			'approve_poll'	=> __('Approve', "poll-maker"),
			'id'			=> __('ID', "poll-maker"),
		);

		return $columns;
	}

	/**
	 * Columns to make sortable.
	 *
	 * @return array
	 */
	public function get_sortable_columns() {
		$sortable_columns = array(
			'title'   => array('title', true),
			'user_id' => array('user_id', true),
			'id'      => array('id', true),
		);

		return $sortable_columns;
	}

	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		$actions = array(
			'bulk-approve' => __('Approve', "poll-maker"),
			'bulk-delete'  => __('Delete', "poll-maker"),
		);

		return $actions;
	}

	/**
     * Returns the count of records in the database.
     *
     * @return null|string
     */
    public static function record_count() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_requests";

        return $wpdb->get_var( $sql );
    }

	/**
	 * Handles data query and filter, sorting, and pagination.
	 */
	public function prepare_items() {

		$this->_column_headers = $this->get_column_info();

		/** Process bulk action */
		$this->process_bulk_action();

		$per_page = $this->get_items_per_page('poll_requests_per_page', 20);

		$current_page = $this->get_pagenum();
		$total_items  = self::record_count();

		$this->set_pagination_args(array(
			'total_items' => $total_items, //WE have to calculate the total number of items
			'per_page'    => $per_page, //WE have to determine how many items to show on a page
		));

		$this->items = self::get_reports($per_page, $current_page);
	}

	public function process_bulk_action() {
		//Detect when a bulk action is being triggered...
		if ('delete' === $this->current_action()) {

			// In our file that handles the request, verify the nonce.
			$nonce = esc_attr($_REQUEST['_wpnonce']);

			if (!wp_verify_nonce($nonce, $this->plugin_name . '-delete-result')) {
				die('Go get a life script kiddies');
			} else {
				self::delete_requests(absint($_GET['result']));

				// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
				// add_query_arg() return the current url
				$message = 'deleted';
				$url     = esc_url_raw(remove_query_arg([
						'action',
						'result',
						'_wpnonce'
					])) . '&status=' . $message;
				wp_redirect($url);
			}

		}

		// If the delete bulk action is triggered
		if ((isset($_POST['action']) && 'bulk-delete' == $_POST['action'])
		    || (isset($_POST['action2']) && 'bulk-delete' == $_POST['action2'])
		) {
			$delete_ids = esc_sql($_POST['bulk-action']);

			// loop over the array of record IDs and delete them
			foreach ( $delete_ids as $id ) {
				self::delete_requests($id);
			}

			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
			// add_query_arg() return the current url

			$message = 'deleted';
			$url     = esc_url_raw(remove_query_arg(['action', 'result', '_wpnonce'])) . '&status=' . $message;
			wp_redirect($url);
		} elseif ((isset($_POST['action']) && 'bulk-read' == $_POST['action'])
		          || (isset($_POST['action2']) && 'bulk-read' == $_POST['action2'])
		) {

			$read_ids = esc_sql($_POST['bulk-action']);

			// loop over the array of record IDs and mark as readed them
			foreach ( $read_ids as $id ) {
				echo $id . "<br>";
				self::mark_as_unread($id);
			}

			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
			// add_query_arg() return the current url

			$message = 'read';
			$url     = esc_url_raw(remove_query_arg(['action', 'result', '_wpnonce'])) . '&status=' . $message;
			wp_redirect($url);
		} elseif((isset($_POST['action']) && 'bulk-approve' == $_POST['action'])
					|| (isset($_POST['action2']) && 'bulk-approve' == $_POST['action2'])
		){
			$approve_ids = esc_sql($_POST['bulk-action']);
			$_REQUEST['action'] == 'ays_poll_add_request';
			foreach ( $approve_ids as $id ) {
				self::ays_poll_add_bulk_approve($id);
			}

			$message = 'approved';
			$url     = esc_url_raw(remove_query_arg(['action','result', '_wpnonce'])) . '&status=' . $message;
			wp_redirect($url);
		}
	}

	public function results_notices() {
		$status = (isset($_REQUEST['status'])) ? sanitize_text_field($_REQUEST['status']) : '';

		if (empty($status)) {
			return;
		}

		if ('deleted' == $status) {
			$updated_message = esc_html(__('Result(s) deleted.', "poll-maker"));
		}
		if ('read' == $status) {
			$updated_message = esc_html(__('Result(s) marked as read.', "poll-maker"));
		}

		if (empty($updated_message)) {
			return;
		}

 		?>
        <div class="notice notice-success is-dismissible">
            <p>
 	           <?php echo $updated_message; ?>
            </p>
        </div>
 		<?php
	}

}