<?php
ob_start();

class Pma_Results_List_Table extends WP_List_Table {
	private $plugin_name;
	private $results_obj;
	private $title_length;
	
	/** Class constructor */
	public function __construct( $plugin_name ) {
		$this->plugin_name = $plugin_name;
		$this->title_length = Poll_Maker_Ays_Admin::get_listtables_title_length('results');
		parent::__construct(array(
			'singular' => __('Result', "poll-maker"), //singular name of the listed records
			'plural'   => __('Results', "poll-maker"), //plural name of the listed records
			'ajax'     => false, //does this table support ajax?
		));
		add_action('admin_notices', array($this, 'results_notices'));

	}

	/**
	 * Retrieve customers data from the database
	 *
	 * @param int $per_page
	 * @param int $page_number
	 *
	 * @return mixed
	 */
	public static function get_reports( $per_page = 50, $page_number = 1 ) {

		global $wpdb;
		$current_user = get_current_user_id();
		$author_check = '';
		$polls_table = esc_sql($wpdb->prefix."ayspoll_polls");
		if( ! current_user_can( 'manage_options' ) ){
			$author_check .= " AND {$wpdb->prefix}ayspoll_polls.author_id = ".$current_user." ";
		}

		$sql = "SELECT
        {$wpdb->prefix}ayspoll_polls.id,
		{$wpdb->prefix}ayspoll_polls.author_id,
		SUM({$wpdb->prefix}ayspoll_answers.votes) AS voted,
		{$wpdb->prefix}ayspoll_answers.poll_id,
        {$wpdb->prefix}ayspoll_polls.categories
        FROM
        {$wpdb->prefix}ayspoll_answers 
        INNER JOIN 
		{$wpdb->prefix}ayspoll_polls
        ON {$wpdb->prefix}ayspoll_answers.poll_id = {$wpdb->prefix}ayspoll_polls.id ".$author_check."";

		if (isset($_REQUEST['orderbypoll']) && $_REQUEST['orderbypoll'] > 0) {
			$poll_id = absint($_REQUEST['orderbypoll']);
			
			$sql .= " AND {$wpdb->prefix}ayspoll_reports.answer_id IN (SELECT {$wpdb->prefix}ayspoll_answers.id FROM {$wpdb->prefix}ayspoll_answers WHERE {$wpdb->prefix}ayspoll_answers.poll_id='$poll_id')";
		}

		if (isset($_REQUEST['orderbycat']) && $_REQUEST['orderbycat'] > 0) {
			$cat_id = absint($_REQUEST['orderbycat']);
			$sql .= " AND {$wpdb->prefix}ayspoll_polls.categories LIKE('%,{$cat_id},%')";
		}
		
 		$sql .= "GROUP BY {$wpdb->prefix}ayspoll_answers.poll_id";
		if (!empty($_REQUEST['orderby'])) {
			$sql .= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
			$sql .= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' DESC';
		} else {
			$sql .= ' ORDER BY id DESC';
		}

		$sql .= " LIMIT $per_page";
		$sql .= ' OFFSET ' . ($page_number - 1) * $per_page;

		$result = $wpdb->get_results($sql, 'ARRAY_A');

		return $result;
	}

	public function display_tablenav( $which ) {
        ?>
        <div class="tablenav <?php echo esc_attr( $which ); ?>">
            
            <div class="alignleft actions">
                <?php  $this->bulk_actions( $which ); ?>
            </div>
            <?php
            $this->extra_tablenav( $which );
            $this->pagination( $which );
            ?>
            <br class="clear" />
        </div>
        <?php
	}

	public function extra_tablenav($which) {
		$this->ays_category_filter_content();
	}

	public function get_report_by_id( $id ) {
		global $wpdb;

		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_reports WHERE id=" . absint(intval($id));

		$result = $wpdb->get_row($sql, 'ARRAY_A');

		return $result;
	}

	public static function get_answer_by_id( $id ) {
		global $wpdb;

		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_answers WHERE id=" . absint(intval($id));

		$result = $wpdb->get_row($sql, 'ARRAY_A');

		return $result;
	}

	public function get_polls() {
		global $wpdb;

		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_polls";

		$current_user = get_current_user_id();
        if( ! current_user_can( 'manage_options' ) ){
            $sql .= " WHERE author_id = ".$current_user;
        }

		$result = $wpdb->get_results($sql, 'ARRAY_A');

		return $result;
	}

	//Getting polls votes quantity by day and by poll, for charts
	public function get_most_least_polls() {
		global $wpdb;
		$sql   = "SELECT
        {$wpdb->prefix}ayspoll_answers.poll_id,
        {$wpdb->prefix}ayspoll_polls.title,
        Sum({$wpdb->prefix}ayspoll_answers.votes) AS sum_votes
        FROM
        {$wpdb->prefix}ayspoll_answers
        JOIN {$wpdb->prefix}ayspoll_polls ON {$wpdb->prefix}ayspoll_polls.id = {$wpdb->prefix}ayspoll_answers.poll_id
        GROUP BY
        {$wpdb->prefix}ayspoll_polls.title
        ORDER BY
        sum_votes";
		$most  = $wpdb->get_row($sql . " DESC
        LIMIT 1", "ARRAY_A");
		$least = $wpdb->get_row($sql . " ASC
        LIMIT 1", "ARRAY_A");

		return array("most" => $most, "least" => $least);
	}

	public function get_votes_count_by_time_interval( $interval, $poll = 0 ) {
		global $wpdb;
		$today = date("Y-m-d");
		$interval--;
		$start_day = date('Y-m-d', strtotime("-$interval day"));
		if ($interval == 0) {
			$where = "
            DATE({$wpdb->prefix}ayspoll_reports.vote_date) = '$today'";
		} else {
			$where = "
            DATE({$wpdb->prefix}ayspoll_reports.vote_date) <= '$today'
            AND DATE({$wpdb->prefix}ayspoll_reports.vote_date) > '$start_day'";
		}
		if ($poll > 0) {
			$where .= " AND {$wpdb->prefix}ayspoll_answers.poll_id='$poll'";
		}
		$sql         = "SELECT
        {$wpdb->prefix}ayspoll_answers.poll_id,
        {$wpdb->prefix}ayspoll_polls.title,
        Count({$wpdb->prefix}ayspoll_answers.poll_id) AS votes,
        DATE({$wpdb->prefix}ayspoll_reports.vote_date) AS date
        FROM
        {$wpdb->prefix}ayspoll_answers
        JOIN {$wpdb->prefix}ayspoll_polls ON {$wpdb->prefix}ayspoll_polls.id = {$wpdb->prefix}ayspoll_answers.poll_id
        JOIN {$wpdb->prefix}ayspoll_reports ON {$wpdb->prefix}ayspoll_reports.answer_id = {$wpdb->prefix}ayspoll_answers.id
        WHERE
        EXISTS(
            SELECT id FROM {$wpdb->prefix}ayspoll_answers
            WHERE id={$wpdb->prefix}ayspoll_reports.answer_id
        )=1 AND "
		               . $where .
		               "GROUP BY
        {$wpdb->prefix}ayspoll_polls.title";
		$res         = $wpdb->get_results($sql, "ARRAY_A");
		$votes_count = array_sum(array_column($res, 'votes'));

		return $votes_count;
	}

	public function get_voting_first_day() {
		global $wpdb;
		$sql  = "SELECT
        Min({$wpdb->prefix}ayspoll_reports.vote_date) AS min_date
        FROM
        {$wpdb->prefix}ayspoll_reports WHERE EXISTS(SELECT id FROM {$wpdb->prefix}ayspoll_answers WHERE id={$wpdb->prefix}ayspoll_reports.answer_id)=1";
		$date = $wpdb->get_var($sql);

		return $date;
	}

	public function get_poll_data_by_day( $first_day, $day, $id ) {
		global $wpdb;
		$sql = "SELECT
    				a.poll_id AS id,
			        p.title,
			        COUNT(a.poll_id) AS polling_count,
			        DATE(r.vote_date) AS vote_date_day
        FROM {$wpdb->prefix}ayspoll_reports AS r
        JOIN {$wpdb->prefix}ayspoll_answers AS a ON r.answer_id = a.id
        JOIN {$wpdb->prefix}ayspoll_polls AS p ON a.poll_id = p.id
        WHERE 
        	r.vote_date BETWEEN '$first_day' AND '$day' ";

        if( !$id == 0 ){
        	$sql .= " AND a.poll_id ='$id' ";
        }

        $sql .= " GROUP BY DATE(r.vote_date)";

		$results = $wpdb->get_results($sql, 'ARRAY_A');

		return $results;
	}

	public function get_poll_data_all( $poll_id = 0 ) {
		global $wpdb;
		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_reports WHERE EXISTS(SELECT id FROM {$wpdb->prefix}ayspoll_answers WHERE id={$wpdb->prefix}ayspoll_reports.answer_id)=1";
		$res = $wpdb->get_results($sql, 'ARRAY_A');
		if (empty($res)) {
			return $res;
		}
		$start_day = $this->get_voting_first_day();
		$end_day   = current_time( 'mysql' );
		$datediff  = strtotime( $end_day ) - strtotime( $start_day );
		$day_count = ceil($datediff / (60 * 60 * 24));
		$data = array();
		$datas = array();
		if ($day_count > 0) {
			$days = array();
			$polls = $this->get_polls();
			for ( $i = 1; $i <= $day_count; $i++ ) {
				$days[] = date('Y-m-d', strtotime( "+". $i ." day", strtotime( $start_day ) ) );
			}

			if ($poll_id == 0) {
				$temps = $this->get_poll_data_by_day($start_day, $end_day, 0);

				foreach ($temps as $key => $temp) {
					$data[ $temp["vote_date_day"] ] = $temp;
				}
			} else {
				$temps = $this->get_poll_data_by_day($start_day, $end_day, $poll_id);
				foreach ($temps as $key => $temp) {
					$data[ $temp["vote_date_day"] ] = $temp;
				}
			}
			
			foreach ($days as $key => $day) {
				if( isset( $data[$day] ) ){
					$datas[] = $data[$day];
				}else{
					$datas[] = array(
						'id'            => '0',
						'title'         => '',
						'polling_count' => 0,
						'vote_date_day' => $day,
					);
				}
			}
		}

		return $datas;
	}

	public function get_poll_data_pie( $poll_id ) {
		global $wpdb;
		$sql = "SELECT
        {$wpdb->prefix}ayspoll_answers.answer,
        {$wpdb->prefix}ayspoll_answers.votes
        FROM
        {$wpdb->prefix}ayspoll_answers
        WHERE
        {$wpdb->prefix}ayspoll_answers.poll_id = '$poll_id'";

		$result = $wpdb->get_results($sql, 'ARRAY_A');

		$votes     = array_column($result, 'votes');
		$votes_sum = array_sum($votes);
		for ( $i = 0; $i < count($result); $i++ ) {
			$result[$i]['answer']  = stripslashes($result[$i]['answer']);
			$result[$i]['percent'] = round(($result[$i]['votes'] * 100) / $votes_sum);
		}

		// echo "<pre>";
		// print_r($result);
		// wp_die();
		return $result;
	}

	/**
	 * Delete a result record.
	 *
	 * @param int $id result ID
	 */
	public static function delete_reports( $id ) {
		global $wpdb;
				
		$wpdb->update(
			"{$wpdb->prefix}ayspoll_answers",
			array(
				"votes" => 0
			),
			array(
				'poll_id' => $id
			)
		);
	
		$sql = "DELETE r FROM {$wpdb->prefix}ayspoll_reports as r
            JOIN {$wpdb->prefix}ayspoll_answers ON {$wpdb->prefix}ayspoll_answers.id = r.answer_id
            WHERE {$wpdb->prefix}ayspoll_answers.poll_id = $id";
		$res = $wpdb->query($sql);

		return $res > 0;
	}

	/**
	 * Mark as read a result record.
	 *
	 * @param int $id result ID
	 */
	public static function mark_as_read_reports( $id ) {
		global $wpdb;
		$sql = "UPDATE {$wpdb->prefix}ayspoll_reports
            JOIN {$wpdb->prefix}ayspoll_answers ON {$wpdb->prefix}ayspoll_answers.id = {$wpdb->prefix}ayspoll_reports.answer_id
            SET {$wpdb->prefix}ayspoll_reports.unread = 0
            WHERE {$wpdb->prefix}ayspoll_answers.poll_id = $id";
		$res = $wpdb->query($sql);

		return $res > 0 ? true : false;
	}

	/**
	 * Returns the count of records in the database.
	 *
	 * @return null|string
	 */
	public static function record_count() {
		global $wpdb;

		/* $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_reports
		 WHERE EXISTS(SELECT id FROM {$wpdb->prefix}ayspoll_answers WHERE id={$wpdb->prefix}ayspoll_reports.answer_id)=1";*/

		$sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_polls";

		$current_user = get_current_user_id();
        if( ! current_user_can( 'manage_options' ) ){
            $sql .= " WHERE author_id = ".$current_user." ";
        }

		return $wpdb->get_var($sql);
	}

	/** Text displayed when no customer data is available */
	public function no_items() {
		_e('There are no results yet.', "poll-maker");
	}

	/**
	 * Render a column when no column specific method exist.
	 *
	 * @param array $item
	 * @param string $column_name
	 *
	 * @return mixed
	 */
	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'poll_title':
			case 'voted':
			case 'unread':
			case 'id':
				return $item[$column_name];
				break;
			default:
				return print_r($item, true); //Show the whole array for troubleshooting purposes
		}
	}

	/**
	 * Render the bulk edit checkbox
	 *
	 * @param array $item
	 *
	 * @return string
	 */
	function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="bulk-action[]" value="%s">', $item['id']
		);
	}

	/**
	 * Method for name column
	 *
	 * @param array $item an array of DB data
	 *
	 * @return string
	 */

	function column_poll_title( $item ) {
		global $wpdb;
		$delete_nonce = wp_create_nonce($this->plugin_name . '-delete-result');

		$res = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_polls WHERE id={$item['id']}", "ARRAY_A");

		$restitle = Poll_Maker_Ays_Admin::ays_restriction_string("word",stripcslashes($res['title']), $this->title_length);
		$title   = sprintf('<a href="?page=%s-each&poll=%d&title=%s">%s</a>', esc_attr($_REQUEST['page']), absint($item['id']), stripslashes($res['title']), $restitle);
		$actions = [
			'delete' => sprintf('<a href="?page=%s&action=%s&result=%s&_wpnonce=%s">Delete</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce),
		];

		return $title . $this->row_actions($actions);
	}

	function column_unread( $item ) {
		global $wpdb;
		$sql = "SELECT
            COUNT({$wpdb->prefix}ayspoll_reports.unread)
            FROM
            {$wpdb->prefix}ayspoll_reports
            JOIN {$wpdb->prefix}ayspoll_answers ON {$wpdb->prefix}ayspoll_answers.id = {$wpdb->prefix}ayspoll_reports.answer_id
            WHERE {$wpdb->prefix}ayspoll_answers.poll_id = {$item['id']} AND {$wpdb->prefix}ayspoll_reports.unread = 1
            GROUP BY {$wpdb->prefix}ayspoll_answers.poll_id";
		$res = $wpdb->get_var($sql);
		$result = $res ? $res : 0;
		$unread = $res ? 'ays_poll_unread' : '';
		$count   = sprintf('<span class="%s">' . $result . '</span>', $unread);
		return $count;
	}

	function get_poll_title( $item ) {
		global $wpdb;
		$delete_nonce = wp_create_nonce($this->plugin_name . '-delete-result');

		$result = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_answers WHERE id={$item['answer_id']}", "ARRAY_A");

		$res = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_polls WHERE id={$result['poll_id']}", "ARRAY_A");

		return stripslashes($res['title']);
	}

	function column_answer( $item ) {
		global $wpdb;
		$delete_nonce = wp_create_nonce($this->plugin_name . '-delete-result');

		$result = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_answers WHERE id={$item['answer_id']}", "ARRAY_A");		

		$poll_type = $this->get_poll_type($result['poll_id']);

		$result['answer'] = $poll_type['type'] == 'voting' && $result['answer'] == '1' ? 'Like' :  $result['answer'];
		$result['answer'] = $poll_type['type'] == 'voting' && $result['answer'] == '-1' ? 'Dislike' :  $result['answer'];
		
		return stripslashes($result['answer']);
	}


	function column_voted( $item ) {
		global $wpdb;
		$sql = "SELECT
            COUNT({$wpdb->prefix}ayspoll_reports.id)
            FROM
            {$wpdb->prefix}ayspoll_reports
            JOIN {$wpdb->prefix}ayspoll_answers ON {$wpdb->prefix}ayspoll_answers.id = {$wpdb->prefix}ayspoll_reports.answer_id
            WHERE {$wpdb->prefix}ayspoll_answers.poll_id = {$item['id']}
            GROUP BY {$wpdb->prefix}ayspoll_answers.poll_id";
		$res = $wpdb->get_var($sql);

		return $res ? $res : 0;

	}

	/**
	 *  Associative array of columns
	 *
	 * @return array
	 */
	function get_columns() {
		$columns = array(
			'cb'         => '<input type="checkbox" />',
			'id'         => __('ID', "poll-maker"),
			'poll_title' => __('Poll', "poll-maker"),
			'voted'      => __('Voters count', "poll-maker"),
			'unread'     => __('New results count', "poll-maker")
		);

		return $columns;
	}

	/**
	 * Columns to make sortable.
	 *
	 * @return array
	 */
	public function get_sortable_columns() {
		$sortable_columns = array(
			'vote_date' => array('vote_date', true),
			'id'        => array('id', true),
		);

		return $sortable_columns;
	}

	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		$actions = array(
			'bulk-read'   => __('Mark as read', "poll-maker"),
			'bulk-delete' => __('Delete', "poll-maker"),
		);

		return $actions;
	}

	/**
	 * Handles data query and filter, sorting, and pagination.
	 */
	public function prepare_items() {

		$this->_column_headers = $this->get_column_info();

		/** Process bulk action */
		$this->process_bulk_action();

		$per_page = $this->get_items_per_page('poll_results_per_page', 50);

		$current_page = $this->get_pagenum();
		$total_items  = self::record_count();

		$this->set_pagination_args(array(
			'total_items' => $total_items, //WE have to calculate the total number of items
			'per_page'    => $per_page, //WE have to determine how many items to show on a page
		));

		$this->items = self::get_reports($per_page, $current_page);
	}

	public function process_bulk_action() {
		//Detect when a bulk action is being triggered...
		if ('delete' === $this->current_action()) {

			// In our file that handles the request, verify the nonce.
			$nonce = esc_attr($_REQUEST['_wpnonce']);

			if (!wp_verify_nonce($nonce, $this->plugin_name . '-delete-result')) {
				die('Go get a life script kiddies');
			} else {
				self::delete_reports(absint($_GET['result']));

				// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
				// add_query_arg() return the current url
				$message = 'deleted';
				$url     = esc_url_raw(remove_query_arg([
						'action',
						'result',
						'_wpnonce'
					])) . '&status=' . $message;
				wp_redirect($url);
			}

		}

		// If the delete bulk action is triggered
		if ((isset($_POST['action']) && 'bulk-delete' == $_POST['action'])
		    || (isset($_POST['action2']) && 'bulk-delete' == $_POST['action2'])
		) {
			$delete_ids = esc_sql($_POST['bulk-action']);

			// loop over the array of record IDs and delete them
			foreach ( $delete_ids as $id ) {
				self::delete_reports($id);
			}

			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
			// add_query_arg() return the current url

			$message = 'deleted';
			$url     = esc_url_raw(remove_query_arg(['action', 'result', '_wpnonce'])) . '&status=' . $message;
			wp_redirect($url);
		} elseif ((isset($_POST['action']) && 'bulk-read' == $_POST['action'])
		          || (isset($_POST['action2']) && 'bulk-read' == $_POST['action2'])
		) {

			$read_ids = esc_sql($_POST['bulk-action']);

			// loop over the array of record IDs and mark as readed them
			foreach ( $read_ids as $id ) {
				echo $id . "<br>";
				self::mark_as_read_reports($id);
			}

			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
			// add_query_arg() return the current url

			$message = 'read';
			$url     = esc_url_raw(remove_query_arg(['action', 'result', '_wpnonce'])) . '&status=' . $message;
			wp_redirect($url);
		}
	}

	public function results_notices() {
		$status = (isset($_REQUEST['status'])) ? sanitize_text_field($_REQUEST['status']) : '';

		if (empty($status)) {
			return;
		}

		if ('deleted' == $status) {
			$updated_message = esc_html(__('Result(s) deleted.', "poll-maker"));
		}
		if ('read' == $status) {
			$updated_message = esc_html(__('Result(s) marked as read.', "poll-maker"));
		}

		if (empty($updated_message)) {
			return;
		}

		?>
        <div class="notice notice-success is-dismissible">
            <p>
	            <?php echo $updated_message; ?>
            </p>
        </div>
		<?php
	}

	public function get_poll_type($item) {
		global $wpdb;

		$id = absint(intval($item));
		$poll_table = esc_sql($wpdb->prefix."ayspoll_polls");
		$sql = "SELECT type FROM ".$poll_table." WHERE id=%d";

		$result = $wpdb->get_row(
			   	  	$wpdb->prepare( $sql, $id),
			   	  	'ARRAY_A'
				  );

		return $result;
	}

	public function ays_category_filter_content(){
		$poll_cats = $this->get_categories();
		$content = "";		
		if(isset($poll_cats)){
			$content = '<label for="bulk-action-selector-top-cat" class="screen-reader-text">Select Filter Type</label>
						<select name="orderbycat" id="bulk-action-selector-top-cat">
						<option value="0" selected>' .__("Select Category", "poll-maker"). '</option>';
			$selected = "";
			$this_cat_id = 0;
			foreach ($poll_cats as $cat_key => $cat_value) {
				$selected  = (isset($_REQUEST['orderbycat']) && $_REQUEST['orderbycat'] == $cat_value['id'] ) ? 'selected' : '';
				$this_cat_id = isset($_REQUEST['orderbycat']) ? $_REQUEST['orderbycat'] : $this_cat_id;
				$cat_id    = isset($cat_value['id']) && $cat_value['id'] != "" ? esc_attr($cat_value['id']) : "";
				$cat_value = isset($cat_value['title']) && $cat_value['title'] != "" ? esc_attr($cat_value['title']) : "";
				$content .= '<option value="'.$cat_id.'" '.$selected.'>'.$cat_value.'</option>';
			}
			$content .= '</select>';
			$content .= '<input type="submit" id="doactioncat" name="filter_by_cat" class="button action" value="'.__("Filter", "poll-maker").'" style="width: 3.7rem;margin-left: 5px;">';
			if(isset($_REQUEST['filter_by_cat'])){
				$new_url = remove_query_arg("orderbycat")."&orderbycat=".$this_cat_id;
				wp_redirect($new_url);
			}
		}
		echo $content;
	}

	public function get_categories(){
		global $wpdb;
		$category_table = $wpdb->prefix . 'ayspoll_categories';
        $sql = "SELECT title,id FROM ".$category_table." ORDER BY title";
        $results = $wpdb->get_results($sql , "ARRAY_A");
		if(isset($results) && !empty($results)){
			return $results;
		}
		else{
			return array();
		}
	}

	// Get answers old 
	// public function get_poll_answers($id){
	// 	global $wpdb;
	// 	$answers_table = $wpdb->prefix."ayspoll_answers";
	// 	$sql = "SELECT * FROM ".$answers_table." WHERE poll_id=".$id." AND show_user_added = 1";
	// 	$result = $wpdb->get_results($sql , "ARRAY_A");
	// 	return $result;
	// }

	// Get answers modified
	public function get_poll_answers($poll_id){
		global $wpdb;

		$sql = "SELECT * FROM `{$wpdb->prefix}ayspoll_reports` WHERE poll_id=$poll_id";
		$result = $wpdb->get_results($sql, "ARRAY_A");

		$multivote_answers_ids = array();
		$multivote_answers = array();

		foreach ($result as $r_key => $r_value) {

			$r_value['multi_answer_id'] = json_decode($r_value['multi_answer_id'], true);

			$multivote_res = false;
			if (isset($r_value['multi_answer_id']) && count($r_value['multi_answer_id']) > 0) {
				$multivote_res = true;
			}

			if ($multivote_res) {
				foreach ($r_value['multi_answer_id'] as $m_key => $m_val) {
					$multivote_answers_ids[] = $m_val;
					$multi_answer = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_answers WHERE id=".$m_val, "ARRAY_A");
					$multivote_answers[ $m_val ] = $multi_answer['answer'];
				}
				$answ_poll_id = $multi_answer['poll_id'];
			} else {
				$answer = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_answers WHERE id={$r_value['answer_id']}", "ARRAY_A");
				$multivote_answers_ids[] = $r_value['answer_id'];
				$multivote_answers[ $r_value['answer_id'] ] = $answer['answer'];
				$answ_poll_id = $answer['poll_id'];
			}
		}

		$multivote_answers_count_arr = array_count_values( $multivote_answers_ids );
		
		$res = array();
		foreach ($multivote_answers_count_arr as $key => $value) {
			$res[] = array(
				"votes" => $value,
				"answer" => $multivote_answers[ $key ],
			);
		}

		if ( is_null( $res ) || empty( $res ) ) {
			$res = array();
		}

		return $res;
	}
	

}