(function($) {
    'use strict';

    function AysPollRecaptchaPlugin(element, options){
        this.el = element;
        this.$el = $(element);
        this.htmlClassPrefix = 'ays-poll-';
        this.current_fs;
        this.next_fs;
        this.pollObject = undefined;
        this.finishButton = undefined;
        this.dbOptions = undefined;

        this.init();

        return this;
    }

    AysPollRecaptchaPlugin.prototype.init = function() {
        var _this = this;

        var uniqueKey = _this.$el.find('.'+ _this.htmlClassPrefix + 'g-recaptcha').data('uniqueKey');
        if( typeof window.aysPollRecaptchaObj != 'undefined' ){
            if(typeof window.aysPollRecaptchaObj[ uniqueKey ] != 'undefined' ){
                _this.dbOptions = JSON.parse( window.atob( window.aysPollRecaptchaObj[ uniqueKey ] ) );
            }
        }

        _this.setEvents();
    };

    AysPollRecaptchaPlugin.prototype.setEvents = function(e){
        var _this = this;

        _this.$el.find('form.' + _this.htmlClassPrefix + 'form').on('afterPollSubmission', function(e){
            _this.finishButton = e.detail.thisButton;
            var form = _this.$el.find('form');
            var pollRecaptcha = _this.dbOptions.eable_recaptcha && _this.dbOptions.enable_recaptcha == "on" ? true : false;

            var formCaptchaValidation = false;
            if( pollRecaptcha ){
                formCaptchaValidation = form.children().attr('data-recaptcha-validate') && form.children().attr('data-recaptcha-validate') == 'true' ? true : false;
            }

            if( formCaptchaValidation === false ) {
                _this.initRecaptcha($(this));
            }else{
                e.preventDefault();
            }

            _this.hidePoll(form.children());

        });
    }

    AysPollRecaptchaPlugin.prototype.initRecaptcha = function( step ) {
        var _this = this;

        var captchaContainer = step.find( '.' + _this.htmlClassPrefix + 'recaptcha-wrap' ),
            captcha          = step.find( '.' + _this.htmlClassPrefix + 'g-recaptcha' );
            var captchaSiteKey = _this.dbOptions.siteKey === '' ? null : _this.dbOptions.siteKey,
            captchaID      = _this.htmlClassPrefix + 'recaptcha-' + Date.now(),
            apiVar         = grecaptcha,
            theme          = _this.dbOptions.theme === '' ? null : _this.dbOptions.theme;
            
        captcha.attr('id', captchaID);
        if( captchaSiteKey ) {
            try {
                var options = {
                    'sitekey': captchaSiteKey,
                    'expired-callback': function () {
                        _this.setRecaptchaChecked(false);
                        apiVar.reset(opt_widget_id);
                    },
                    'callback': function (response) {
                        if (!response) {
                            _this.recaptchaErrorCallback($('#' + captchaID));
                        } else {
                            _this.recaptchaSuccessCallback($('#' + captchaID));
                        }
                    },
                    // 'error-callback': function () {
                    //     _this.setRecaptchaChecked(false);
                    //     apiVar.reset(opt_widget_id);
                    // }
                };

                if( theme ) {
                    options.theme = theme;
                }

                var opt_widget_id = apiVar.render( captchaID, options );
                captcha.attr('data-widget-id', opt_widget_id);
            } catch (error) {}
            _this.pollDispatchEvent(document, "AysPollRecaptchaLoaded", true);
        }
    }

    AysPollRecaptchaPlugin.prototype.recaptchaErrorCallback = function (el) {
        var _this = this;
        _this.setRecaptchaChecked( false );
        _this.pollDispatchEvent(document, "AysPollRecaptchaError", true);
        var err = el.parents('.' + _this.htmlClassPrefix + 'recaptcha-wrap').find('.' + _this.htmlClassPrefix + 'g-recaptcha-hidden-error');
        err.show();
        return false;
    };

    AysPollRecaptchaPlugin.prototype.recaptchaSuccessCallback = function (el) {
        var _this = this;
        _this.setRecaptchaChecked( true );
        _this.pollDispatchEvent(document, "AysPollRecaptchaSuccess", true);
        var err = el.parents('.' + _this.htmlClassPrefix + 'recaptcha-wrap').find('.' + _this.htmlClassPrefix + 'g-recaptcha-hidden-error');
        err.hide();
        setTimeout(function (){
            _this.$el.find('.' + _this.htmlClassPrefix + 'recaptcha-section').remove();
            _this.$el.find('.ays-poll-hide-boxes-recaptcha').each(function() {
                $(this).removeClass('ays-poll-hide-boxes-recaptcha');
            })

            if (_this.$el.find('.user-form').length) {
                _this.$el.find('.user-form').addClass('ays-poll-user-form-recaptcha-completed');
            }
            _this.finishButton.trigger('click');
        }, 500);
    };

    AysPollRecaptchaPlugin.prototype.setRecaptchaChecked = function ( isChceked ) {
        var _this = this;
        var form = _this.$el.find('form');
        form.children().attr('data-recaptcha-validate', isChceked ? 'true' : 'false');
    }

    AysPollRecaptchaPlugin.prototype.pollDispatchEvent = function (el, ev, custom) {
        var e = document.createEvent(custom ? "CustomEvent" : "HTMLEvents");
        custom ? e.initCustomEvent(ev, true, true, false) : e.initEvent(ev, true, true);
        el.dispatchEvent(e);
    };

    AysPollRecaptchaPlugin.prototype.hidePoll = function(mainDiv) {
        var _this = this;
        mainDiv.children().addClass('ays-poll-hide-boxes-recaptcha');
        mainDiv.find('.' + _this.htmlClassPrefix + 'recaptcha-section').removeClass('ays-poll-hide-boxes-recaptcha');
        mainDiv.find('.' + _this.htmlClassPrefix + 'g-recaptcha div').css({
            'display': 'block',
            'margin': 'auto'
        })
    }

    $.fn.AysPollRecaptcha = function(options) {
        return this.each(function() {
            if (!$.data(this, 'AysPollRecaptcha')) {
                $.data(this, 'AysPollRecaptcha', new AysPollRecaptchaPlugin(this, options));
            } else {
                try {
                    $(this).data('AysPollRecaptcha').init();
                } catch (err) {
                    console.error('AysPollRecaptcha has not initiated properly');
                }
            }
        });
    };

    $(document).find('.ays-poll-main').AysPollRecaptcha();
})(jQuery);
