<?php
    class Ays_Poll_Maker_User_Activity_Per_Day{
        /**
         * The ID of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string $plugin_name The ID of this plugin.
         */
        protected $plugin_name;

        /**
         * The version of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string $version The current version of this plugin.
         */
        private $version;

        private $html_class_prefix = 'ays-poll-user-activity-per-day-';
        private $html_name_prefix = 'ays-poll-';
        private $name_prefix = 'ays_poll_';
        private $unique_id;
        private $unique_id_in_class;

        /**
         * Initialize the class and set its properties.
         *
         * @since    1.0.0
         * @param      string $plugin_name The name of the plugin.
         * @param      string $version The version of this plugin.
         */
        public function __construct($plugin_name, $version){

            $this->plugin_name = $plugin_name;
            $this->version = $version;

            add_shortcode('ays_poll_user_activity_per_day', array($this, 'ays_generate_user_activity_per_day'));
        }

            /**
         * Register the stylesheets for the public-facing side of the site.
         *
         * @since    1.0.0
         */
	    public function enqueue_styles() {

            /**
             * This function is provided for demonstration purposes only.
             *
             * An instance of this class should be passed to the run() function
             * defined in Poll_Maker_Ays_Loader as all of the hooks are defined
             * in that particular class.
             *
             * The Poll_Maker_Ays_Loader will then create the relationship
             * between the defined hooks and the functions defined in this
             * class.
             */
	    }

        /**
         * Register the JavaScript for the public-facing side of the site.
         *
         * @since    1.0.0
         */
	    public function enqueue_scripts() {

            /**
             * This function is provided for demonstration purposes only.
             *
             * An instance of this class should be passed to the run() function
             * defined in Poll_Maker_Ays_Loader as all of the hooks are defined
             * in that particular class.
             *
             * The Poll_Maker_Ays_Loader will then create the relationship
             * between the defined hooks and the functions defined in this
             * class.
             */
            wp_enqueue_script( $this->plugin_name . '-charts-google', POLL_MAKER_AYS_ADMIN_URL . '/js/google-chart.js', array('jquery'), $this->version, true);
            wp_enqueue_script(  $this->plugin_name . '-user-activity-per-day', POLL_MAKER_AYS_PUBLIC_URL . '/js/partials/poll-maker-ays-user-activity-per-day.js', array('jquery'), $this->version, true);
    
	    }

         /*
        ==========================================
            User Activite Per Day shortcode
        ==========================================
        */

        public function ays_generate_user_activity_per_day(){
            $this->enqueue_styles();
            $this->enqueue_scripts();
                
            $unique_id = uniqid();
            $this->unique_id = $unique_id;
            $this->unique_id_in_class = $unique_id;

            $user_id = get_current_user_id();

            $user_activity_per_day_html = "";

            $user_activity_per_day_html = $this->ays_user_activity_per_day_html( $user_id );
    
            return str_replace(array("\r\n", "\n", "\r"), "\n", $user_activity_per_day_html);
        }

        public function get_user_reports_info( $id ){
            global $wpdb;

            $reports_table = esc_sql( $wpdb->prefix . "ayspoll_reports" );

            if( is_null( $id ) && $id == 0){
                return null;
            }

            $sql = "SELECT DATE(`vote_date`) AS date, COUNT(*) AS value FROM `{$reports_table}` WHERE `user_id` = ".$id." GROUP BY date";

            $result = $wpdb->get_results( $sql, 'ARRAY_A' );

            foreach ($result as $key => $value) {
                $value['value'] = intval($value['value']);
                $value = array_values($value);
            }

            return $result;

        }

        public function ays_user_activity_per_day_html( $id ){

            $this->enqueue_scripts();


            $unique_id = uniqid();

            $this->unique_id = $unique_id;
            $this->unique_id_in_class = $id . "-" . $unique_id;

            $results = array();
            $content = array();
            $obj     = array();

            if ( ! is_null( $id ) && $id > 0 ) {
                $results = $this->get_user_reports_info( $id );
            }

            if ( is_null( $results ) || empty($results) ) {
                $content = '';
                return $content;
            }

            foreach ($results as $key => $result) {
                $r_val  = ( isset( $result['value'] ) && $result['value'] != '' ) ? absint( $result['value'] ) : 0;
                $r_date = ( isset( $result['date'] ) && $result['date'] != '' ) ? sanitize_text_field( $result['date'] ) : null;

                if ( is_null( $r_date ) ) {
                   continue;
                }

                $obj[] = array(
                    $r_date, $r_val
                );
            }

            $script = '<script type="text/javascript">';
            $script .= "
                    if(typeof aysPollUserActivityPerDayData === 'undefined'){
                        var aysPollUserActivityPerDayData = [];
                    }
                    aysPollUserActivityPerDayData['" . $this->unique_id . "']  = '" . base64_encode( json_encode( $obj ) ) . "';";
            $script .= '</script>';


            $content[] = '<div class="'. $this->html_class_prefix .'container" id="'. $this->html_class_prefix .'container-' . $this->unique_id_in_class . '" data-id="' . $this->unique_id . '" style="margin: 20px auto;">';

                $content[] = '<div class="'. $this->html_class_prefix .'box" id="'. $this->html_class_prefix . 'chart-'. $this->unique_id .'"></div>';
                $content[] = $script;

            $content[] = '</div>';

            $content = implode( '', $content );
            
            return $content;
        }

    }

?>