(function($) {
    $(function() {
        if ((typeof pollCount !== 'undefined') && (pollCount > 0)) {
            // Themes begin
            am4core.useTheme(am4themes_animated);
            // Themes end

            // Create chart instance
            var chart = am4core.create("chartdiv", am4charts.XYChart);

            // Add data
            for (var i = 0; i < pollData.length; i++) {
                var poll = pollData[i];

                chart.data.push([]);
                chart.data[i]['date'] = poll['vote_date_day'];
                chart.data[i]['poll_' + poll['id']] = +poll['polling_count'];

            }
            // Create axes
            var categoryAxis = chart.xAxes.push(new am4charts.CategoryAxis());
            categoryAxis.dataFields.category = "date";
            categoryAxis.numberFormatter.numberFormat = "#";
            categoryAxis.renderer.inversed = false;
            categoryAxis.renderer.grid.template.location = 0;
            categoryAxis.renderer.labels.template.rotation = 270;
            categoryAxis.renderer.minGridDistance = 20;
            categoryAxis.renderer.cellStartLocation = 0.1;
            categoryAxis.renderer.cellEndLocation = 0.9;

            var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
            valueAxis.renderer.opposite = false;

            // Create series
            function createSeries(field, name) {
                var series = chart.series.push(new am4charts.ColumnSeries());
                series.dataFields.categoryX = "date";
                series.dataFields.valueY = field;
                series.name = name;
                series.columns.template.tooltipText = "{name}: [bold]{valueY}[/]";
                series.columns.template.height = am4core.percent(100);
                series.sequencedInterpolation = true;

                var valueLabel = series.bullets.push(new am4charts.LabelBullet());
                valueLabel.label.text = "{valueX}";
                valueLabel.label.horizontalCenter = "left";
                valueLabel.label.dx = 10;
                valueLabel.label.hideOversized = false;
                valueLabel.label.truncate = false;
            }
            for (var i = 0; i < pollCount; i++) {

                var poll = pollData[i];
                if(parseInt(poll['polling_count']) == 0){
                    continue;
                }
                var flag = false;
                for (var j=0; j < chart.series.values.length ; j++) {
                    if( chart.series.values[j].dataFields.valueY && chart.series.values[j].dataFields.valueY == "poll_" + poll['id']){
                        flag = true;
                        break;
                    }
                }
                if(flag){
                    continue;
                }

                createSeries("poll_" + poll['id'], poll['title']);
            }
            // Add legend
            chart.legend = new am4charts.Legend();
        } else {
            var textContentContainer = document.getElementById('chartdiv');
            if(textContentContainer){
                textContentContainer.textContent = "There are not results yet.";
            }
            // document.getElementById('chartdiv')
        }
    })


})(jQuery)
