function hexToRgba(hex, alfa) {
    var c;
    if (alfa == null) {
        alfa = 1;
    }
    if (/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)) {
        c = hex.substring(1).split('');
        if (c.length == 3) {
            c = [c[0], c[0], c[1], c[1], c[2], c[2]];
        }
        c = '0x' + c.join('');
        return 'rgba(' + [(c >> 16) & 255, (c >> 8) & 255, c & 255].join(',') + ',' + alfa + ')';
    }
}

jQuery.fn.aysModal = function(action){
    var jQuerythis = jQuery(this);
    switch(action){
        case 'hide':
            jQuery(this).find('.ays-modal-content').css('animation-name', 'zoomOut');
            setTimeout(function(){
                jQuery(document.body).removeClass('modal-open');
                jQuery(document).find('.ays-modal-backdrop').remove();
                jQuerythis.hide();
            }, 250);
        break;
        case 'show': 
        default:
            jQuerythis.show();
            jQuery(this).find('.ays-modal-content').css('animation-name', 'zoomIn');
            jQuery(document).find('.modal-backdrop').remove();
            jQuery(document.body).append('<div class="ays-modal-backdrop"></div>');
            jQuery(document.body).addClass('modal-open');
        break;
    }
}

var themes = [
    'personal',
    {
        name: 'Classic Light',
        themeClass: 'ays-classic-theme',
        mainColor: '#0C6291',
        textColor: '#0C6291',
        buttonTextColor: '#FBFEF9',
        buttonBgColor: '#0c6291',
        iconColor: '#0C6291',
        bgColor: '#FBFEF9',
        answerBgColor: '#FBFEF9',
        titleBgColor: 'rgba(255,255,255,0)',
    },
    {
        name: 'Classic Dark',
        themeClass: 'ays-classic-theme',
        mainColor: '#FBFEF9',
        textColor: '#FBFEF9',
        buttonTextColor: '#222222',
        buttonBgColor: '#FBFEF9',
        iconColor: '#FBFEF9',
        bgColor: '#222222',
        answerBgColor: '#222222',
        titleBgColor: 'rgba(255,255,255,0)',
    },
    {
        name: 'Light Shape',
        themeClass: 'ays-shape-theme',
        mainColor: '#FF2B63',
        textColor: '#4B93B1',
        buttonTextColor: '#FCFFF3',
        buttonBgColor: '#FF2B63',
        iconColor: '#70C1B3',
        bgColor: '#FCFFF3',
        answerBgColor: '#FCFFF3',
        titleBgColor: 'rgba(255,255,255,0)',
    },
    {
        name: 'Dark Shape',
        themeClass: 'ays-shape-theme',
        mainColor: '#B00101',
        textColor: '#FAA916',
        buttonTextColor: '#1B1B1E',
        buttonBgColor: '#B00101',
        iconColor: '#FAA916',
        bgColor: '#1B1B1E',
        answerBgColor: '#1B1B1E',
        titleBgColor: 'rgba(255,255,255,0)',
    },
    {
        name: 'Coffee Fluid',
        themeClass: 'ays-coffee-theme',
        mainColor: 'rgba(80,24,1,0.25)',
        textColor: '#501801',
        buttonTextColor: '#fffbee',
        buttonBgColor: '#501801',
        iconColor: '#501801',
        bgColor: '#fffbee',
        answerBgColor: '#fffbee',
        titleBgColor: 'rgba(255,255,255,0)',
    },
    {
        name: 'Aquamarine',
        themeClass: 'ays-aqua-theme',
        mainColor: '#028090',
        textColor: '#F4F6CF',
        buttonTextColor: '#F4F6CF',
        buttonBgColor: '#028090',
        iconColor: '#FFBA49',
        bgColor: '#00A896',
        answerBgColor: '#00A896',
        titleBgColor: 'rgba(255,255,255,0)',
    },
    {
        name: 'minimal',
        themeClass: 'ays-minimal-theme',
        mainColor: '#7a7a7a',
        textColor: '#424242',
        buttonTextColor: '#424242',
        buttonBgColor: 'rgba(0,0,0,0)',
        iconColor: '#999A9C',
        bgColor  : 'rgba(0,0,0,0)',
        answerBgColor: 'rgba(0,0,0,0)',
        titleBgColor: 'rgba(255,255,255,0)',
    },
];

(function ($) {
    'use strict';

    window.FontAwesomeConfig = {
        autoReplaceSvg: false
    };


        $(document).find('.ays-close').on('click', function () {
              $(document).find('.ays-modal').aysModal('hide');
        });

    $.fn.serializeFormJSON = function () {
        var o = {},
            a = this.serializeArray();
        $.each(a, function () {
            if (o[this.name]) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    };

    $.fn.goToNormal = function() {
        $('html, body').animate({
            scrollTop: this.offset().top - 200 + 'px'
        }, 'normal');
        return this; // for chaining...
    }

    // slack
    $('#ays_slack_client').on('input', function () {
        var clientId = $(this).val();
        if (clientId == '') {
            $("#slackOAuth2").addClass('disabled btn-outline-secondary');
            $("#slackOAuth2").removeClass('btn-secondary');
            return false;
        }
        var scopes = "channels%3Ahistory%20" +
            "channels%3Aread%20" +
            "channels%3Awrite%20" +
            "groups%3Aread%20" +
            "groups%3Awrite%20" +
            "mpim%3Aread%20" +
            "mpim%3Awrite%20" +
            "im%3Awrite%20" +
            "im%3Aread%20" +
            "chat%3Awrite%3Abot%20" +
            "chat%3Awrite%3Auser";
        var url = "https://slack.com/oauth/authorize?client_id=" + clientId + "&scope=" + scopes + "&state=" + clientId;
        $("#slackOAuth2").attr('data-src', url);//.toggleClass('disabled btn-outline-secondary btn-secondary');
        $("#slackOAuth2").removeClass('disabled btn-outline-secondary');
        $("#slackOAuth2").addClass('btn-secondary');
    });
    $("#slackOAuth2").on('click', function () {
        var url = $(this).attr('data-src');
        if (!url) {
            return false;
        }
        location.replace(url);
    });
    $('#ays_slack_secret').on('input', function(e) {
        if($(this).val() == ''){
            $("#slackOAuthGetToken").addClass('disabled btn-outline-secondary');
            $("#slackOAuthGetToken").removeClass('btn-secondary');
            return false;
        }

        $("#slackOAuthGetToken").removeClass('disabled btn-outline-secondary');
        $("#slackOAuthGetToken").addClass('btn-secondary');
    });
    $("#slackInstructionsPopOver").popover({
        content: $("#slackInstructions").html(),
        html: true,
    //            trigger: "focus"
    });


    // USER ADDED ANSWERS

    $('input.apm-answer-by-user').each(function () {
        var notice = $("<span class=\"ays-poll-change-notice apm-user-added-notice\">Answer added by user</span>");
        $(this).parent().css('position', 'relative').prepend(notice);
    });

    $(document).find('.ays_poll_aysDropdown').aysDropdown();
    $(document).find('[data-toggle="dropdown"]').dropdown();

    //PLUGINS
    $('[data-toggle="tooltip"]').tooltip();
    $('.apm-cat-select2').select2({
        placeholder: 'Select category'
    });
    $('select.ays-select').not('.ays-select-search').select2({
        minimumResultsForSearch: -1
    });
    $('.ays-select-search').select2();

    $(document).find('#ays_user_roles').select2({
        placeholder: 'Select role'
    });
    // $('.answers-col').sortable({
    //     placeholder: 'ays-answer-placeholder',
    //     cancel: '.d-none'
    // });

    // copy shortcode
    $(document).find('.ays-poll-copy-image').on('click', function(){
        var _this = this;
        var input = $(_this).parent().find('input.ays-poll-shortcode-input');
        var length = input.val().length;

        input[0].focus();
        input[0].setSelectionRange(0, length);
        document.execCommand('copy');

        $(_this).attr('data-original-title', pollLangObj.copied);
        $(_this).tooltip('show');
    });

    $(document).find('.ays-poll-copy-image').on('mouseleave', function(){
        var _this = this;

        $(_this).attr('data-original-title', pollLangObj.clickForCopy);
    });

    // VERSUS TYPE
    function changeClassesBySelect(select, prefix) {
        if (prefix == null) {
            prefix = '';
        }
        var vsClass = select.val(),
            classes = [];
        select.find('option').each(function () {
            classes.push($(this).attr('value'));
        });
        for (var c in classes) {
            $('div.versus-images-container').removeClass(prefix + classes[c]);
        }
        $('div.versus-images-container').addClass(prefix + vsClass);
    }

    $(document).on('mouseover', '.versus-poll label', function () {
        var $this = $(this);
        $this.parent().addClass('hover-answer');
        $this.parent().parent().addClass('apm-no-after').children().not('.hover-answer').addClass('apm-w-0');
    });
    $(document).on('mouseleave', '.versus-poll label', function () {
        var $this = $(this);
        $this.parent().parent().removeClass('apm-no-after').children().removeClass('apm-w-0');
        $this.parent().removeClass('hover-answer');
    });
    $(document).on('click', '.versus-poll label', function () {
        var $this = $(this);
        $this.parent().parent().children().removeClass('active-answer');
        $this.parent().addClass('active-answer');
    });

    $('#versus-type').on('change', function () {
        changeClassesBySelect($(this), '');
    })
    $('#versus-icon-type').on('change', function () {
        changeClassesBySelect($(this), 'vs-');
    });
    $('#versus-icon-position').on('change', function () {
        changeClassesBySelect($(this), 'vs-icon-');
    });

    $('#ays_enable_restriction_pass').on('change', function () {
        if ($(this).prop('checked')) {
            if(!$('#ays_enable_logged_users').prop('checked')) {
                $('#ays_enable_logged_users').trigger('click');
            }
        } else {
            $('.if-users-roles').fadeOut();
        }
    });

    if ($('#ays_enable_logged_users').prop('checked')) {
        $('.if-logged-in').fadeIn();
    }

    if ($('#ays_enable_restriction_pass').prop('checked')) {
        $('.if-users-roles').fadeIn();
    }

    $('#ays_enable_logged_users').on('change', function () {
        if (!$(this).prop('checked')) {
            $('#ays_enable_restriction_pass').prop('checked', false);
            $('.if-users-roles').fadeOut();
        }
    });

    // Redirect after vote
    if ($('#ays_redirect_after_vote').prop('checked')) {
        $('.if-redirect-after-vote').fadeIn();
    }
    $('#ays_redirect_after_vote').on('change', function () {
        $('.if-redirect-after-vote').fadeToggle()
    });

    // Answer Sound
    if ($('#ays_enable_asnwers_sound').prop('checked')) {
        $('.if_answer_sound').fadeIn();
    }
    $('#ays_enable_asnwers_sound').on('change', function () {
        $('.if_answer_sound').fadeToggle()
    });

    //Hide results
    // $('.if-ays-poll-hide-results').css("display", "flex").hide();
    // if ($('#ays-poll-hide-results').prop('checked')) {
    //     $('.if-ays-poll-hide-results').fadeIn();
    // }
    $('#ays-poll-hide-results').on('change', function () {
        // $('.if-ays-poll-hide-results').fadeToggle();
        if ($(this).prop('checked')) {
            $('#ays-poll-allow-not-vote').prop('checked', false);
        }
    });

    //Allow not to vote
    $('#ays-poll-allow-not-vote').on('change', function () {
        if ($('#ays-poll-allow-not-vote').prop('checked')) {
            $('#ays-poll-hide-results').prop('checked', false)
            $('.ays-poll-hide-results-message-box').slideUp()
        }
    });

    $('#allow_not_to_vote').on('change', function() {
        var state = $('#allow_not_to_vote').prop('checked');

        if (state) {
            $('#quick-poll-hide-results').prop('checked', false);
        }
    })

    $('#quick-poll-hide-results').on('change', function() {
        var state = $('#quick-poll-hide-results').prop('checked');

        if (state) {
            $('#allow_not_to_vote').prop('checked', false);
        }
    })

    //Allow info_form
    $('.ays-poll-if-form-on').css("display", "flex").hide();
    if ($('#ays_poll_info_form').prop('checked')) {
        $('.ays-poll-if-form-on').fadeIn();
    }
    $('#ays_poll_info_form').on('change', function () {
        var propCheck = $(this).prop("checked");
        var allowCollect = $(document).find(".ays_toggle_target_inverse");
        if(propCheck){
            allowCollect.children('#ays_allow_collecting_logged_in_users_data').prop("checked" , false);
            allowCollect.fadeOut();
        }
        else{
            allowCollect.fadeIn();
        }
        $('.ays-poll-if-form-on').fadeToggle();
    });
    $(".ays-poll-sel-fields input[type='checkbox']").on('change', function () {
        var id = $(this).val();
        if ($(this).prop('checked')) {
            $('#ays-poll-box-rfield-' + id).fadeIn();
        } else {
            $('#ays-poll-box-rfield-' + id).find('input').prop('checked', false);
            $('#ays-poll-box-rfield-' + id).fadeOut();
        }
    });

    //Loading animation
    $('.if-custom-load').css("display", "flex").hide();
    if ($('#ays-poll-load-effect').val() == 'custom') {
        $('.if-custom-load').fadeIn();
    }
    $('.if-loading-gif').css("display", "flex").hide();
    if ($('#ays-poll-load-effect').val() == 'load_gif') {
        $('.if-loading-gif').fadeIn();
    }
    if ($('#ays-poll-load-effect').val() == 'message') {
        $('.if-loading-message').fadeIn();
    }

    $('#ays-poll-load-effect').on('change', function () {
        var effect = $(this).val();
        var sizeCont = $(document).find(".ays_load_gif_cont");
        var sizeContLine = $(document).find(".ays_line_changeing");

        if (effect == 'custom') {
            $('.if-custom-load').fadeIn();
        } else {
            $('.if-custom-load').fadeOut(0)
        }
        if (effect == 'load_gif') {
            $('.if-loading-gif').fadeIn();
            $('.if-loading-message').hide();
            if(sizeCont.hasClass("display_none")){
                sizeCont.removeClass("display_none");
            }
            if(sizeContLine.hasClass("ays_hr_display_none")){
                sizeContLine.removeClass("ays_hr_display_none");
            }

        }
        else if(effect == 'message'){
            $('.if-loading-message').fadeIn();
            $('.if-loading-gif').hide();
        }
 
        else {
            $('.if-loading-gif').fadeOut(0);
            $('.if-loading-message').fadeOut();
            if(!sizeCont.hasClass("display_none")){
                sizeCont.addClass("display_none");
                sizeContLine.addClass("ays_hr_display_none");
            }
            if(!sizeContLine.hasClass("ays_hr_display_none")){
                sizeContLine.addClass("ays_hr_display_none");
            }

        }
    });

    // Show answer message
    $(document).on('change', '#ays_show_answer_message', function(e) {
        var state = $(this).prop('checked');
        var answersTable = $(document).find('.ays-field-dashboard.ays-poll-answers-table-container');
        if (state) {
            answersTable.slideDown();
        } else {
            answersTable.slideUp();
        }
    });
    $(document).on('click', 'a.add-load-image', function (e) {
        openMediaUploaderLoad(e, $(this));
    });

    $(document).on('click', 'a.add-question-image', function (e) {
        openMediaUploader(e, $(this));
    });
    $(document).on('click', 'a.add-bg-image', function (e) {
        openMediaUploaderBg(e, $(this));
    });
    $(document).on('click', 'a.add-logo-image', function (e) {
        openMediaUploaderLogo(e, $(this));
    });
    $(document).on('click', '.ays-remove-load-img', function () {
        $('img#ays-poll-custom-load').attr('src', '');
        $('input#ays-poll-custom-load').val('');
        $('.ays-poll-load-image-container').fadeOut();
        $('a.add-load-image').text('Add Image');
    });
    $(document).on('click', '.ays-remove-question-img', function () {
        $(this).parent().find('img#ays-poll-img').attr('src', '');
        $(this).parent().find('input#ays-poll-image').val('').trigger('change');
        $(this).parent().fadeOut();
        $(document).find('label a.add-question-image').text('Add Image');
        $('.ays-poll-img').remove();
    });
    $(document).on('click', '.ays-remove-bg-img', function () {
        $('img#ays-poll-bg-img').attr('src', '');
        $('input#ays-poll-bg-image').val('').trigger('change');
        $('.ays-poll-bg-image-container').parent().fadeOut(300);
        $(this).parents(".form-group.row").find('a.add-bg-image').text('Add Image');
        $('.box-apm').css('background-image', 'unset');
        $('#ays-poll-background-image-options').fadeOut(300);
        if ($(document).find('#ays-enable-background-gradient').prop('checked')) {
            toggleBackgrounGradient();
        }

    });
    
    $(document).on('click', '.delete a[href]', function(){
        return confirm('Do you want to delete?');
    });

    function openMediaUploader(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload',
            button: {
                text: 'Upload'
            },
            library: {
                type: 'image'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            element.text('Edit Image');
            $('.ays-poll-question-image-container').fadeIn();
            $('img#ays-poll-img').attr('src', attachment.url);
            $('input#ays-poll-image').val(attachment.url).trigger('change');
            $('.apm-img-box').empty().fadeIn().append("<img class='ays-poll-img' src='"+attachment.url+"'>");
        }).open();
        return false;
    }

    function openMediaUploaderBg(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload',
            button: {
                text: 'Upload'
            },
            library: {
                type: 'image'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            element.text('Edit Image');
            $('.ays-poll-bg-image-container').parent().fadeIn();
            $('img#ays-poll-bg-img').attr('src', attachment.url);
            $('input#ays-poll-bg-image').val(attachment.url).trigger('change');
            $('.box-apm').css('background-image', "url('"+attachment.url+"')");
            $('#ays-poll-background-image-options').show();
            ////
        }).open();
        return false;
    }

    function openMediaUploaderLoad(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload',
            button: {
                text: 'Upload'
            },
            library: {
                type: 'image'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            element.text('Edit Image');
            $('.ays-poll-load-image-container').fadeIn();
            $('img#ays-poll-custom-load').attr('src', attachment.url);
            $('input#ays-poll-custom-load').val(attachment.url);
        }).open();
        return false;
    }

    function openMediaUploaderLogo(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload',
            button: {
                text: 'Upload'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            var attachmentUrl = attachment.url;
            if (attachment.type != 'image') {
                return alert('Please load image file');
            }
            element.text('Edit Image');
            $('.ays-poll-logo-image-container').parents('.ays_logo_image_remove').fadeIn();
            $('img#ays-poll-logo-img').attr('src', attachmentUrl);
            $('input#ays-poll-logo-image').val(attachmentUrl).trigger('change');
            $(document).find(".box-apm:not(.ays-poll-live-container-answers)").css('position' , 'relative');
            $(document).find(".ays-poll-logo-url-disable").removeClass("display_none");
            var imageLiveContainer = $(document).find(".ays_live_logo_container");
            imageLiveContainer.show();
            imageLiveContainer.html("<img src="+attachmentUrl+" width='55' height='55' class='ays_live_image_preview'>");
            var getClass = $(document).find(".box-apm:not(.ays-poll-live-container-answers)");
            if(!getClass.hasClass("ays_logo_cont_image_on")){
                getClass.addClass("ays_logo_cont_image_on");
            }
            $(document).find(".ays-poll-toggle-image-url-box").removeClass("display_none");
            $(document).find(".ays-poll-toggle-image-title-box").removeClass("display_none");
        }).open();
        return false;
    }


    $('#ays-poll-vote-type').on('change', function () {
        switch ($(this).val()) {
            case 'hand':
                $('#vote-res').removeClass().addClass('ays_poll_far ays_poll_fa-thumbs-up');
                break;
            case 'emoji':
                $('#vote-res').removeClass().addClass('ays_poll_fas ays_poll_fa-smile');
                break;
            default:
                break;
        }
    });
    $('#ays-poll-rate-type').on('change', function () {
        switch ($(this).val()) {
            case 'star':
                $('#rate-res').removeClass().addClass('ays_poll_fas ays_poll_fa-star');
                break;
            case 'emoji':
                $('#rate-res').removeClass().addClass('ays_poll_fas ays_poll_fa-smile');
                break;
            default:
                break;
        }
    });

    //checkPollType();
    // $('#ays-poll-type').on('change', checkPollType);
    $('.ays_poll_type_image_div').on('click', checkPollType);
    $(".ays-poll-types:checked").parents('.ays_poll_type_image_div').find('label').addClass('apm_active_type');
    function checkPollType(type) {
        var checkType = $('#type_choosing').prop('checked');
        //var pollType = $(document).find('.ays-poll-types:checked').val();
        var pollType = type;
        // $('.ays_poll_type_image_div label').each(function () {
        //     $(this).removeClass('apm_active_type');
        // });
        // $(this).find('label').addClass('apm_active_type');
        // var blocks = $('div.apm-poll-type[class|="if"]').hide();
        // var thisBlock = $('.if-' + $(".ays-poll-types:checked").val()).css('display', 'flex');

        $('.if_versus_type').css("display", "flex").hide();
        if ($('#type_versus').prop('checked')) {
            $('.if_versus_type').fadeIn();
        }else{
            if( $("#ays_poll_show_res_versus_chart").prop('checked')){
             $('#ays_poll_show_res_standart').prop("checked", true);
             $("#ays_poll_show_res_versus_chart").removeAttr('checked'); 
            }

        }

        var showPollresultsType = $(document).find('input[name="ays_poll_show_result_view"]:checked').val();
        if( pollType == 'choosing' ){
            $(document).find('input[name="ays_poll_show_result_view"][value="not_reloading"]').parents('.ays_poll_loader').show();
            $(document).find('.ays_poll_option_only_for_choosing_type').show();
        }
        else if(pollType == 'dropdown'){
            $(document).find("#ays_poll_enable_answer_style").attr("checked" , false);
            var notType = $(document).find('input[name="ays_poll_show_result_view"][value="not_reloading"]').attr('checked');
            if(notType == 'checked'){
                $(document).find('input[name="ays_poll_show_result_view"][value="standart"]').prop('checked', true);
            }
            $(document).find('input[name="ays_poll_show_result_view"][value="not_reloading"]').parents('.ays_poll_loader').hide();
            $(document).find('.ays_poll_option_only_for_choosing_type, .if-choosing').hide();
            $(document).find('.is-choosing.is-versus').hide();
        }
        else if(pollType == 'text'){
            var pollTypeS = $("input[name='ays_poll_text_type']:checked").val();
            $(document).find('.ays_poll_option_only_for_choosing_type, .if-choosing').hide();
            $(document).find('.is-choosing.is-versus').hide();
        } else if (pollType == 'voting') {
            $(document).find('.ays_poll_option_only_for_rating_voting_types').show();
            $(document).find('.ays_poll_option_only_for_choosing_type, .if-choosing').hide();
            $(document).find('.is-choosing.is-versus').hide();
        } else {
            $(document).find("#ays_poll_enable_answer_style").attr("checked" , false);
            $(document).find('input[name="ays_poll_show_result_view"][value="not_reloading"]').prop('checked', false);
            $(document).find('input[name="ays_poll_show_result_view"][value="not_reloading"]').parents('.ays_poll_loader').hide();
            $(document).find('input[name="ays_poll_show_result_view"][value="standart"]').prop('checked', true);
            $(document).find('.ays_poll_option_only_for_choosing_type, .if-choosing').hide();
        }

        if (pollType == 'range') {
            $(document).find('.ays_poll_hide_for_range_type').hide();
            $(document).find('.is-choosing.is-versus').hide();
        }

        $('.if_rating_type').css("display", "flex").hide();

        if ($('#type_rating').prop('checked') ) {
            if($('#ays-poll-rate-type').val() == 'star'){
                $('.if_rating_type').fadeIn();
            }
            $(document).find('.ays_poll_option_only_for_rating_voting_types').show();
        }else{
            if( $("#ays_poll_show_res_rating_chart").prop('checked')){
             $('#ays_poll_show_res_standart').prop("checked", true);
             $("#ays_poll_show_res_rating_chart").removeAttr('checked'); 
            }
        }
            // fields = blocks.find('select, input'),
            // thisFields = thisBlock.find('select, input')

        /*fields.each(function () {
            if ($(this).attr('data-required') === 'true') {
                $(this).attr('data-required', false)
            }
        });
        thisFields.each(function () {
            if ($(this).attr('data-required') !== undefined) {
                $(this).attr('data-required', true)
            }
        });*/

        $('[class|="if"].poll-type-block ').hide().find('select, input:not([type="hidden"]):not(.ays_redirect_active)').attr('data-required', false);
        if ($('.apm-poll-type.form-group.row:visible').length > 0) {
            $('.apm-poll-type.form-group.row:visible').css('display', 'none');
        }
        $('.if-' + pollType).css('display', 'flex').find('select, input:not([type="hidden"]):not(.ays_redirect_active)').attr('data-required', true);
        $(document).find('#ays_poll_question_text_max_length').attr('data-required', false);
        $(document).find('#ays_poll_text_type_placeholder').attr('data-required', false);
        $(document).find('#ays_poll_text_type_width').attr('data-required', false);
        $('.if-choosing').find('select, input:not([type="hidden"]):not(.ays_redirect_active)').attr('data-required', false);
        checkHr(checkType, pollType);

        if(type == 'text'){
            ays_tmce_setContent('<p style="text-align: center;">Thank you!</p>','ays_result_message');

            // Set alignment default value to center
            $(document).find('#apm-dir-center').prop('checked', true);
        }
    }

    function ays_tmce_setContent(content, editor_id, textarea_id) {
        if ( typeof editor_id == 'undefined' ) editor_id = wpActiveEditor;
        if ( typeof textarea_id == 'undefined' ) textarea_id = editor_id;
        if ( $(document).find('#wp-'+editor_id+'-wrap').hasClass('tmce-active') && tinyMCE && tinyMCE.get(editor_id) ) {
          return tinyMCE.get(editor_id).setContent(content);
        }else{
          return $(document).find('#'+textarea_id).val(content);
        }
    }

    var pollType = $(document).find('#poll_choose_type_first').val();
    $('.if-' + pollType).css('display', 'flex').find('select, input:not([type="hidden"]):not(.ays_redirect_active)').attr('data-required', true);
    $('.if-choosing').find('select, input:not([type="hidden"]):not(.ays_redirect_active)').attr('data-required', false);
    $(document).find('#ays_poll_question_text_max_length').attr('data-required', false);
    $(document).find('#ays_poll_text_type_placeholder').attr('data-required', false);
    $(document).find('#ays_poll_text_type_width').attr('data-required', false);
    checkHr(false , pollType)

    function checkHr(type , pollType) {
        var typeChecker = $(document).find(".ays_hr_on");
        var textTypeChecker = $(document).find(".ays_hr_on_text");
        //var rangeType = $('#type_range').prop('checked');
        if(pollType !== "choosing"){
            // if(typeChecker.hasClass("ays_hr_check")){
            //     typeChecker.addClass("ays_hr_on");
            //     // typeChecker.hide();
            // }
            typeChecker.hide();
        }
        else{
            typeChecker.show();
        }

        if(pollType == "text"){
            textTypeChecker.show();
        }
        else{
            textTypeChecker.hide();
        }

        if(pollType == "range"){
            $(document).find(".ays_hr_check").hide();
        }
        else{
            $(document).find(".ays_hr_check").show();
        }
    }

    $(document).find('#ays-poll-rate-type').on('change',function(){
        var $this = $(this);
        var selectedVal = $this.val();

        switch ( selectedVal ) {
            case 'star' :
                 $('.if_rating_type').fadeIn();
            break;
            case 'emoji' :
                if($('#ays_poll_show_res_rating_chart').prop("checked")){
                    $("#ays_poll_show_res_rating_chart").removeAttr('checked');
                    $('#ays_poll_show_res_rating_chart').prop("checked", false);
                    $('.if_rating_type').fadeOut();
                    $('#ays_poll_show_res_standart').prop("checked", true);
                }
                else{
                   $('.if_rating_type').fadeOut(); 
                }
            break;
            default:
                $('.if_rating_type').fadeIn();
            break;
        }
    }); 

    function rateType() {
        var val = $('#ays-poll-rate-value').val();
        $('#ays-poll-rate-value').empty();
        for (var i = 10; i > 2; i--) {
            if ($('#ays-poll-rate-type').val() == 'emoji' && (i == 4 || i > 5)) continue;
            if (i == 9 || i == 8 || i == 6 ) continue;
            var selected = '';
            if (i == val) {
                selected = 'selected';
            }
            var option = $("<option value="+i+" "+ selected +">"+i+"</option>");
            $('#ays-poll-rate-value').append(option)
        }
        $('#ays-poll-rate-value').show();
    }

    rateType();
    $('#ays-poll-rate-type').on('change', rateType);
    
    $('.ays_poll_choose_answer_type').on('click', function () {
        var check_this = $(this).parent().find('input[name="ays_poll_choose_answer_type"]').val();
        if (check_this == 'grid') {
            $('div.apm-answers').addClass('apm-grid').find('.apm-choosing label').each(function () {
                if (!($(this)[0].style.backgroundImage == 'unset' || $(this)[0].style.backgroundImage == '' || $(this)[0].style.backgroundImage == 'none')) {
                    $(this).addClass('apm-label-with-bg');
                }                
            });
            $('.apm-answer-img').fadeIn();
            $('.apm-remove-answer-bg').each(function () {
                if ($(this).parent().find('.apm-answer-img input').val() != '') {
                    $(this).fadeIn();
                }
            })
            $('.ays_grid_show').css('display','flex');
            if (!$('#ays_poll_show_answers_caption').prop('checked')) {
                $('.ays_grid_answer_span').hide();
            }
        } else {
            $('.ays_grid_answer_span').css('display','inline-block');
            $('div.apm-answers').removeClass('apm-grid').find('.apm-choosing label').removeClass('apm-label-with-bg');
            $('.apm-answer-img').fadeOut();
            $('.apm-remove-answer-bg').fadeOut();
            $('.ays_grid_show').fadeOut();
        }
    });
    // $(document).on('click','#add-answer' ,function(){
    //     var answersCount = $('.if-choosing .answers-col').find('input[type="text"]').length;
    //     var id = ++answersCount;
    //     $('.if-choosing .answers-col').append(`<div>
    //                     <input type="text" class="ays-text-input ays-text-input-short ays_add_poll_answers" name='ays-poll-answers[]' data-id='${id}'>
    //                     <input type="hidden" name="ays-poll-answers-ids[]" data-id='${id}' value="0">
    //                     <i class='ays_poll_fas ays_poll_fa-minus-square remove-answer' data-id='${id}'></i>
    //                     <i ${$('.poll_choose_type[checked]').val() != 'grid' ? `style="display:none"` : ``} class="ays_poll_far ays_poll_fa-image apm-answer-img" data-id="${id}" title="Add image for answer">
    //                         <input type="hidden" class="apm-answers-images" name="apm-answers-images[]" value="">
    //                     </i>
    //                     <span style="display:none" title="Remove answer image" class="apm-remove-answer-bg" data-id='${id}'>
    //                         <i class="ays_poll_far ays_poll_fa-image">
    //                             <i class="ays_poll_fas ays_poll_fa-times"></i>
    //                         </i>
    //                     </span>
    //                     <input type="hidden" name="ays_poll_show_user_added[]" value="1">
    //                 </div>`);

    //     var addedRedirectBox = '';

    //     addedRedirectBox += '<div class="ays-redirect-parent-box">';
    //         addedRedirectBox += '<div class="ays-redirect-content-left">';
    //             addedRedirectBox += '<label for="ays_submit_redirect_url_'+id+'">URL ';
    //                 addedRedirectBox += '<a class="ays_help" data-toggle="tooltip">';
    //                     addedRedirectBox += '<i class="ays_poll_fas ays_poll_fa-info-circle"></i>';
    //                 addedRedirectBox += '</a>';
    //             addedRedirectBox += '</label>';
    //         addedRedirectBox += '</div>';
                
    //         addedRedirectBox += '<div>';
    //             addedRedirectBox += '<input type="url" class="ays-text-input ays-text-input-short" id="ays_submit_redirect_url_'+id+'" name="ays_submit_redirect_url[]" />';
    //         addedRedirectBox += '</div>';
    //     addedRedirectBox += '</div>';

    //     $('#ays_redirect_box').append(addedRedirectBox);

    // });
    // ==================================
    // ==================================
    // ==================================

    $(document).on('click','#add-answer', function(){
        var answersTable = $(document).find('#ays-answers-table');
        var answersTableTbody = answersTable.find('tbody');

        var aysRedirectChekbox = $(document).find('input[type="checkbox"]#ays_redirect_after_submit');
        var aysFakeVotes = $(document).find('input[type="checkbox"]#ays_add_f_votes');
        var aysRedirectChekboxClass = '';
        var aysFakeVotesClass = '';
        if(aysRedirectChekbox.prop('checked') == false){
            aysRedirectChekboxClass = 'ays_poll_display_none';
        }
        var latestTr = answersTable.find(".ays_poll_enter_key");
        var latestTrClass = "";
        if(latestTr.length > 0){
            latestTrClass = "ays_poll_enter_key";
            if(latestTr.hasClass("ays_poll_enter_key")){
                latestTr.removeClass("ays_poll_enter_key");
            }
        }

        if(!aysFakeVotes.prop('checked')){
            aysFakeVotesClass = 'ays_poll_display_none';
        }

        var answersCount = $(document).find('#ays_poll_answers_count').val();
        var id = 1 + parseInt(answersCount);

        var content = '';

        content += '<tr class="ays-answer-row ui-state-default">';
            content += '<td class="ays-sort"><div class="ays_poll_move_arrows"></div></td>';
            content += '<td>';
                content += '<div class="ays_poll_display_flex">';
                    content += '<input type="hidden" class="" />';
                    content += '<input type="text" class="ays-text-input ays-answer-value '+latestTrClass+'" name="ays-poll-answers[]" data-id="'+id+'" data-lid="'+id+'">';
                    content += '<input type="hidden" name="ays-poll-answers-ids[]" data-id="'+id+'" value="0">';
                content += '</div>';
            content += '</td>';
            content += '<td class="ays-answer-redirect-row '+ aysRedirectChekboxClass +' ">';
                content += '<input type="text" class="ays-text-input ays_redirect_active" id="ays_submit_redirect_url_'+id+'" name="ays_submit_redirect_url[]" />';
            content += '</td>';
            content += '<td class="ays-f-votes-row '+ aysFakeVotesClass +' ">';
                content += '<input type="number" class="ays-text-input ays_f_votes_active" id="ays_f_votes_count_'+id+'" name="ays_f_votes_count[]" value="0"/>';
            content += '</td>';
            content += '<td>';
                content += '<label class="ays-label" for="ays-answer">';
                    content += '<a style="" class="add-answer-image add-answer-image-icon"></a>';
                content += '</label>';

                content += '<div class="ays-answer-image-container ays-answer-image-container-div" style="display:none;">';
                    content += '<span class="ays-remove-answer-img"></span>';
                    content += '<img src="" class="ays-answer-img"/>';
                    content += '<input type="hidden" name="apm-answers-images[]" class="ays-answer-image-path" value=""/>';
                content += '</div>';
            content += '</td>';
            content += '<td>';
                content += '<a href="javascript:void(0)" class="ays-delete-answer" data-id='+id+' data-press-key='+latestTrClass+'>';
                content += '</a>';
            content += '</td>';
        content += '</tr>';

        answersTableTbody.append(content);
        var appendedTr = answersTableTbody.find(".ays_poll_enter_key");
        appendedTr.focus();


        var answersRow = $(document).find('#ays-answers-table tbody tr.ays-answer-row');
        var index = 1;
        if (answersRow.length > 0) {
            answersRow.each(function () {
                if ($(this).hasClass('even')) {
                    $(this).removeClass('even');
                }
                var className = ((index % 2) === 0) ? 'even' : '';
                index++;
                $(this).addClass(className);
            });
        }

        $(document).find('#ays_poll_answers_count').val(id);
    });


    // $(document).find('#add-answer-dropdown').on('mouseover' , function () {
    //     $(this).removeClass('ays_poll_far').addClass('ays_poll_fas');
    // });
    // $(document).find('#add-answer-dropdown').on('mouseout' , function() {
    //     $(this).removeClass('ays_poll_fas').addClass('ays_poll_far');
    // });
    $(document).find('#add_dropdown_answer_top, #add_dropdown_answer_bottom').on('click' , function () {
        var answersTable = $(document).find('#ays-dropdown-answers-table');
        var answersTableTbody = answersTable.find('tbody');

        var aysRedirectChekbox = $(document).find('input[type="checkbox"]#ays_redirect_after_submit');
        var aysRedirectChekboxClass = '';
        if(aysRedirectChekbox.prop('checked') == false){
            aysRedirectChekboxClass = 'ays_poll_display_none';
        }
        var latestTr = answersTable.find(".ays_poll_enter_key");
        var latestTrClass = "";
        if(latestTr.length > 0){
            latestTrClass = "ays_poll_enter_key";
            if(latestTr.hasClass("ays_poll_enter_key")){
                latestTr.removeClass("ays_poll_enter_key");
            }
        }

        var answersCount = $(document).find('#ays_poll_drpdwn_answers_count').val();
        var id = 1 + parseInt(answersCount);

        var content = '';

        content += '<tr class="ays-answer-row ui-state-default">';
            content += '<td class="ays-sort"><i class="ays_poll_fas ays_poll_fa_arrows" aria-hidden="true"></i></td>';
            content += '<td>';
                content += '<div class="ays_poll_display_flex">';
                    content += '<input type="hidden" class="" />';
                    content += '<input type="text" class="ays-text-input ays-answer-value '+latestTrClass+'" name="ays-poll-answers-dropdown[]" data-id="'+id+'" data-lid="'+id+'">';
                    content += '<input type="hidden" name="ays-poll-answers-dropdown-ids[]" data-id="'+id+'" value="0">';
                content += '</div>';
            content += '</td>';
            content += '<td class="ays-answer-redirect-row '+ aysRedirectChekboxClass +' ">';
                content += '<input type="text" class="ays-text-input ays_redirect_active" id="ays_dropdown_submit_redirect_url'+id+'" name="ays_dropdown_submit_redirect_url[]" />';
            content += '</td>';
            content += '<td>';
                content += '<a href="javascript:void(0)" class="ays-delete-answer" data-id='+id+' data-press-key='+latestTrClass+'>';
                content += '</a>';
            content += '</td>';
        content += '</tr>';

        answersTableTbody.append(content);
        var appendedTr = answersTableTbody.find(".ays_poll_enter_key");
        appendedTr.focus();


        var answersRow = $(document).find('#ays-answers-table tbody tr.ays-answer-row');
        var index = 1;
        if (answersRow.length > 0) {
            answersRow.each(function () {
                if ($(this).hasClass('even')) {
                    $(this).removeClass('even');
                }
                var className = ((index % 2) === 0) ? 'even' : '';
                index++;
                $(this).addClass(className);
            });
        }

        $(document).find('#ays_poll_drpdwn_answers_count').val(id);


            // var answersCount = $('.if-dropdown .answers-col').find('input[type="text"]').length;
            // var id = ++answersCount;
            // var dropContent = '<div> ';
            //         dropContent += ' <input type="text" class="ays-text-input ays-text-input-short ays_add_poll_answers" name="ays-poll-answers-dropdown[]" data-id='+id+'> ';
            //         dropContent += ' <input type="hidden" name="ays-poll-answers-dropdown-ids[]" data-id='+id+' value="0"> ';
            //         dropContent += ' <i class="ays_poll_fas ays_poll_fa-minus-square remove-answer" data-id='+id+'></i> ';
            //         dropContent += ' <input type="hidden" name="ays_poll_show_user_added_dropdown[]" value="1"> ';
            //   dropContent += ' </div>';
            // $('.if-dropdown .answers-col').append(dropContent);

            // var addedRedirectBox = '';

            // addedRedirectBox += '<div class="ays-redirect-parent-box">';
            //     addedRedirectBox += '<div class="ays-redirect-content-left">';
            //         addedRedirectBox += '<label for="ays_dropdown_submit_redirect_url_'+id+'">URL ';
            //             addedRedirectBox += '<a class="ays_help" data-toggle="tooltip">';
            //                 addedRedirectBox += '<i class="ays_poll_fas ays_poll_fa-info-circle"></i>';
            //             addedRedirectBox += '</a>';
            //         addedRedirectBox += '</label>';
            //     addedRedirectBox += '</div>';
                    
            //     addedRedirectBox += '<div>';
            //         addedRedirectBox += '<input type="url" class="ays-text-input ays-text-input-short" id="ays_dropdown_submit_redirect_url_'+id+'" name="ays_dropdown_submit_redirect_url[]" />';
            //     addedRedirectBox += '</div>';
            // addedRedirectBox += '</div>';

            // $('#ays_redirect_box_dropdown').append(addedRedirectBox);
    });

    // $(document).on('click', '.remove-answer', function () {
    //     var answerId = $(this).attr('data-id');
    //     if ($(this).parents(".if-choosing").length) {
    //         $('.if-choosing .answers-col').find('input[data-id="' + answerId + '"]').parent().remove();
    //         $(document).find('#ays_submit_redirect_url_'+answerId).parent().parent().remove();
    //         $(document).find('#ays_f_votes_count_'+answerId).parent().parent().remove();
    //     }else if($(this).parents(".if-dropdown").length){
    //         $('.if-dropdown .answers-col').find('input[data-id="' + answerId + '"]').parent().remove();
    //         $(document).find('#ays_dropdown_submit_redirect_url_'+answerId).parent().parent().remove();
    //     }
    // });

    $(document).on('click', '.ays-delete-answer', function () {
        var confirmAnswerDelete = window.confirm(pollLangObj.deleteAnswer);
        if(confirmAnswerDelete) {
            var $this = $(this);
            var index = 1;
            var rowCount = $('tr.ays-answer-row').length;
            if (rowCount > 2) {
                $this.parents("tr").css({
                    'animation-name': 'slideOutLeft',
                    'animation-duration': '.3s'
                });
                var currentElement = "ays_poll_enter_key";
                setTimeout(function(){
                    $this.parent('td').parent('tr.ays-answer-row').remove();
                    $(document).find('tr.ays-answer-row').each(function () {
                        if ($(this).hasClass('even')) {
                            $(this).removeClass('even');
                        }
                        var className = ((index % 2) === 0) ? 'even' : '';
                        $(this).addClass(className);
                        $(this).find('span.ays-radio').find('input').attr('id', 'ays-correct-answer-' + index);
                        $(this).find('span.ays-radio').find('input').val(index);
                        $(this).find('span.ays-radio').find('label').attr('for', 'ays-correct-answer-' + index);
                        index++;
                    });
                    
                        var latestAnswer = $(document).find("table#ays-answers-table input[name='ays-poll-answers[]']").last();
                        var oldValue  = latestAnswer.val();
                        latestAnswer.val(" ").trigger('change');
                        latestAnswer.val(oldValue);
                        latestAnswer.addClass(currentElement);
                        latestAnswer.focus();
                },300);
                var $thisDataId = $this.data("lid");
                $(document).find(".apm-choosing").each(function(){
                    var livePrevDataId = $(this).data("lid");
                    if(livePrevDataId == $thisDataId){
                        $(this).remove();
                    }
                });
            }
            else {
                swal({
                    type: 'warning',
                    text: pollLangObj.answersMinCount
                });
            }
        }
    });

    $(document).on('mouseover', '.remove-answer', function () {
        $(this).removeClass('ays_poll_fas').addClass('ays_poll_far');
    });
    $(document).on('mouseout', '.remove-answer', function () {
        $(this).removeClass('ays_poll_far').addClass('ays_poll_fas');
    });
    $(document).on('mouseover', '.apm-answer-img', function () {
        $(this).removeClass('ays_poll_far').addClass('ays_poll_fas');
    });
    $(document).on('mouseout', '.apm-answer-img', function () {
        $(this).removeClass('ays_poll_fas').addClass('ays_poll_far');
    });
    $(document).on('click', '.apm-answer-img', function (e) {
        openMediaUploaderAnswer(e, $(this));
    });
    $(document).on('mouseover', '.apm-remove-answer-bg .ays_poll_fa-image', function () {
        $(this).removeClass('ays_poll_far').addClass('ays_poll_fas')
    });
    $(document).on('mouseout', '.apm-remove-answer-bg .ays_poll_fa-image', function () {
        $(this).removeClass('ays_poll_fas').addClass('ays_poll_far');
    });
    $(document).on('click', '.apm-remove-answer-bg', function () {
        $(this).parent().find('.ays-text-input').css('background-image', 'unset');
        $(this).parent().find('.apm-answers-images').val('');
        var index = $(this).parent().index();
        if ($(this).parents('.if-versus').length > 0) {
            $('.versus-image-container').eq(index).css({
                backgroundImage: "",
                border: ""
            });
        } else {
            $('.apm-choosing').eq(index).find('label').css('background-image', 'unset').removeClass('apm-label-with-bg');
        }
        $(this).parent().find('.apm-answer-img').attr('title', 'Add answer image').removeClass('ays_poll_fa-images').addClass('ays_poll_fa-image');
        $(this).fadeOut();
    });

    function openMediaUploaderAnswer(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload',
            button: {
                text: 'Upload'
            },
            library: {
                type: 'image'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            element.attr('title', 'Edit image').removeClass('ays_poll_fa-image').addClass('ays_poll_fa-images');
            element.find('.apm-answers-images').val(attachment.url);
            element.parent().find('.apm-remove-answer-bg').fadeIn();
            var index = element.parent().index();
            if (element.parents('.if-versus').length > 0) {
                $('.versus-image-container').eq(index).css({
                    "backgroundImage": "url('"+attachment.url+"')",
                    "border": "none"
                });
            } else {
                index--;
                var apmChoosing = $('.apm-choosing').eq(index).find('label');
                apmChoosing.css(
                    "background-image", "url('"+attachment.url+"')"
                );
                apmChoosing.addClass('apm-label-with-bg');
            }
        }).open();
        return false;
    }

    $(document).find('.nav-tab-wrapper a.nav-tab').on('click', function (e) {
        if(! $(this).hasClass('no-js')){
            var elemenetID = $(this).attr('href');
            var activeTab = $(this).attr('data-title');
            var activeTabData = $(this).attr('data-tab');
            var setActiveTab = $(this).attr('data-tab');
            
            $(document).find('.nav-tab-wrapper a.nav-tab').each(function () {
                if ($(this).hasClass('nav-tab-active')) {
                    $(this).removeClass('nav-tab-active');
                }
            });
            $(this).addClass('nav-tab-active');
            $(document).find('.ays-poll-tab-content').each(function () {
                $(this).css('display', 'none');
            });

            $('#ays_poll_active_tab').val(activeTab);
            $(document).find('#ays_poll_active_tab_settings').val(activeTabData);
            $(document).find('#ays_poll_active_tab_results').val(activeTabData);
            $(document).find("[name='ays_poll_tab']").val(setActiveTab);

            $('.ays-poll-tab-content' + elemenetID).css('display', 'block');
            e.preventDefault();
        }
    });
    $('.button-primary.ays-button').on('click', function () {
        $('#ays_poll_active_tab').val('General')
    });
    $('.button-primary.ays-button-top').on('click', function () {
        $('#ays_poll_active_tab').val('General')
    });

    function checkTheme() {
        var themeId = +$(this).find('input').val();
        $('.ays_poll_theme_image_div label').each(function () {
            $(this).removeClass('apm_active_theme')
        });
        $(this).find('label').addClass('apm_active_theme');
        answerStyleChange(themeId);
        for (var t = 0; t < themes.length; t++) {
            if (themes[t].themeClass === 'personal') continue;
            $('.box-apm').removeClass(themes[t].themeClass);
        }
        $('.box-apm').addClass(themes[themeId].themeClass);
        $('.apm-themes-row').attr('data-themeId',themeId);

        if ($('#ays_poll_show_answers_icon').prop('checked')) {
            switch(themeId){
                case 6:
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');  
                    break;
                case 7:
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');  
                    break;
                default:
                    var iconsVal = $('input[name="ays_poll_answer_icon"]:checked').val();
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').addClass('ays_poll_answer_icon_'+iconsVal);
                    break;
            }
        }else{
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
        }
        answerStyleChange(themeId);
        switch (themeId) {
            case 3:
            case 4:
                $('#ays-poll-border-style').val('double').change();
                break;
            case 5:
                $('#ays-poll-border-style').val('solid').change();
                $('#ays-poll-border-width').val(1).change();
                break;
            case 6:
            case 7:
                $('#ays-poll-border-style').val('none').change();
                $('#ays-poll-border-width').val(0).change();
                break;
            default:
                $('#ays-poll-border-style').val('solid').change();
                break;
        }
        setThemeColors(themes[themeId]);
        $('#ays-poll-text-color').parent().parent().prev().css({
            'background-color': themes[themeId].textColor
        });
        $('#ays-poll-text-color').val(themes[themeId].textColor);

        $('#ays-poll-button-text-color').parent().parent().prev().css({
            'color': themes[themeId].buttonTextColor
        });
        $('#ays-poll-button-bg-color').parent().parent().prev().css({
            'background-color': themes[themeId].buttonBgColor
        });
        $('#ays-poll-button-text-color').val(themes[themeId].buttonTextColor);
        
        $('#ays-poll-button-bg-color').val(themes[themeId].buttonBgColor);

        $('#ays-poll-main-color').parent().parent().prev().css({
            'background-color': themes[themeId].mainColor
        });
        $('#ays-poll-main-color').val(themes[themeId].mainColor);

        $('#ays-poll-bg-color').parent().parent().prev().css({
            'background-color': themes[themeId].bgColor
        });
        $('#ays-poll-bg-color').val(themes[themeId].bgColor);

        $('#ays-poll-answer-bg-color').parent().parent().prev().css({
            'background-color': themes[themeId].answerBgColor
        });
        $('#ays-poll-answer-bg-color').val(themes[themeId].answerBgColor);

        $('#ays-poll-title-bg-color').parent().parent().prev().css({ 
            'background-color': themes[themeId].titleBgColor
        });
        $('#ays-poll-title-bg-color').val(themes[themeId].titleBgColor);

        $('#ays-poll-icon-color').parent().parent().prev().css({
            'background-color': themes[themeId].iconColor
        });
        $('#ays-poll-icon-color').val(themes[themeId].iconColor);
    }

    function setThemeColors(theme) {
        var mainColor = (theme.mainColor.length > 0 && theme.mainColor.length != '') ? theme.mainColor : '#B00101';
        var bgColor = (theme.bgColor.length > 0 && theme.bgColor.length != '') ? theme.bgColor : '#B00101';
        var answerBgColor = (theme.answerBgColor.length > 0 && theme.answerBgColor.length != '') ? theme.answerBgColor : '#B00101';
        var titleBgColor = (theme.titleBgColor.length > 0 && theme.titleBgColor.length != '') ? theme.titleBgColor : '#B00101';
        var textColor = (theme.textColor.length > 0 && theme.textColor.length != '') ? theme.textColor : '#B00101';
        var buttonTextColor = (theme.buttonTextColor.length > 0 && theme.buttonTextColor.length != '') ? theme.buttonTextColor : '#B00101';
        var buttonBgColor = (theme.buttonBgColor.length > 0 && theme.buttonBgColor.length != '') ? theme.buttonBgColor : '#B00101';
        var iconColor = (theme.iconColor.length > 0 && theme.iconColor.length != '') ? theme.iconColor : '#B00101';
        mainColorChange(mainColor);
        bgColorChange(bgColor);
        // answerBgColorChange(answerBgColor);
        titleBgColorChange(titleBgColor);
        textColorChange(textColor);
        buttonTextColorChange(buttonTextColor);
        buttonBgColorChange(buttonBgColor);

        if (theme.name == 'Coffee Fluid') {
            textColorChangeA(textColor);
        }
        iconColorChange(iconColor);
        boxShadowColorChange(mainColor);
    }

    //checkTheme();
    $('.ays_poll_theme_image_div:not(.apm-pro-feature)').on('click', checkTheme);


    //**********************/
    //LIVE PREVIEW
    //*********************/

    $("#ays_enable_vote_button").on('change', function () {
        $('.apm-answers').toggleClass("apm-answers-without-submit")
    });

    var themeId = $('.apm_active_theme+input').val() || 0;
    $(document).find('#ays-poll-main-color').wpColorPicker({
        defaultColor: themes[themeId].mainColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].mainColor});
            mainColorChange(color);
        }
    });
    $(document).find('#ays-poll-text-color').wpColorPicker({
        defaultColor: themes[themeId].textColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].textColor});
            setTimeout(function () {
                textColorChange(color);
            }, 1);
            if ($('.apm_active_theme+input').val() == 5) {
                textColorChangeA(color);
            }
        }
    });
    $(document).find('#ays-poll-button-text-color').wpColorPicker({
        defaultColor: themes[themeId].buttonTextColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].buttonTextColor});
            buttonTextColorChange(color);
        }
    });
    $(document).find('#ays-poll-button-bg-color').wpColorPicker({
        defaultColor: themes[themeId].buttonBgColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].buttonBgColor});
            buttonBgColorChange(color);
        }
    });
    $(document).find('#ays-poll-icon-color').wpColorPicker({
        defaultColor: themes[themeId].iconColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].iconColor});
            iconColorChange(color);
        }
    });
    $(document).find('#ays-poll-bg-color').wpColorPicker({
        defaultColor: themes[themeId].bgColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].bgColor});
            bgColorChange(color);
        }
    });
    $(document).find('#ays-poll-answer-bg-color').wpColorPicker({
        defaultColor: themes[themeId].answerBgColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].answerBgColor});
            // answerBgColorChange(color);
        }
    });
    $(document).find('#ays-poll-title-bg-color').wpColorPicker({
        defaultColor: themes[themeId].titleBgColor,
        change: function(event, ui) {
            var color = event.target.value;
            $(this).wpColorPicker({defaultColor: themes[$('.apm_active_theme+input').val()].titleBgColor});
            titleBgColorChange(color);
        }
    });
    $(document).find('#ays-poll-box-shadow-color').wpColorPicker({
        defaultColor: '#000000',
        change: function(event, ui) {
            var color = event.target.value;
            boxShadowColorChange(color);
        }
    });

    $(document).find('#ays-background-gradient-color-1').wpColorPicker({
        defaultColor: '#103251',
        change: function(event, ui) {
            toggleBackgrounGradient();
        }
    });

     $(document).find('#ays-background-gradient-color-2').wpColorPicker({
        defaultColor: '#607593',
        change: function(event, ui) {
            toggleBackgrounGradient();
        }
    });

    $(document).find('#ays_gleadboard_color').wpColorPicker({
        defaultColor: '#0C6291',
        change: function(event, ui) {
            toggleBackgrounGradient();
        }
    });

    $(document).find('#ays_answers_border_color').wpColorPicker({
        change: function(event, ui) {
        }
    });

    $(document).find('#ays-poll-border-color').wpColorPicker({
        defaultColor: '#0C6291',
        change: function(event, ui) {
            borderColorChange(ui);
        }
    });

    
    function borderColorChange(ui) {
        var color = ui.color.toString();
        $(document).find(".box-apm").css("border-color" , color);
        $('#ays-poll-border-color')
            .val(color)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', color);
    }

    $(document).find('#ays_answers_box_shadow_color').wpColorPicker({
        // defaultColor: '#0C6291',
        change: function(event, ui) {
        }
    });

    $(document).find('#ays_poll_cat_gleadboard_color').wpColorPicker({
        defaultColor: '#0C6291',
        change: function(event, ui) {
            toggleBackgrounGradient();
        }
    });

    $(document).find('#ays_poll_title_text_shadow_color').wpColorPicker({
        defaultColor: 'rgba(255,255,255,0)',
        change: function(event, ui) {
            textShadowChange(ui);
        }
    });

    $(document).find('#ays_poll_popup_bg_color').wpColorPicker({
        change: function(event, ui) {
    
        }
    });


    // $(document).find('#ays-poll-answer-bg-color').wpColorPicker({
    //     // defaultColor: '#0C6291',
    //     change: function(event, ui) {
    //     }
    // });


    if($(document).find('#ays-poll-bg-image').val() != ''){
        $('.box-apm').css('background-image', 'url('+ $(document).find('#ays-poll-bg-image').val() +')');
        $('.box-apm').css('background-position', $(document).find('#ays-poll-bg-image-pos').val());
    }

    function mainColorChange(color) {
        var mColor = color;
        if(typeof mColor !== "string"){
            mColor = mColor.toString();
        }
        document.documentElement.style.setProperty('--theme-main-color', mColor);
        $('#ays-poll-main-color')
            .attr('value', mColor)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', mColor);
        // $('.box-apm.choosing-poll label').css('border','1px solid'+color);
    }

    function textColorChange(color) {
        var tColor = color;
        if(typeof tColor != "string"){
            tColor = tColor.toString();
        }
        document.documentElement.style.setProperty('--theme-text-color', tColor);
        $('#ays-poll-text-color')
            .attr('value', tColor)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', tColor);
        $(document).find('.box-apm').css({
            'color': tColor,
        });
    }

    function textColorChangeA(color) {
        var ttColor = color;
        if(typeof ttColor != "string"){
            ttColor = ttColor.toString();
        }
        
        document.documentElement.style.setProperty('--theme-text-color-a2', hexToRgba(ttColor, 0.2));
        document.documentElement.style.setProperty('--theme-text-color-a5', hexToRgba(ttColor, 0.5));
        document.documentElement.style.setProperty('--theme-text-color-a75', hexToRgba(ttColor, 0.75));
    }

    function buttonTextColorChange(color) {
        var tColor = color;
        if(typeof tColor != "string"){
            tColor = tColor.toString();
        }
        document.documentElement.style.setProperty('--theme-button-text-color', tColor);
        $('#ays-poll-button-text-color')
            .attr('value', tColor)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', tColor);
    }

    function buttonBgColorChange(color) {
        var tColor = color;
        if(typeof tColor != "string"){
            tColor = tColor.toString();
        }
        document.documentElement.style.setProperty('--theme-button-bg-color', tColor);
        $('#ays-poll-button-bg-color')
            .attr('value', tColor)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', tColor);

    }

    function iconColorChange(color) {
        var iColor = color;
        if(typeof iColor != "string"){
            iColor = iColor.toString();
        }
        document.documentElement.style.setProperty('--theme-icon-color', iColor);
        $('#ays-poll-icon-color')
            .attr('value', iColor)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', iColor);
    }

    function bgColorChange(color) {
        var bgColor = color;
        if(typeof bgColor != "string"){
            bgColor = bgColor.toString();
        }
        document.documentElement.style.setProperty('--theme-bg-color', bgColor);
        $('#ays-poll-bg-color')
            .attr('value', bgColor)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', bgColor);
    }

    // var answer_border_side = $(document).find('#ays-poll-border-side').val();
    // answerBorderSideChange(answer_border_side);

    function answerBorderSideChange(side) {
        var answersBorderWidth = $(document).find('#ays_answers_border_width').val();
        var answersBorderStyle = $(document).find('#ays_answers_border_style').val();
        var answersBorderColor = $(document).find('#ays_answers_border_color').val();
        var borderStyles = answersBorderWidth+'px' + ' ' + answersBorderStyle + ' ' + answersBorderColor;
        if (side == 'none') {
            $(document).find('.box-apm.choosing-poll label,div.ays-container-only-images').each(function(){
                $(this)[0].style.border = 'none';
            });
        }else{
            var b_color = $('.box-apm .ays-poll-btn').css('background-color');
            switch(side) {
              case 'all_sides':
                $(document).find('.box-apm.choosing-poll label,div.ays-container-only-images').each(function(){
                    $(this).css('border',borderStyles);
                });
                break;
              case 'top':
                $(document).find('.box-apm.choosing-poll label,div.ays-container-only-images').each(function(){
                    $(this)[0].style.border = 'none';
                    $(this).css('border-top',borderStyles);
                });
                break;
              case 'bottom':
                $(document).find('.box-apm.choosing-poll label,div.ays-container-only-images').each(function(){
                    $(this)[0].style.border = 'none';
                    $(this).css('border-bottom',borderStyles);
                });
                break;
              case 'left':
                $(document).find('.box-apm.choosing-poll label,div.ays-container-only-images').each(function(){
                    $(this)[0].style.border = 'none';
                    $(this).css('border-left',borderStyles);
                });
                break;
              case 'right':
                $(document).find('.box-apm.choosing-poll label,div.ays-container-only-images').each(function(){
                    $(this)[0].style.border = 'none';
                    $(this).css('border-right',borderStyles);
                });
                break;
            }
        }
    }

    function answerStyleChange(theme_id) {
        if (theme_id == 7) {
            $('.box-apm').find('.apm-choosing').addClass('ays_poll_minimal_theme');
            $('.box-apm').find('.btn.ays-poll-btn').addClass('ays_poll_minimal_theme_btn');
            $('#ays_poll_enable_answer_style').removeAttr('checked');
            answerBorderSideChange("none");
            $('#ays-poll-border-width').val(0);
            document.documentElement.style.setProperty('--poll-border-width', "0px");
        }else{
            $('.box-apm').find('.apm-choosing').removeClass('ays_poll_minimal_theme');
            $('.box-apm').find('.btn.ays-poll-btn').removeClass('ays_poll_minimal_theme_btn');
            $('#ays_poll_enable_answer_style').prop('checked', true);
            var bSide = $(document).find("#ays-poll-border-side").val();
            answerBorderSideChange(bSide);
        }        
    }

    // function answerBgColorChange(color) {
    //     var ansBgColor = color;
    //     if(typeof ansBgColor != "string"){
    //         ansBgColor = ansBgColor.toString();
    //     }
    //     document.documentElement.style.setProperty('--theme-answer-bg-color', ansBgColor);
    //     // var mainColor = $('#ays-poll-main-color').val();
    //     if (ansBgColor == 'transparent') {
    //         document.documentElement.style.setProperty('--theme-answer-bg-color', "initial");
    //         // $('.box-apm.choosing-poll label').css('border','none');
    //     }else{
    //         document.documentElement.style.setProperty('--theme-answer-bg-color', ansBgColor);
    //         $('#ays-poll-answer-bg-color')
    //             .attr('value', ansBgColor)
    //             .parents('.wp-picker-container')
    //             .find('.color-alpha').css('background-color', ansBgColor);
    //     }
    // }

    function titleBgColorChange(color) {
        var titleBgColor = color;
        if(typeof titleBgColor != "string"){
            titleBgColor = titleBgColor.toString();
        }
        document.documentElement.style.setProperty('--theme-title-bg-color', titleBgColor);
        $('#ays-poll-title-bg-color')
                .attr('value', titleBgColor)
                .parents('.wp-picker-container')
                .find('.color-alpha').css('background-color', titleBgColor);
    }

    var theme_Ids = $('.apm-themes-row').attr('data-themeid');
    if ($('#ays_poll_show_answers_icon').prop('checked') && theme_Ids != 6 && theme_Ids != 7) {
        if ($('input[name="ays_poll_answer_icon"]:checked').prop('checked')) {
            var iconVal = $('input[name="ays_poll_answer_icon"]:checked').val();
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
            $('.ays_label_poll').addClass('ays_poll_answer_icon_'+iconVal);
        }else{
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
        }
    }else{
        $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
        $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
    }

    $('#ays_poll_show_answers_icon').change(function () {
        var themeIds = $('.apm-themes-row').attr('data-themeid');
        if ($('#ays_poll_show_answers_icon').prop('checked')) {
            switch(parseInt(themeIds)){
                case 6:
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');  
                    break;
                case 7:
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');  
                    break;
                default:
                    var icons_val = $('input[name="ays_poll_answer_icon"]:checked').val();
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').addClass('ays_poll_answer_icon_'+icons_val);
                    break;
            }            
        }else{
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
        }
    });

    $('.ays_poll_answ_icon').change(function () {
        if ($(this).prop('checked')) {
            var themesIds = $('.apm-themes-row').attr('data-themeid');
            switch(parseInt(themesIds)){
                case 6:
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');  
                    break;
                case 7:
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');  
                    break;
                default:
                    var icon_val = $(this).val();
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
                    $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $('.ays_label_poll').addClass('ays_poll_answer_icon_'+icon_val);
            }
        }else{
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
            $('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');  
        }
    });

    function boxShadowColorChange(ui) {
        if (typeof ui == 'object') {
            var color = ui.color.toString();
        }else{
            var color = ui;
        }

        if (color == 'transparent' || !$(document).find('#ays_poll_enable_box_shadow').prop("checked")) {
            document.documentElement.style.setProperty('--poll-box-shadow', "initial");
        } else {
            var x_offset = $(document).find('input#ays_poll_box_shadow_x_offset').val() + "px ";
            var y_offset = $(document).find('input#ays_poll_box_shadow_y_offset').val() + "px ";
            var z_offset = $(document).find('input#ays_poll_box_shadow_z_offset').val() + "px ";

            var boxShadow = x_offset + y_offset + z_offset;

            document.documentElement.style.setProperty('--poll-box-shadow', color + " " + boxShadow + " 1px");
            $('#ays-poll-box-shadow-color')
                .attr('value', color)
                .parents('.wp-picker-container')
                .find('.color-alpha').css('background-color', color);
        }
    }

    /* 
    ========================================== 
        Background Gradient Aro
    ========================================== 
    */
   function toggleBackgrounGradient() {
        if ($(document).find('#ays-enable-background-gradient').prop('checked') || $(document).find('input#ays-poll-bg-image').val() != '') {
            if($(document).find('#ays_poll_gradient_direction').val() != '') {
                var ays_poll_gradient_direction = $(document).find('#ays_poll_gradient_direction').val();
                switch(ays_poll_gradient_direction) {
                    case "horizontal":
                        ays_poll_gradient_direction = "to right";
                        break;
                    case "diagonal_left_to_right":
                        ays_poll_gradient_direction = "to bottom right";
                        break;
                    case "diagonal_right_to_left":
                        ays_poll_gradient_direction = "to bottom left";
                        break;
                    default:
                        ays_poll_gradient_direction = "to bottom";
                }

                if($(document).find('input#ays-poll-bg-image').val() != ''){
                    return false;
                }else{
                    $(document).find('.box-apm').css({'background-image': "linear-gradient(" + ays_poll_gradient_direction + ", " + $(document).find('input#ays-background-gradient-color-1').val() + ", " + $(document).find('input#ays-background-gradient-color-2').val()+")"
                    });
                }
            }
        }
        else{
            $(document).find('.box-apm').css('background-image' , 'unset');
            return false;
        }
    }

    function textShadowChange(ui , isChecked) {
        if (typeof ui == 'object') {
            var color = ui.color.toString();
        }else{
            var color = ui;
        }
        var x_offset = $(document).find('input#ays_poll_title_text_shadow_x_offset').val() + "px ";
        var y_offset = $(document).find('input#ays_poll_title_text_shadow_y_offset').val() + "px ";
        var z_offset = $(document).find('input#ays_poll_title_text_shadow_z_offset').val() + "px ";

        var boxShadow = x_offset + y_offset + z_offset;
        if($(document).find('#ays_poll_enable_title_text_shadow').prop("checked")){
            $(document).find(".apm-title-box > h5").css("text-shadow" , boxShadow+" "+ color);
            
        }
        $('#ays_poll_title_text_shadow_color')
            .val(color)
            .parents('.wp-picker-container')
            .find('.color-alpha').css('background-color', color);
    }


    $(document).find('#ays_poll_enable_title_text_shadow').on('change', function(){
        var color =  $(document).find('#ays_poll_title_text_shadow_color').val();
        var checkedShadow = $(this).prop('checked');
        if(checkedShadow){
            textShadowChange(color);
        }else{
            $(document).find(".apm-title-box > h5").css("text-shadow" , "unset");
        }
    });


    $(document).find('.ays-title-text-shadow-coord-change').on('change', function(){
        var color =  $(document).find('#ays_poll_title_text_shadow_color').val();
        textShadowChange(color);
    });



    var ays_poll_box_gradient_color1_picker = {
            change: function (e) {
                setTimeout(function () {
                    toggleBackgrounGradient();
                }, 1);
            }
        };
        
    var ays_poll_box_gradient_color2_picker = {
        change: function (e) {
            setTimeout(function () {
                toggleBackgrounGradient();
            }, 1);
        }
    };

    function ays_poll_search_box_pagination(listTableClass, searchBox) {
        if($(document).find( "." + listTableClass ).length) {
            if($(document).find( "#" + searchBox ).length) {
                var search_string = $(document).find("#" + searchBox).val();
                if(search_string != "") {
                    $(document).find("."+ listTableClass +" .pagination-links a").each(function() {
                        if ( typeof this.href != "undefined" && this.href != "" ) {
                            if ( this.href.indexOf("&s=") < 0 ) {
                                this.href = this.href + "&s=" + search_string;
                            }
                        }
                    });
                }
            }
        }
    }

    $(document).find('#ays_poll_gradient_direction').on('change', function () {
        toggleBackgrounGradient();
    });


    $(document).find('#ays-background-gradient-color-1').wpColorPicker(ays_poll_box_gradient_color1_picker);
    $(document).find('#ays-background-gradient-color-2').wpColorPicker(ays_poll_box_gradient_color2_picker);

    toggleBackgrounGradient();
    $(document).find('input#ays-enable-background-gradient').on('change', function () {
        toggleBackgrounGradient();
    });

    $(document).on('click', '.ays-remove-poll-bg-img', function () {
        $(document).find('.box-apm').css({'background-image': 'none'});
        toggleBackgrounGradient();
    });

    // $(document).find('#ays_poll_enable_answer_style').on('change', function () {
    //     var color = $(this).prop('checked') ? $(document).find('#ays-poll-answer-bg-color').val() : "transparent";
    //     var side = $(this).prop('checked') ? $(document).find('#ays-poll-border-side').val() : "none";
    //     answerBgColorChange(color);
    //     answerBorderSideChange(side);
    // });

    // Answer style on/off
    answerStylesOnOff($(document).find('#ays_poll_enable_answer_style').prop("checked"))
    function answerStylesOnOff(checker) {
        var color = checker ? $(document).find('#ays-poll-answer-bg-color').val() : "transparent";
        var side = checker ? $(document).find('#ays-poll-border-side').val() : "none";
        var answerStyle = $(this).prop('checked');
        // answerBgColorChange(color);
        answerBorderSideChange(side);
        
        // Main container
        var mainDiv = $(document).find("div.ays_answer_styles_main");
        mainDiv.css("pointer-events", "all");

        // Labels and fields
        var answerStylesContainer = $(document).find(".ays_poll_answer_style_options");
        var answerLabels = $(document).find(".ays_enable_answer_style");
        var answerInps = $(document).find(".ays_enable_answer_field");
        answerLabels.css("opacity" , 1);
        answerInps.prop("disabled" , false);
        answerStylesContainer.removeClass("ays_poll_answer_style_options_disable")
        var answersBoxShadow = $(document).find('#ays_answers_box_shadow').val('on');

        if(!checker){
            answerStylesContainer.addClass("ays_poll_answer_style_options_disable")
            mainDiv.css("pointer-events", "none");
            answerLabels.css("opacity", 0.5);
            answerInps.prop("disabled", true);
            answerStyleDefault();
        }
    }

    function answerStyleDefault(){
        var mainContsStyles = $(document).find(".ays_label_poll");
        var mainContsStyles2 = $(document).find('.ays-poll-answers .ays-field.ays_list_view_item,.apm-answers div[class^="apm-choosing answer-"]');
        var mainCont = $(document).find("div.ays-poll-answers");
        var apmFields = $(document).find("div.ays-field");
        var answersImagesCont = $(document).find('.answers-image-container .ays-poll-answers');
        var answersBoxShadow = $(document).find('#ays_answers_box_shadow').val('off');
        // var questionFontSize = $(document).find('.ays_question').children("p");

        // Only for images
        var answerImage = $(document).find('.ays-answer-image');
        answerImage.siblings("p").css("font-size", "15px");

        mainContsStyles2.css({
            'margin-bottom': '10px',
        });

        // Main Container Styles default
        mainContsStyles.css({
            "font-size":"15px",
            'padding': "10px",
            // "margin-bottom": '10px',
            'border': 0,
            'border-radius': 0,
            'box-shadow': "unset"
        });

        // Question font size default
        // questionFontSize.css("font-size" , "16px");

        // View default
        if(mainCont.hasClass('ays_grid_view_container')){
            mainCont.removeClass('ays_grid_view_container');
            mainCont.addClass('ays_list_view_container');
        }
        apmFields.each(function () {
            if(apmFields.hasClass('ays_grid_view_item')){
                apmFields.removeClass('ays_grid_view_item');
                apmFields.addClass('ays_list_view_item');
            }
            apmFields.css({'flex-direction': 'row-reverse', 'width': '100%'});
        });

        // Object fit default
        answersImagesCont.find('.ays-field .ays-answer-image').css({
            'object-fit': 'cover',
            'height': '150px'
        });

    }


    // Show answers caption
    !$(document).find('#ays_poll_show_answers_caption').prop('checked') ? $(document).find('.apm-grid .ays_grid_answer_span').hide() : $(document).find('.apm-grid .ays_grid_answer_span').css('display','inline-block');

    $(document).find('#ays_poll_show_answers_caption').on('change', function () {
        !$(this).prop('checked') ? $(document).find('.apm-grid .ays_grid_answer_span').hide() : $(document).find('.apm-grid .ays_grid_answer_span').css('display','inline-block');        
    });

    $('#ays_poll_enable_box_shadow').on('change', function () {
        var defaultColor = $(document).find('#ays-poll-main-color').val();
        var currentColor = $(document).find('#ays-poll-box-shadow-color').val();
        if(currentColor != '' && !$(this).prop('checked')){
            $(document).find('#ays-poll-box-shadow-color').attr("value" , '');
        }
        var color = $(this).prop('checked') && currentColor == '' ? defaultColor : currentColor;
        boxShadowColorChange(color);
    });

    $(document).find('#ays-enable-background-gradient').on('change', function () {
        var color = $(this).prop('checked') ? $(document).find('#ays-background-gradient-color-1').val() : "transparent";
        toggleBackgrounGradient(color);
    });

    $(document).find('#ays-enable-background-gradient').on('change', function () {
        var color = $(this).prop('checked') ? $(document).find('#ays-background-gradient-color-2').val() : "transparent";
        toggleBackgrounGradient(color);
    });

    $('#ays-poll-icon-size').on('change', function () {
        var val = (+$(this).val() > 10) ? $(this).val() : 10;
        $(this).val(val);
        var value = val + 'px';
        document.documentElement.style.setProperty('--poll-icons-size', value);
    });

    $('#ays-poll-border-width').on('change', function () {
        var val = $(this).val();
        var value = val + 'px';
        document.documentElement.style.setProperty('--poll-border-width', value);
    });

    $('#ays-poll-btn-text').on('change', function () {
        var val = $(this).val() !== '' ? $(this).val() : "Vote";
        $('.ays-poll-btn').val(val);
    });

    $('#ays-poll-border-style').on('change', function () {
        var val = $(this).val();
        document.documentElement.style.setProperty('--poll-border-style', val);
    });

    // $('#ays-poll-border-side').on('change', function () {
    //     var val = $(this).val();        
    //     answerBorderSideChange(val);
    // });

    $(document).on('click', 'a.add-poll-bg-music', function (e) {
        openMusicMediaUploader(e, $(this));
    });

    $('#ays_buttons_border_radius').on('change', function () {
        var val = $(this).val();
        // document.documentElement.style.setProperty('--poll-border-radius', `${val}px`);
        $(document).find('input[type="button"].ays-poll-btn').css('border-radius', val + 'px');
    });
    
    $('#ays_poll_buttons_width').on('change', function () {
        var val = $(this).val();
        $(document).find('input[type="button"].ays-poll-btn').css('width', val + 'px');
    });

    $('.ays_buttons_padding').on('change', function () {
        var top_bottom = $(document).find('#ays_buttons_top_bottom_padding').val();
        var left_top = $(document).find('#ays_buttons_left_right_padding').val();
        $(document).find('input[type="button"].ays-poll-btn').css('padding', top_bottom + 'px ' + left_top +'px');
    });

    $('#ays_buttons_font_size').on('change', function () {
        var val = $(this).val();
        $(document).find('input[type="button"].ays-poll-btn').css('font-size', val + 'px');
    });

    $('#ays-poll-border-width').on('change', function () {
        var val = $(this).val();
        var value = val + 'px';
        document.documentElement.style.setProperty('--poll-border-width', value);
    });

    // $('#ays_custom_css').on('change', function () {
    //     $('#ays-poll-custom-css')[0].innerHTML = $(this).val();
    // });
    $('#show-title').on('change', function () {
        $('.apm-title-box').fadeToggle();
    });
    $('#ays-poll-title').on('change', function () {
        var val = $(this).val();
        $('.apm-title-box').text(val)
    });

    //FormFields
    $('#ays-formfield-type').on('change', function () {
        var newId = $('#ays-formfield-slug').attr('data-new-id');
        if (newId > 0) {
            var newSlug = "apm_" + $(this).val() + "_" + newId;
            $('#ays-formfield-slug').val(newSlug);
        }
    });

    if ($('#ays-attribute-type').val() == 'select') {
        $('.ays_attr_options').show(250);
    }
    if ($('#ays-formfield-type').val() == 'checkbox') {
        $('.ays_attr_description').show(250);
    }
    $('#ays-formfield-type').on('change', function () {
        if ($(this).val() === 'select') {
            $('.ays_attr_options').show(250);
            $('.ays_attr_description').hide();
        } else if ($(this).val() === 'checkbox') {
            $('.ays_attr_description').show(250);
            $('.ays_attr_options').hide();
        }else {
            $('.ays_attr_description').hide(100);
            $('.ays_attr_options').hide();
        }
    });

    //Import poll form 
    $('#import-csv').on('change', function () {
        $('#import-poll-form').submit()
    });

    //Each results
    if ($('.unread-result-badge.unread-result').length > 0) {
        $('.unread-result-badge.unread-result').each(function () {
            $(this).parent().parent().find('td').css('font-weight', 'bold')
        })
    }

    //Each results
    if ($('.ays_poll_unread').length > 0) {
        $('.ays_poll_unread').each(function () {
            $(this).parent().parent().find('td').css('font-weight', 'bold')
        })
    }


    // $('.active_date_check').change(function () {
    //     if ($(this).prop('checked')) {
    //         $('.active_date').show(250);
    //     } else {
    //         $('.active_date').hide(250);
    //     }
    // });

    $('#ays_poll_show_timer').change(function () {
        if ($(this).prop('checked')) {
            $('.ays_show_time').show(250);
        } else {
            $('.ays_show_time').hide(250);
        }
    });

    $('#show_result_btn_schedule').change(function () {
        if ($(this).prop('checked')) {
            $('.result_btn_see').show(250);
        } else {
            $('.result_btn_see').hide(250);
        }
    });

    $(document).on('change', '.ays_toggle', function (e) {
        var state = $(this).prop('checked');
        if ($(this).hasClass('ays_toggle_slide')) {
            switch (state) {
                case true:
                    $(this).parent().find('.ays_toggle_target').slideDown(250);
                    break;
                case false:
                    $(this).parent().find('.ays_toggle_target').slideUp(250);
                    break;
            }
        } else {
            switch (state) {
                case true:
                    $(this).parent().find('.ays_toggle_target').show(250);
                    break;
                case false:
                    $(this).parent().find('.ays_toggle_target').hide(250);
                    break;
            }
        }
    });

    $(document).on('change', '.ays_toggle_checkbox', function (e) {
        var state = $(this).prop('checked');
        var parent = $(this).closest('.ays_toggle_parent');
        
        if($(this).hasClass('ays_toggle_slide')){
            switch (state) {
                case true:
                    parent.find('.ays_toggle_target').slideDown(500);
                    break;
                case false:
                    parent.find('.ays_toggle_target').slideUp(500);
                    break;
            }
        }else{
            var targetEl = parent.find('.ays_toggle_target');
            for (let i = 0; i<targetEl.length; i++) {
                if(targetEl.eq(i).closest('.ays_toggle_parent')[0] != parent[0]) {
                    targetEl.splice(i, 1);
                    i--;
                }
            }

            switch (state) {
                case true:
                    targetEl.show(250);
                    break;
                case false:
                    targetEl.hide(250);
                    break;
            }
        }
    });

    $(document).on('change', '.ays_poll_send_mail_type', function (e) {
        var val = $(this).val();
        var disabled_val = $(this).val();
        
        if (val == 'custom') {
            $('.poll_send_mail_type_custom').show(250);
            $('.poll_send_mail_type_sendgrid').hide(250);

        } else if (val == 'sendgrid') {
            if ( $(this).prop('disabled' , false) ) {
                $('.poll_send_mail_type_custom').hide(250);
                $('.poll_send_mail_type_sendgrid').show(250);
            }
        }
    });

    $(document).find('table#ays-answers-table tbody, table#ays-dropdown-answers-table tbody').sortable({
        handle: 'td.ays-sort',
        cursor: 'move',
        opacity: 0.8,
        tolerance: "pointer",
        helper: function(e, tr) {
            var $originals = tr.children();
            var $helper = tr.clone();
            $helper.children().each(function(index)
            {
              // Set helper cell sizes to match the original sizes
              $(this).width($originals.eq(index).width());
            });
            return $helper;
        },
        axis: 'y',
        revert: true,
        forcePlaceholderSize: true,
        forceHelperSize: true,
        start: function(event, ui) {
            $(this).find('th:nth-child(4)').addClass('ays_poll_display_none');
            $(this).find('th:nth-child(3)').addClass('ays_poll_display_none');
            if( $(this).find('td.ays-f-votes-row').hasClass('ays_poll_display_none')){
                $(this).find('td:nth-child(4)').addClass('ays_poll_display_none');
            }
            if( $(this).find('td.ays-answer-redirect-row').hasClass('ays_poll_display_none')){
                $(this).find('td:nth-child(3)').addClass('ays_poll_display_none');
            }
            ui.helper.css('display', 'table')
        },
        stop: function(event, ui) {
            ui.item.css('display', '');
        },
        update: function (event, ui) {
            var className = ui.item.attr('class').split(' ')[0];
            $('#ays-answers-table, #ays-dropdown-answers-table').find('tr.' + className).each(function (index) {
                var classEven = (((index + 1) % 2) === 0) ? 'even' : '';
                if ($(this).hasClass('even')) {
                    $(this).removeClass('even');
                }
                $(this).addClass(classEven);
            });
        }
    });

    $(document).find('.poll-maker-challenge-cancel').on('click', function() {
        var challengeBox = $(this).closest('.poll-maker-challenge');
        var wp_nonce = $(document).find('#poll_maker_ajax_challenge_cancel_nonce').val();

        $.ajax({
            url: poll.ajax,
            type: 'POST',
            data: { 
                action: 'delete_challenge_box',
                _ajax_nonce: wp_nonce,
             },
            success: function(response) {
                    var result = JSON.parse(response);
                    if (result.success) {
                        challengeBox.remove();
                    }
                }
        });
    })

    $(document).find('#ays_poll_create_author').select2({
        placeholder: 'Select users',
        minimumInputLength: 1,
        allowClear: true,
        language: {
            // You can find all of the options in the language files provided in the
            // build. They all must be functions that return the string that should be
            // displayed.
            inputTooShort: function () {
                return poll.pleaseEnterMore;
            }
        },
        ajax: {
            url: poll.ajax,
            dataType: 'json',
            data: function (response) {
                var checkedUsers = $(document).find('#ays_poll_create_author').val();
                return {
                    action: 'ays_poll_create_author',
                    search: response.term,
                    val: checkedUsers,
                };
            },
        }
    });

    $(document).on("input", 'input', function (e) {
        if (e.keyCode == 13) {
            return false;
        }
    });

    // $(document).on("keydown", function (e) {
    //     if (e.target.nodeName == "TEXTAREA") {
    //         return true;
    //     }
    //     if (e.keyCode == 13) {
    //         return false;
    //     }
    //     if(e.keyCode === 27){
    //         $(document).find('.ays-modal').aysModal('hide');
    //         $(document).find('.ays-modal-backdrop').remove();
    //         return false;
    //     }
    // });

    $(document).find('#ays-deactive, #ays-active, #ays_poll_change_creation_date').datetimepicker({
        controlType: 'select',
        oneLine: true,
        dateFormat: "yy-mm-dd",
        timeFormat: "HH:mm:ss"
    });

    // Codemirror 
    setTimeout(function(){
        if($(document).find('#ays_custom_css').length > 0){
            if(wp.codeEditor){
                wp.codeEditor.initialize($(document).find('#ays_custom_css'), cm_settings);
            }
        }
    }, 500);

    $(document).find('a[href="#tab2"]').on('click', function (e) {        
        setTimeout(function(){
            if($(document).find('#ays_custom_css').length > 0){
                var ays_custom_css = $(document).find('#ays_custom_css').html();
                if(wp.codeEditor){
                    $(document).find('#ays_custom_css').next('.CodeMirror').remove();
                    wp.codeEditor.initialize($(document).find('#ays_custom_css'), cm_settings);
                    $(document).find('#ays_custom_css').html(ays_custom_css).trigger('change');
                }
            }
        }, 500);
    });

    // $(document).find('input[type="checkbox"]#ays_redirect_after_submit').on('change', function(e){
    //     if($(this).prop('checked') == false){
    //         $(document).find('#ays_redirect_box').css('display', 'none');
    //         // $(document).find('.ays_redirect_active').attr('data-required', false);
    //     }else{
    //         $(document).find('#ays_redirect_box').removeAttr('style');
    //         // $(document).find('.ays_redirect_active').attr('data-required', false);
    //     }

    // });

    $(document).find('input[type="checkbox"]#ays_redirect_after_submit').on('change', function(e){
        var answerRedirectRow = $(document).find('#ays-answers-table .ays-answer-redirect-row');
        if($(this).prop('checked') == false){
            answerRedirectRow.addClass('ays_poll_display_none');
        }else{
            if (answerRedirectRow.hasClass('ays_poll_display_none')) {
                answerRedirectRow.removeClass('ays_poll_display_none');
            }
        }
    });

    // Fake Votes
    $(document).find('input[type="checkbox"]#ays_add_f_votes').on('change', function(e){
        var answerVotesRow = $(document).find('#ays-answers-table .ays-f-votes-row');
        if($(this).prop('checked') == false){
            answerVotesRow.addClass('ays_poll_display_none');
        }else{
            if (answerVotesRow.hasClass('ays_poll_display_none')) {
                answerVotesRow.removeClass('ays_poll_display_none');
            }
        }
    });

    $(document).find('input[type="checkbox"]#ays_redirect_after_submit_dropdown').on('change', function(e){
        var checked = $(this).prop('checked');
        if(checked){
            $(document).find('.ays-answer-redirect-row').css('display', 'block');
        }else{
            $(document).find('.ays-answer-redirect-row').css('display', 'none');
        }
    });

    $(document).find('input[type="checkbox"]#apm_allow_add_answers').on('change', function(e){
        if($(this).prop('checked') == false){
            // $(document).find('.allow_add_answers_not_show_up').hide();
            // $(document).find('.allow_add_answers_not_show_up .ays_toggle_target').hide(250);
            $(document).find('#ays_poll_allow_add_answers_not_show_up').removeAttr('checked');
            check_allow_add_answers_show_up();
        }else{
            $(document).find('.allow_add_answers_not_show_up').show();
            check_allow_add_answers_show_up();
        }

    }); 
    
    function check_allow_add_answers_show_up() {
        var aa_show = $(document).find('input[type="checkbox"]#ays_poll_allow_add_answers_not_show_up');
        let requireAdminApprovalCbState = $(document).find('input[type="checkbox"]#ays_poll_allow_answer_require').prop('checked');

        if(!requireAdminApprovalCbState){
            $(document).find('.ays_show_user_added').hide();
            $(document).find('.ays_show_user_added_hid').each(function () {
                $(this).parent('.ays-sortable-answers').find('.ays_show_user_added').prop('checked', false);
                // $(this).val(0);
            });
        }else{
            $(document).find('.ays_show_user_added').show();
            $(document).find('.ays_show_user_added_hid').each(function () {
                // $(this).val(1);
                // $(this).prop('checked', true);
                $(this).parent('.ays-sortable-answers').find('.ays_show_user_added').val(1);
            });
        }        
    }

    function toggleOptionsAccordion(arrowBtn) {
        var arrowSvg = arrowBtn.find('svg');
        var accordionMainContainer = arrowBtn.parents('.ays-poll-accordion-options-main-container');
        var accordionBody = accordionMainContainer.find('.ays-poll-accordion-body');

        arrowSvg.toggleClass('ays-poll-accordion-arrow-active');
        accordionBody.slideToggle();
    }

    $(document).find('input[type="checkbox"]#ays_poll_allow_add_answers_not_show_up').on('change', function(e){
        check_allow_add_answers_show_up();
    });

    // Options accordion effect start
    $(document).on('click', '.ays-poll-accordion-header', function() {
        toggleOptionsAccordion($(this));
    });
    // Options accordion effect end

    $(document).find("#ays_poll_require_approve_select_all").prop("checked" , false);
    $(document).find("#ays_poll_require_approve_select_all").on("change" , function(){
        var aa_show = $(document).find('input[type="checkbox"]#ays_poll_allow_add_answers_not_show_up');
        if($(this).prop('checked') == false){
            // $(document).find('.ays_show_user_added').hide();
            $(document).find('.ays_show_user_added').each(function () {
                $(this).parent('.ays-sortable-answers').find('.ays_show_user_added').prop('checked', false);
                $(this).val(0);
                $(this).prop('checked' , false);
                $(document).find('.ays_show_user_added_hid').val(0);

            });
        }else{
            // $(document).find('.ays_show_user_added').show();
            $(document).find('.ays_show_user_added').each(function () {
                $(this).val(1);
                $(this).prop('checked', true);
                $(this).parent('.ays-sortable-answers').find('.ays_show_user_added').val(1);
                // $(this).prop('checked' , true);
                $(document).find('.ays_show_user_added_hid').val(1);
            });
        }  
    });


    $(document).find('input[type="checkbox"].ays_show_user_added').on('change', function(e){
        let selectAllCb = $(document).find('input[type="checkbox"]#ays_poll_require_approve_select_all');
        if($(this).prop('checked') == true){
            $(this).parent().find('.ays_show_user_added_hid').val(1);
            var isAllChecked = 0;
            var allShowUserAddedCbArr = $(document).find('input[type="checkbox"].ays_show_user_added');
            for (i = 0; i < allShowUserAddedCbArr.length; i++) {
                if(allShowUserAddedCbArr.eq(i).prop('checked')) {
                    isAllChecked++;
                }
            }
            if (isAllChecked === allShowUserAddedCbArr.length && selectAllCb.prop('checked') === false) {
                selectAllCb.prop('checked', true);
            }
        }else{
            $(this).parent().find('.ays_show_user_added_hid').val(0);

            if (selectAllCb.prop('checked')) {
                selectAllCb.prop('checked', false);
            }
        }
    });

    var backgroundSize = $(document).find('#ays_poll_background_size').val();
    $(document).find('#ays_poll_background_size').on('change' , function(){
        var thisBackgroundSize = $(this).val();       
        switch (thisBackgroundSize){
            case 'cover':
                $(document).find("label.apm-label-with-bg").css('background-size' , 'cover');
            break;
            case 'contain':
                $(document).find("label.apm-label-with-bg").css('background-size' , 'contain');
            break;
        }      
    });
    $(document).find("label.apm-label-with-bg").css('background-size' , backgroundSize);

    // var checkLabelHover = $(document).find('label.ays_label_poll');       
    // var disableAnswerHover = $(document).find("#ays_disable_answer_hover");
    $(document).find("#ays_disable_answer_hover").on('change', function(){
        var checkLabelHover = $(document).find('.ays_label_poll');
        checkLabelHover.each(function(){
            if($(this).hasClass('ays_enable_hover') && !$(this).hasClass('disable_hover')){
                $(this).addClass('disable_hover');
                $(this).removeClass('ays_enable_hover');
            }else{            
                $(this).addClass('ays_enable_hover');
                $(this).removeClass('disable_hover');
            }
        });
    });

    $('#ays_add_postcat_for_poll').select2();

    // Answers table 
    $(document).find("#ays_reset_answers").on("click" , function() {
        $(document).find("#ays-button-apply").trigger("click");
    });

    function openAnswerMediaUploader(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload',
            button: {
                text: 'Upload'
            },
            library: {
                type: 'image'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            element.parents().eq(1).find('.add-answer-image').parent().css('display', 'none');
            element.parent().parent().find('.ays-answer-image-container').fadeIn();
            element.parent().parent().find('img.ays-answer-img').attr('src', attachment.url);
            element.parents('tr').find('input.ays-answer-image-path').val(attachment.url);
            if(element.hasClass('add-answer-image')){
                element.parent().parent().find('img').attr('src', attachment.url);
                element.parents('tr').find('input.ays-answer-image').val(attachment.url);
            }
        }).open();
        return false;
    }

    function openMusicMediaUploader(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload music',
            button: {
                text: 'Upload'
            },
            library: {
                type: 'audio'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            element.next().attr('src', attachment.url);
            element.parent().find('input.ays_poll_bg_music').val(attachment.url).trigger('change');
        }).open();
        return false;
    }

    $(document).on('click', 'label.ays-label a.add-answer-image', function (e) {
        openAnswerMediaUploader(e, $(this));
    });

    $(document).on('click', '.ays-remove-answer-img', function () {
        $(this).parent().fadeOut();
        var ays_remove_answer_img = $(this);
        if(ays_remove_answer_img.parent().hasClass('ays-answer-image-container')){
            setTimeout(function(){
                ays_remove_answer_img.parents().eq(1).find('.add-answer-image').parent().css('display', 'block');
                ays_remove_answer_img.parents().eq(1).find('.add-answer-image').css('display', 'inline-block');
                ays_remove_answer_img.parent().find('img.ays-answer-img').attr('src', '');
                ays_remove_answer_img.parent().find('input.ays-answer-image').val('');
                ays_remove_answer_img.parent().find('input.ays-answer-image-path').val('');
            },300);
        }
    });

    $(document).find('#ays_buttons_size').on('change', function(e){
        var buttonsSize = $(document).find('#ays_buttons_size').val();
        var buttonsFontSize,
            buttonsLeftRightPadding,
            buttonsTopBottomPadding,
            buttonsBorderRadius;

        switch(buttonsSize){
            case "small":
                buttonsFontSize = 14;
                buttonsLeftRightPadding = 14;
                buttonsTopBottomPadding = 7;
                buttonsBorderRadius = 3;
            break;
            case "large":
                buttonsFontSize = 20;
                buttonsLeftRightPadding = 30;
                buttonsTopBottomPadding = 13;
                buttonsBorderRadius = 3;
            break;
            default:
                buttonsFontSize = 17;
                buttonsLeftRightPadding = 20;
                buttonsTopBottomPadding = 10;
                buttonsBorderRadius = 3;
            break;
        }

        $(document).find('#ays_buttons_font_size').val(buttonsFontSize);
        $(document).find('#ays_buttons_left_right_padding').val(buttonsLeftRightPadding);
        $(document).find('#ays_buttons_top_bottom_padding').val(buttonsTopBottomPadding);
        $(document).find('#ays_buttons_border_radius').val(buttonsBorderRadius);
        $(document).find('#ays_poll_buttons_width').val(buttonsWidth);
        $(document).find('input[type="button"].ays-poll-btn').css('font-size', buttonsFontSize + 'px');
        $(document).find('input[type="button"].ays-poll-btn').css('padding', buttonsTopBottomPadding+'px '+ buttonsLeftRightPadding+'px');
        $(document).find('input[type="button"].ays-poll-btn').css('border-radius', buttonsBorderRadius + 'px');
    });

    $(document).find('#apm_dropdown_answers').select2({
        minimumResultsForSearch: -1
    });

    $(document).find('#ays_poll_bg_image_position').on('change', function () {
        var pollContainer = $(document).find('.box-apm ,.choosing-poll');
        pollContainer.css({
            'background-position': $(this).val()
        });
    });

    var heart_interval = setInterval(function () {
        $(document).find('.ays-poll-maker-wrapper i.ays_fa').toggleClass('ays_poll_pulse');
    }, 1000);

    $(document).find('.checkbox_carousel_body input[type="checkbox"]').on('change', function(e){
        if($(this).prop('checked') == true){
            $(document).find('#'+$(this).attr('id')+'_required').removeAttr('disabled');
        }else{
            $(document).find('#'+$(this).attr('id')+'_required').attr('disabled', 'disabled');
            $(document).find('#'+$(this).attr('id')+'_required').removeAttr('checked');
        }
    });

    $(document).find('.checkbox_carousel_body input[type="checkbox"]').each(function(e){
        if($(this).prop('checked') == true){
            $(document).find('#'+$(this).attr('id')+'_required').removeAttr('disabled');
        }else{
            $(document).find('#'+$(this).attr('id')+'_required').attr('disabled', 'disabled');
            $(document).find('#'+$(this).attr('id')+'_required').removeAttr('checked');
        }
    });

    $(document).find('#form_available_fields').sortable({
        cursor: 'move',
        opacity: 0.8,
        tolerance: "pointer",
        helper: "clone",
        placeholder: "sortable_placeholder",
        connectWith: ".checkbox_carousel_body",
        revert: true,
        forcePlaceholderSize: true,
        forceHelperSize: true,
        containment: ".checkbox_carousel",
        receive: function(event, ui) {
            var item = ui.item;
            var $default_fields = ["apm-name","apm-email","apm_phone"];
            item.find('.custom_field_required').addClass('display_none');
            item.find('input[name="ays-poll-form-fields[]"]').attr('name', 'ays-poll-form-fields-passive[]');
            item.find('input[name="ays_poll_fields_active_order[]"]').attr('name', 'ays_poll_fields_passive_order[]');
            for(var i=0; i < $default_fields.length; i++){
                item.find('input[id="'+$default_fields[i]+'"]').val('off');
            }
        }
    });

    $(document).find('#form_fields').sortable({
        cursor: 'move',
        opacity: 0.8,
        tolerance: "pointer",
        helper: "clone",
        placeholder: "sortable_placeholder",
        connectWith: ".checkbox_carousel_body",
        revert: true,
        forcePlaceholderSize: true,
        forceHelperSize: true,
        containment: ".checkbox_carousel",
        receive: function(event, ui) {
            var item = ui.item;
            var $default_fields = ["apm-name","apm-email","apm_phone"];
            item.find('.custom_field_required').removeClass('display_none');
            item.find('input[name="ays-poll-form-fields-passive[]"]').attr('name', 'ays-poll-form-fields[]');
            item.find('input[name="ays_poll_fields_passive_order[]"]').attr('name', 'ays_poll_fields_active_order[]');
            for(var i=0; i < $default_fields.length; i++){
                item.find('input[id="'+$default_fields[i]+'"]').val($default_fields[i]);
            }
        }
    });

    //-------------GOOGLE SHEETS START-------------------
    var currentVal = $(document).find("#ays_poll_google_client").val();
    $('#ays_poll_google_client').on('input', function () {
        var gclientId = $(this).val();
        if (gclientId == '') {
            $("#ays_poll_googleOAuth2").removeClass('btn-secondary');
            
            $("#ays_poll_googleOAuth2").addClass('btn-outline-secondary');
            $("#ays_poll_googleOAuth2").attr('data-src', '');
            return false;
        }
        var redirectUri = $(document).find("#ays_poll_google_redirect").val();
        var scope = "https://www.googleapis.com/auth/spreadsheets";
        var url = "https://accounts.google.com/o/oauth2/auth?" + "scope=" + scope+ "&access_type=offline&prompt=consent" + "&response_type=code" + "&redirect_uri=" + redirectUri + "&client_id=" + gclientId;
        $("#ays_poll_googleOAuth2").attr('data-src', url);
        $("#ays_poll_googleOAuth2").removeClass('disabled btn-outline-secondary');
        $("#ays_poll_googleOAuth2").addClass('btn-secondary');
        $("#ays_poll_googleOAuth2").removeClass('btn-success');
    });

    $("#googleInstructionsPopOver").popover({
        content: $("#googleInstructions").html(),
        html: true,
    });

    var googleSecret = $(document).find('#ays_poll_google_secret');
    if(googleSecret.hasClass('ays_enable_secret')){
        googleSecret.prop("readonly" , false);
    }

    $("#ays_poll_googleOAuth2").on('click', function () {
        var url = $(this).attr('data-src');
        if (!url) {
            return false;               
        }

        location.replace(url);
    });
    //-------------GOOGLE SHEETS END-------------------

    // Submit buttons disableing with loader
    // var subButtons = '.button.ays-button-top,.button.ays-button,.button#ays-button-top,.button#ays-button-top-apply,.button#ays-button,.button#ays-button-apply';
    var subButtons = '.button.ays-button-top,.button.ays-loader-banner,.ays-apply-all';
    $(subButtons).on('click', function () {        
        var $this = $(this);
        submitOnce($this);
    });

    $(document).find(".button#ays-button-cat").on("click" , function(){
        var catTitle = $(document).find("#ays-title").val();
        if(catTitle != ''){
            var $this = $(this);
            subButtons += ',.button#ays-button-cat';
            submitOnce($this);
        }
    });

    function submitOnce(subButton){
        var subLoader = subButton.siblings(".display_none");
        subLoader.removeClass("display_none");
        subLoader.css("padding-left" , "8px");
        subLoader.css("display" , "inline-flex");
        subLoader.css("align-items" , "center");
        setTimeout(function() {
            $(subButtons).attr('disabled', true);
        }, 50);
        setTimeout(function() {
            $(subButtons).attr('disabled', false);
            subLoader.addClass("display_none").hide();
        }, 5000);
    }

    // ============  Ani Start  ==============

    //Google Charts
    $(document).find('.ays-poll-google-chart.nav-tab').on('click', function(e) {
        var contValue = $('div#statistics').css('display');
        if (this.getAttribute('href') == '#statistics' || contValue == 'block') {

            var count_of_answer_by_country = PollChartData.count_of_answer_by_country;
            var poll_id = PollChartData.poll_id;

            $.each(count_of_answer_by_country,function(){
                var dataTypes = [['Country', 'Percent']];
                for (var key in this) {
                    dataTypes.push([
                        key, parseInt(this[key])
                    ]);
                }
                google.charts.load("current", {packages:["corechart"]});
                google.charts.setOnLoadCallback(drawChart);
                function drawChart() {

                    var data = google.visualization.arrayToDataTable(dataTypes);
                    var options = {
                        // sliceVisibilityThreshold:0
                    };

                    var chart = new google.visualization.PieChart(document.getElementById('poll_chart_div_'+poll_id));

                    chart.draw(data, options);
                }
            })
        }
    });

    // LIVE PREVIEW Strat
    $(document).find('.nav-answers-tab-wrapper a.nav-tab').on('click', function (e) {
        var elemenetID = $(this).attr('href');
        $(document).find('.nav-answers-tab-wrapper a.nav-tab').each(function () {
            if ($(this).hasClass('nav-tab-active')) {
                $(this).removeClass('nav-tab-active');
            }
        });
        $(this).addClass('nav-tab-active');
        $(document).find('.ays-poll-live-container-answers .step').each(function () {
            if ($(this).hasClass('active-step'))
                $(this).removeClass('active-step');
        });
        $('.ays-poll-live-container-answers .step' + elemenetID).addClass('active-step');
        e.preventDefault();
    });

    var buttonsArr = new Array(
        'input[name="ays_poll_theme"]',
        '#ays_poll_enable_answer_style',
        '#ays-poll-color',
        '#ays-poll-text-color',
        '#ays_answers_view',
        '#ays_answers_padding',
        '#ays_answers_font_size',
        '#ays_answers_border',
        '#ays_answers_border_width',
        '#ays_answers_border_style',
        '#ays_answers_box_shadow',
        '#ays_poll_show_answers_caption',
        '#ays_answers_margin',
        '#ays_ans_img_height',
        '#ays_ans_img_caption_position',
        '#ays_ans_img_caption_style',
        '#ays_answers_object_fit',
        '#ays_poll_question_image_object_fit',
        '#ays_answers_grid_column',
        '.ays-poll-question-font-size-all',
        '#ays_answers_border_radius',
        '#ays_answers_border_color',
        '#ays_answers_box_shadow_color',
        '#ays-poll-answer-bg-color',
        'input#ays-poll-border-radius',
        '#ays_poll_question_image_height',
        '#ays_poll_title_font_size',
        '#ays_poll_title_alignment',
        '#ays_poll_text_type_placeholder',
        '#ays-poll-border-side',
        '#ays_poll_answer_box_shadow_x_offset',
        '#ays_poll_answer_box_shadow_y_offset',
        '#ays_poll_answer_box_shadow_z_offset',
    );

    var buttonsStr = buttonsArr.join(",");

    $(document).find(buttonsStr).on('change', function(e){
        refreshLivePreview();
    });
    refreshLivePreview();
    function refreshLivePreview(){

        var liveCSS = $(document).find('#ays_live_custom_css');
        var answersCSS = '';
        var answersCont = $(document).find('.ays-poll-answers');
        var answersImagesCont = $(document).find('.answers-image-container .ays-poll-answers');
        var answersField = $(document).find('.ays-poll-answers .ays-field');

        var pollTextColor = $(document).find('#ays_poll_text_color').val();
        var pollColor = $(document).find('#ays_poll_main_color').val();

        var viewType = $(document).find('#ays_answers_view').val();
        var showCaption = $(document).find('#ays_poll_show_answers_caption').prop('checked');
        var captionPosition = $(document).find('#ays_ans_img_caption_position').val();
        var captionStyle = $(document).find('#ays_ans_img_caption_style').val();
        var imageHeight = $(document).find('#ays_ans_img_height').val();
        var borderColor = $(document).find("#ays-poll-border-color").val();
        var answerObjectFit = $(document).find('#ays_answers_object_fit').val();
        var imageBorderRadius = $(document).find('#ays_poll_answer_image_border_radius').val();
        var answersBoxShadow = $(document).find('#ays_answers_box_shadow').prop('checked');
        var answersBorderRadius = $(document).find('#ays_answers_border_radius').val();
        var answersBoxShadowColor = $(document).find('#ays_answers_box_shadow_color').val();
        var answersBoxShadowXOffset = $(document).find('#ays_poll_answer_box_shadow_x_offset').val();
        var answersBoxShadowYOffset = $(document).find('#ays_poll_answer_box_shadow_y_offset').val();
        var answersBoxShadowZOffset = $(document).find('#ays_poll_answer_box_shadow_z_offset').val();

        var answersBackgroundColor = $(document).find('#ays-poll-answer-bg-color').val();

        var answersPadding = $(document).find('#ays_answers_padding').val();
        var answersMargin = $(document).find('#ays_answers_margin').val();
        var answersFontSize = $(document).find('#ays_answers_font_size').val();
        var answersGridCount = $(document).find('#ays_answers_grid_column').val();

        // Poll text type
        var checkTextType     = $(document).find('.box-apm.text-poll').length > 0 ? true : false;
        // Poll text type placeholder
        var textPlaceholder     = $(document).find("#ays_poll_text_type_placeholder");
        var textPlaceholderVal  = textPlaceholder.val();
        $(document).find('.ays-poll-text-type-fields').attr('placeholder' , textPlaceholderVal);
        

        // Live preview border Color
        var pollBorderRadius = $(document).find("#ays-poll-border-radius").val();
        $(document).find(".box-apm,.answer_style_content").css("border-radius" , pollBorderRadius+"px");
        $(document).find('.box-apm').css("border-color" , borderColor);
        // $(document).find('.ays_question>p').css({'font-size':questionFontSize+'px'});
        answersImagesCont.find('.ays-field .ays-answer-image').css('object-fit', answerObjectFit);

        if(!showCaption){
            $(document).find('.ays-field .ays_answer_live_label>p').addClass('display_none_imp');
        }else{
            $(document).find('.ays-field .ays_answer_live_label>p').removeClass('display_none_imp');
        }

        // Question font size
        var pattern = /Android|webOS|iPhone|iPad|Mac|Macintosh|iPod|BlackBerry|IEMobile|Opera Mini/i;
        var questionFontSize;
        if( pattern.test(navigator.userAgent) ) {
            questionFontSize = $(document).find("#ays_poll_answers_font_size_mobile").val();            
        }
        else{
            questionFontSize = $(document).find("#ays_poll_answers_font_size_pc").val();
        }
        
        $(document).find('.ays_question p').css({ 'font-size': questionFontSize+"px" });

        // Question image height
        var questionImageHeight = $(document).find("#ays_poll_question_image_height").val();
        var questionHeight = questionImageHeight == "" ? "100%" : questionImageHeight+"px";

        var questionImageObjectFit = $(document).find("#ays_poll_question_image_object_fit").val();
        $(document).find(".apm-img-box img.ays-poll-img").css({"height" : questionHeight, "object-fit" : questionImageObjectFit});

        // Title font size
        var titleFontSizeBox     = $(document).find("#ays_poll_title_font_size");
        var titleFontSize        = titleFontSizeBox.val();
        // Title alignment
        var titleAlignment     = $(document).find("#ays_poll_title_alignment").val();

        if(titleFontSize < 0){
            titleFontSize = 0;
            titleFontSizeBox.val(0);
        }
        $(document).find('.apm-title-box h5').css({
            "font-size" : titleFontSize + "px",
            "text-align" : titleAlignment,
        });

        if(viewType == 'list'){
            $(document).find('.grid_column_count').hide(250);
            answersCont.removeClass('ays_grid_view_container');
            answersCont.addClass('ays_list_view_container');
            answersField.removeClass('ays_grid_view_item');
            answersField.addClass('ays_list_view_item');
            // if(captionStyle == 'inside'){
                // $(document).find('.ays-poll-answers .ays_list_view_item div.ays-container-only-images').css({
                //     "height": "unset"
                // });
                $(document).find('.ays-poll-answers .ays-field.ays_list_view_item').css({
                    'margin-right': 0,
                });
                if(captionPosition == 'top'){
                    $(document).find('.ays-field.ays_list_view_item,.ays_label_poll').css({
                        'flex-direction': 'row-reverse'
                    });
                    answersImagesCont.find('.ays-field.ays_list_view_item>.ays_answer_live_label>p').css({
                        'position': 'relative',
                        'top': '0',
                        'bottom': 'unset',
                        'opacity': '1',
                    });
                }else if(captionPosition == 'bottom'){
                    $(document).find('.ays-field.ays_list_view_item,.ays_label_poll').css({
                        'flex-direction': 'row'
                    });
                    answersImagesCont.find('.ays-field.ays_list_view_item>.ays_answer_live_label>p').css({
                        'position': 'relative',
                        'top': 'unset',
                        'bottom': '0',
                        'opacity': '1',
                    });
                }
            // }
            // else{
                // if(captionPosition == 'bottom'){
                //     $(document).find('.ays-field.ays_list_view_item,.ays_label_poll').css({
                //         'flex-direction': 'row-reverse'
                //     });
                // }
                // else if(captionPosition == 'bottom'){
                    
                // }
                
            // }
            $(document).find('.ays-poll-answers .ays-field.ays_list_view_item').css({
                'width': '100%',
            });

            $(document).find('.ays-poll-answers .ays-field.ays_list_view_item,.apm-answers div[class^="apm-choosing answer-"]').css({
                'margin-bottom': answersMargin  + 'px',
            });

            $(document).find('.ays-poll-answers .ays-field.ays_list_view_item label').css({
                "min-height": "unset"
            });
    
        }else if(viewType == 'grid' && !checkTextType){

            $(document).find('.grid_column_count').show(250);
            answersCont.removeClass('ays_list_view_container');
            answersCont.addClass('ays_grid_view_container');
            answersField.removeClass('ays_list_view_item');
            answersField.addClass('ays_grid_view_item');
            // $(document).find('.ays-poll-answers .ays_grid_view_item div.ays-container-only-images').parent().css({
            //     "height": "220px"
            // });
            answersImagesCont.find('.ays-field.ays_grid_view_item div.ays-container-only-images p').css({
                "min-height": "45px"
            });
            switch(answersGridCount){
                case '2':
                    $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item').css({
                        'width': 'calc(50% - ' + Math.round(answersMargin / 2) + 'px)',
                        'margin-right': Math.round(answersMargin / 2) + 'px',
                    });
                    $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item label').css({
                        "min-height": "unset"
                    });
                    // $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item').css({
                    // });
                    break;
                case '3':
                    $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item').css({
                        'width': 'calc(33% - ' + Math.round(answersMargin / 3) + 'px)',
                        'margin-right': Math.round(answersMargin / 3) + 'px',
                    });
                    $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item label').css({
                        "min-height": "77px"
                    });
                    break;
                case '4':
                    $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item').css({
                        'width': 'calc(20% - ' + Math.round(answersMargin / 4) + 'px)',
                        'margin-right': Math.round(answersMargin / 4) + 'px',
                    });
                    $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item label').css({
                        "min-height": "98px"
                    });
                    // $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item').css({
                    // });
                    answersImagesCont.find('.ays-field.ays_grid_view_item div.ays-container-only-images p').css({
                        "min-height": "120px"
                    });
                    break;
            }

            $(document).find('.ays-poll-answers .ays-field.ays_grid_view_item').css({
                'margin-top': 0,
            });

            

            if(captionStyle == 'outside'){
                if(captionPosition == 'top'){
                    $(document).find('.ays-field.ays_grid_view_item>div.ays_answer_live_label').css({
                        'flex-direction': 'column-reverse'
                    });
                    answersImagesCont.find('.ays-field.ays_grid_view_item >div>p').css({
                        'position': 'static',
                    });
                }else if(captionPosition == 'bottom'){
                    $(document).find('.ays-field.ays_grid_view_item>div.ays_answer_live_label').css({
                        'flex-direction': 'column'
                    });
                    answersImagesCont.find('.ays-field.ays_grid_view_item > div.ays_answer_live_label > p').css({
                        'position': 'static',
                    });
                }
            }else if(captionStyle == 'inside'){
                if(captionPosition == 'top'){
                    answersImagesCont.find('.ays-field.ays_grid_view_item > div.ays_answer_live_label > p').css({
                        'position': 'absolute',
                        'top': '0',
                        'left': '0',
                        'bottom': 'unset',
                        'min-height': 'unset',
                    });
                }else if(captionPosition == 'bottom'){
                    answersImagesCont.find('.ays-field.ays_grid_view_item > div.ays_answer_live_label > p').css({
                        'position': 'absolute',
                        'top': 'unset',
                        'left': '0',
                        'bottom': '-15px',
                        'min-height': 'unset',
                    });
                }
            }
        }

        if(answersBoxShadow){
            $(document).find('.ays-poll-answers .ays-field>label,.ays-poll-answers .ays-field >.ays_answer_live_label,label.ays_label_poll').css({
                'box-shadow': answersBoxShadowXOffset+'px '+answersBoxShadowYOffset+'px '+answersBoxShadowZOffset+'px '+answersBoxShadowColor,
            });
        }else{
            $(document).find('.ays-poll-answers .ays-field>label,.ays-poll-answers .ays-field >.ays_answer_live_label,label.ays_label_poll').css({
                'box-shadow': 'none',
            });
        }

        $(document).find('.ays-poll-answers .ays-field .ays-answer-image').css({
            'height': imageHeight+'px',
            'border-radius': imageBorderRadius+'px',
        });
        $(document).find('.ays-poll-answers .ays-field>label,div.ays-container-only-images,label.ays_label_poll').css({
            'font-size': answersFontSize + 'px',
            // 'margin-bottom': answersMargin + 'px',
            'padding': answersPadding + 'px',
            'border-radius': answersBorderRadius+'px',
            'background': answersBackgroundColor+'px',
        });

        $(document).find(".ays-field .ays_answer_live_label>p").css({
            'font-size': answersFontSize + 'px',
        });

        answersCSS = '.ays-poll-answers .ays-field>label,.ays-poll-answers .ays-field >.ays_answer_live_label {'+
                'color: '+ pollTextColor +';'+
            '}'+
            '.ays-poll-live-container .ays-field input:checked~label:hover {'+
                'background-color: '+ pollColor +';'+
            '}'+
            '.ays-poll-live-container .ays-field input:checked~label {'+
                'background-color: '+ pollColor +';'+
            '}';

        answersCSS += '.ays-poll-live-container .ays-field:hover,'+
            '.ays-poll-live-container .ays-field:hover label {'+
                'background-color: '+ pollColor +';'+
                'color: '+ pollTextColor +';'+
            '}';

        
        liveCSS.html('');
        liveCSS.html(liveCSS.html() + answersCSS);
    }

    $(document).find('#ays_poll_enable_answer_style').on('change', function(e) { 
        var answersStyleButton = $(document).find('#ays_poll_enable_answer_style');
        var answersBorder = $(document).find('#ays_answers_border').prop('checked');
        var answersBorderSide = $(document).find('#ays-poll-border-side').val();

        if (answersStyleButton.prop("checked")) {
            answerStylesOnOff(true);
            if (answersBorder) {
                answerBorderSideChange(answersBorderSide);
            } else {
                answerBorderSideChange("none");
            }
        } else {
            answerStylesOnOff(false);
        }
    })

    $(document).find(".ays_default_btn").on("click" , function(e){
            var message = $(this).data('message');
            var confirm = window.confirm( message );
            var $this = $(this);
            if(confirm !== true){
                e.preventDefault();
            }else{
                setTimeout(function() {
                    $($this).attr('disabled', true);
                }, 50);
                submitOnce($this);
            }
    });

    // ============  Ani End  ==============
    
    $('#ays_poll_admin_email_session').select2({
        minimumResultsForSearch: -1
    });

    $(document).find('#ays_poll_email_to_admins').on('change',function(){
        var inpChecked = $(document).find('#ays_poll_email_to_admins').prop('checked');
        
        if(inpChecked){
            $(document).find("#ays_poll_email_admin").show(250);
        }else{
            $(document).find("#ays_poll_email_admin").hide(250);
        }
    });

    $(document).on("click" , "div.ays-container-only-images" ,function(){
            $(document).find("div.ays_list_view_item input[type='radio'],div.ays_grid_view_item input[type='radio']").attr("checked" , false);
            $(this).prev().attr("checked" , true);
    });

    // ==== Added new ====
    $(document).find("#ays_see_result_show").on("change" , function(){
        var checker = $(this).prop("checked");
        var buttonsCont = $(document).find("#ays_poll_show_hide_button");
        if(checker){
            buttonsCont.show(200);
            buttonsCont.css("display" , "flex");
        }
        else{
            buttonsCont.hide(200);
        }
    });

    $(document).find('input[type="submit"]#doaction, input[type="submit"]#doaction2').on('click', function(e) {
        showConfirmationIfDelete(e);
    })

    $(document).find("input#poll-maker-ays-search-input + input#search-submit").on("click", function (e) {
        var _this  = $(this);
        var parent = _this.parents('form');
        
        var search_input = parent.find('input#poll-maker-ays-search-input');
        var input_value  = search_input.val();

        var field = 's';
        var flag = false;
        var url = window.location.href;
        if(url.indexOf('?' + field + '=') != -1){
            flag = true;
        }
        else if(url.indexOf('&' + field + '=') != -1){
            flag = true;
        }

        if (flag) {
            if (typeof input_value != 'undefined' && input_value != "") {
                e.preventDefault();
                location.href=location.href.replace(/&s=([^&]$|[^&]*)/i, "&s="+input_value);
            }
        }
    });

    function showConfirmationIfDelete(e) {
        var $el = $(e.target);
        var elParent = $el.parent();
        var actionSelect = elParent.find('select[name="action"]');
        var action = actionSelect.val();

        if (action === 'bulk-delete') {
            e.preventDefault();
            var confirmDelete = confirm('Are you sure you want to delete?');

            if (confirmDelete) {
                var form = $el.closest('form');
                form.submit()
            }
        }
    }

    $(document).on('click', '.ays_polls_each_results_list_table th.manage-column a', function(e) {
        var href = $(this).attr('href');
        $(this).attr('href', href + '&ays_poll_tab_results=tab2');
    })

    // Ctrl + s combination
    $(document).keydown(function(event) {
        var editButton = $(document).find("#ays-button-apply, input.ays-apply-all");
        if (!(event.which == 83 && event.ctrlKey) && !(event.which == 19)){
            return true;  
        }
        editButton.trigger("click");
        event.preventDefault();
        return false;
    });
    //

    function aysPollGetCookie(c_name) {
        if (document.cookie.length > 0) {
            var c_start = document.cookie.indexOf(c_name + "=");
            if (c_start != -1) {
                c_start = c_start + c_name.length + 1;
                var c_end = document.cookie.indexOf(";", c_start);
                if (c_end == -1) {
                    c_end = document.cookie.length;
                }
                return unescape(document.cookie.substring(c_start, c_end));
            }
        }
        return "";
    }
    // Check new added Poll start
    var createdNewPoll = aysPollGetCookie('ays_poll_created_new');
    if(createdNewPoll && createdNewPoll > 1){
        var url = new URL(window.location.href);

        // Get a specific GET parameter by name
        var parameterValue = url.searchParams.get("action");
        var htmlDefaultText = '<p style="margin-top:1rem;">'+ pollLangObj.formMoreDetailed +' <a href="admin.php?page=poll-maker-ays&action=edit&poll=' + createdNewPoll + '">'+ pollLangObj.editPollPage +'</a>.</p>';

        var htmlContent = parameterValue && parameterValue == 'edit' ? '' : htmlDefaultText;
        swal({
            title: '<strong>' + pollLangObj.greateJob + '</strong>',
            type: 'success',
            html: '<p>' + pollLangObj.youCanUuseThisShortcode + '</p><input type="text" id="ays-poll-create-new" onClick="this.setSelectionRange(0, this.value.length)" readonly value="[ays_poll id=\'' + createdNewPoll + '\']" />' + htmlContent,
            showCloseButton: true,
            focusConfirm: false,
            confirmButtonText: '<i class="ays_poll_fas ays_poll_fa_thumbs_up"></i> '+ pollLangObj.done,
            confirmButtonAriaLabel: pollLangObj.thumbsUpGreat,
        });
        aysPollDeleteCookie('ays_poll_created_new');
    }

    function aysPollDeleteCookie(name) {
        document.cookie = name + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
    }

    $(document).find("#ays_poll_default_type").select2();
    $(document).find("#ays_poll_default_cat,#ays_poll_default_cat_for_request").select2({
        multiple: true,
    });

    // Answers chart tab chart 
    var drawChartLink = $(document).find(".ays_poll_answer_chart_active");
    if(drawChartLink.hasClass("nav-tab-active")){
        google.charts.load('current', {packages: ['corechart', 'bar']});
        google.charts.setOnLoadCallback(drawBasic);
    }
    
    drawChartLink.on("click" , function(){
        google.charts.load('current', {packages: ['corechart', 'bar']});
        google.charts.setOnLoadCallback(drawBasic);
    });
    //

        // Write poll title immediately
    $(document).find('#ays-poll-title').on('input', function(e){
        var pollTitleVal = $(this).val();
        var pollTitle = aysPollstripHTML( pollTitleVal );
        $(document).find('.ays_poll_title_in_top').html( pollTitle );
    });

    function aysPollstripHTML( dirtyString ) {
        var container = document.createElement('div');
        var text = document.createTextNode(dirtyString);
        container.appendChild(text);
        return container.innerHTML; // innerHTML will be a xss safe string
    }
    //

    // Create and Delete rows in Answers table
    $(document).on("keydown" , "input[name='ays-poll-answers[]'], input[name='ays-poll-answers-dropdown[]']" , function(event) {
        var $thisValue = $(this).val();
        if (event.keyCode === 13) {
                event.preventDefault();
                if($(this).hasClass("ays_poll_enter_key")){
                    var editButton = $(document).find(".ays-click-once").eq(0); 
                    editButton.trigger("click");
                }
                else{
                    var nextInput = $(this).parents("tr").next().find("td input:nth-child(2)");
                    nextInput.focus();
                    var oldValue  = nextInput.val();
                    nextInput.val(" ");
                    nextInput.val(oldValue);
                }
            }
        else if(event.keyCode === 8  && $thisValue == ""){     
            var editButton = $(this).parents("tr").find("a.ays-delete-answer");
            editButton.trigger("click");
            event.preventDefault();
        }
    });
    //

    // == Ani == 
    $(document).find('.ays-show-user-history-table').sortable({
        cursor: 'move',
        opacity: 0.8,
        tolerance: "pointer",
        helper: "clone",
        placeholder: "ays_user_history_sortable_placeholder",
        revert: true,
        forcePlaceholderSize: true,
        forceHelperSize: true,
    });
    // ==

    $(document).find('.ays-poll-all-results-table').sortable({
        cursor: 'move',
        opacity: 0.8,
        tolerance: "pointer",
        helper: "clone",
        placeholder: "ays_poll_all_results_sortable_placeholder",
        revert: true,
        forcePlaceholderSize: true,
        forceHelperSize: true,
    });

    // Filter Polls by Category
    $(document).find('.ays-poll-question-tab-all-filter-button-top, .ays-poll-question-tab-all-filter-button-bottom').on('click', function(e) {
        e.preventDefault();
        var $this = $(this);
        var parent = $this.parents('.tablenav');

        var searchForm = parent.parent();
        var searchInput = searchForm.find('input#poll-maker-ays-search-input')
        var searchValue = searchInput.val();

        var html_name = '';
        var top_or_bottom = 'top';

        if ( parent.hasClass('bottom') ) {
            top_or_bottom = 'bottom';
        }

        var catFilter = $(document).find('select[name="filterby-'+ top_or_bottom +'"]').val();
        var authorFilter = $(document).find('select[name="filterbyauthor-'+ top_or_bottom +'"]').val();
        var typeFilter = $(document).find('select[name="filterbytype-'+ top_or_bottom +'"]').val();
        var link = location.href;

        if (typeof catFilter != "undefined") {
            link = catFilterForListTable(link, searchValue, {
                what: 'filterby',
                value: catFilter
            });
        }
        if (typeof authorFilter != "undefined") {
            link = catFilterForListTable(link, searchValue, {
                what: 'filterbyauthor',
                value: authorFilter
            });
        }
        if (typeof typeFilter != "undefined") {
            link = catFilterForListTable(link,searchValue, {
                what: 'filterbytype',
                value: typeFilter
            });
        }
        document.location.href = link;
    })

    function catFilterForListTable(link, searchValue, options){
        if( options.value != '' ){
            options.value = "&" + options.what + "=" + options.value;
            var linkModifiedStart = link.split('?')[0];
            var linkModified = link.split('?')[1].split('&');
            for(var i = 0; i < linkModified.length; i++){
                if ( linkModified[i].split("=")[0] == "ays_result_tab" ) {
                    linkModified.splice(i, 1, "ays_result_tab=poststuff");
                }
                if(linkModified[i].split("=")[0] == options.what){
                    linkModified.splice(i, 1);
                }
            }
            linkModified = linkModified.join('&');
            if (typeof searchValue != 'undefined' && searchValue != '') {
                linkModified = linkModified + "&s=" + searchValue;
            }
            return linkModifiedStart + "?" + linkModified + options.value;
        }else{
            var linkModifiedStart = link.split('?')[0];
            var linkModified = link.split('?')[1].split('&');
            for(var i = 0; i < linkModified.length; i++){
                if(linkModified[i].split("=")[0] == options.what){
                    linkModified.splice(i, 1);
                }
            }
            linkModified = linkModified.join('&');
            if (typeof searchValue != 'undefined' && searchValue != '') {
                linkModified = linkModified + "&s=" + searchValue;
            }
            return linkModifiedStart + "?" + linkModified;
        }
    }

    $(document).find('strong.ays-poll-shortcode-box').on('mouseleave', function(){
        var _this = $(this);

        _this.attr( 'data-original-title', pollLangObj.clickForCopy );
    });

    // Remove logo image 
    $(document).find(".ays-poll-logo-image-remove-box").hover(function(){
        $(this).find("img").attr("src" , pollLangObj.removeImageHover);
    } , function(){
        $(this).find("img").attr("src" , pollLangObj.removeImage);
    });

    $(document).find("#ays-poll-logo-image-remover").on("click" , function(){
        $(document).find("#ays-poll-logo-img").attr("src" , '');
        $(document).find("#ays-poll-logo-image").val('');
        $(document).find(".ays_logo_image_remove").hide();
        $(document).find(".box-apm").css('position' , 'static');
        $(document).find(".ays_live_logo_container").hide();
        $(document).find(".ays_live_image_preview").attr("src" , '');
        $(document).find("a.add-logo-image").html("Add Image");
        $(document).find(".box-apm").removeClass("ays_logo_cont_image_on");
        $(document).find(".ays-poll-logo-url-disable").addClass("display_none");
        $(this).parents(".ays_toggle_parent").find(".ays-poll-toggle-image-url-box").addClass("display_none");
        $(this).parents(".ays_toggle_parent").find(".ays-poll-toggle-image-title-box").addClass("display_none");
    });

    $(document).find("#ays_enable_restriction_pass").on("change" , function(){
        var checked = $(this).prop("checked");
        if(checked){
            $(document).find("#ays_enable_logged_users").prop("disabled" , true);
        }
        else{
            $(document).find("#ays_enable_logged_users").prop("disabled" , false);
        }
    });

    $(document).on('click', '.ays_poll_block_with_hidden_row_show_row_block, .ays_poll_block_with_hidden_row_hide_row_block', toggleHiddenBlockRow)

    function toggleHiddenBlockRow() {
        var isShow = $(this).hasClass('ays_poll_block_with_hidden_row_show_row_block');
        var mainBlock = $(this).parents('.ays_poll_block_with_hidden_row');

        if (isShow) {
            $(mainBlock).find(".ays_poll_hidden_block_content").show(200);
            $(mainBlock).find(".ays_poll_hidden_hr_content").show(200);
        } else {
            $(mainBlock).find(".ays_poll_hidden_block_content").hide(200);
            $(mainBlock).find(".ays_poll_hidden_hr_content").hide(200);
        }
    }

    var toggle_ddmenu = $(document).find('.toggle_ddmenu');
    toggle_ddmenu.on('click', function () {
        var ddmenu = $(this).next();
        var state = ddmenu.attr('data-expanded');
        switch (state) {
            case 'true':
                $(this).find('.ays_fa').css({
                    transform: 'rotate(0deg)'
                });
                ddmenu.attr('data-expanded', 'false');
                break;
            case 'false':
                $(this).find('.ays_fa').css({
                    transform: 'rotate(90deg)'
                });
                ddmenu.attr('data-expanded', 'true');
                break;
        }
    });
    
    // Check if submit button clicked for unsaved changes confirmation box
    var subButtons = '.button#ays-button-top-apply, .button#ays_apply_top, .button#ays-button-top, .button#ays-button, .button#ays-button-apply, .button#ays_default, .button#ays_submit_top, .button#ays_apply, .button#ays_submit, .button#ays_poll_cancel_top, .button#ays_poll_cancel, .button#ays-apply';
    $(document).on('click', subButtons ,function () {
        var $this = $(this);
        $this.addClass('ays-submit-button-clicked');
    });

    var aysUnsavedChanges = false;
    var formInputs = '#ays-poll-form .ays-poll-tab-content input, #ays-poll-form .ays-poll-tab-content select, ' +
            '#ays-poll-form .ays-poll-tab-content textarea, #ays-poll-category-form input, ' +
            '#ays-poll-category-form select, #ays-poll-category-form textarea, ' +
            '#ays-poll-general-settings-form input, #ays-poll-general-settings-form select, ' +
            '#ays-poll-general-settings-form textarea';

    $(document).on('change input', formInputs, function() {
        aysUnsavedChanges = true;
    });

    $(window).on('beforeunload', function(event) {
        var saveButtons = $(document).find('.button#ays-button-top-apply, .button#ays_apply_top, .button#ays-button-top, .button#ays-button, .button#ays-button-apply, .button#ays_default, .button#ays_submit_top, .button#ays_apply, .button#ays_submit, .button#ays-apply');

        var savingButtonsClicked = saveButtons.filter('.ays-submit-button-clicked').length > 0;

        if (aysUnsavedChanges && !savingButtonsClicked) {
            event.preventDefault();
            event.returnValue = true;
        }
    });

    // Poll Responsive tabs start
    if($(document).find('.ays-top-menu').width() <= $(document).find('div.ays-top-tab-wrapper').width()){
        $(document).find('.ays_menu_left').css('display', 'flex');
        $(document).find('.ays_menu_right').css('display', 'flex');
    }
    $(window).resize(function(){
        if($(document).find('.ays-top-menu').width() < $(document).find('div.ays-top-tab-wrapper').width()){
            $(document).find('.ays_menu_left').css('display', 'flex');
            $(document).find('.ays_menu_right').css('display', 'flex');
        }else{
            $(document).find('.ays_menu_left').css('display', 'none');
            $(document).find('.ays_menu_right').css('display', 'none');
            $(document).find('div.ays-top-tab-wrapper').css('transform', 'translate(0px)');
        }
    });
    var menuItemWidths0 = [];
    var menuItemWidths = [];
    $(document).find('.ays-top-tab-wrapper .nav-tab').each(function(){
        var $this = $(this);
        menuItemWidths0.push($this.outerWidth());
    });

    for(var i = 0; i < menuItemWidths0.length; i+=2){
        if(menuItemWidths0.length <= i+1){
            menuItemWidths.push(menuItemWidths0[i]);
        }else{
            menuItemWidths.push(menuItemWidths0[i]+menuItemWidths0[i+1]);
        }
    }
    var menuItemWidth = 0;
    for(var i = 0; i < menuItemWidths.length; i++){
        menuItemWidth += menuItemWidths[i];
    }
    menuItemWidth = menuItemWidth / menuItemWidths.length;

    $(document).on('click', '.ays_menu_left', function(){
        var scroll = parseInt($(this).attr('data-scroll'));
        scroll -= menuItemWidth;
        if(scroll < 0){
            scroll = 0;
        }
        $(document).find('div.ays-top-tab-wrapper').css('transform', 'translate(-'+scroll+'px)');
        $(this).attr('data-scroll', scroll);
        $(document).find('.ays_menu_right').attr('data-scroll', scroll);
    });
    $(document).on('click', '.ays_menu_right', function(){
        var scroll = parseInt($(this).attr('data-scroll'));
        var howTranslate = $(document).find('div.ays-top-tab-wrapper').width() - $(document).find('.ays-top-menu').width();
        howTranslate += 7;
        if(scroll == -1){
            scroll = menuItemWidth;
        }
        scroll += menuItemWidth;
        if(scroll > howTranslate){
            scroll = Math.abs(howTranslate);
        }
        $(document).find('div.ays-top-tab-wrapper').css('transform', 'translate(-'+scroll+'px)');
        $(this).attr('data-scroll', scroll);
        $(document).find('.ays_menu_left').attr('data-scroll', scroll);
    });
    // Poll Responsive tabs end

    // checkbox carousel start
    $(document).on('click', '.cb_carousel_left', function(){
        var howTranslate = ($(document).find('div.checkbox_carousel').width() * 25) / 100;
        var currentTranslate = parseInt($(this).parents('.checkbox_carousel').find('.checkbox_carousel_body').css('transform').split(',')[4]);
        if(currentTranslate == NaN){
            currentTranslate = 0;
        }
        if(currentTranslate < 0){
            howTranslate = howTranslate + currentTranslate;
        }else{
            howTranslate = howTranslate + -currentTranslate;
        }
        if(howTranslate > 0){
            howTranslate = 0;
        }
        $(this).parents('.checkbox_carousel').find('.checkbox_carousel_body').css('transform', 'translateX('+howTranslate+'px)');
    });
    
    $(document).on('click', '.cb_carousel_right', function(){
        var howTranslate = ($(document).find('div.checkbox_carousel').width() * 25) / 100;
        var currentTranslate = parseInt($(this).parents('.checkbox_carousel').find('.checkbox_carousel_body').css('transform').split(',')[4]);
        if(currentTranslate < 0){
            howTranslate = howTranslate + -currentTranslate;
        }else{
            howTranslate = howTranslate + currentTranslate;
        }
        
        if(parseInt($(this).parents('.checkbox_carousel')[0].scrollWidth) - parseInt($(this).parents('.checkbox_carousel').width()) < Math.abs(howTranslate)){
            howTranslate = parseInt($(this).parents('.checkbox_carousel').data('scrollWidth') - parseInt($(this).parents('.checkbox_carousel').width()) + 2);
        }
        $(this).parents('.checkbox_carousel').find('.checkbox_carousel_body').css('transform', 'translateX(-'+howTranslate+'px)');
    });
    // checkbox carousel end
    
    $(document).on('click', '#ays-polls-next-button, #ays-polls-prev-button, #ays-poll-category-next-button, #ays-poll-category-prev-button', function(e){
        e.preventDefault();
        var message = $(this).data('message');
        var confirm = window.confirm( message );
        if(confirm === true){
            window.location.replace($(this).attr('href'));
        }
    });

    $(document).find('table#ays-poll-popup-position-table tr td').on('click', function(e){
        var val = $(this).data('value');
        $(document).find('.popup_poll_position_block #ays-poll-popup-position-val').val(val);
            aysCheckPopupPosition();
    });

    function aysCheckPopupPosition(){
        var hiddenVal = $(document).find('.popup_poll_position_block #ays-poll-popup-position-val').val();
           
        if (hiddenVal == "") {
            var $this = $(document).find('table#ays-poll-popup-position-table tr td[data-value="center-center"');
        }else{
            var $this = $(document).find('table#ays-poll-popup-position-table tr td[data-value='+ hiddenVal +']');
        }

        if (hiddenVal == 'center-center' || hiddenVal == ''){
            $(document).find("#popupMargin").addClass('display_none');
            $(document).find(".ays_pb_hr_hide").addClass('display_none');
        }else{
            $(document).find("#popupMargin").removeClass('display_none');
            $(document).find(".ays_pb_hr_hide").removeClass('display_none');
        }

        $(document).find('table#ays-poll-popup-position-table td').removeAttr('style');
        $this.css('background-color','#a2d6e7');
    }

    $(document).find(".ays-poll-popup-show-where").on('change', function(){
        var checked = $(this).val();
        if( checked == 'all' ){
            $(document).find('.ays_poll_view_place_tr').addClass('display_none');
        }else{
            $(document).find('.ays_poll_view_place_tr').removeClass('display_none');
        }
    });

    //Get Only selected post types(AV)
    $(document).find('#ays_poll_post_types').select2({
        placeholder: "Select post type",
        allowClear: true,
        minimumInputLength: 3,
        multiple: true,
    });

    // CHOOSE POLL TYPE FROM MODAL START
    $(document).find('.ays_poll_layer_box_blocks label.ays-poll-dblclick-layer:not(.ays-poll-type-pro-feature)').on('dblclick',function(){
        $(this).parents('.ays_poll_layer_container').find('.ays_poll_select_button_layer input.ays_poll_layer_button').trigger('click');
    });

    $(document).find('.ays-poll-content-type').on('change',function(){
        $(this).parents('.ays_poll_layer_container').find('.ays_poll_select_button_layer input.ays_poll_layer_button').prop('disabled',false).attr("data-type" , $(this).val());
        $(document).find('#poll_choose_type').val($(this).val());
    });

    $(document).find('.ays_poll_layer_button').on('click',function(){
        $('.ays_poll_layer_container').css({'position':'unset' , 'display':'none'});

        checkPollType($(this).attr("data-type"));
    })
    // CHOOSE POLL TYPE FROM MODAL END

    $(document).find('.ays-poll-open-polls-list').on('click', function(e){
        $(this).parents(".ays-poll-subtitle-main-box").find(".ays-poll-polls-data").toggle('fast');
    });

    $(document).find(".ays-poll-go-to-polls").on("click" , function(e){
        e.preventDefault();
        var confirmRedirect = window.confirm(pollLangObj.areYouSure);
        if(confirmRedirect){
            window.location = $(this).attr("href");
        }
    });

    $(document).find('#ays_poll_reset_to_default').on('click', function (e) {
        e.preventDefault();
        var themeId = $(document).find('.ays-poll-theme-item.apm_active_theme').next('input').val();
        
        $(document).find('.apm-themes-row').attr('data-themeId',themeId);
        if ($(document).find('#ays_poll_show_answers_icon').prop('checked')) {
            switch(parseInt(themeId)){
                case 6: 
                case 7:
                    $(document).find('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $(document).find('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
                    break;
                default:
                    var iconsVal = $('input[name="ays_poll_answer_icon"]:checked').val();
                    $(document).find('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
                    $(document).find('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
                    $(document).find('.ays_label_poll').addClass('ays_poll_answer_icon_'+iconsVal);
                    break;
            }
        } else {
            $(document).find('.ays_label_poll').removeClass('ays_poll_answer_icon_checkbox');
            $(document).find('.ays_label_poll').removeClass('ays_poll_answer_icon_radio');
        }

        answerStyleChange(themeId);

        textColorChange(themes[themeId].textColor);
        buttonTextColorChange(themes[themeId].buttonTextColor);
        buttonBgColorChange(themes[themeId].buttonBgColor);
        mainColorChange(themes[themeId].mainColor);
        bgColorChange(themes[themeId].bgColor);
        // answerBgColorChange({
        //     color: themes[themeId].answerBgColor
        // });
        titleBgColorChange(themes[themeId].titleBgColor);
        iconColorChange(themes[themeId].iconColor);
        $(document).find('#ays-poll-text-color').parent().parent().prev().css({
            'background-color': themes[themeId].textColor
        });
        $(document).find('#ays-poll-text-color').val(themes[themeId].textColor);

        $(document).find('#ays-poll-button-text-color').parent().parent().prev().css({
            'color': themes[themeId].buttonTextColor
        });
        $(document).find('#ays-poll-button-text-color').val(themes[themeId].buttonTextColor);

        $(document).find('#ays-poll-button-bg-color').parent().parent().prev().css({
            'background-color': themes[themeId].buttonBgColor
        });
        $(document).find('#ays-poll-button-bg-color').val(themes[themeId].buttonBgColor);

        $(document).find('#ays-poll-main-color').parent().parent().prev().css({
            'background-color': themes[themeId].mainColor
        });
        $(document).find('#ays-poll-main-color').val(themes[themeId].mainColor);

        $(document).find('#ays-poll-bg-color').parent().parent().prev().css({
            'background-color': themes[themeId].bgColor
        });
        $(document).find('#ays-poll-bg-color').val(themes[themeId].bgColor);

        // $(document).find('#ays-poll-answer-bg-color').parent().parent().prev().css({
        //     'background-color': themes[themeId].answerBgColor
        // });
        // $(document).find('#ays-poll-answer-bg-color').val(themes[themeId].answerBgColor);

        $(document).find('#ays-poll-title-bg-color').parent().parent().prev().css({ 
            'background-color': themes[themeId].titleBgColor
        });
        $(document).find('#ays-poll-title-bg-color').val(themes[themeId].titleBgColor);

        $(document).find('#ays-poll-icon-color').parent().parent().prev().css({
            'background-color': themes[themeId].iconColor
        });
        $(document).find('#ays-poll-icon-color').val(themes[themeId].iconColor);

        $(document).find('.ays-remove-bg-img').trigger('click');

        if(themeId == 6 || themeId == 7){
            $(document).find('#ays-poll-border-side').val('none').change();
        }else{
            $(document).find('#ays-poll-border-side').val('all_sides').change();            
        }

        $(document).find('#ays-poll-background-image-options').hide().change();
        $(document).find('input#ays_answers_font_size').val('16').change();
        $(document).find('input#ays_poll_answer_font_size_mobile').val('16').change();
        $(document).find('input#ays_ans_img_height').val('150').change();
        $(document).find('input#ays_poll_answer_image_height_for_mobile').val('150').change();
        $(document).find('input#ays_poll_answer_image_border_radius').val('0').change();
        $(document).find('#ays_poll_background_size').val('cover').change();
        $(document).find('input#ays_answers_padding').val('10').change();
        $(document).find('input#ays_answers_margin').val('10').change();
        $(document).find('input#ays_answers_border_radius').val('0').change();

        $(document).find("#ays_poll_show_answers_icon").prop('checked' , false).change();

        $(document).find('#ays_answers_view').val('list').change();
        $(document).find("#ays_answers_box_shadow").prop('checked' , false).change();
        $(document).find('input#ays_poll_title_font_size').val('20').change();
        $(document).find('input#ays_poll_title_font_size_mobile').val('20').change();
        $(document).find('#ays_poll_title_alignment').val('center').change();
        $(document).find('#ays_poll_title_alignment_mobile').val('center').change();
        $(document).find("#ays_poll_enable_title_text_shadow").prop('checked' , false).change();
        $(document).find('input#ays-poll-icon-size').val('24').change();
        $(document).find('input#ays-poll-width').val('0').change();
        $(document).find('input#ays_poll_width_for_mobile').val('0').change();
        $(document).find('input#ays_poll_min_height').val('').change();
        $(document).find('#ays-poll-border-style').val('ridge').change();
        $(document).find('input#ays-poll-border-radius').val('0').change();
        $(document).find('input#ays-poll-border-width').val('2').change();
        $(document).find("#ays_poll_enable_box_shadow").prop('checked' , false).change();
        $(document).find("#ays-enable-background-gradient").prop('checked' , false).change();
        $(document).find('input#ays_questions_font_size').val('16').change();
        $(document).find('input#ays_poll_answers_font_size_mobile').val('16').change();
        $(document).find('input#ays_poll_question_image_height').val('').change();
        $(document).find('input#ays_poll_question_image_object_fit').val('cover').change();
        $(document).find('input#ays_poll_mobile_max_width').val('').change();
        $(document).find('#ays_buttons_size').val('medium').change();
        $(document).find('input#ays_buttons_font_size').val('17').change();
        $(document).find('input#ays_poll_buttons_mobile_font_size').val('17').change();
        $(document).find('input#ays_buttons_left_right_padding').val('20').change();
        $(document).find('input#ays_buttons_top_bottom_padding').val('10').change();
        $(document).find('input#ays_buttons_border_radius').val('3').change();
        $(document).find('input#ays_poll_buttons_width').val('').change();
        $(document).find("#ays_disable_answer_hover").prop('checked' , false).change();

        $(document).find("#ays-poll-logo-image-remover").trigger('click');
        $(document).find('input#ays_poll_custom_class').val('').change();
        
        setTimeout(function(){
            if($(document).find('#ays_custom_css').length > 0){
                if(wp.codeEditor){
                    $(document).find('#ays_custom_css').next('.CodeMirror').remove();
                    $(document).find('#ays_custom_css').val('');
                    wp.codeEditor.initialize($(document).find('#ays_custom_css'), cm_settings);
                }
            }
        }, 100);

        $(document).find("#tab2").goToNormal();
    });

    $(document).on('mouseover', '.ays-dashicons', function(){
        var allRateStars = $(document).find('.ays-dashicons');
        var index = allRateStars.index(this);
        allRateStars.removeClass('ays-dashicons-star-filled').addClass('ays-dashicons-star-empty');
        for (var i = 0; i <= index; i++) {
            allRateStars.eq(i).removeClass('ays-dashicons-star-empty').addClass('ays-dashicons-star-filled');
        }
    });

    $(document).on('mouseleave', '.ays-rated-link', function(){
        $(document).find('.ays-dashicons').removeClass('ays-dashicons-star-filled').addClass('ays-dashicons-star-empty');                
    });

    var aysPollListTables = $(document).find('#wpcontent #wpbody div.wrap.ays-poll-list-table');

    if ( aysPollListTables.length > 0) {
        var listTableClass = "";
        var searchBox = "";
        if( aysPollListTables.hasClass('ays_polls_list_table') ){
            listTableClass = 'ays_polls_list_table';
            searchBox = 'poll-maker-ays-search-input';            
        } 
        else if( aysPollListTables.hasClass('ays_poll_categories_list_table') ){
            listTableClass = 'ays_poll_categories_list_table';
            searchBox = 'poll-maker-ays-search-input';
        }        
        else if( aysPollListTables.hasClass('ays_poll_results_list_table') ){
            listTableClass = 'ays_polls_each_results_list_table';
            searchBox = 'poll-maker-ays-search-input';
        }        

        if( listTableClass != "" && searchBox != "" ){
            ays_poll_search_box_pagination(listTableClass, searchBox);
        }
    }

    // Select message vars galleries page | Start
    $(document).find('.ays-poll-message-vars-icon').on('click', function(e){
        $(this).parents(".ays-poll-message-vars-box").find(".ays-poll-message-vars-data").toggle('fast');
    });
    
    $(document).on( "click" , function(e){
        if($(e.target).closest('.ays-poll-message-vars-box').length != 0){
        } 
        else{
            $(document).find(".ays-poll-message-vars-box .ays-poll-message-vars-data").hide('fast');
        }
    });

    $(document).find('.ays-poll-message-vars-each-data').on('click', function(e){
        var _this  = $(this);
        var parent = _this.parents('.ays-poll-desc-message-vars-parent');

        var textarea   = parent.find('textarea.ays-textarea');
        var textareaID = textarea.attr('id');

        var messageVar = _this.find(".ays-poll-message-vars-each-var").val();
        
        if ( parent.find("#wp-"+ textareaID +"-wrap").hasClass("tmce-active") ){
            window.tinyMCE.get(textareaID).setContent( window.tinyMCE.get(textareaID).getContent() + messageVar + " " );
        }else{
            $(document).find('#'+textareaID).append( " " + messageVar + " ");
        }
    });
    /* Select message vars galleries page | End */

    // Initialize select2 for country selection dropdown
    $(document).ready(function($){
        $('#ays_poll_limit_countrys').select2({
            placeholder: 'Select countries',
            multiple: true,
            width: '100%'
        });
    });
    
    // ==== ====

})(jQuery);

function selectElementContents(el) {
    if (window.getSelection && document.createRange) {
        var _this = jQuery(document).find('strong.ays-poll-shortcode-box');
        var text      = el.textContent;
        var textField = document.createElement('textarea');

        textField.innerText = text;
        document.body.appendChild(textField);
        textField.select();
        document.execCommand('copy');
        textField.remove();
        var sel = window.getSelection();
        var range = document.createRange();
        range.selectNodeContents(el);
        sel.removeAllRanges();
        sel.addRange(range);
        _this.attr( "data-original-title", pollLangObj.copied );
        _this.attr( "title", pollLangObj.copied );
        _this.tooltip("show");
    } else if (document.selection && document.body.createTextRange) {
        var textRange = document.body.createTextRange();
        textRange.moveToElementText(el);
        textRange.select();
    }
}

// Answers chart tab chart 
function drawBasic() {
    if(typeof pollAnswerChartObj != "undefined"){
        var data = google.visualization.arrayToDataTable(pollAnswerChartObj.answerData);
        var rowCount = data.getNumberOfRows();
        var multiply;
        if(rowCount < 8){
            multiply = 40;
        }
        else{
            multiply = 30;
        }
        var chartAreaHeight = rowCount * multiply;
        var chartHeight = chartAreaHeight + 80;
        /* === Old type === */
        // var options = {
        //     title: pollAnswerChartObj.pollTitle,
        //     width: '100%',
        //     fontSize: 15,
        //     height: chartHeight,
        //     chartArea: { 
        //         width: '75%',
        //         height: '75%'
        //     },
        //     hAxis: {
        //     minValue: 0
        //     }
        // };

        /* === New type === */
        var options = {
            title: pollAnswerChartObj.pollTitle,
            width: '100%',
            height: chartHeight,
            fontSize: 15,
            chartArea: { 
                width: '50%',
                height: '80%'
            },
            hAxis: {
                minValue: 0
            },
            annotations: {
                alwaysOutside: true
            },
            bars: 'horizontal',
            bar: { groupWidth: "50%" }
        };

        

        var chart = new google.visualization.BarChart(document.getElementById('ays_poll_answer_chart'));

        chart.draw(data, options);
        resizeChart(chart, data, options);
    }

    function resizeChart(chart, data, options){
    
        //create trigger to resizeEnd event     
        jQuery(window).resize(function() {
            if(this.resizeTO) clearTimeout(this.resizeTO);
            this.resizeTO = setTimeout(function() {
                jQuery(this).trigger('resizeEnd');
            }, 100);
        });
    
        //redraw graph when window resize is completed  
        jQuery(window).on('resizeEnd', function() {
            chart.draw(data, options);
        });
    }
    
}

