<?php
$action   = (isset($_GET['action'])) ? sanitize_text_field($_GET['action']) : '';
$heading  = '';
$loader_iamge = '';
$id       = (isset($_GET['poll_category'])) ? absint(intval($_GET['poll_category'])) : null;
// ==== ADDED NEW ====
$default_message = 'The polls that belong to this category are expired or unpublished';
// ==== ====
$category = array(
	'id'          => '',
	'title'       => '',
	'description' => '',
	'options'     => json_encode(array(
		'allow_skip' => 'allow',
		'next_text'  => 'Next',
        'allow_autonext' => 'off',
        'exp_message' => $default_message,
	)),
);
switch ( $action ) {
	case 'add':
		$heading = __('Add new category', "poll-maker");
		break;
	case 'edit':
		$heading  = __('Edit category', "poll-maker");
		$category = $this->cats_obj->get_poll_category($id);
		break;
}

$settings_options = $this->settings_obj->ays_get_setting('options');
if($settings_options){
    $settings_options = json_decode($settings_options, true);
}else{
    $settings_options = array();
}

$loader_iamge = "<span class='display_none'><img src=".POLL_MAKER_AYS_ADMIN_URL."/images/loaders/loading.gif></span>";
$cat_opt = isset($category['options']) && $category['options'] != '' ? json_decode($category['options'], true) : array();
if (isset($_POST['ays_submit'])) {
	$this->cats_obj->add_edit_poll_category($_POST, $id);
} elseif (isset($_POST['ays_apply'])) {
	$this->cats_obj->add_edit_poll_category($_POST, $id, "apply");
}
// ==== ADDED NEW ====

// Category expired message
$exp_message = (isset($cat_opt['exp_message']) && $cat_opt['exp_message'] != '') ? stripslashes($cat_opt['exp_message']) : $default_message;
// ==== ====

// Previous Button Disabel 
$poll_disable_prev = isset($cat_opt['poll_disable_prev']) && $cat_opt['poll_disable_prev'] == 'on' ? 'checked' : ''; 

// WP Editor height
$poll_wp_editor_height = (isset($settings_options['poll_wp_editor_height']) && $settings_options['poll_wp_editor_height'] != '') ? absint( sanitize_text_field($settings_options['poll_wp_editor_height']) ) : 100 ;

// $next_poll_cat_id = "";
// if ( isset( $id ) && !is_null( $id ) ) {
//     $next_poll_cat_data = $this->get_next_or_prev_row_by_id( $id, "next", "ayspoll_categories" );
//     $next_poll_cat_id = (isset( $next_poll_cat_data['id'] ) && $next_poll_cat_data['id'] != "") ? absint( $next_poll_cat_data['id'] ) : null;
// }

// $prev_poll_cat_id = "";
// if ( isset( $id ) && !is_null( $id ) ) {
//     $prev_poll_cat_data = $this->get_next_or_prev_row_by_id( $id, "prev", "ayspoll_categories" );
//     $prev_poll_cat_id = (isset( $prev_poll_cat_data['id'] ) && $prev_poll_cat_data['id'] != "") ? absint( $prev_poll_cat_data['id'] ) : null;
// }

?>
<div class="wrap">
    <div class="container-fluid">
        <div class="ays-poll-heading-box">
            <div class="ays-poll-wordpress-user-manual-box">
                <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank" style="text-decoration: none;font-size: 13px;">
                    <i class="ays_poll_fas ays_fa_file_text"></i>
                    <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "poll-maker"); ?></span>
                </a>
            </div>
        </div>
        <h1><?= $heading; ?></h1>
        <?php if(isset($id)): ?>
        <hr/>
        <div class="row">
            <div class="col-sm-3">
                <label> <?php echo __( "Shortcode text for editor", "poll-maker" ); ?> </label>
            </div>
            <div class="col-sm-9">
                <p style="font-size:14px; font-style:italic;">
                    <?php echo __("To insert the Category into a page, post or text widget, copy shortcode", "poll-maker"); ?>
                    <strong class="ays-poll-shortcode-box" data-toggle="tooltip" title="<?php echo __('Click for copy.',"poll-maker");?>" onClick="selectElementContents(this)" style="font-size:16px; font-style:normal;"><?php echo "[ays_poll cat_id=".$id."]"; ?></strong>
                    <?php echo " " . __( "and paste it at the desired place in the editor.", "poll-maker"); ?>
                </p>
            </div>
        </div>
        <?php endif; ?>
        <hr/>
        <form class="ays-poll-category-form" id="ays-poll-category-form" method="post">
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-title'><?= __('Title', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Write the name of the category.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input class='ays-text-input ays-text-input-short' id='ays-title' name='ays_title' required
                           type='text' value='<?= stripslashes($category['title']); ?>'>
                </div>
            </div>
            <hr>
            <div class='ays-field'>
                <label for='ays-description'><?= __('Description', "poll-maker"); ?>
                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Provide more information about the poll category.", "poll-maker"); ?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                    </a>
                </label>
				<?php
				$content = stripslashes($category['description']);
				$editor_id = 'ays-description';
				$settings  = array(
					'editor_height' => $poll_wp_editor_height,
					'textarea_name' => 'ays_description',
					'editor_class'  => 'ays-textarea',
					'media_buttons' => false
				);
				wp_editor($content, $editor_id, $settings);
				?>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-poll-skip'><?= __('Allow to skip polls', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __("If this option is enabled, the “Next” button will be available and the user can skip the poll and go forward.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="checkbox" name="ays_poll_allow_skip" id="ays-poll-skip"
                           value="allow" <?= isset($cat_opt['allow_skip']) && $cat_opt['allow_skip'] == 'allow' ? 'checked' : ''; ?>>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays_poll_next_text'><?= __('Next button text', "poll-maker"); ?><a
                                class="ays_help" data-toggle="tooltip" data-placement="top"
                                title="<?= __("Write your preferred text for the “Next” button.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a></label>
                </div>
                <div class="col-sm-9">
                    <input class='ays-text-input ays-text-input-short' id='ays_poll_next_text' name='ays_poll_next_text'
                           required type='text'
                           value='<?= empty($cat_opt['next_text']) ? 'Next' : $cat_opt['next_text']; ?>'>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays_poll_previous_text'><?= __('Previous button text', "poll-maker"); ?><a
                                class="ays_help" data-toggle="tooltip" data-placement="top"
                                title="<?= __("Write your preferred text for the “Previous” button.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a></label>
                </div>
                <div class="col-sm-9">
                    <input class='ays-text-input ays-text-input-short' id='ays_poll_previous_text' name='ays_poll_previous_text'
                           required type='text'
                           value='<?= empty($cat_opt['previous_text']) ? 'Previous' : $cat_opt['previous_text']; ?>'>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-poll-autonext'><?= __('Autonext', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __("After enabling the option, the user will automatically move to next poll after selecting their chosen option.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="checkbox" name="ays_poll_allow_autonext" id="ays-poll-autonext" value="on" <?= isset($cat_opt['allow_autonext']) && $cat_opt['allow_autonext'] == 'on' ? 'checked' : ''; ?>>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays_poll_cat_message'><?= __('Message when no active polls found', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __('The message will appear when all polls with this category are expired or unpublished.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <?php
                    $exp_message_content = $exp_message;
                    $editor_id = 'ays_poll_cat_message';
                    $settings  = array(
                        'editor_height' => $poll_wp_editor_height,
                        'textarea_name' => 'ays_poll_cat_message',   
                        'editor_class'  => 'ays-textarea',
                        'media_buttons' => false
                    );
                    wp_editor($exp_message_content, $editor_id, $settings);
                    ?>
                    <!-- <input class='ays-text-input ays-text-input-short' id='ays_poll_cat_message' name='ays_poll_cat_message' type='text' value='<?php echo $exp_message; ?>'> -->
                </div>
            </div><!-- Poll expired message -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays_poll_disable_prev_button'><?= __('Disable previous button', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __('Activate the option if you want to disable the previous button.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input id='ays_poll_disable_prev_button' name='ays_poll_disable_prev_button' type='checkbox' value='on' <?php echo $poll_disable_prev?>>
                </div>
            </div><!-- Disable Previous Button -->
            <hr>
            <div class="form-group row ays-poll-button-box">
                <div class="col-sm-8 ays-poll-button-first-row" style="padding: 0;">
                    <?php
                    wp_nonce_field('poll_category_action', 'poll_category_action');
                    $other_attributes_save = array();
                    submit_button(__('Save Category', "poll-maker"), 'primary ays-button ays-loader-banner ays-apply-all', 'ays_submit', false, $other_attributes_save);

                    $other_attributes_apply = array(
                        'id' => 'ays-apply',
                        'title' => 'Ctrl + s',
                        'data-toggle' => 'tooltip',
                        'data-delay'=> '{"show":"1000"}'
                    );

                    submit_button(__('Apply Category', "poll-maker"), 'ays-button ays-loader-banner ays-apply-all', 'ays_apply', false, $other_attributes_apply);
                    echo $loader_iamge;
                    ?>
                </div>
                <!-- <div class="col-sm-4 ays-poll-button-second-row">
                    <?php
                        // if ( $next_poll_cat_id != "" && !is_null( $next_poll_cat_id ) ) {
                        //     $other_attributes = array(
                        //         'id' => 'ays-poll-category-next-button',
                        //         'data-message' => __( 'Are you sure you want to go to the next poll category page?', $this->plugin_name),
                        //         'href' => sprintf( '?page=%s&action=%s&poll_category=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $next_poll_cat_id ) )
                        //     );
                        //     submit_button(__('Next Poll Category', $this->plugin_name), 'button button-primary ays-poll-next-prev-button-class ays-button', 'ays_poll_category_next_button', false, $other_attributes);
                        // }
                    ?>
                    <?php
                        // if ( $prev_poll_cat_id != "" && !is_null( $prev_poll_cat_id ) ) {

                        //     $other_attributes = array(
                        //         'id' => 'ays-poll-category-prev-button',
                        //         'data-message' => __( 'Are you sure you want to go to the previous poll category page?', $this->plugin_name),
                        //         'href' => sprintf( '?page=%s&action=%s&poll_category=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $prev_poll_cat_id ) )
                        //     );
                        //     submit_button(__('Previous Poll Category', $this->plugin_name), 'button button-primary ays-poll-next-prev-button-class ays-button', 'ays_poll_category_prev_button', false, $other_attributes);
                        // }
                    ?>
                </div> -->
            </div>
        </form>
    </div>
</div>