<?php
$action         = (isset($_GET['action'])) ? sanitize_text_field($_GET['action']) : '';
$heading        = '';
$loader_iamge   = '';
$id             = (isset($_GET['poll_formfield'])) ? absint(intval($_GET['poll_formfield'])) : null;
$poll_formfield = [
	'id'        => '',
	'name'      => '',
	'type'      => '',
	'published' => '',
    'sendgrid'  => '',
];
switch ( $action ) {
	case 'add':
		$heading     = __('Add new Attribute', "poll-maker");
		$new_slug_id = $this->formfields_obj->get_new_slug_id($id);
		break;
	case 'edit':
		$heading        = __('Edit Attribute', "poll-maker");
		$poll_formfield = $this->formfields_obj->get_formfield_by_id($id);
		break;
}
$loader_iamge = "<span class='display_none'><img src=".POLL_MAKER_AYS_ADMIN_URL."/images/loaders/loading.gif></span>";
if (isset($_POST['ays_submit'])) {
	$result = $this->formfields_obj->add_edit_poll_formfield($_POST, $id);
} elseif (isset($_POST['ays_apply'])) {
	$this->formfields_obj->add_edit_poll_formfield($_POST, $id, "apply");
}

$sendgrid_enabled = false;
$sendgrid_api = $this->settings_obj->ays_get_setting('sendgrid');
$sendgrid          = json_decode($sendgrid_api, true);
$sendgrid_api_key  = isset($sendgrid['apiKey']) ? $sendgrid['apiKey'] : '';
if($sendgrid_api_key != ''){
    $sendgrid_templates = $this->ays_poll_sendgrid_templates($sendgrid_api_key);
    $sendgrid_enabled = array_key_exists('errors', $sendgrid_templates) ? false : true;    
}

// SendGrid subtitution tags 
$poll_formfield_sendgrid = (isset($poll_formfield['sendgrid']) && $poll_formfield['sendgrid'] != '' ) ? stripslashes( htmlentities( $poll_formfield['sendgrid']) ) : '';
?>

<div class="wrap">
    <div class="ays-poll-heading-box">
        <div class="ays-poll-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank" style="text-decoration: none;font-size: 13px;">
                <i class="ays_poll_fas ays_fa_file_text"></i>
                <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "poll-maker"); ?></span>
            </a>
        </div>
    </div>
    <div class="container-fluid">
        <h1><?= $heading; ?></h1>
        <hr/>
        <form class="ays-poll-formfield-form" id="ays-poll-formfield-form" method="post">
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-formfield-name'><?= __('Name', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Write the name of the form custom field.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input class='ays-text-input' id='ays-formfield-name' name='ays_name' required type='text'
                           value='<?= (isset($poll_formfield['name'])) ? stripslashes(htmlentities($poll_formfield['name'])) : ''; ?>'>
                </div>
            </div>

            <hr/>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays-formfield-slug"><?= __('Slug', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('The slug of form custom field. This is an alias of the field.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input class='ays-text-input' id='ays-formfield-slug' name='ays_slug' required readonly type='text'
                           data-new-id='<?= isset($poll_formfield['slug']) ? 0 : $new_slug_id; ?>'
                           value='<?= (isset($poll_formfield['slug'])) ? stripslashes(htmlentities($poll_formfield['slug'])) : "apm_attr_$new_slug_id"; ?>'>
                </div>
            </div>
            <hr/>
            <?php if($sendgrid_enabled) :?>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_sendgrid_subtitution_tags"><?php echo __('SendGrid subtitution tags', "poll-maker"); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __('The name of subtitution for custom field (wirte without lines)', "poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type='text' class='ays-text-input' id='ays_sendgrid_subtitution_tags' name='ays_sendgrid_subtitution_tags' value='<?php echo $poll_formfield_sendgrid; ?>'>
                    </div>
                </div>
                <hr/>
            <?php endif; ?>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays-formfield-type"><?= __('Type', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Choose the type of the custom field.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-3">
                    <select class='ays-select ays-select-search' id='ays-formfield-type'
                            name='ays_poll_formfield_type'>
                        <option value="0" selected disabled><?= __("Select field type", "poll-maker") ?></option>
                        <option value="text" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'text') ? 'selected' : ''; ?>><?= __('Text', "poll-maker"); ?></option>
                        <option value="textarea" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'textarea') ? 'selected' : ''; ?>><?= __('Textarea', "poll-maker"); ?></option>
                        <option value="email" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'email') ? 'selected' : ''; ?>><?= __('E-Mail', "poll-maker"); ?></option>
                        <option value="number" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'number') ? 'selected' : ''; ?>><?= __('Number', "poll-maker"); ?></option>
                        <option value="tel" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'tel') ? 'selected' : ''; ?>><?= __('Telephone', "poll-maker"); ?></option>
                        <option value="url" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'url') ? 'selected' : ''; ?>><?= __('URL', "poll-maker"); ?></option>
                        <option value="select" <?php echo (isset($poll_formfield['type']) && $poll_formfield['type'] == 'select' ) ? 'selected' : '' ; ?>><?php echo __('Select', "poll-maker"); ?></option>
                        <option value="date" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'date') ? 'selected' : ''; ?>><?= __('Date', "poll-maker"); ?></option>
                        <option value="color" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'color') ? 'selected' : ''; ?>><?= __('Color', "poll-maker"); ?></option>
                        <option value="checkbox" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'checkbox') ? 'selected' : ''; ?>><?= __('Checkbox', "poll-maker"); ?></option>
                    </select>
                </div>
                <div class="col-sm-6 ays_attr_options" <?php echo (!isset($poll_formfield['type']) || $poll_formfield['type'] != "select") ? 'style="display:none"' : ''; ?>>    <div class="form-group row">
                        <div class="col-sm-2">
                            <label for="ays_poll_attr_option"><?php echo __('Options', "poll-maker"); ?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Please write your options separated by example: Red; Blue; Green',"poll-maker")?>">
                                <i class="ays_fa ays_fa_info_circle"></i>
                            </a>
                            </label>
                        </div>
                        <div class="col-sm-10">
                            <input type="text" name="ays_poll_attr_options" id="ays_poll_attr_option" class="ays-text-input" value="<?php echo (isset($poll_formfield['options']) && $poll_formfield['type'] == "select") ? stripslashes(htmlentities($poll_formfield['options'])) : ''; ?>" placeholder="Red; Blue; Green">
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 ays_attr_description" <?php echo (!isset($poll_formfield['type']) || $poll_formfield['type'] != "checkbox") ? 'style="display:none"' : ''; ?> >
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_poll_attr_option">Description                       
                            <a class="ays_help" data-toggle="tooltip" title="" data-original-title="Please write any text, email or link">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="text" name="ays_poll_attr_description" id="ays_poll_attr_option" class="ays-text-input" value="<?php echo (isset($poll_formfield['options']) && $poll_formfield['type'] == "checkbox") ? stripslashes($poll_formfield['options']) : ''; ?>" placeholder="Accept <a href='#'>Terms</a>">
                        </div>
                    </div>
                </div>
            </div>
            <hr/>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label><?= __('Custom field status', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Choose whether the custom field is active or not. If you choose an unpublished option, the field won’t be shown in the Information Form. (You do not need to remove it from the given poll(s)).', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>

                <div class="col-sm-9">
                    <div class="form-check form-check-inline">
                        <input type="radio" id="ays-publish" name="ays_publish"
                               value="1" <?= ($poll_formfield["published"] == '') ? "checked" : ""; ?> <?= ($poll_formfield['published'] == '1') ? 'checked' : ''; ?> />
                        <label class="form-check-label"
                               for="ays-publish"> <?= __('Published', "poll-maker"); ?> </label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio" id="ays-unpublish" name="ays_publish"
                               value="0" <?= ($poll_formfield['published'] == '0') ? 'checked' : ''; ?> />
                        <label class="form-check-label"
                               for="ays-unpublish"> <?= __('Unpublished', "poll-maker"); ?> </label>
                    </div>
                </div>
            </div>
            <hr/>

			<?php
			wp_nonce_field('poll_formfield_action', 'poll_formfield_action');
			$other_formfields_save = array();
			submit_button(__('Save Attribute', "poll-maker"), 'primary ays-button ays-loader-banner', 'ays_submit', false, $other_formfields_save);
			$other_formfields_apply = array(
                'id' => 'ays_apply',
                'title' => 'Ctrl + s',
                'data-toggle' => 'tooltip',
                'data-delay'=> '{"show":"1000"}'
            );
			// if ($id != null) {
				submit_button(__('Apply Attribute', "poll-maker"), 'ays-button ays-loader-banner ays-apply-all', 'ays_apply', false, $other_formfields_apply);
			// }
            echo $loader_iamge;
			?>
        </form>
    </div>
</div>