<div id="tab1" class="ays-poll-tab-content <?= $active_tab == 'tab1' ? 'ays-poll-tab-content-active' : ''; ?>">
    <div class="col-sm-12" style="padding-left:0;display:flex;justify-content:space-between;">
        <p class="ays-subtitle" style="margin-bottom:0;">
            <?= __('General options', "poll-maker"); ?>
        </p>
        <?php if ($poll_main_url != ''): ?>
            <div class="d-flex align-items-end justify-content-end" style="margin-top: 15px;">
                <a data-toggle="tooltip" title="<?php echo esc_attr__("After clicking on the View button you will be redirected to the particular poll link.", "poll-maker");?>" href="<?php echo $poll_main_url != '' ? esc_url($poll_main_url) : 'javascript:void(0)'; ?>" target="<?php echo $poll_main_url != '' ? '_blank' : ''; ?>" type="button" class="button button-primary" style="margin-right: 12px;">
                    <i class="fa fa-eye" aria-hidden="true"></i>
                    <span style="margin-left: 5px;"><?php echo __( 'View', "easy-form" ); ?></span>
                </a>
            </div>
        <?php endif; ?>
    </div>
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='ays-poll-title'>
                <?= __('Title', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Define a name for your poll which will be shown as a headline inside the poll.", "poll-maker"); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a></label>
        </div>
        <div class="col-sm-9 ays_divider_left">
            <input type="text" class="ays-text-input" id='ays-poll-title' name='ays-poll-title'
                   data-required="true" value="<?= stripslashes(htmlentities($poll['title'])); ?>"/>
        </div>
    </div> <!-- Title -->
    <hr>
    <div class='form-group row' style="display:none">
        <div class="col-sm-3">
            <label for='ays-poll-description'>
                <?= __('Description', "poll-maker"); ?></label>
        </div>
        <div class="col-sm-9">
            <textarea class="ays-textarea" name="ays-poll-description" id="ays-poll-description" cols="30"
                      rows="10">
                <?= stripslashes($poll['description']); ?>
            </textarea>
        </div>
    </div> <!-- Description -->
    <div class="form-group row" style="display: flex;">
        <div class="col-sm-3">
            <label for='ays-poll-question'>
                <?= __('Question', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Write the main content/question, which will be shown inside the poll.", "poll-maker"); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
                <a href="javascript:void(0)" class="add-question-image button">
                    <?= $image_text; ?>
                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Add an image to the question.", "poll-maker"); ?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                    </a>
                </a>
            </label>
            <div class="ays-poll-question-image-container" style="<?= $style; ?>">
                <span class="ays-remove-question-img"></span>
                <img src="<?= $poll['image']; ?>" id="ays-poll-img"/>
                <input type="hidden" name="ays_poll_image" id="ays-poll-image" value="<?= $poll['image']; ?>"/>
            </div>
        </div>
        <div class="col-sm-9">
            <?php
            $content   = stripslashes($poll["question"]);
            $editor_id = 'ays-poll-question';
            $settings  = array(
                'editor_height' => $poll_wp_editor_height,
                'textarea_name' => 'ays_poll_question',
                'editor_class'  => 'ays-textarea',
                'media_buttons' => true,
                'tinymce'       => array(
                    "init_instance_callback" => "function(editor) {
                        editor.on('Change', function(e) {
                            document.querySelector('.box-apm .ays_question').innerHTML = e.level.content;
                        });
                    }",
                )
            );
            wp_editor($content, $editor_id, $settings);
            ?>
        </div>
    </div> <!-- Question -->
    <hr class="ays_hr_check">
    <div class="form-group row if-choosing apm-poll-type" style="display: <?php echo ($poll['type'] == 'choosing') ? 'flex' : 'none' ?>">
        <div class="col-sm-3">
                <label for="ays-poll-answer" >
                <?php echo __('Options', "poll-maker")?>
            </label>
        </div>
        <div class="col-sm-9">
            <div style="display:flex;justify-content:space-between;">
                <div class='add-option-top-container'>
                    <a class="ays-add-answer ays-click-once" id='add-answer'>
                        <img src= "<?php echo (POLL_MAKER_AYS_ADMIN_URL . '/images/icons/plus.svg') ?>" class='plus-sign'>
                        <span>Add Option</span>
                    </a>
                </div>
                <div style="display: flex;gap:10px;">
                    <div id="ays_answer_import_message"></div>
                    <div style="text-align:right;">
                        <div style="display: flex; justify-content: space-around; width: 140px;">
                            <div>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Please import a CSV file. Note that the system will take the first column of the imported file.',"poll-maker")?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </div>
                            <div>
                                <input type="file" name="ays_poll_import_answers" id="ays_poll_import_answers" accept=".csv" style="display: none;">
                                <label for="ays_poll_import_answers" class="ays_add_answer_label"><?php echo __("Import Options" , "poll-maker") ?>
                                </label>
                            </div>
                        </div>
                        <span class="ays_add_answer_loader display_none"><img src='<?php echo POLL_MAKER_AYS_ADMIN_URL."/images/loaders/loading.gif"; ?>'></span>
                    </div>
                </div>
            </div> <!-- Options Button -->
            <div class="if-choosing apm-poll-type ays-poll-answers-table-scroll-mobile">
                <table class="ays-answers-table" id="ays-answers-table" ays_default_count="<?php echo 2; ?>">
                    <thead>
                        <tr class="ui-state-default">
                            <th class="th-150"><?php echo __('Ordering', "poll-maker"); ?></th>
                            <th style="width: 100vw;"><?php echo __('Option', "poll-maker"); ?></th>
                            <th class="th-350 ays-answer-redirect-row <?php echo ($redirect_after_submit) ? '' : 'ays_poll_display_none'; ?>"><?php echo __('Redirect URL', "poll-maker"); ?></th>
                            <th class="th-350 ays-f-votes-row <?php echo ($fake_votes_check) ? '' : 'ays_poll_display_none'; ?>"><?php echo __('Fake Votes', "poll-maker"); ?></th>
                            <th class="th-150 only_pro"><?php echo __('Image', "poll-maker"); ?></th>
                            <th class="th-150"><?php echo __('Delete', "poll-maker"); ?></th>
                        </tr>
                    </thead>
                    <tbody class="">
                    <?php 
                    $answers = $poll['answers'];
                    $answers_count = (! empty($answers) ) ? count($answers) : $answer_default_count;
                    $answer_votes = 0;
                    $loop_iteration = 0;
                    $rows_count = count($answers);
                    $ays_key_enter = "";
                    $user_add_html = '';
                    if (count($answers) > 0  && $poll['type'] == 'choosing') :
                        foreach ($answers as $index => $answer) {
                            $user_add_html = '';
                            $class = (($index + 1) % 2 == 0) ? "even" : "";
                            $answer_val = stripslashes(htmlentities($answer["answer"]));
                            $answer_id  = $answer["id"];
                            $answer_redirect  = $answer['redirect'];
                            $answer_votes     = isset($answer['fake_votes']) && $answer['fake_votes'] != '' ? intval($answer['fake_votes']) : 0;
                            $answer_img  = (is_null($answer['answer_img']) || $answer['answer_img'] == '') ? '' : $answer['answer_img'];
                            $answer_img_class  = (is_null($answer['answer_img']) || $answer['answer_img'] == '') ? 'display:none;' : 'display:block';
                            $user_added = (isset($answer['user_added']) && $answer['user_added'] == 1) ? true : false;
                            $show_user_added = (isset($answer['show_user_added']) && $answer['show_user_added'] == 1) ? true : false;

                            if ($allow_custom_answer && $require_admin_approval) {
                                $disable_show_user_added = '';
                            }else{
                                $disable_show_user_added = 'display: none;';
                            }
                        

                            $show_user_added_checkbox = '';
                            if ($show_user_added == 1) {
                                $show_user_added_checkbox = 'checked';
                            }
                            if ( $user_added ) { 
                                $user_add_html = '<input type="checkbox" class="ays_show_user_added" style="'. $disable_show_user_added .'" title="Show up on the poll" '. $show_user_added_checkbox .' />';
                            }

                            if(isset($answer['show_user_added']) && $answer['show_user_added'] == 1){
                                $check_show_user_added = "1";
                            }elseif (isset($answer['show_user_added']) && $answer['show_user_added'] == 0) {
                                $check_show_user_added = "0";
                            }else{
                                $check_show_user_added = "1";
                            }

                            if($loop_iteration == $rows_count - 1){
                                $ays_key_enter = "ays_poll_enter_key";
                            }
                            $loop_iteration++;
                            ?>
                            <tr class="ays-answer-row ui-state-default <?php echo $class; ?>">
                                <td class="ays-sort">
                                    <div class='ays_poll_move_arrows'></div>
                                </td>
                                <td>
                                    <div class="ays_poll_display_flex">
                                        <input type="hidden" class="<?php echo ( $user_added ) ? 'ays_show_user_added_hid' : ''; ?>" name="ays_poll_show_user_added[]" value="<?= $check_show_user_added ?>" />
                                        <input type="text" class="ays-text-input ays-answer-value <?php echo $ays_key_enter;?>" name="ays-poll-answers[]" data-id="<?php echo $index;?>" value="<?php echo esc_html($answer_val); ?>">
                                        <?php echo $user_add_html; ?>
                                        <input type="hidden" name="ays-poll-answers-ids[]" data-id="<?php echo $index;?>" value="<?php echo $answer_id; ?>">
                                    </div>
                                </td>
                                <td class="ays-answer-redirect-row <?php echo ($redirect_after_submit) ? '' : 'ays_poll_display_none'; ?>">
                                    <input type="text" class="ays-text-input ays_redirect_active" id="ays_submit_redirect_url_<?php echo $answer_id; ?>" name="ays_submit_redirect_url[]" value="<?php echo "$answer_redirect"; ?>"/>
                                </td>
                                <td class="ays-f-votes-row <?php echo ($fake_votes_check) ? '' : 'ays_poll_display_none'; ?>">
                                    <input type="number" class="ays-text-input ays_f_votes_active" id="ays_f_votes_count_<?php echo $answer_id; ?>" name="ays_f_votes_count[]" value="<?php echo $answer_votes; ?>"/>
                                </td>
                                <td>
                                    <label class='ays-label' for='ays-answer' style="<?php echo ($answer_img == '') ? 'display:inline-block;' : 'display:none'; ?>">
                                        <a class="add-answer-image add-answer-image-icon" style="<?php echo ($answer_img == '') ? 'display:block;' : 'display:none'; ?>"></a>
                                    </label>
                                    <div class="ays-answer-image-container" style="<?php echo $answer_img_class; ?>">
                                        <span class="ays-remove-answer-img"></span>
                                        <img src="<?php echo $answer_img; ?>" class="ays-answer-img"/>
                                        <input type="hidden" name="apm-answers-images[]" class="ays-answer-image-path" value="<?php echo $answer_img; ?>"/>
                                    </div>
                                </td>
                                <td>
                                    <a href="javascript:void(0)" class="ays-delete-answer" data-id="<?php echo $index;?>" data-lid="<?php echo $index;?>">
                                    </a>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    <?php
                    else:
                        for ($dac_i=1; $dac_i <= intval($answer_default_count); $dac_i++) :
                            $ays_even_or_not =  ($dac_i%2 !=0) ? 'even' : '';
                            if($loop_iteration == intval($answer_default_count) - 1){
                                $ays_key_enter = "ays_poll_enter_key";
                            }
                            $loop_iteration++;
                        ?>
                        <tr class="ays-answer-row ui-state-default <?php echo $ays_even_or_not; ?>">
                            <td class="ays-sort"><i class="ays_poll_fas ays_poll_fa_arrows" aria-hidden="true"></i></td>
                            <td>
                                <div class="ays_poll_display_flex">
                                    <input type="text" class="ays-text-input ays-answer-value <?php echo $ays_key_enter;?>" name="ays-poll-answers[]" data-id="<?php echo $dac_i;?>" value="<?= __("Option", "poll-maker") . " " . $dac_i; ?>">
                                    <?php echo $user_add_html; ?>
                                    <input type="hidden" name="ays-poll-answers-ids[]" data-id="<?php echo $dac_i;?>" value="0">
                                </div>
                            </td>
                            <td class="ays-answer-redirect-row <?php echo ($redirect_after_submit) ? '' : 'ays_poll_display_none'; ?>">
                                <input type="text" class="ays-text-input ays_redirect_active" id="ays_submit_redirect_url_<?php echo $dac_i; ?>" name="ays_submit_redirect_url[]" value=""/>
                            </td>
                            <td class="ays-f-votes-row <?php echo ($fake_votes_check) ? '' : 'ays_poll_display_none'; ?>">
                                <input type="number" class="ays-text-input ays_f_votes_active" id="ays_f_votes_count_<?php echo $dac_i; ?>" name="ays_f_votes_count[]" value="0"/>
                            </td>
                            <td title="<?php echo __( 'This property aviable only in pro version', "poll-maker" ); ?>">
                                <label class='ays-label' for='ays-answer'>
                                    <a style="" class="add-answer-image" style="display:block;"><?php echo __('Add',"poll-maker"); ?></a>
                                </label>
                                <div class="ays-answer-image-container ays-answer-image-container-div" style="display:none;">
                                    <span class="ays-remove-answer-img"></span>
                                    <img src="" class="ays-answer-img"/>
                                    <input type="hidden" name="apm-answers-images[]" class="ays-answer-image-path" value=""/>
                                </div>
                            </td>

                            <td>
                                <a href="javascript:void(0)" class="ays-delete-answer"></a>
                            </td>
                        </tr>
                        <?php
                        endfor;
                    endif;
                    ?>
                    </tbody>
                </table>                        
                <input type="hidden" id="ays_poll_answers_count" value="<?php echo $answers_count ?>">
            </div> <!-- Options Choosing Table -->
            <div class="if-choosing apm-poll-type ays-answers-toolbar-bottom" >
                <div class='add-option-top-container'>
                    <a class="ays-add-answer ays-click-once" id='add-answer'>
                        <img src= "<?php echo (POLL_MAKER_AYS_ADMIN_URL . '/images/icons/plus.svg') ?>" class='plus-sign'>
                        <span>Add Option</span>
                    </a>
                </div>
            </div> <!-- Options Button -->
        </div>
    </div>
    <hr class="if-choosing" style="display: <?php echo ($poll['type'] == 'choosing') ? 'flex' : 'none' ?>">
    <div class="if-choosing form-group row" style="display: <?php echo ($poll['type'] == 'choosing') ? 'flex' : 'none' ?>">
        <div class="col-sm-3">
            <label for="ays-poll-answer" >
                <?php echo __('Option Settings', "poll-maker")?>
            </label>
        </div>
        <div class="col-sm-9">
            <div class="if-choosing apm-poll-type poll-type-block form-group row ays-poll-type-block" >
                <div class="col-sm-12">
                    <div class="form-group row">
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1 ays_toggle_checkbox" id="ays_redirect_after_submit" name="ays_redirect_after_submit" value="on" <?php echo $redirect_after_submit ? 'checked' : '' ?>/>
                        </div>
                        <div class="col-sm-4 unset-padding-left">
                            <label for="ays_redirect_after_submit" >
                                <?php echo __('Answer Redirection',"poll-maker")?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable redirection to the custom URL(s) after the user votes the poll. Assign different URLs to each answer separately.',"poll-maker")?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="ays_poll_option_only_for_choosing_type" style="display: <?php echo ($poll['type'] == 'choosing') ? 'flex' : 'none' ?>">
            <div class="if-choosing apm-poll-type poll-type-block form-group ays-poll-type-block row ays_toggle_parent">
                <div class="col-sm-12">
                    <div class="form-group row ays_poll_allow_add_answers_flex_container">
                        <div class="col-1">
                            <input type="checkbox" name="apm_allow_add_answers" id="apm_allow_add_answers" class="ays_toggle_checkbox"
                            value="allow" <?= $allow_custom_answer ? 'checked' : ''; ?>>
                        </div>
                        <div class="col-4" style="padding-left:0;">
                            <label for="apm_allow_add_answers">
                                <?= __('Allow custom answer', "poll-maker"); ?>
                                <a class="ays_help" data-toggle="tooltip"
                                data-placement="top"
                                title="<?= __("Allow users to add their custom answer.", "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-7 allow_add_answers_not_show_up_container">
                            <div class="ays_toggle_target" <?= $allow_custom_answer ? '' : 'style="display:none;"'; ?>>
                                <div class="form-group row allow_add_answers_not_show_up ays_toggle_parent">
                                    <div class="col-sm-2 ays_divider_left">
                                        <input type="checkbox" name="add_answers_not_show_up" id="ays_poll_allow_add_answers_not_show_up" class="ays_toggle_checkbox"
                                            value="allow" <?= ($require_admin_approval && $allow_custom_answer) ? '' : 'checked'; ?> />
                                    </div>
                                    <div class="col-sm-10">
                                        <label for="ays_poll_allow_add_answers_not_show_up">
                                            <?= __('Require admin approval', "poll-maker"); ?>
                                            <a class="ays_help" data-toggle="tooltip"
                                            data-placement="top"
                                            title="<?= __("If the option is enabled, the answers added by users will require admin approval to be shown up inside the poll (public).", "poll-maker"); ?>">
                                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                            </a>
                                        </label>
                                    </div>
                                    <?php
                                    $poll_answers = $poll['answers'];
                                    $is_user_added_exist = 0;
                                    foreach ($poll_answers as $index => $answer) {
                                        if($answer['user_added'] == 1) {
                                            $is_user_added_exist++;
                                        }
                                    }
                                    if($is_user_added_exist > 0):
                                    ?>
                                    <div class="col-12 row ays_toggle_target" <?= ($require_admin_approval && $allow_custom_answer) ? 'style="display:none;"' : '' ; ?>>
                                        <div class="col-2 ays_divider_left" style="align-items:center;">
                                            <input type="checkbox" id="ays_poll_require_approve_select_all"/>
                                        </div>
                                        <div class="col-10" style="padding-left:22px;">
                                            <label for="ays_poll_require_approve_select_all">
                                                <?= __('Select all', "poll-maker"); ?>
                                                <a class="ays_help" data-toggle="tooltip"
                                                data-placement="top"
                                                title="<?= __("If the option is enabled, all the custom answers will be ticked in bulk and will be displayed for the poll on the front end.", "poll-maker"); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                    </div>
                                    <?php
                                    endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> <!-- Allow custom answer -->
            <hr class="if-choosing">
            <div class="if-choosing apm-poll-type poll-type-block form-group ays-poll-type-block">
                <div class="col-sm-12" style="padding:0;">
                    <div class="form-group row">
                        <div class="col-sm-1">
                            <input type="checkbox" name="ays_add_f_votes" id="ays_add_f_votes"
                            value="on" <?= $fake_votes ?>>
                        </div>
                        <div class="col-sm-4 unset-padding-left">
                            <label for="ays_add_f_votes">
                                <?= __('Add fake votes', "poll-maker"); ?>
                                <a class="ays_help" data-toggle="tooltip"
                                data-placement="top"
                                title="<?= __("Allow users to add their fake votes to each answer.", "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <hr class="ays_hr_on"/>
    <div class="if-voting apm-poll-type form-group row">
        <div class="col-sm-3">
            <label for="ays-poll-vote-type">
                <?= __('Options', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Select the appearance of the poll.", "poll-maker"); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <select class="ays-select" id="ays-poll-vote-type" name="ays-poll-vote-type">
                <option value='hand' <?= $poll['view_type'] == 'hand' ? "selected" : ""; ?>>
                    <?= __('Hand (Default)', "poll-maker"); ?>
                </option>
                <option value="emoji" <?= $poll['view_type'] == 'emoji' ? "selected" : ""; ?>>
                    <?= __('Emoji', "poll-maker"); ?>
                </option>
            </select>
            <?php switch ( $poll['view_type'] ) {
                case 'hand':
                    $vote_res = 'ays_poll_far ays_poll_fa-thumbs-up';
                    $rate_res = 'ays_poll_fas ays_poll_fa-star';
                    break;
                case 'emoji':
                    $vote_res = 'ays_poll_fas ays_poll_fa-smile';
                    $rate_res = 'ays_poll_fas ays_poll_fa-smile';
                    break;
                case 'star':
                    $rate_res = 'ays_poll_fas ays_poll_fa-star';
                    $vote_res = 'ays_poll_far ays_poll_fa-thumbs-up';
                    break;
                default:
                    $vote_res = 'ays_poll_far ays_poll_fa-thumbs-up';
                    $rate_res = 'ays_poll_fas ays_poll_fa-star';
                    break;
            } ?>
            <i id="vote-res" class="<?= $vote_res; ?>"></i>
        </div>
    </div> <!-- Options voting -->
    <div class="if-rating apm-poll-type form-group row">
        <div class="col-sm-3">
            <label for="ays-poll-rate-type">
                <?= __('Options', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Select the appearance and the scale of assessment of the poll.", "poll-maker"); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a></label>
        </div>
        <div class="col-sm-9">
            <select class="ays-select" id="ays-poll-rate-type" name="ays-poll-rate-type">
                <option value='star' <?= $poll['view_type'] == 'star' ? "selected" : ""; ?>>
                    <?= __('Stars (Default)', "poll-maker"); ?>
                </option>
                <option value="emoji" <?= $poll['view_type'] == 'emoji' ? "selected" : ""; ?>>
                    <?= __('Emoji', "poll-maker"); ?>
                </option>
            </select>
            <select class="ays-select" id="ays-poll-rate-value" name="ays-poll-rate-value">
                <option value="<?= count($poll['answers']); ?>" selected>
                    <?= count($poll['answers']); ?>
                </option>
            </select>
            <i id="rate-res" class="<?= $rate_res; ?>"></i>
        </div>
    </div> <!-- Options Rating -->
    <div class="if-versus apm-poll-type form-group row">
        <div class="col-sm-3">
            <label for="versus-type">
                <?= __('Options', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __("Add the two variants to the poll which need to be compared.", "poll-maker"); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-3 answers-col">
            <?php
            if (count($poll['answers']) > 0 && $poll['type'] == 'versus'):
                $answer_id = 1;
                foreach ( $poll['answers'] as $answer ):?>
                    <div class="form-group">
                        <input type="text" class="ays-text-input ays-text-input-short"
                               name='vs-poll-answers[]'
                               data-id="<?= $answer_id ?>"
                            <?= $answer_id > 2 ? "" : "data-required = \"true\""; ?>
                               value="<?= isset($answer['answer']) ? stripslashes($answer['answer']) : "" ?>">
                        <input type="hidden" data-id="<?= $answer_id ?>" name="vs-poll-answers-ids[]"
                               value="<?= $answer['id'] ?>">
                        <i style="display: inline-block"
                           class="ays_poll_far <?= isset($answer['answer_img']) && !empty($answer['answer_img']) ? "ays_poll_fa-images" : "ays_poll_fa-image"; ?> apm-answer-img"
                           data-id="<?= $answer_id ?>" title="
                    <?= isset($answer['answer_img']) && !empty($answer['answer_img']) ? __("Edit answer image", "poll-maker") : __("Add image for answer", "poll-maker"); ?>">
                            <input type="hidden" class="apm-answers-images" name="vs-answers-images[]"
                                   value="<?= isset($answer['answer_img']) ? $answer['answer_img'] : ''; ?>">
                        </i>
                        <span style="display: <?= isset($answer['answer_img']) && !empty($answer['answer_img']) ? " inline-block" : "none"; ?>"
                              title=" <?= __("Remove answer image", "poll-maker"); ?>"
                              class="apm-remove-answer-bg" data-id="<?= $answer_id ?>">
                        <i class="ays_poll_far ays_poll_fa-image">
                            <i class="ays_poll_fas ays_poll_fa-times"></i>
                        </i>
                    </span>
                    </div>
                    <?php
                    $answer_id++;
                endforeach;
            else:
                ?>
                <div class="form-group">
                    <input type="text" class="ays-text-input ays-text-input-short"
                           name='vs-poll-answers[]' data-id="1"
                           data-required="true"
                           value="">
                    <input type="hidden" data-id="1" name="vs-poll-answers-ids[]"
                           value="0">
                    <i style="display:  inline-block"
                       class="ays_poll_far ays_poll_fa-image apm-answer-img" data-id="1" title="
                    <?= __("Add image for answer", "poll-maker"); ?>">
                        <input type="hidden" class="apm-answers-images" name="vs-answers-images[]"
                               value="">
                    </i>
                    <span style="display: none "
                          title="<?= __("Remove answer image", "poll-maker"); ?>"
                          class="apm-remove-answer-bg" data-id="1">
                        <i class="ays_poll_far ays_poll_fa-image">
                            <i class="ays_poll_fas ays_poll_fa-times"></i>
                        </i>
                    </span>
                </div>
                <div class="form-group">
                    <input type="text" class="ays-text-input ays-text-input-short"
                           name='vs-poll-answers[]' data-id="2"
                           data-required="true"
                           value="">
                    <input type="hidden" data-id="2" name="vs-poll-answers-ids[]"
                           value="0">
                    <i style="display:  inline-block"
                       class="ays_poll_far ays_poll_fa-image apm-answer-img" data-id="2" title="
                    <?= __("Add image for answer", "poll-maker"); ?>">
                        <input type="hidden" class="apm-answers-images" name="vs-answers-images[]"
                               value="">
                    </i>
                    <span style="display: none "
                          title="<?= __("Remove answer image", "poll-maker"); ?>"
                          class="apm-remove-answer-bg" data-id="2">
                        <i class="ays_poll_far ays_poll_fa-image">
                            <i class="ays_poll_fas ays_poll_fa-times"></i>
                        </i>
                    </span>
                </div>
            <?php endif; ?>
            <div class="form-group d-flex justify-content-between align-items-center" style="width: 200px;">
                <label for="versus-show-label">
                    <?= __('Show Labels', "poll-maker"); ?>
                    <a class="ays_help" data-toggle="tooltip" data-placement="top"
                       title="<?= __("If the option is enabled, the titles of the variants will also be shown under the attached images inside the poll.", "poll-maker"); ?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                    </a>
                </label>
                <input type="checkbox" name="versus-show-label" id="versus-show-label"
                       value="show" <?= (isset($options['versus_answers_label']) && $options['versus_answers_label']) ? 'checked' : '' ?>>
            </div>
            <div class="form-group">
                <select class="ays-select" id="versus-type" name="versus-type">
                    <option value="0" selected
                            disabled><?= __("Select versus direction", "poll-maker"); ?></option>
                    <option <?= isset($poll['view_type']) && $poll['view_type'] == "horizontal" ? "selected" : ""; ?>
                            value="horizontal"><?= __("Horizontal (Default)", "poll-maker"); ?></option>
                    <option <?= isset($poll['view_type']) && $poll['view_type'] == "vertical" ? "selected" : ""; ?>
                            value="vertical"><?= __("Vertical", "poll-maker"); ?></option>
                </select>
            </div>
            <div class="form-group">
                <select class="ays-select ays-select-search" id="versus-icon-type" name="versus-icon-type">
                    <option value="0" selected
                            disabled><?= __("Select versus icon", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_type']) && $options['versus_icon_type'] == 'default' ? "selected" : ""; ?>
                            value="default"><?= __("Default", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_type']) && $options['versus_icon_type'] == 'times' ? "selected" : ""; ?>
                            value="times"><?= __("Times", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_type']) && $options['versus_icon_type'] == 'battle' ? "selected" : ""; ?>
                            value="battle"><?= __("Battle", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_type']) && $options['versus_icon_type'] == 'classic' ? "selected" : ""; ?>
                            value="classic"><?= __("Classic", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_type']) && $options['versus_icon_type'] == 'graffiti' ? "selected" : ""; ?>
                            value="graffiti"><?= __("Graffiti", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_type']) && $options['versus_icon_type'] == 'material' ? "selected" : ""; ?>
                            value="material"><?= __("Material", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_type']) && $options['versus_icon_type'] == 'simple' ? "selected" : ""; ?>
                            value="simple"><?= __("Simple", "poll-maker"); ?></option>
                </select>
            </div>
            <div class="form-group">
                <select name="versus-icon-position" id="versus-icon-position"
                        class="ays-select">
                    <option value="0" selected
                            disabled><?= __("Select icon position", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_position']) && $options['versus_icon_position'] == 'start' ? "selected" : "" ?>
                            value="start"><?= __("Start", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_position']) && $options['versus_icon_position'] == 'center' ? "selected" : "" ?>
                            value="center"><?= __("Center (Default)", "poll-maker"); ?></option>
                    <option <?= isset($options['versus_icon_position']) && $options['versus_icon_position'] == 'end' ? "selected" : "" ?>
                            value="end"><?= __("End", "poll-maker"); ?></option>
                </select>
            </div>
        </div>
        <div class="col-sm-6">
            <?php
            $vs_img1     = (isset($poll['answers'][0]['answer_img']) && $poll['type'] == 'versus') ? $poll['answers'][0]['answer_img'] : "";
            $vs_img2     = (isset($poll['answers'][1]['answer_img']) && $poll['type'] == 'versus') ? $poll['answers'][1]['answer_img'] : "";
            $vs_icon_pos = $poll['type'] == 'versus' && isset($options['versus_icon_position']) ? $options['versus_icon_position'] : "";
            ?>
            <div class="versus-images-container d-flex vs-icon-<?= $vs_icon_pos ?> vs-<?= ($poll['type'] == 'versus' && isset($options['versus_icon_type'])) ? $options['versus_icon_type'] : "default" ?> <?= ($poll['type'] == 'versus' && isset($poll['view_type'])) ? $poll['view_type'] : "horizontal" ?>">
                <div style="background-image:url(<?= $vs_img1 ?>); border: <?= $vs_img1 ? "none" : "1px dashed #b4b9be" ?>"
                     id="apm-vs-1" class="versus-image-container"></div>
                <div style="background-image:url(<?= $vs_img2 ?>); border: <?= $vs_img2 ? "none" : "1px dashed #b4b9be" ?>"
                     id="apm-vs-2" class="versus-image-container"></div>
            </div>
        </div>
    </div> <!-- Option Versus -->
    <!-- answer type dropdown start -->
    <div class="if-dropdown apm-poll-type poll-type-block form-group ays-poll-type-block">
        <div class="col-sm-3 ays-poll-type-block">
            <div class="form-group row ays-poll-type-block">
                <label for="ays-poll-answer">
                    <?php echo __('Options', "poll-maker"); ?>
                    <a class="ays-add-answer">
                        <i class="ays_poll_fas ays_poll_fa-plus-square ays-click-once" title="<?= __("Add option", "poll-maker"); ?>" id="add_dropdown_answer_top"></i>
                    </a>
                </label>
            </div>
        </div>
        <div class="col-sm-9">
            <div class="form-group row">
                <div class="col-sm-6">
                    <label for="ays_redirect_after_submit_dropdown" >
                        <?php echo __('Redirect',"poll-maker")?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable redirection to the custom URL(s) after the user votes the poll. Assign different URLs to each answer separately.',"poll-maker")?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-6">
                    <input type="checkbox" class="ays-enable-timer1 ays_toggle_checkbox" id="ays_redirect_after_submit_dropdown" name="ays_redirect_after_submit_dropdown" value="on" <?php echo $redirect_after_submit_dropdown ? 'checked' : '' ?>/>
                </div>
            </div>
        </div>
    </div> <!-- Options Button -->
    <div class="if-dropdown apm-poll-type poll-type-block form-group row ays-poll-type-block">
        <div class="col-sm-12">
            <table class="ays-answers-table" id="ays-dropdown-answers-table" ays_default_count="<?php echo 2; ?>">
                <thead>
                    <tr class="ui-state-default">
                        <th class="th-150"><?php echo __('Ordering', "poll-maker"); ?></th>
                        <th style="width: 100vw;"><?php echo __('Option', "poll-maker"); ?></th>
                        <th class="th-350 ays-answer-redirect-row <?php echo ($redirect_after_submit_dropdown) ? '' : 'ays_poll_display_none'; ?>" ><?php echo __('REDIRECT', "poll-maker"); ?></th>
                        <th class="th-150"><?php echo __('Delete', "poll-maker"); ?></th>
                    </tr>
                </thead>
                <tbody class="">
                <?php 
                $answers = $poll['answers'];
                $answers_count = (! empty($answers) ) ? count($answers) : $answer_default_count;
                $answer_votes = 0;
                $loop_iteration = 0;
                $rows_count = count($answers);
                $ays_key_enter = "";
                $user_add_html = '';
                if (count($answers) > 0  && $poll['type'] == 'dropdown') :
                    foreach ($answers as $index => $answer) {
                        $user_add_html = '';
                        $class = (($index + 1) % 2 == 0) ? "even" : "";
                        $answer_val = stripslashes(htmlentities($answer["answer"]));
                        $answer_id  = $answer["id"];
                        $answer_redirect  = $answer['redirect'];
                        $user_added = (isset($answer['user_added']) && $answer['user_added'] == 1) ? true : false;
                        $show_user_added = (isset($answer['show_user_added']) && $answer['show_user_added'] == 1) ? true : false;

                        if ($allow_custom_answer && $require_admin_approval) {
                            $disable_show_user_added = '';
                        }else{
                            $disable_show_user_added = 'display: none;';
                        }
                    

                        $show_user_added_checkbox = '';
                        if ($show_user_added == 1) {
                            $show_user_added_checkbox = 'checked';
                        }
                        if ( $user_added ) { 
                            $user_add_html = '<input type="checkbox" class="ays_show_user_added" style="'. $disable_show_user_added .'" title="Show up on the poll" '. $show_user_added_checkbox .' />';
                        }

                        if(isset($answer['show_user_added']) && $answer['show_user_added'] == 1){
                            $check_show_user_added = "1";
                        }elseif (isset($answer['show_user_added']) && $answer['show_user_added'] == 0) {
                            $check_show_user_added = "0";
                        }else{
                            $check_show_user_added = "1";
                        }

                        if($loop_iteration == $rows_count - 1){
                            $ays_key_enter = "ays_poll_enter_key";
                        }
                        $loop_iteration++;

                        ?>
                        <tr class="ays-answer-row ui-state-default <?php echo $class; ?>">
                            <td class="ays-sort"><i class="ays_poll_fas ays_poll_fa_arrows" aria-hidden="true"></i></td>
                            <td>
                                <div class="ays_poll_display_flex">
                                    <input type="hidden" class="<?php echo ( $user_added ) ? 'ays_show_user_added_hid' : ''; ?>" name="ays_poll_show_user_added[]" value="<?= $check_show_user_added ?>" />
                                    <input type="text" class="ays-text-input ays-answer-value <?php echo $ays_key_enter;?>" name="ays-poll-answers-dropdown[]" data-id="<?php echo $index;?>" value="<?php echo esc_html($answer_val); ?>">
                                    <?php echo $user_add_html; ?>
                                    <input type="hidden" name="ays-poll-answers-dropdown-ids[]" data-id="<?php echo $index;?>" value="<?php echo $answer_id; ?>">
                                </div>
                            </td>
                            <td class="ays-answer-redirect-row <?php echo ($redirect_after_submit_dropdown) ? '' : 'ays_poll_display_none'; ?>">
                                <input type="text" class="ays-text-input ays_redirect_active" id="ays_dropdown_submit_redirect_url<?php echo $answer_id; ?>" name="ays_dropdown_submit_redirect_url[]" value="<?php echo "$answer_redirect"; ?>"/>
                            </td>
                            <td>
                                <a href="javascript:void(0)" class="ays-delete-answer"></a>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                <?php
                else:
                    for ($dac_i=1; $dac_i <= intval($answer_default_count); $dac_i++) :
                        $ays_even_or_not =  ($dac_i%2 !=0) ? 'even' : '';
                        if($loop_iteration == intval($answer_default_count) - 1){
                            $ays_key_enter = "ays_poll_enter_key";
                        }
                        $loop_iteration++;
                    ?>
                    <tr class="ays-answer-row ui-state-default <?php echo $ays_even_or_not; ?>">
                        <td class="ays-sort"><i class="ays_poll_fas ays_poll_fa_arrows" aria-hidden="true"></i></td>
                        <td>
                            <div class="ays_poll_display_flex">
                                <input type="text" class="ays-text-input ays-answer-value <?php echo $ays_key_enter;?>" name="ays-poll-answers-dropdown[]" data-id="<?php echo $dac_i;?>" value="<?= __("Option", "poll-maker") . " " . $dac_i; ?>">
                                <?php echo $user_add_html; ?>
                                <input type="hidden" name="ays-poll-answers-dropdown-ids[]" data-id="<?php echo $dac_i;?>" value="0">
                            </div>
                        </td>
                        <td class="ays-answer-redirect-row <?php echo ($redirect_after_submit_dropdown) ? '' : 'ays_poll_display_none'; ?>">
                            <input type="text" class="ays-text-input ays_redirect_active" id="ays_dropdown_submit_redirect_url_<?php echo $dac_i; ?>" name="ays_dropdown_submit_redirect_url[]" value="">
                        </td>
                        <td>
                            <a href="javascript:void(0)" class="ays-delete-answer"></a>
                        </td>
                    </tr>
                    <?php
                     endfor;
                endif;
                ?>
                </tbody>
            </table>                        
            <input type="hidden" id="ays_poll_drpdwn_answers_count" value="<?php echo $answers_count ?>">
        </div>
    </div> <!-- Options Choosing Table -->
    <div class="if-dropdown apm-poll-type poll-type-block form-group row ays-poll-type-block ays-answers-toolbar-bottom" >
        <div class="col-sm-12">
            <label for="ays-poll-answer">
                <?php echo __('Options', "poll-maker"); ?>
                <a class="ays-add-answer">
                    <i class="ays_poll_fas ays_poll_fa-plus-square" title="<?= __("Add option", "poll-maker"); ?>" id="add_dropdown_answer_bottom"></i>
                </a>
            </label>
        </div>
    </div> <!-- Options Button -->
    <!-- Option Dropdown -->
    <div class="if-text apm-poll-type form-group row">
        <div class="col-sm-3">
            <label for="">
                <?= __('Choose text type', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-html="true" data-placement="top" title="<p style='margin-bottom:3px;'>
                        <?php echo __( 'Choose the type of the question:' , "poll-maker" ); ?>
                            <p style='padding-left:10px;margin-bottom:3px;'><strong><?php echo __( 'Short text', "poll-maker" ); ?></strong><?php echo __( ' - a question that requires to be answered by writing short text.' , "poll-maker" ); ?></p>
                            <p style='padding-left:10px;margin-bottom:3px;'><strong><?php echo __( 'Paragraph', "poll-maker" ); ?></strong><?php echo __( ' - a question that requires to be answered by writing text.', "poll-maker" ); ?></p>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9 answers-col row">
            <div class="d-flex" style="padding: 0 15px;">
                <div class="form-check-inline">
                    <input type="radio" id="ays_poll_text_type_short" name="ays_poll_text_type" value="short_text" class="ays-poll-text-types-type" <?php echo ($poll_view_type_for_text == "short_text") ? "checked" : ""; ?>>
                    <label for="ays_poll_text_type_short"><?php echo __("Short text", "poll-maker");?>
                    </label>
                </div>
                <div class="form-check-inline">
                    <input type="radio" id="ays_poll_text_type_paragraph" name="ays_poll_text_type" value="paragraph" class="ays-poll-text-types-type" <?php echo ($poll_view_type_for_text == "paragraph") ? "checked" : ""; ?>>
                    <label for="ays_poll_text_type_paragraph"><?php echo __("Paragraph", "poll-maker");?>
                    </label>
                </div>
            </div>
        </div>
    </div>
    <hr class="ays_hr_on_text" <?php echo $poll['type'] == 'text' ? "" : "style='display: none;'"?>>
    <div class="if-text apm-poll-type form-group row">
        <div class="col-sm-3">
            <label for='ays_poll_text_type_placeholder'>
                <?= __("Placeholder", "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                    title="<?= __("Write your preferred word to show in the placeholder field.", "poll-maker"); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-3 ays_divider_left">
            <input type="text" name="ays_poll_text_type_placeholder" id="ays_poll_text_type_placeholder" value="<?php echo $poll_text_type_placeholder?>">
        </div>
    </div>
    <hr class="ays_hr_on_text" <?php echo $poll['type'] == 'text' ? "" : "style='display: none;'"?>>
    <div class="if-text apm-poll-type form-group row">
        <div class="col-sm-3">
            <label for='ays_poll_text_type_width'>
                <?= __("Width", "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                    title="<?= __("Specify the width of the text field.", "poll-maker"); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-3 ays_divider_left">
            <input type="number" name="ays_poll_text_type_width" id="ays_poll_text_type_width" value="<?php echo $poll_text_type_width; ?>">
        </div>
        <div class="col-sm-6">
            <select class="ays-text-input ays-text-input-short ays_poll_select_short" name="ays_poll_text_type_width_type" id="ays_poll_text_type_width_type">
                <option value="percent" <?php echo ($poll_text_type_width_type == "percent") ? "selected" : ""; ?>>%</option>
                <option value="pixel"   <?php echo ($poll_text_type_width_type == "pixel") ? "selected" : ""; ?>>px</option>
            </select>
        </div>
    </div>
    <hr class="ays_hr_on_text" <?php echo $poll['type'] == 'text' ? "" : "style='display: none;'"?>>
    <div class="if-text apm-poll-type form-group row ays_toggle_parent">
        <div class="col-sm-3">
            <label for="ays_poll_enable_question_length">
                <?= __('Maximum length of a text field', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-html="true" data-placement="top" title="<?php echo __( 'Restrict the number of characters/words to be inserted in the text field by the user.' , "poll-maker" ); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-1 ays_divider_left">
            <input type="checkbox" class="ays-enable-timer1 ays_toggle_checkbox" id="ays_poll_enable_question_length" name="ays_poll_enable_question_length" value="on" <?php echo ($poll_text_type_length_enable) ? 'checked' : ''; ?>>                           
        </div>
        <div class="col-sm-7 ays_toggle_target ays_divider_left <?php echo ($poll_text_type_length_enable) ? '' : 'display_none'; ?>">
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_poll_question_limit_text_type">
                        <?php echo __('Limit by', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose your preferred type of limitation.',"poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8">
                    <select class="ays-text-input ays-text-input-select" id="ays_poll_question_limit_text_type" name="ays_poll_question_limit_text_type" style="max-width: 100%;">
                        <option value='characters' <?php echo ($poll_text_type_limit_type == 'characters') ? 'selected' : '' ?> ><?php echo __( 'Characters' , "poll-maker" ); ?></option>
                        <option value='words' <?php echo ($poll_text_type_limit_type == 'words') ? 'selected' : '' ?> ><?php echo __( 'Words' , "poll-maker" ); ?></option>
                    </select>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_poll_question_text_max_length">
                        <?php echo __('Length', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Indicate the length of the characters/words.',"poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8">
                    <input type="number" id="ays_poll_question_text_max_length" class="ays-text-input" name="ays_poll_question_text_max_length" value="<?php echo $poll_text_type_limit_length; ?>" style="width: 100%;">
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_poll_question_enable_text_message">
                        <?php echo __('Show word/character counter', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Tick the checkbox and the live box will appear under the text field. It will indicate the current state of word/character usage.',"poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8">
                    <div class="form-check form-check-inline">
                        <input type="checkbox" id="ays_poll_question_enable_text_message" name="ays_poll_question_enable_text_message" value="on" <?php echo ($poll_text_type_limit_message) ? "checked" : ""; ?> />
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- answer type dropdown end -->
<!--     <div class="if-range apm-poll-type form-group row">
    </div> -->
    <!-- <hr> -->
</div>