<div id="tab4" class="ays-poll-tab-content <?= $active_tab == 'tab4' ? 'ays-poll-tab-content-active' : ''; ?>">
    <div class="ays-poll-accordion-options-main-container">
        <div class="ays-poll-accordion-header">
            <?php echo $poll_acordion_svg_html; ?>
            <p class="ays-subtitle"><?= __('Results Settings', "poll-maker"); ?></p>
        </div>
        <hr class="ays-poll-bolder-hr" />
        <div class="ays-poll-accordion-body">
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='show-res-percent'>
                        <?= __('Show answer percent', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                            title="<?= __("Enable to show the percentage of each question on the progressbar on the result page of the poll.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="checkbox" name="show_res_percent" id="show-res-percent" value="1" <?= $show_res_percent ? 'checked' : '' ?>>
                </div>
            </div> <!-- Show answer percent -->
            <hr>
            <div class="form-group row ays_toggle_parent ays-poll-desc-message-vars-parent">
                <div class="col-sm-3">
                    <label for='ays-poll-hide-results'>
                        <?= __('Hide results', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                            title="<?= __("Disable to show voting results to the users on the result page of the poll.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                    <p class="ays_poll_small_hint_text_for_message_variables">
                        <span><?php echo __("To see all Message Variables ", "poll-maker"); ?></span>
                        <a href="?page=poll-maker-ays-settings&ays_poll_tab=tab6"
                            target="_blank"><?php echo __("click here", "poll-maker"); ?></a>
                    </p>
                </div>
                <div class="col-sm-9 ays_toggle_parent">
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <input type="checkbox" name="ays-poll-hide-results" class="ays_toggle_checkbox"
                                id="ays-poll-hide-results" value="hide" <?php echo ($hide_results) ? 'checked' : ''; ?>>
                        </div>
                    </div>
                    <div
                        class="col-sm-12 ays_toggle_target ays-poll-hide-results-message-box <?php echo ($hide_results) ? '' : 'display_none'; ?>">
                        <div class="form-group row">
                            <div class="col-sm-12">
                                <div>
                                    <label for='ays-poll-hide-results-text'>
                                        <?= __('Message instead of results', "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                            title="<?= __("Message that will appear instead of the voting results after the poll", "poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <?php
                                echo $poll_message_vars_html;
                                $content = isset($options['hide_results_text']) ? stripslashes($options['hide_results_text']) : __("Thanks for your answer!", "poll-maker");
                                $editor_id = 'ays-poll-hide-results-text';
                                $settings = array(
                                    'editor_height' => $poll_wp_editor_height,
                                    'textarea_name' => 'ays-poll-hide-results-text',
                                    'editor_class' => 'ays-textarea',
                                    'media_elements' => false
                                );
                                wp_editor($content, $editor_id, $settings);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div> <!-- Hide results -->
            <hr>
            <hr class="if-ays-poll-hide-results">
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-poll-hide-results-question'>
                        <?= __('Hide question text', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                            title="<?= __("Enable this option and the texts of the questions will not be displayed after the poll submission.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="checkbox" name="ays-poll-hide-results-question" id="ays-poll-hide-results-question"
                        <?= $hide_results_questions ? 'checked' : '' ?>>
                </div>
            </div> <!-- Hide question text -->
            <hr>
            <div class="form-group row ays_toggle_parent ays-poll-desc-message-vars-parent">
                <div class="col-sm-3">
                    <label for="ays_poll_result_message">
                        <?php echo __('Results Message', "poll-maker") ?>
                        <a class="ays_help" data-toggle="tooltip"
                            title="<?php echo __('Write the message, which will be shown on the result page of the poll.', "poll-maker") ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" name="ays_poll_result_message" class="ays_toggle_checkbox"
                        id="ays_poll_result_message" value="hide" <?php echo ($hide_result_message) ? 'checked' : ''; ?>>
                </div>
                <div
                    class="col-sm-8 ays_divider_left ays_toggle_target <?php echo ($hide_result_message) ? '' : 'display_none'; ?>">
                    <div class="form-group row">
                        <div class="col-sm-12 if_poll_hide_result_message" style="margin-top: 15px;">
                            <?php
                            $res_def_message = isset($poll['type']) && $poll['type'] == 'text' ? '<p style="text-align: center;">' . __("Thank you!", "poll-maker") . '</p>' : '';
                            echo $poll_message_vars_html;
                            $content = wpautop(stripslashes((isset($options['result_message'])) ? $options['result_message'] : $res_def_message));
                            $editor_id = 'ays_result_message';
                            $settings = array('editor_height' => $poll_wp_editor_height, 'textarea_name' => 'ays_result_message', 'editor_class' => 'ays-textarea', 'media_elements' => false);
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </div>
                    </div>
                </div>
            </div> <!-- Result Message -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-poll-result-sort-type'>
                        <?php echo __('Results sorting', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-html="true" data-placement="top" title="<?php
                        echo __("Select the way of arrangement of the results on the result page of the poll.", "poll-maker") .
                        "<ul style='list-style-type: circle;padding-left: 20px;'>".
                            "<li>". __('Most voted – the smallest to largest',"poll-maker") ."</li>".
                            "<li>". __('Least voted – the largest to smallest',"poll-maker") ."</li>".
                            "<li>". __('None',"poll-maker") ."</li>".
                            "</ul>";
                        ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
            <select name="ays-poll-result-sort-type" id="ays-poll-result-sort-type" class="ays-select ays_poll_aysDropdown">
                        <option value="none" <?= isset($options['result_sort_type']) && $options['result_sort_type'] == "none" ? 'selected' : ''; ?>>
                            <?= __("None", "poll-maker"); ?>
                        </option>
                        <option value="ASC" <?= isset($options['result_sort_type']) && $options['result_sort_type'] == "ASC" ? 'selected' : ''; ?>>
                            <?= __("Most voted", "poll-maker"); ?>
                        </option>
                        <option value="DESC" <?= isset($options['result_sort_type']) && $options['result_sort_type'] == "DESC" ? 'selected' : ''; ?>>
                            <?= __("Least voted", "poll-maker"); ?>
                        </option>
                    </select>
                </div>
            </div> <!--  Results sorting -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='show-votes-count'>
                        <?= __('Show votes count', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                            title="<?= __("Enable to show the total number of votes of each answer on the result page of the poll", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
            <input type="checkbox" name="show_votes_count" id="show-votes-count"
                   value="1" <?= $show_votes_count ? 'checked' : '' ?> >
                </div>
            </div> <!-- Show votes count -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-poll-load-effect'>
                        <?= __('Loading effect', "poll-maker"); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Choose the loading effect of the displaying poll results.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a></label>
                </div>
                <div class="col-sm-3">
            <select name="ays-poll-load-effect" id="ays-poll-load-effect" class="ays-select ays_poll_aysDropdown">
                <option value="opacity" <?= $loading_effect == "opacity" ? 'selected' : ''; ?>><?= __("Opacity", "poll-maker"); ?></option>
                <option value="blur" <?= $loading_effect == "blur" ? 'selected' : ''; ?>><?= __("Blur", "poll-maker"); ?></option>
                <option value="load_gif" <?= $loading_effect == "load_gif" ? 'selected' : ''; ?>><?= __("Loading GIF", "poll-maker"); ?></option>
                <option value="custom" <?= $loading_effect == "custom" ? 'selected' : ''; ?>><?= __("Custom GIF", "poll-maker"); ?></option>
                <option value="message" <?= $loading_effect == "message" ? 'selected' : ''; ?>><?= __("Message", "poll-maker"); ?></option>
                    </select>
                </div>
                <div class="if-custom-load col-sm-6 row">
                    <span class="if-custom-load">
                        <a href="javascript:void(0)" class="add-load-image button">
                            <?= $image_text_load; ?><a class="ays_help" data-toggle="tooltip" data-placement="top"
                                title="<?= __("You can upload custom GIF.", "poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </a>
                    </span>
                    <div class="ays-poll-load-image-container" style="<?= $style_load; ?>">
                        <span class="ays-remove-load-img"></span>
                        <img src="<?= isset($options['custom_load']) ? $options['custom_load'] : ""; ?>"
                     id="ays-poll-custom-load"/>
                        <input type="hidden" name="ays_poll_custom_load" id="ays-poll-custom-load"
                       value="<?= isset($options['custom_load']) ? $options['custom_load'] : ""; ?>"/>
                    </div>
                </div>
                <div class="if-loading-gif col-sm-6 row">
                    <div class="apm-loader d-flex justify-content-between align-items-center">
                <input type="radio"
                       name="ays-poll-load-gif" <?= $loading_effect == "load_gif" && $loading_gif == 'plg_default' ? 'checked' : ''; ?>
                       id="plg_default" value="plg_default">
                        <label for="plg_default" class="apm-loading-gif">
                            <div class="loader loader--style3">
                                <svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg"
                             xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                             width="100%" height="100%" viewBox="0 0 50 50"
                             style="enable-background:new 0 0 50  50;" xml:space="preserve">
                                    <path fill="#000"
                                        d="M43.935,25.145c0-10.318-8.364-18.683-18.683-18.683c-10.318,       0-18.683,8.365-18.683,18.683h4.068c0-8.071,6.543-14.615,14.615-14.615c8.072,0,  14.615,   6.543,14.615,14.615H43.935z">
                                <animateTransform attributeType="xml"
                                                  attributeName="transform"
                                                  type="rotate"
                                                  from="0 25 25"
                                                  to="360 25 25"
                                                  dur="0.7s"
                                                  repeatCount="indefinite"/>
                                    </path>
                                </svg>
                            </div>
                        </label>
                    </div>
                    <div class="apm-loader d-flex justify-content-between align-items-center">
                        <input type="radio" name="ays-poll-load-gif" <?= $loading_effect == "load_gif" && $loading_gif == 'plg_1' ? 'checked' : ''; ?> id="plg_1" value="plg_1">
                        <label for="plg_1" class="apm-loading-gif">
                            <div class="loader loader--style5">
                                <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%"
                                    height="100%" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;"
                                    xml:space="preserve">
                                    <rect x="0" y="0" width="4" height="10" fill="#333">
                                <animateTransform attributeType="xml"
                                                  attributeName="transform" type="translate"
                                                  values="0 0; 0 20; 0 0"
                                                  begin="0" dur="0.8s" repeatCount="indefinite"/>
                                    </rect>
                                    <rect x="10" y="0" width="4" height="10" fill="#333">
                                <animateTransform attributeType="xml"
                                                  attributeName="transform" type="translate"
                                                  values="0 0; 0 20; 0 0"
                                                  begin="0.2s" dur="0.8s" repeatCount="indefinite"/>
                                    </rect>
                                    <rect x="20" y="0" width="4" height="10" fill="#333">
                                <animateTransform attributeType="xml"
                                                  attributeName="transform" type="translate"
                                                  values="0 0; 0 20; 0 0"
                                                  begin="0.4s" dur="0.8s" repeatCount="indefinite"/>
                                    </rect>
                                </svg>
                            </div>
                        </label>
                    </div>
                    <div class="apm-loader d-flex justify-content-between align-items-center">
                        <input type="radio" name="ays-poll-load-gif" <?= $loading_effect == "load_gif" && $loading_gif == 'plg_2' ? 'checked' : ''; ?> id="plg_2" value="plg_2">
                        <label for="plg_2" class="apm-loading-gif">
                            <div class="loader loader--style8">
                                <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%"
                                    height="100%" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;"
                                    xml:space="preserve">
                                    <rect x="0" y="10" width="4" height="10" fill="#333" opacity="0.2">
                                        <animate attributeName="opacity" attributeType="XML" values="0.2; 1; .2"
                                            begin="0s" dur="0.7s" repeatCount="indefinite" />
                                        <animate attributeName="height" attributeType="XML" values="10; 20; 10"
                                            begin="0s" dur="0.7s" repeatCount="indefinite" />
                                        <animate attributeName="y" attributeType="XML" values="10; 5; 10" begin="0s"
                                            dur="0.7s" repeatCount="indefinite" />
                                    </rect>
                                    <rect x="8" y="10" width="4" height="10" fill="#333" opacity="0.2">
                                        <animate attributeName="opacity" attributeType="XML" values="0.2; 1; .2"
                                            begin="0.15s" dur="0.7s" repeatCount="indefinite" />
                                        <animate attributeName="height" attributeType="XML" values="10; 20; 10"
                                            begin="0.15s" dur="0.7s" repeatCount="indefinite" />
                                        <animate attributeName="y" attributeType="XML" values="10; 5; 10" begin="0.15s"
                                            dur="0.7s" repeatCount="indefinite" />
                                    </rect>
                                    <rect x="16" y="10" width="4" height="10" fill="#333" opacity="0.2">
                                        <animate attributeName="opacity" attributeType="XML" values="0.2; 1; .2"
                                            begin="0.3s" dur="0.7s" repeatCount="indefinite" />
                                        <animate attributeName="height" attributeType="XML" values="10; 20; 10"
                                            begin="0.3s" dur="0.7s" repeatCount="indefinite" />
                                        <animate attributeName="y" attributeType="XML" values="10; 5; 10" begin="0.3s"
                                            dur="0.7s" repeatCount="indefinite" />
                                    </rect>
                                </svg>
                            </div>
                        </label>
                    </div>
                    <div class="apm-loader d-flex justify-content-between align-items-center">
                        <input type="radio" name="ays-poll-load-gif" <?= $loading_effect == "load_gif" && $loading_gif == 'plg_3' ? 'checked' : ''; ?> id="plg_3" value="plg_3">
                        <label for="plg_3" class="apm-loading-gif">
                            <div class="loader loader--style5">
                                <svg width="100%" height="100%" viewBox="0 0 105 105" xmlns="http://www.w3.org/2000/svg"
                                    fill="#000">
                                    <circle cx="12.5" cy="12.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="0s" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="12.5" cy="52.5" r="12.5" fill-opacity=".5">
                                        <animate attributeName="fill-opacity" begin="100ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="52.5" cy="12.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="300ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="52.5" cy="52.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="600ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="92.5" cy="12.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="800ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="92.5" cy="52.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="400ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="12.5" cy="92.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="700ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="52.5" cy="92.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="500ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                    <circle cx="92.5" cy="92.5" r="12.5">
                                        <animate attributeName="fill-opacity" begin="200ms" dur="0.9s" values="1;.2;1"
                                            calcMode="linear" repeatCount="indefinite" />
                                    </circle>
                                </svg>
                            </div>
                        </label>
                    </div>
                    <div class="apm-loader d-flex justify-content-between align-items-center">
                        <input type="radio" name="ays-poll-load-gif" <?= $loading_effect == "load_gif" && $loading_gif == 'plg_4' ? 'checked' : ''; ?> id="plg_4" value="plg_4">
                        <label for="plg_4" class="apm-loading-gif">
                            <div class="loader loader--style4">
                                <svg width="100%" height="100%" viewBox="0 0 57 57" xmlns="http://www.w3.org/2000/svg"
                                    stroke="#000">
                                    <g fill="none" fill-rule="evenodd">
                                        <g transform="translate(1 1)" stroke-width="2">
                                            <circle cx="5" cy="50" r="5">
                                                <animate attributeName="cy" begin="0s" dur="2.2s" values="50;5;50;50"
                                                    calcMode="linear" repeatCount="indefinite" />
                                                <animate attributeName="cx" begin="0s" dur="2.2s" values="5;27;49;5"
                                                    calcMode="linear" repeatCount="indefinite" />
                                            </circle>
                                            <circle cx="27" cy="5" r="5">
                                                <animate attributeName="cy" begin="0s" dur="2.2s" from="5" to="5"
                                                    values="5;50;50;5" calcMode="linear" repeatCount="indefinite" />
                                                <animate attributeName="cx" begin="0s" dur="2.2s" from="27" to="27"
                                                    values="27;49;5;27" calcMode="linear" repeatCount="indefinite" />
                                            </circle>
                                            <circle cx="49" cy="50" r="5">
                                                <animate attributeName="cy" begin="0s" dur="2.2s" values="50;50;5;50"
                                                    calcMode="linear" repeatCount="indefinite" />
                                                <animate attributeName="cx" from="49" to="49" begin="0s" dur="2.2s"
                                                    values="49;5;27;49" calcMode="linear" repeatCount="indefinite" />
                                            </circle>
                                        </g>
                                    </g>
                                </svg>
                            </div>
                        </label>
                    </div>
                    <div class="apm-loader d-flex justify-content-between align-items-center">
                        <input type="radio" name="ays-poll-load-gif" <?= $loading_effect == "load_gif" && $loading_gif == 'plg_pro1' ? 'checked' : ''; ?> id="plg_pro1" value="plg_pro1">
                        <label for="plg_pro1" class="apm-loading-gif">
                            <div class="loader loader--style4">
                                <svg width="100%" height="100%" viewBox="0 0 135 140" xmlns="http://www.w3.org/2000/svg"
                                    fill="#000">
                                    <rect y="10" width="15" height="120" rx="6">
                                        <animate attributeName="height" begin="0.5s" dur="1s"
                                            values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear"
                                            repeatCount="indefinite" />
                                        <animate attributeName="y" begin="0.5s" dur="1s"
                                            values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear"
                                            repeatCount="indefinite" />
                                    </rect>
                                    <rect x="30" y="10" width="15" height="120" rx="6">
                                        <animate attributeName="height" begin="0.25s" dur="1s"
                                            values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear"
                                            repeatCount="indefinite" />
                                        <animate attributeName="y" begin="0.25s" dur="1s"
                                            values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear"
                                            repeatCount="indefinite" />
                                    </rect>
                                    <rect x="60" width="15" height="140" rx="6">
                                        <animate attributeName="height" begin="0s" dur="1s"
                                            values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear"
                                            repeatCount="indefinite" />
                                        <animate attributeName="y" begin="0s" dur="1s"
                                            values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear"
                                            repeatCount="indefinite" />
                                    </rect>
                                    <rect x="90" y="10" width="15" height="120" rx="6">
                                        <animate attributeName="height" begin="0.25s" dur="1s"
                                            values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear"
                                            repeatCount="indefinite" />
                                        <animate attributeName="y" begin="0.25s" dur="1s"
                                            values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear"
                                            repeatCount="indefinite" />
                                    </rect>
                                    <rect x="120" y="10" width="15" height="120" rx="6">
                                        <animate attributeName="height" begin="0.5s" dur="1s"
                                            values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear"
                                            repeatCount="indefinite" />
                                        <animate attributeName="y" begin="0.5s" dur="1s"
                                            values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear"
                                            repeatCount="indefinite" />
                                    </rect>
                                </svg>
                            </div>
                        </label>
                    </div>
                </div>
                <div class="if-loading-message col-sm-6 row">
                    <input type="text" class="ays-text-input ays-text-input-short" name="ays_poll_load_effect_message"
                        value="<?php echo $poll_effect_message; ?>">
                </div>
            </div> <!-- Loading effect -->
            <hr class="<?php echo $poll_loader_size_line_enable; ?> ays_line_changeing">
            <div class="form-group row <?php echo $poll_loader_size_enable; ?> ays_load_gif_cont">
                <div class="col-sm-3">
                    <label for="ays_loader_font_size">
                        <?= __('Loading effect size', "poll-maker") ?>
                        <a class="ays_help" data-toggle="tooltip"
                            title="<?= __('Define the size of the loading effect. It will get the default value if you leave it blank.', "poll-maker") ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9 ays_option_with_default_measurement_unit">
                    <div>
                        <input type="number" class="ays-text-input ays-poll-answer-results-short-input"
                            id="ays_loader_font_size" name="ays_loader_font_size"
                            value="<?= $poll_loader_font_size; ?>" />
                    </div>
                    <div class="ays_option_default_measurement_unit">
                        <input type="text" value="px" disabled>
                    </div>
                </div>
            </div><!-- Loading font-size -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays_enable_restart_button">
                        <?= __('Enable restart button', "poll-maker") ?>
                        <a class="ays_help" data-toggle="tooltip"
                            title="<?= __('Show the restart button on the result page of the poll for restarting the poll and taking it again.', "poll-maker") ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" class="ays-enable-timer1" id="ays_enable_restart_button"
                        name="ays_enable_restart_button" value="on" <?= (isset($options['enable_restart_button']) && $options['enable_restart_button']) ? 'checked' : '' ?> />
                </div>
            </div> <!-- Enable restart button -->
            <hr class="ays_poll_hide_for_range_type <?php echo $poll['type'] == 'range' ? 'display_none' : ''; ?>">
            <div
                class="ays_poll_block_with_hidden_row ays_poll_result_view_type ays_poll_hide_for_range_type <?php echo $poll['type'] == 'range' ? 'display_none' : ''; ?>">
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="apm_allow_add_answers">
                            <?php echo __('Show results by', "poll-maker") ?>
                            <a class="ays_help" data-toggle="tooltip"
                                title="<?php echo __('Select the way of displaying the results on the result page of the poll.', "poll-maker") ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <div class="form-group row">
                            <div class="col-sm-12">
                                <div class="ays_poll_loaders_flexbox" style="display: flex;">
                                    <div class="form-check form-check-inline ays_poll_loader_show_results_by">
                                        <label
                                            class="form-check-label ays_poll_check_label ays_poll_block_with_hidden_row_hide_row_block">
                                            <input type="radio" id="ays_poll_show_res_standart"
                                                name="ays_poll_show_result_view" value="standart"
                                                <?= ($show_result_view == 'standart' || $show_result_view == 'default_bar_chart') ? 'checked' : ''; ?> />
                                            <span><?= __('Bar Chart', "poll-maker"); ?></span>
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline ays_poll_loader_show_results_by">
                                        <label
                                            class="form-check-label ays_poll_check_label ays_poll_block_with_hidden_row_hide_row_block">
                                            <input type="radio" id="ays_poll_show_res_pie_chart"
                                                name="ays_poll_show_result_view" value="pie_chart"
                                                <?= ($show_result_view == 'pie_chart') ? 'checked' : ''; ?> />
                                            <span><?= __('Pie Chart', "poll-maker"); ?></span>
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline ays_poll_loader_show_results_by">
                                        <label
                                            class="form-check-label ays_poll_check_label ays_poll_block_with_hidden_row_hide_row_block">
                                            <input type="radio" id="ays_poll_show_res_column_chart"
                                                name="ays_poll_show_result_view" value="column_chart"
                                                <?= ($show_result_view == 'column_chart') ? 'checked' : ''; ?> />
                                            <span><?= __('Column Chart', "poll-maker"); ?></span>
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline ays_poll_loader_show_results_by">
                                        <label
                                            class="form-check-label ays_poll_check_label ays_poll_block_with_hidden_row_show_row_block">
                                            <input type="radio" id="ays_poll_show_res_google_bar_chart"
                                                name="ays_poll_show_result_view" value="google_bar_chart"
                                                <?= ($show_result_view == 'google_bar_chart') ? 'checked' : ''; ?> />
                                            <span><?= __('Bar chart(Google)', "poll-maker"); ?></span>
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline ays_poll_loader_show_results_by if_versus_type"
                                        style="display: none">
                                        <label
                                            class="form-check-label ays_poll_check_label ays_poll_block_with_hidden_row_hide_row_block">
                                            <input type="radio" id="ays_poll_show_res_versus_chart"
                                                name="ays_poll_show_result_view" value="versus_chart"
                                                <?= ($show_result_view == 'versus_chart') ? 'checked' : ''; ?> />
                                            <span><?= __('Versus Chart', "poll-maker"); ?></span>
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline ays_poll_loader_show_results_by if_rating_type"
                                        style="<?php echo $poll['view_type'] == 'star' ? '' : 'display: none' ?>">
                                        <label
                                            class="form-check-label ays_poll_check_label ays_poll_block_with_hidden_row_hide_row_block">
                                            <input type="radio" id="ays_poll_show_res_rating_chart"
                                                name="ays_poll_show_result_view" value="rating_chart"
                                                <?= ($show_result_view == 'rating_chart') ? 'checked' : ''; ?> />
                                            <span><?= __('Rating Chart', "poll-maker"); ?></span>
                                        </label>
                                    </div>
                                    <div class="form-check form-check-inline ays_poll_loader_show_results_by if_chossong_type"
                                        style="<?php echo $poll['type'] == 'choosing' ? '' : 'display: none' ?>">
                                        <label
                                            class="form-check-label ays_poll_check_label ays_poll_block_with_hidden_row_hide_row_block">
                                            <input type="radio" id="ays_poll_show_res_not_reloading"
                                                name="ays_poll_show_result_view" value="not_reloading"
                                                <?= ($show_result_view == 'not_reloading') ? 'checked' : ''; ?> />
                                            <span><?= __('Not reloading', "poll-maker"); ?></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr class="ays_poll_hidden_hr_content"
                            style="<?php echo ($show_result_view == 'google_bar_chart') ? '' : 'display: none' ?>">
                        <div class="ays_poll_hidden_block_content"
                            style="<?php echo ($show_result_view == 'google_bar_chart') ? '' : 'display: none' ?>">
                            <div class="form-group row">
                                <div class="ays_divider_left col-sm-2 ays_option_with_default_measurement_unit">
                                    <label for="ays_poll_show_result_chart_google_height">
                                        <?= __('Chart height', "poll-maker") ?>
                                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                            title="<?= __("Set the Results Chart height. Note: The option works only for the Google Bar Chart.", "poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-9 ays_option_with_default_measurement_unit">
                                    <div>
                                        <input type="number" class="ays-text-input ays-poll-answer-results-short-input"
                                            id="ays_poll_show_result_chart_google_height"
                                            name="ays_poll_show_result_chart_google_height"
                                            value="<?= $show_chart_type_google_height; ?>" />
                                    </div>
                                    <div class="ays_option_default_measurement_unit">
                                        <input type="text" value="px" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> <!-- Show results by -->
            <hr>
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for='ays-poll-show-social'>
                        <?= __('Social share buttons', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                            title='<?= __("Enable to show social media share buttons on the result page of the poll. (Facebook, Twitter, LinkedIn)", "poll-maker"); ?>'>
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a></label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" name="ays-poll-show-social" class="ays_toggle_checkbox"
                        id="ays-poll-show-social" value="show" <?= $poll_social_buttons ? 'checked' : ''; ?>>
                </div>
                <div
                    class="col-sm-8 ays_toggle_target ays_divider_left <?php echo $poll_social_buttons ? '' : 'display_none'; ?>">
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label>
                                <?php echo __('Heading for share buttons', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Text that will be displayed over share buttons.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <?php
                            $content = $poll_social_buttons_heading;
                            $editor_id = 'ays_poll_social_buttons_heading';
                            $settings = array('editor_height' => $poll_wp_editor_height, 'textarea_name' => 'ays_poll_social_buttons_heading', 'editor_class' => 'ays-textarea', 'media_elements' => false);
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_poll_enable_linkedin_share_button">
                                <i class="ays_poll_fas ays_poll-fa-linkedin"></i>
                                <?php echo __('LinkedIn button', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Display LinkedIn social button so that the users can share the page on which your poll is posted.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_linkedin_share_button"
                                name="ays_poll_enable_linkedin_share_button" value="on" <?php echo ($poll_show_social_ln) ? "checked" : ""; ?> />
                        </div>
                    </div>
                    <hr />
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_poll_enable_facebook_share_button">
                                <i class="ays_poll_fas ays_poll_facebook"></i>
                                <?php echo __('Facebook button', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Display Facebook social button so that the users can share the page on which your poll is posted.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_facebook_share_button"
                                name="ays_poll_enable_facebook_share_button" value="on" <?php echo ($poll_show_social_fb) ? "checked" : ""; ?> />
                        </div>
                    </div>
                    <hr />
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_poll_enable_twitter_share_button">
                                <i class="ays_fa ays_fa_twitter_square"></i>
                                <?php echo __('Twitter button', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Display Twitter social button so that the users can share the page on which your poll is posted.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_twitter_share_button"
                                name="ays_poll_enable_twitter_share_button" value="on" <?php echo ($poll_show_social_tr) ? "checked" : ""; ?> />
                        </div>
                    </div>
                    <hr />
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_poll_enable_vkontakte_share_button">
                                <i class="ays_fa ays_fa_vk"></i>
                                <?php echo __('VKontakte button', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Display VKontakte social button so that the users can share the page on which your poll is posted.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_vkontakte_share_button"
                                name="ays_poll_enable_vkontakte_share_button" value="on" <?php echo ($poll_show_social_vk) ? "checked" : ""; ?> />
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for="ays_enable_social_links">
                        <?php echo __('Enable Social Media links', "poll-maker") ?>
                        <a class="ays_help" data-toggle="tooltip"
                            title="<?php echo __('Display social media links at the end of the poll to allow users to visit your pages in the Social media.', "poll-maker") ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" class="ays-enable-timer1 ays_toggle_checkbox" id="ays_enable_social_links"
                        name="ays_poll_enable_social_links" value="on" <?php echo $enable_social_links ? 'checked' : '' ?> />
                </div>
                <div
                    class="col-sm-8 ays_toggle_target ays_divider_left <?php echo $enable_social_links ? '' : 'display_none' ?>">
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label>
                                <?php echo __('Heading for social links', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Text that will be displayed over social links.', "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <?php
                            $content = $poll_social_links_heading;
                            $editor_id = 'ays_poll_social_links_heading';
                            $settings = array('editor_height' => $poll_wp_editor_height, 'textarea_name' => 'ays_poll_social_links_heading', 'editor_class' => 'ays-textarea', 'media_elements' => false);
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_linkedin_link">
                                <i class="ays_fa ays_fa_linkedin_square"></i>
                                <?php echo __('LinkedIn link', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Linkedin profile or page link for showing after poll finish.', "poll-maker") ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" class="ays-text-input" id="ays_linkedin_link"
                                name="ays_poll_social_links[ays_linkedin_link]" value="<?php echo $linkedin_link; ?>" />
                        </div>
                    </div>
                    <hr />
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_facebook_link">
                                <i class="ays_fa ays_fa_facebook_square"></i>
                                <?php echo __('Facebook link', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Facebook profile or page link for showing after poll finish.', "poll-maker") ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" class="ays-text-input" id="ays_facebook_link"
                                name="ays_poll_social_links[ays_facebook_link]" value="<?php echo $facebook_link; ?>" />
                        </div>
                    </div>
                    <hr />
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_twitter_link">
                                <i class="ays_fa ays_fa_twitter_square"></i>
                                <?php echo __('Twitter link', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Twitter profile or page link for showing after poll finish.', "poll-maker") ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" class="ays-text-input" id="ays_twitter_link"
                                name="ays_poll_social_links[ays_twitter_link]" value="<?php echo $twitter_link; ?>" />
                        </div>
                    </div>
                    <hr />
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_vkontakte_link">
                                <i class="ays_fa ays_fa_vk"></i>
                                <?php echo __('VKontakte link', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('VKontakte profile or page link for showing after poll finish.', "poll-maker") ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" class="ays-text-input" id="ays_vkontakte_link"
                                name="ays_poll_social_links[ays_vkontakte_link]"
                                value="<?php echo $vkontakte_link; ?>" />
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_youtube_link">
                                <i class="ays_fa ays_fa_vk"></i>
                                <?php echo __('YouTube link', "poll-maker") ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    title="<?php echo __('Youtube profile or page link for showing after poll finish.', "poll-maker") ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <input type="text" class="ays-text-input" id="ays_youtube_link"
                                name="ays_poll_social_links[ays_youtube_link]" value="<?php echo $youtube_link; ?>" />
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-poll-res-rgba'>
                        <?= __('Results bar in RGBA', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                            title="<?= __("If the option is enabled, the opacity of the result bar color will depend on the number of votes.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="checkbox" name="ays-poll-res-rgba" id="ays-poll-res-rgba" value="on"
                        <?= isset($options['result_in_rgba'])
                            && $options['result_in_rgba'] ? 'checked' : ''; ?>>
                </div>
            </div> <!-- Results bar in RGBA -->
            <hr>
            <div class="form-group row ays_toggle_parent">
                <div class="col-sm-3">
                    <label for='ays_poll_show_users'>
                        <?php echo __('Show passed users avatars', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                            title="<?= __("If this option is enabled, you will see users' avatars(profile pictures) who have already voted on the result page.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" name="ays_poll_show_users" id="ays_poll_show_users" value="on" <?php echo $poll_show_passed_users_checked; ?> class="ays_toggle_checkbox">
                </div>
                <div
                    class="col-sm-8 <?php echo $poll_show_passed_users_checked == "checked" ? "" : "display_none"; ?> ays_toggle_target">
                    <div class="row">
                        <div class="col-sm-3 ays_divider_left">
                            <label for='ays_poll_show_users_count'>
                                <?= __('Users count', "poll-maker"); ?>
                                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                    title="<?= __("Indicate the count of users' avatars to be shown.", "poll-maker"); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="number" name="ays_poll_show_users_count" id="ays_poll_show_users_count"
                                class="ays-text-input ays-poll-answer-results-short-input"
                                value="<?php echo $poll_show_passed_users_count; ?>">
                        </div>
                    </div>
                </div>
            </div> <!-- Show passed users avatars -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays_poll_enable_answer_image_after_voting">
                        <?= __('Show answers image', "poll-maker") ?>
                        <a class="ays_help" data-toggle="tooltip"
                            title="<?= __('Tick this option to see the answers images after voting. Note it works only with the choosing type and you should have at least one answer with an image to use it.', "poll-maker") ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" id="ays_poll_enable_answer_image_after_voting"
                        name="ays_poll_enable_answer_image_after_voting" value="on" <?php echo ($poll_enable_answer_image_after_voting) ? "checked" : ""; ?>>
                </div>
            </div>
            <hr>
            <?php if ($poll_type == 'choosing'):
                global $wpdb;
                $sql_answers = "SELECT * FROM " . $wpdb->prefix . "ayspoll_answers WHERE poll_id=" . $id . " ORDER BY ordering ASC, id ASC";
                $answers_table = $wpdb->get_results($sql_answers);
                ?>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_show_answer_message">
                    <?php echo __('Show Answer message',"poll-maker")?>
                    <a class="ays_help" data-toggle="tooltip"
                    data-placement="top"
                                title="<?= __("Show different messages based on the answer.", "poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_show_answer_message"
                            name="ays_show_answer_message" value="on" <?php echo $ays_answer_message ? 'checked' : '' ?> />
                    </div>
                </div> <!-- Show Answer message -->
                <div class="ays-field-dashboard ays-poll-answers-table-container"
                    style="<?php echo $ays_answer_message ? '' : 'display:none'; ?>">
                    <hr />
                    <div class='form-group row ays_reset_answers_div'>
                        <input type="button" name="ays_reset_answers" id="ays_reset_answers" class="button ays-button"
                            value="Refresh answer table">
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                            title="<?= __("Refresh the below answers table after adding or removing answer(s) in the General tab.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </div> <!-- Refresh answer table -->
                    <div class="ays-table-wrap">
                        <table class="ays-answers-table ">
                            <thead>
                                <tr class="ui-state-default">
                                    <th><?php echo __('Answers', "poll-maker") ?></th>
                                    <th><?php echo __('Text', "poll-maker") ?></th>
                                    <th><?php echo __('Image', "poll-maker") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($answers_table as $key => $answer_value) {
                                    $div_block = (isset($poll_answer_messages[$answer_value->id]["answer_image"]) && $poll_answer_messages[$answer_value->id]["answer_image"] != '') ? "style=display:block;" : "style=display:none;";
                                    $a_block = (isset($poll_answer_messages[$answer_value->id]['answer_image']) && $poll_answer_messages[$answer_value->id]['answer_image'] != '') ? "style=display:none;" : "style=display:block;";
                                    $img_src = isset($poll_answer_messages[$answer_value->id]['answer_image']) && $poll_answer_messages[$answer_value->id]['answer_image'] != '' ? $poll_answer_messages[$answer_value->id]['answer_image'] : '';
                                    $img_answer = isset($poll_answer_messages[$answer_value->id]['answer']) && $poll_answer_messages[$answer_value->id]['answer'] != '' ? stripslashes(htmlentities($poll_answer_messages[$answer_value->id]['answer'])) : '';
                                    ?>

                                    <tr class="ays-interval-row">
                                        <td>
                                            <span><?php echo stripslashes(htmlentities($answer_value->answer)) ?></span>
                                            <input type="hidden" value=<?php echo $answer_value->id ?> name="ays_answer_id[]">
                                        </td>
                                        <td>
                                            <textarea type="text" name="ays_answer_message[]"
                                                class="interval__text"><?php echo $img_answer ?></textarea>
                                        </td>
                                        <td class="ays-answer-image-td">
                                            <label class="ays-label" for="ays-answer">
                                                <a href="javascript:void(0)" class="add-answer-image" <?php echo $a_block ?>>
                                                    <?php echo __("Add", "poll-maker") ?>
                                                </a>
                                            </label>
                                            <div class="ays-answer-image-container ays-interval-image-container" <?php echo $div_block ?>>
                                                <span class="ays-remove-answer-img"></span>
                                                <img src="<?php echo $img_src ?>" class="ays-answer-img">
                                                <input type="hidden" name="interval_image[]" class="ays-answer-image"
                                                    value=<?php echo $img_src ?>>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>