<div id="tab6" class="ays-poll-tab-content <?= $active_tab == 'tab6' ? 'ays-poll-tab-content-active' : ''; ?>">
    <div class="ays-poll-accordion-options-main-container">
        <div class="ays-poll-accordion-header">
            <?php echo $poll_acordion_svg_html; ?>
            <p class="ays-subtitle"><?= __('User Data Settings', "poll-maker"); ?></p>
        </div>
        <hr class="ays-poll-bolder-hr" />
        <div class="ays-poll-accordion-body">
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays_poll_info_form'>
                        <?= __('Enable Information Form', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip"
                        data-placement="top"
                        title="<?= __("After enabling this option, the user will have to fill out the information form (data form for the user’s personal information) after submitting the poll.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-2">
                    <input type="checkbox" name="ays_poll_info_form" id="ays_poll_info_form"
                        value="on" <?= $options['info_form'] == 1 ? 'checked' : ''; ?>>
                </div>
                <div class="col-sm-7 ays_divider_left ays_toggle_target_inverse <?php echo (isset($options['info_form']) && $options['info_form'] == 1) ? 'display_none' : ''; ?>">
                    <label for="ays_allow_collecting_logged_in_users_data" style="margin-right:20px;">
                        <?php echo __('Allow collecting information of logged in users',"poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Allow collecting information from logged in users. Email and name of users will be stored in the database. Email options will be work for these users.', "poll-maker")?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                    <input type="checkbox" id="ays_allow_collecting_logged_in_users_data" name="ays_allow_collecting_logged_in_users_data" value="on" <?php echo $poll_allow_collect_info; ?>>
                </div> <!-- Allow collecting information of logged in users -->
            </div> <!-- Enable Information Form -->
            <hr class="ays-poll-if-form-on">
            <div class="form-group row ays-poll-if-form-on">
                <div class="col-sm-3">
                    <label>
                        <?= __('Select fields', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                        title="<?= __("Select which fields the user should fill out.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <div class="checkbox_carousel">
                        <div class="form_fields_wrap">
                            <p class="ays-subtitle" style="text-align:center;"><?php echo __( "Available fields", "poll-maker" ); ?></p>
                            <ul id="form_available_fields" class="checkbox_carousel_body form_available_fields">
                                <?php
                                foreach ($custom_fields_passive as $slug => $attribute) {
                                    $attr_name = "ays-poll-form-fields-passive[]";
                                    $attr_name_required = "ays-poll-form-required-fields[]";
                                    $attr_value = $attribute['slug'];
                                    $attr_required_check = in_array($attribute, $required_fields);
                                    $slug_id = $attribute['slug'];

                                    if ( $attribute['slug'] == "apm-name" || $attribute['slug'] == "apm-email" || $attribute['slug'] == "apm_phone" ) {
                                        $attribute['name'] .= "<p class='ays_poll_small_hint_text_for_message_variables' style='margin:0;'>" . __( "(Default)", "poll-maker" ) . "</p>";
                                        $attr_value = 'off';
                                    }
                                    ?>
                                    <li class="checkbox_ays">
                                        <input type="hidden" name="ays_poll_fields_passive_order[]" value="<?php echo $attribute['slug']; ?>">
                                        <div class="form-check form-check-inline">
                                            <input type="hidden" class="form-check-input" id="<?php echo $slug_id; ?>" name="<?php echo $attr_name; ?>" value="<?php echo $attr_value; ?>"/>
                                            <label class="form-check-label" for="<?php echo $slug_id; ?>"><?php echo $attribute['name']; ?></label>
                                        </div>
                                        <div class="custom_field_type">
                                            <span class="ays_poll_small_hint_text"><?php echo $attribute['type']; ?></span>
                                        </div>
                                        <div class="form-check form-check-inline custom_field_required display_none">
                                            <input type="checkbox" class="form-check-input" id="<?php echo $slug_id; ?>_required" name="<?php echo $attr_name_required; ?>"
                                                value="<?php echo $slug_id; ?>" <?php echo $attr_required_check ? 'checked' : ''; ?> />
                                            <label class="form-check-label" for="<?php echo $slug_id; ?>_required"><?php echo __( "Required", "poll-maker" ); ?></label>
                                        </div>
                                    </li>
                                <?php
                                }
                                ?>
                            </ul>
                        </div>
                        <div class="form_fields_wrap">
                            <p class="ays-subtitle" style="text-align:center;"><?php echo __( "Active fields", "poll-maker" ); ?></p>
                            <ul id="form_fields" class="checkbox_carousel_body form_fields">
                                <?php
                                foreach ($custom_fields_active as $slug => $attribute) {
                                    $attr_name = "ays-poll-form-fields[]";
                                    $attr_name_required = "ays-poll-form-required-fields[]";
                                    $attr_required_check = in_array($attribute, $required_fields);
                                    $slug_id = $attribute['slug'];
                                    
                                    if ( $attribute['slug'] == "apm-name" || $attribute['slug'] == "apm-email" || $attribute['slug'] == "apm_phone" ) {
                                        $attribute['name'] .= "<p class='ays_poll_small_hint_text_for_message_variables' style='margin:0;'>" . __( "(Default)", "poll-maker" ) . "</p>";
                                    }
                                    ?>
                                    <li class="checkbox_ays">
                                        <input type="hidden" name="ays_poll_fields_active_order[]" value="<?php echo $attribute['slug']; ?>">
                                        <div class="form-check form-check-inline">
                                            <input type="hidden" class="form-check-input" id="<?php echo $slug_id; ?>" name="<?php echo $attr_name; ?>" value="<?php echo $slug_id; ?>"/>
                                            <label class="form-check-label" for="<?php echo $slug_id; ?>"><?php echo $attribute['name']; ?></label>
                                        </div>
                                        <div class="custom_field_type">
                                            <span class="ays_poll_small_hint_text"><?php echo $attribute['type']; ?></span>
                                        </div>
                                        <div class="form-check form-check-inline custom_field_required">
                                            <input type="checkbox" class="form-check-input" id="<?php echo $slug_id; ?>_required" name="<?php echo $attr_name_required; ?>"
                                                value="<?php echo $slug_id; ?>" <?php echo $attr_required_check ? 'checked' : ''; ?> />
                                            <label class="form-check-label" for="<?php echo $slug_id; ?>_required"><?php echo __( "Required", "poll-maker" ); ?></label>
                                        </div>
                                    </li>
                                <?php
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div> <!-- Select fields -->
            <hr class="ays-poll-if-form-on">
            <div class="form-group row ays-poll-if-form-on">
                <div class="col-sm-3">
                    <label>
                        <?= __('Information form title', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                        title="<?= __("Write the title of the Information Form which will be shown at the top of the Form Fields.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <?php
                    $content   = isset($options['info_form_title']) ? stripslashes($options['info_form_title']) : "<h5>" . __("Please fill out the form:", "poll-maker") . "</h5>";
                    $editor_id = 'ays-poll-info-form-text';
                    $settings  = array(
                        'editor_height'  => $poll_wp_editor_height,
                        'textarea_name'  => 'ays-poll-info-form-text',
                        'editor_class'   => 'ays-textarea',
                        'media_elements' => false
                    );
                    wp_editor($content, $editor_id, $settings);
                    ?>
                </div>
            </div> <!-- Information form title -->
            <hr class="ays-poll-if-form-on">
            <div class="form-group row ays-poll-if-form-on">
                <div class="col-sm-3">
                    <label>
                        <?php echo __('Custom fields',"poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                        title="<?= __("You can create custom fields with the following types: text, textarea, number, telephone, date, e-mail, URL, color, checkbox.", "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <blockquote>
                        <?php echo __("For creating custom fields click ", "poll-maker"); ?>
                        <a href="?page=<?php echo $this->plugin_name; ?>-formfields" target="_blank" ><?php echo __("here", "poll-maker"); ?></a>
                    </blockquote>
                </div>
            </div> <!-- Custom fields -->
            <hr class="ays-poll-if-form-on">
            <div class="form-group row ays-poll-if-form-on">
                <div class="col-sm-3">
                    <label for="ays_poll_autofill_user_data">
                        <?php echo __('Autofill logged-in user data', "poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr__('After enabling this option, logged in user\'s name and email will be autofilled in Information Form.', "poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <div class="information_form_settings">
                        <input type="checkbox" id="ays_poll_autofill_user_data" name="ays_poll_autofill_user_data" value="on" <?php echo $autofill_user_data ? "checked" : ""; ?>>
                    </div>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays_poll_display_fields_labels">
                        <?php echo __('Display form fields with labels',"poll-maker"); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr__('Show labels of form fields on the top of each field. Texts of labels will be taken from the "Fields placeholder" section on the General setting page.',"poll-maker"); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <div class="information_form_settings">
                        <input type="checkbox" id="ays_poll_display_fields_labels" name="ays_poll_display_fields_labels" value="on" <?php echo $display_fields_labels ? "checked" : ""; ?>>
                    </div>
                </div>
            </div>
            <hr class="ays-poll-if-form-on">
        </div>
    </div>
</div>