<div id="tab8" class="ays-poll-tab-content <?= $active_tab == 'tab8' ? 'ays-poll-tab-content-active' : ''; ?>">
    <div class="ays-poll-accordion-options-main-container">
        <div class="ays-poll-accordion-header">
            <?php echo $poll_acordion_svg_html; ?>
            <p class="ays-subtitle"><?= __('Integrations settings', "poll-maker"); ?></p>
        </div>
        <hr class="ays-poll-bolder-hr" />
        <div class="ays-poll-accordion-body">
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mailchimp_logo.png" alt="">
                    <h5><?php echo __('MailChimp Settings',"poll-maker")?></h5>
                </legend>
                <?php
                if(count($mailchimp) > 0):
                ?>
                <?php
                if($mailchimp_username == "" || $mailchimp_api_key == ""):
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                else:
                ?>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_enable_mailchimp">
                            <?php echo __('Enable MailChimp',"poll-maker")?>
                        </label>
                        <div style="display: flex; align-items: center; ">
                            <p style="margin: 0; color: gray; font-style: italic;">Please Note</p>
                            <a class="ays_help" data-toggle="tooltip"
                                data-placement="top"
                                title="<?= __("If the Integration is correctly set up, however, the email is not added to the MailChimp account, then, make sure you don't have any required fields for your MailChimp account. To check this, head to the All contacts > Settings > Audience Fields and *|MERGE|* tags.", "poll-maker"); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-sm-1">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_enable_mailchimp"
                            name="ays_enable_mailchimp"
                            value="on"
                            <?php
                            if($mailchimp_username == "" || $mailchimp_api_key == ""){
                                echo "disabled";
                            }else{
                                echo ($enable_mailchimp == 'on') ? 'checked' : '';
                            }
                            ?>/>
                    </div>
                </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_mailchimp_list">
                                <?php echo __('MailChimp list',"poll-maker")?>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <?php if(is_array($mailchimp_select)): ?>
                                <select name="ays_mailchimp_list" id="ays_mailchimp_list"
                                    <?php
                                    if($mailchimp_username == "" || $mailchimp_api_key == ""){
                                        echo 'disabled';
                                    }
                                    ?>>
                                    <option value="" disabled selected>Select list</option>
                                    <?php foreach($mailchimp_select as $mlist): ?>
                                        <option <?php echo ($mailchimp_list == $mlist['listId']) ? 'selected' : ''; ?>
                                                value="<?php echo $mlist['listId']; ?>"><?php echo $mlist['listName']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            <?php else: ?>
                                <span><?php echo $mailchimp_select; ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php
                endif;
                    ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- MailChimp Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/campaignmonitor_logo.png" alt="">
                    <h5><?php echo __('Campaign Monitor Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($monitor) > 0):
                    ?>
                    <?php
                    if ($monitor_client == "" || $monitor_api_key == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php
                    else:
                        ?>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_enable_monitor">
                                    <?php echo __('Enable Campaign Monitor', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_enable_monitor"
                                    name="ays_enable_monitor"
                                    value="on"
                                    <?php
                                    if ($monitor_client == "" || $monitor_api_key == "") {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_monitor == 'on') ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_monitor_list">
                                    <?php echo __('Campaign Monitor list', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <?php if (is_array($monitor_select)): ?>
                                    <select name="ays_monitor_list" id="ays_monitor_list"
                                        <?php
                                        if ($monitor_client == "" || $monitor_api_key == "") {
                                            echo 'disabled';
                                        }
                                        ?>>
                                        <option value="" disabled selected><?= __("Select List", "poll-maker") ?></option>
                                        <?php foreach ( $monitor_select as $mlist ): ?>
                                            <option <?= ($monitor_list == $mlist['ListID']) ? 'selected' : ''; ?>
                                                    value="<?= $mlist['ListID']; ?>"><?php echo $mlist['Name']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                                    <span><?php echo $monitor_select; ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php
                    endif;
                    ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- Campaign Monitor Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/zapier_logo.png" alt="">
                    <h5><?php echo __('Zapier Integration Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($zapier) > 0):
                    ?>
                    <?php
                    if ($zapier_hook == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php else: ?>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_enable_zapier">
                                    <?php echo __('Enable Zapier Integration', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_enable_zapier"
                                    name="ays_enable_zapier"
                                    value="on"
                                    <?php
                                    if ($zapier_hook == "") {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_zapier == 'on') ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>
                            <div class="col-sm-3">
                                <button type="button"
                                        data-url="<?= $zapier_hook ?>" <?= $zapier_hook ? "" : "disabled" ?>
                                        id="testZapier"
                                        class="btn btn-outline-secondary">
                                    <?= __("Send test data", "poll-maker") ?>
                                </button>
                                <a class="ays_help" data-toggle="tooltip" style="font-size: 16px;"
                                title="<?= __('We will send you a test data, and you can catch it in your ZAP for configure it.', "poll-maker") ?>">
                                    <i class="ays_fa ays_fa_info_circle"></i>
                                </a>
                            </div>
                        </div>
                        <div id="testZapierFields" class="d-none">
                            <input type="checkbox"
                                name="zapierTest[]"
                                value="ays_user_name" <?php echo (isset($options['form_name']) && $options['form_name'] == 'on') ? 'checked' : ''; ?>/>
                            <input type="checkbox"
                                name="zapierTest[]"
                                value="ays_user_email" <?php echo (isset($options['form_email']) && $options['form_email'] == 'on') ? 'checked' : ''; ?>/>
                            <input type="checkbox"
                                name="zapierTest[]"
                                value="ays_user_phone" <?php echo (isset($options['form_phone']) && $options['form_phone'] == 'on') ? 'checked' : ''; ?>/>
                            <?php
                            //                                foreach ( $all_attributes as $attribute ) {
                            ////                                    $checked = (in_array(strval($attribute['id']), $poll_attributes)) ? 'checked' : '';
                            ////                                    echo "<input type=\"checkbox\" name=\"zapierTest[]\"
                            ////                                                           value=\"" . $attribute['slug'] . "\" " . $checked . "/>";
                            ////                                }
                            ?>
                        </div>
                    <?php endif; ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- Zapier Integration Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/activecampaign_logo.png" alt="">
                    <h5><?php echo __('ActiveCampaign Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($active_camp) > 0):
                    ?>
                    <?php
                    if ($active_camp_url == "" || $active_camp_api_key == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php
                    else:
                        ?>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_enable_active_camp">
                                    <?php echo __('Enable ActiveCampaign', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_enable_active_camp"
                                    name="ays_enable_active_camp"
                                    value="on"
                                    <?php
                                    if ($active_camp_url == "" || $active_camp_api_key == "") {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_active_camp == 'on') ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_active_camp_list">
                                    <?php echo __('ActiveCampaign list', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <?php if (is_array($active_camp_list_select)): ?>
                                    <select name="ays_active_camp_list" id="ays_active_camp_list"
                                        <?php
                                        if ($active_camp_url == "" || $active_camp_api_key == "") {
                                            echo 'disabled';
                                        }
                                        ?>>
                                        <option value="" disabled
                                                selected><?= __("Select List", "poll-maker") ?></option>
                                        <option value=""><?= __("Just create contact", "poll-maker") ?></option>
                                        <?php foreach ( $active_camp_list_select as $list ): ?>
                                            <option <?= ($active_camp_list == $list['id']) ? 'selected' : ''; ?>
                                                    value="<?= $list['id']; ?>"><?= $list['name']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                                    <span><?php echo $active_camp_list_select; ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_active_camp_automation">
                                    <?php echo __('ActiveCampaign automation', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <?php if (is_array($active_camp_automation_select)): ?>
                                    <select name="ays_active_camp_automation" id="ays_active_camp_automation"
                                        <?php
                                        if ($active_camp_url == "" || $active_camp_api_key == "") {
                                            echo 'disabled';
                                        }
                                        ?>>
                                        <option value="" disabled
                                                selected><?= __("Select List", "poll-maker") ?></option>
                                        <option value=""><?= __("Just create contact", "poll-maker") ?></option>
                                        <?php foreach ( $active_camp_automation_select as $automation ): ?>
                                            <option <?= ($active_camp_automation == $automation['id']) ? 'selected' : ''; ?>
                                                    value="<?= $automation['id']; ?>"><?= $automation['name']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                                    <span><?php echo $active_camp_automation_select; ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php
                    endif;
                    ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- ActiveCampaign Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/slack_logo.png" alt="">
                    <h5><?php echo __('Slack Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($slack) > 0):
                    ?>
                    <?php
                    if ($slack_token == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php
                    else:
                        ?>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_enable_slack">
                                    <?php echo __('Enable Slack integration', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_enable_slack"
                                    name="ays_enable_slack"
                                    value="on"
                                    <?php
                                    if ($slack_token == "") {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_slack == 'on') ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_slack_conversation">
                                    <?php echo __('Slack conversation', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <?php if (is_array($slack_select)): ?>
                                    <select name="ays_slack_conversation" id="ays_slack_conversation"
                                        <?php
                                        if ($slack_token == "") {
                                            echo 'disabled';
                                        }
                                        ?>>
                                        <option value="" disabled
                                                selected><?= __("Select Channel", "poll-maker") ?></option>
                                        <?php foreach ( $slack_select as $conversation ): ?>
                                            <option <?= ($slack_conversation == $conversation['id']) ? 'selected' : ''; ?>
                                                    value="<?= $conversation['id']; ?>"><?php echo $conversation['name']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                <?php else: ?>
                                    <span><?php echo $slack_select; ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php
                    endif;
                    ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- Slack Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/sheets_logo.png" alt="">
                    <h5><?php echo __('Google Sheet Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($google) > 0):
                    ?>
                    <?php
                    if ($google_token == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php
                    else:
                        ?>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_google">
                                    <?php echo __('Enable Google integration', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_google"
                                    name="ays_poll_enable_google"
                                    value="on"
                                    <?php
                                    if ($google_token == "") {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_google_sheets == 'on') ? 'checked' : '';
                                    }
                                    ?>/>                        
                            </div>
                        </div>
                        <hr>
                    <?php
                    endif;
                    ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- Google Sheet Settings -->
            <hr>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mad-mimi-logo-min.png" alt="">
                    <h5><?php echo __('Mad Mimi', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($mad_mimi) > 0):
                    ?>
                    <?php
                    if ($mad_mimi_api_key == "" || $mad_mimi_user_name == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php
                    else:
                        ?>
                        <hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_mad_mimi">
                                    <?php echo __('Enable Mad Mimi', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_mad_mimi"
                                    name="ays_poll_enable_mad_mimi"
                                    value="on"
                                    <?php
                                    if ($mad_mimi_api_key == "") {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_mad_mimi) ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_mad_mimi_list">
                                    <?php echo __('Select List', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <?php if(!empty($mad_mimi_lists)){
                                    $mad_mimi_select  = "<select name='ays_poll_mad_mimi_list' id='ays_poll_mad_mimi_list'>";
                                    $mad_mimi_select .= "<option value='' disabled>Select list</option>";
                                    foreach($mad_mimi_lists as $key => $mad_mimi_list){
                                        $list_name = isset($mad_mimi_list['name']) && $mad_mimi_list['name'] != "" ? esc_attr($mad_mimi_list['name']) : ""; 
                                        $selected = isset($mad_mimi_db_list) && $mad_mimi_db_list == $list_name ? "selected" : "";
                                        $mad_mimi_select .= "<option value='".$list_name."' ".$selected.">".$list_name."</option>";
                                    }
                                    $mad_mimi_select .= "</select>";
                                    echo $mad_mimi_select;
                                    }
                                    else{
                                        echo __("There are no lists" , "poll-maker");
                                    }                        
                                ?>
                            </div>
                        </div>
                        <hr>
                    <?php
                    endif;
                    ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- Mad Mimi -->
            <hr>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/get_response.png" alt="">
                    <h5><?php echo __('GetResponse Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($getResponse) > 0):
                    ?>
                    <?php
                    if ($getResponse_api_key == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php else: ?>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_getResponse">
                                    <?php echo __('Enable GetResponse', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="checkbox"
                                    class="ays-enable-timer1"
                                    id="ays_poll_enable_getResponse"
                                    name="ays_poll_enable_getResponse"
                                    value="on"
                                    <?php
                                    if (!$getResponse_status) {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_getResponse) ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>                 
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_getResponse_list">
                                    <?php echo __('GetResponse List', "poll-maker") ?>
                                </label>
                            </div>                                        
                            <div class="col-sm-8">
                                <?php if($getResponse_status): ?>
                                <select id="ays_poll_getResponse_list" name="ays_poll_getResponse_list">
                                    <option value="" disabled selected>Select list</option>
                                    <?php
                                        $content = "";
                                        foreach($getResponse_lists as $key => $getResponse_list){
                                            if(isset($getResponse_list) && is_array($getResponse_list)){
                                                $list_id   = isset($getResponse_list['campaignId']) && $getResponse_list['campaignId'] != "" ? esc_attr($getResponse_list['campaignId']) : "";
                                                $list_name = isset($getResponse_list['name']) && $getResponse_list['name'] != "" ? esc_attr($getResponse_list['name']) : "";
                                                $selected_list = ($list_id == $getResponse_db_list) ? "selected" : "";
                                                $content .= "<option value=".$list_id." ".$selected_list.">".$list_name."</option>";
                                            }
                                        }      
                                        echo $content;                      
                                    ?>
                                </select>
                                <?php else: echo "<blockquote style='border-left:2px solid red;font-size: 16px;'>".$getResponse_message."</blockquote>"; ?>
                                <?php endif;?>
                            </div>   
                        </div>
                    <?php endif; ?>
                <?php
                else:
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- GetResponse Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mailerlite.png" alt="">
                    <h5><?php echo __('MailerLite Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($mailerLite) > 0):
                    ?>
                    <?php
                    if ($mailerLite_api_key == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php else: ?>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_mailerLite">
                                    <?php echo __('Enable MailerLite', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="checkbox"
                                    class="ays-enable-timer1"
                                    id="ays_poll_enable_mailerLite"
                                    name="ays_poll_enable_mailerLite"
                                    value="on"
                                    <?php
                                    if (!$mailerLite_response_status) {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_mailerLite) ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_survey_mailerLite_group_id">
                                    <?php echo __('MailerLite Lists', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <?php 
                                $content = '';
                                if(isset($mailerLite_get_groups) && !empty($mailerLite_get_groups)) {
                                    if( $mailerLite_response_status ) {
                                        $mailerLite_select  = '<select id="ays_poll_mailerLite_group_id" name="ays_poll_mailerLite_group_id">';
                                        $mailerLite_select  .= '<option value="" disabled selected>Select list</option>';
                                        foreach($mailerLite_get_groups as $key => $mailerLite_group){
                                            $response_form_id   = isset($mailerLite_group['id'])   && $mailerLite_group['id'] != ""   ? $mailerLite_group['id'] : "";
                                            $response_form_name = isset($mailerLite_group['name']) && $mailerLite_group['name'] != "" ? $mailerLite_group['name'] : "";

                                            $selected = ($mailerLite_group_id == $response_form_id) ? 'selected' : '';
                                            $mailerLite_select .= "<option value='".$response_form_id."' ".$selected.">".$response_form_name."</option>";
                                        }
                                        $mailerLite_select .= "</select>";
                                        $content .= $mailerLite_select;
                                    } else { 
                                        echo $content .= __("There are no forms" , "poll-maker");
                                    }
                                } else {
                                    $content .= __("There are no forms" , "poll-maker");
                                }
                                echo $content;
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- MailerLite Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/convertkit_logo.png" alt="">
                    <h5><?php echo __('ConvertKit Settings',"poll-maker")?></h5>
                </legend>
                <?php
                    if(isset($convertKit) && count($convertKit) > 0):
                ?>
                    <?php
                        if($convertKit_api_key == ""):
                    ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                    <?php
                        else:
                    ?>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_poll_enable_convertkit">
                                <?php echo __('Enable ConvertKit',"poll-maker")?>
                            </label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_convertkit"
                                name="ays_poll_enable_convertkit"
                                value="on"
                                <?php
                                        if(!$convertKit_response_status){
                                            echo "disabled";
                                        }else{
                                            echo ($enable_convertKit) ? 'checked' : '';
                                        }
                                ?>/>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_poll_convertKit_list">
                                <?php echo __('ConvertKit list',"poll-maker")?>
                            </label>
                        </div>
                        <div class="col-sm-8">
                            <?php if(isset($convertKit_forms) && !empty($convertKit_forms)): ?>
                                <?php if($convertKit_response_status):?>
                                <select name="ays_poll_convertKit_list" id="ays_poll_convertKit_list"
                                <?php
                                        if(!$convertKit_response_status){
                                            echo 'disabled';
                                        }
                                    ?>>
                                    <option value="" disabled selected>Select list</option>
                                <?php foreach($convertKit_forms_list as $key => $convertKit_form): ?>
                                    <option <?php 
                                        $response_form_id = isset($convertKit_form['id']) && $convertKit_form['id'] != "" ? $convertKit_form['id'] : "";
                                        $response_form_name = isset($convertKit_form['name']) && $convertKit_form['name'] != "" ? $convertKit_form['name'] : "";
                                        echo ($convertKit_form_id == $response_form_id) ? 'selected' : ''; ?>
                                        value="<?php echo $response_form_id; ?>"><?php echo $response_form_name; ?></option>
                                <?php endforeach; ?>
                                </select>
                                <?php else: echo __("There are no forms" , "poll-maker");?>
                            <?php endif;?>
                            <?php else: ?>
                                <span><?php echo __("There are no forms" , "poll-maker"); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php
                        endif;
                    ?>
                <?php
                    else:
                ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                    endif;
                ?>
            </fieldset> <!-- ConvertKit Settings -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/klaviyo-logo.png" alt="">
                    <h5><?php echo __('Klaviyo', "poll-maker") ?></h5>
                </legend>
                <div class="form-group row" style="margin: 0px;">
                    <div class="col-sm-12 only_pro" style="padding:10px 0 0 10px;">
                        <div class="pro_features" style="justify-content:flex-end;">
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_klaviyo"><?php echo __('Enable Klaviyo', "poll-maker"); ?></label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_klaviyo" value="on" checked disabled >                
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_klaviyo_list"><?php echo __('Klaviyo list',"poll-maker") ?></label>
                            </div>
                            <div class="col-sm-8">
                                <select name="ays_poll_klaviyo_list" id="ays_poll_klaviyo_list" <?php echo $disabled; ?>>
                                    <option value="" disabled selected> <?php echo __( "Select list", "poll-maker" ) ?> </option>
                                </select>
                            </div>
                        </div>
                        <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                            <div class="ays-poll-new-upgrade-button-box">
                                <div>
                                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                </div>
                                <div class="ays-poll-new-upgrade-button"><?php echo __("Upgrade to Agency", "poll-maker"); ?></div>
                            </div>
                        </a>
                    </div>
                </div>
            </fieldset> <!-- Klaviyo -->
            <hr>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/aweber-logo.png" alt="">
                    <h5><?php echo __('Aweber', "poll-maker") ?></h5>
                </legend>
                <div class="form-group row" style="margin: 0px;">
                    <div class="col-sm-12 only_pro" style="padding:10px 0 0 10px;">
                        <div class="pro_features" style="justify-content:flex-end;">
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_aweber"><?php echo  __('Enable Aweber', "poll-maker") ?></label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_aweber" name="ays_poll_enable_aweber" value="on" checked disabled />
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_aweber_list_id"><?php echo  __('Aweber Lists', "poll-maker") ?></label>
                            </div>
                            <div class="col-sm-8">
                                <select name='ays_poll_aweber_list_id' id='ays_poll_aweber_list_id'>
                                    <option value='' disabled selected><?php echo __( "Select list", "poll-maker" ) ?></option>
                                </select>
                            </div>
                        </div>
                        <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                            <div class="ays-poll-new-upgrade-button-box">
                                <div>
                                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                </div>
                                <div class="ays-poll-new-upgrade-button"><?php echo __("Upgrade to Agency", "poll-maker"); ?></div>
                            </div>
                        </a>
                    </div>
                </div>
            </fieldset> <!-- Aweber -->
            <hr>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mail_poet.png" alt="">
                    <h5><?php echo __('MailPoet', "poll-maker") ?></h5>
                </legend>
                <div class="form-group row" style="margin:0;">
                    <div class="col-sm-12 only_pro" style="padding:10px 0 0 10px;">
                        <div class="pro_features" style="justify-content:flex-end;">
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_mailpoet"><?php echo __('Enable MailPoet',"poll-maker"); ?></label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_mailpoet" name="ays_poll_enable_mailpoet" value="on" selected disabled >
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_mailpoet_list"><?php echo __('MailPoet list',"poll-maker") ?></label>
                            </div>
                            <div class="col-sm-8">
                                <select name="ays_poll_mailpoet_list" id="ays_poll_mailpoet_list">
                                    <option value="" disabled selected> <?php echo __( "Select list", "poll-maker" ) ?> </option>
                                </select>
                            </div>
                        </div>
                        <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                            <div class="ays-poll-new-upgrade-button-box">
                                <div>
                                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                </div>
                                <div class="ays-poll-new-upgrade-button"><?php echo __("Upgrade to Agency", "poll-maker"); ?></div>
                            </div>
                        </a>
                    </div>
                </div>
            </fieldset> <!-- Mailpoet -->
            <hr/>
            <fieldset class="ays_poll_settings_integration_container">
                <legend>
                    <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/recaptcha_logo.png" alt="">
                    <h5><?php echo __('reCAPTCHA Settings', "poll-maker") ?></h5>
                </legend>
                <?php
                if (count($recaptcha) > 0):
                    ?>
                    <?php
                    if ($recaptcha_site_key == "" || $recaptcha_secret_key == ""):
                        ?>
                        <blockquote class="error_message">
                            <?php echo (
                                /* translators: anchor tag */
                                sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                    "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                                )
                            );
                            ?>
                        </blockquote>
                    <?php else: ?>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_poll_enable_recaptcha">
                                    <?php echo __('Enable reCAPTCHA', "poll-maker") ?>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="checkbox"
                                    class="ays-enable-timer1"
                                    id="ays_poll_enable_recaptcha"
                                    name="ays_poll_enable_recaptcha"
                                    value="on"
                                    <?php
                                    if ($recaptcha_site_key == "" || $recaptcha_secret_key == "") {
                                        echo "disabled";
                                    } else {
                                        echo ($enable_recaptcha) ? 'checked' : '';
                                    }
                                    ?>/>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <blockquote class="error_message">
                        <?php echo (
                            /* translators: anchor tag */
                            sprintf( __("For enabling this option, please go to %s page and fill all options.", "poll-maker"),
                                "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>". __("this", "poll-maker")."</a>"
                            )
                        );
                        ?>
                    </blockquote>
                <?php
                endif;
                ?>
            </fieldset> <!-- reCaptcha Settings -->
            <hr/>
        </div>
    </div>
</div>