<?php
    require_once(POLL_MAKER_ADMIN_PATH . "/partials/polls/actions/poll-maker-polls-actions-options.php");

    $get_all_polls = Poll_Maker_Data::get_all_polls('DESC');
?>
<style>
    /*save changing properties of poll in the css-variables*/
    :root {
        /*colors*/
        --theme-main-color: <?=$main_color_s?>;
        --theme-bg-color: <?=$bg_color_s?>;
        --theme-answer-bg-color: <?=$answer_bg_color_s?>;
        --theme-title-bg-color: <?=$title_bg_color_s?>;
        --theme-text-color: <?=$text_color_s?>;
        --theme-button-text-color: <?=$button_text_color_s?>;
        --theme-button-bg-color: <?=$button_bg_color_s?>;
        --theme-icon-color: <?=$text_color_s?>;
        /*only for coffee fluid theme*/
        --theme-text-color-a2: <?=$this->polls_obj->hex2rgba($text_color_s, 0.2)?>;
        --theme-text-color-a5: <?=$this->polls_obj->hex2rgba($text_color_s, 0.5)?>;
        --theme-text-color-a75: <?=$this->polls_obj->hex2rgba($text_color_s, 0.75)?>;
        /*end coffee fluid colors*/

        /*options*/
        --poll-width: <?=((int) $width_s  > 0 ? (int) $width_s  . "px" : "100%")?>;
        --poll-border-style: <?=$border_s?>;
        --poll-border-radius: <?=$border_radius_s?>;
        --poll-border-width: <?=$border_width_s?>;
        --poll-box-shadow: <?=$enable_box_shadow_s?>;
        --poll-bagckround-image: <?=$bg_image_s?>;
        --poll-icons-size: <?=absint($icon_size_s) >= 10 ? absint($icon_size_s) : 24 ?>px;
        --poll-display-title: <?=((1 == $poll['show_title']) ? "block" : "none")?>;
        --poll-display-image-box: <?=((!empty($poll['image'])) ? "block" : "none")?>;

    }

    input[type='button'].ays-poll-btn{
		font-size: <?php echo $buttons_font_size; ?>px;
		padding: <?php echo $buttons_top_bottom_padding."px ".$buttons_left_right_padding."px"; ?>;
		border-radius: <?php echo $buttons_border_radius; ?>px;
        width: <?php echo $poll_buttons_width; ?>px;
	}

</style>
<!--LIVE PREVIEW STYLES END-->
<div class="wrap">
    <div class="ays-poll-heading-box">
        <div class="ays-poll-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank" style="text-decoration: none;font-size: 13px;">
                <i class="ays_poll_fas ays_fa_file_text"></i>
                <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "poll-maker"); ?></span>
            </a>
        </div>
    </div>
    <div class="container-fluid">
        <form class="ays-poll-form <?= $color_class; ?>" id="ays-poll-form" method="post">
            <input type="hidden" name="ays_poll_active_tab" id="ays_poll_active_tab" value="<?php echo htmlentities($active_tab); ?>"/>
           	<input type="hidden" name="ays_poll_ctrate_date" value="<?php // echo $poll_create_date; ?>">
            <input type="hidden"  id="poll_choose_type_first" value="<?php echo $poll['type']; ?>" >
           	<input type="hidden" name="ays_poll_author" value="<?php echo $poll_author; ?>">
            <h1 class="wp-heading-inline">
				<?php
				echo "$heading";
				?>
            </h1>
            <div>
                <div class="ays-poll-subtitle-main-box">
                    <p class="ays-subtitle">
                        <?php if(isset($id) && count($get_all_polls) > 1):?>
                        <i class="ays_poll_fas ays_fa_arrow_down ays-poll-open-polls-list" style="font-size: 15px;"></i>   
                        <?php endif; ?>
                        <strong class="ays_poll_title_in_top"><?php echo $poll['title']; ?></strong>
                    </p>
                    <?php if(isset($id) && count($get_all_polls) > 1):?>
                    <div class="ays-poll-polls-data">
                        <?php $var_counter = 0; foreach($get_all_polls as $var => $var_name): if( intval($var_name['id']) == $id ){continue;} $var_counter++; ?>
                            <?php ?>
                            <label class="ays-poll-message-vars-each-data-label">
                                <input type="radio" class="ays-poll-polls-each-data-checker" hidden id="ays_poll_message_var_count_<?php echo $var_counter?>" name="ays_poll_message_var_count">
                                <div class="ays-poll-polls-each-data">
                                    <input type="hidden" class="ays-poll-polls-each-var" value="<?php echo $var; ?>">
                                    <a href="?page=poll-maker-ays&action=edit&poll=<?php echo $var_name['id']?>" target="_blank" class="ays-poll-go-to-polls"><span><?php echo stripslashes(esc_attr($var_name['title'])); ?></span></a>
                                </div>
                            </label>              
                        <?php endforeach ?>
                    </div>                        
                <?php endif; ?>
                </div>
                <?php if($id !== null): ?>
                <div class="row">
                    <div class="col-sm-3">
                        <label> <?php echo __( "Shortcode text for editor", "poll-maker" ); ?> </label>
                    </div>
                    <div class="col-sm-9">
                        <p style="font-size:14px; font-style:italic;">
                            <?php echo __("To insert the Poll into a page, post or text widget, copy shortcode", "poll-maker"); ?>
                            <strong class="ays-poll-shortcode-box" data-toggle="tooltip" title="<?php echo __('Click for copy.',"poll-maker");?>" onClick="selectElementContents(this)" style="font-size:16px; font-style:normal;"><?php echo "[ays_poll id=".$id."]"; ?></strong>
                            <?php echo " " . __( "and paste it at the desired place in the editor.", "poll-maker"); ?>
                        </p>
                    </div>
                </div>
                <?php endif;?>
            </div>
            <hr>
            <div class='ays-all-container'>
                <div class='ays-all-sub-container'>
                    <div class="ays-top-menu-wrapper">
                        <div class="ays_menu_left" data-scroll="0"><i class="ays_poll_fas ays_poll_fa-left"></i></div>
                        <div class="ays-top-menu">
                            <div class="nav-tab-wrapper ays-top-tab-wrapper">
                                <a href="#tab1" data-title="tab1" class="nav-tab <?= $active_tab == 'tab1' ? 'nav-tab-active' : ''; ?>"><?= __('General', "poll-maker"); ?></a>
                                <a href="#tab2" data-title="tab2" class="nav-tab <?= $active_tab == 'tab2' ? 'nav-tab-active' : ''; ?>"><?= __('Styles', "poll-maker"); ?></a>
                                <a href="#tab3" data-title="tab3" class="nav-tab <?= $active_tab == 'tab3' ? 'nav-tab-active' : ''; ?>"><?= __('Settings', "poll-maker"); ?></a>
                                <a href="#tab4" data-title="tab4" class="nav-tab <?= $active_tab == 'tab4' ? 'nav-tab-active' : ''; ?>"><?= __("Results Settings", "poll-maker"); ?></a>
                                <a href="#tab5" data-title="tab5" class="nav-tab <?= $active_tab == 'tab5' ? 'nav-tab-active' : ''; ?>"><?= __("Limitations", "poll-maker"); ?> </a>
                                <a href="#tab6" data-title="tab6" class="nav-tab <?= $active_tab == 'tab6' ? 'nav-tab-active' : ''; ?>"><?= __("User Data", "poll-maker"); ?></a>
                                <a href="#tab7" data-title="tab7" class="nav-tab <?= $active_tab == 'tab7' ? 'nav-tab-active' : ''; ?>"><?= __("Email", "poll-maker"); ?></a>                
                                <a href="#tab8" data-title="tab8" class="nav-tab <?= $active_tab == 'tab8' ? 'nav-tab-active' : ''; ?>"><?= __("Integrations", "poll-maker"); ?></a>
                            </div>
                            <div class='top-menu-buttons-container'>
                                <?php
                                    echo $loader_iamge;
                                    $save_attributes = array(
                                        'id' => 'ays-button-top-apply',
                                        'title' => 'Ctrl + s',
                                        'data-toggle' => 'tooltip',
                                        'data-delay'=> '{"show":"1000"}'
                                    );
                                    submit_button(__('Save', "poll-maker"), 'ays-bottom-menu-buttons ays-apply-all', 'ays_apply_top', false, $save_attributes);
                                    $save_close_attributes = array('id' => 'ays-button-top');
                                    submit_button(__('Save and close', "poll-maker"), 'primary ays-top-menu-save-and-close ays-bottom-menu-buttons', 'ays_submit_top', false, $save_close_attributes);
                                    submit_button(__('Cancel', "poll-maker"), 'ays-button ays-top-menu-cancel ays-bottom-menu-buttons', 'ays_poll_cancel_top', false, array());
                                ?>
                            </div>
                        </div>
                        <div class="ays_menu_right" data-scroll="-1"><i class="ays_poll_fas ays_poll_fa-right"></i></div>
                    </div>
                    <?php
                        for($tab_ind = 1; $tab_ind <= 8; $tab_ind++){
                            require_once( POLL_MAKER_ADMIN_PATH . "/partials/polls/actions/partials/poll-maker-polls-actions-tab".$tab_ind.".php" );
                        }
                    ?>

                    <?php
                    wp_nonce_field('poll_action', 'poll_action');
                    ?>
                    <div class="ays_save_buttons_content">
                        <div class="ays_save_default_button_box">
                            <div class="ays_next_prev_buttons_box">
                                <?php 
                                    if ( $prev_poll_id != "" && !is_null( $prev_poll_id ) ) {

                                        $other_attributes = array(
                                            'id' => 'ays-polls-prev-button',
                                            'data-message' => __( 'Are you sure you want to go to the previous poll page?', "poll-maker"),
                                            'href' => sprintf( '?page=%s&action=%s&poll=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $prev_poll_id ) )
                                        );
                                        submit_button(__('Prev Poll', "poll-maker"), 'button button-primary ays-button ays-poll-prev-poll-button ays-poll-next-prev-button-class', 'ays_poll_prev_button', false, $other_attributes);
                                    }

                                    if ( $next_poll_id != "" && !is_null( $next_poll_id ) ) {

                                        $other_attributes = array(
                                            'id' => 'ays-polls-next-button',
                                            'data-message' => __( 'Are you sure you want to go to the next poll page?', "poll-maker"),
                                            'href' => sprintf( '?page=%s&action=%s&poll=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $next_poll_id ) )
                                        );
                                        submit_button(__('Next Poll', "poll-maker"), 'button button-primary ays-button ays_poll_next_poll_button ays-poll-next-prev-button-class', 'ays_poll_next_button', false, $other_attributes);
                                    }
                                ?>
                            </div>
                            <div class="ays_default_btn_container">
                                <?php
                                $other_attributes = array( 'data-message' => __( 'Are you sure that you want to save these parameters as default?', "poll-maker" ) );
                                submit_button(__('Save as default', "poll-maker"), 'ays_default_btn', 'ays_default', false ,  $other_attributes);
                                echo $loader_iamge; ?>
                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __( "Saves the assigned settings of the current poll as default. After clicking on this button, each time creating a new poll, the system will take the settings and styles of the current poll. If you want to change and renew it, please click on this button on another poll." , "poll-maker" ); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </div>
                        </div>
                        <div class="bottom-save-buttons-container">
                            <div class="ays_save_buttons_box_for_mobile" id="ays-save-buttons-box-for-mobile">
                                <?php
                                echo $loader_iamge;
                                $other_attributes_apply_bottom = array(
                                    'id' => 'ays-button-apply',
                                    'title' => 'Ctrl + s',
                                    'data-toggle' => 'tooltip',
                                    'data-delay'=> '{"show":"1000"}'
                                );
                                submit_button(__('Save', "poll-maker"), 'ays-bottom-menu-buttons', 'ays_apply', false, $other_attributes_apply_bottom);
                                $save_close_bottom_attributes = array('id' => 'ays-button');
                                submit_button(__('Save and close', "poll-maker"), 'primary ays-bottom-menu-save-and-close ays-bottom-menu-buttons', 'ays_submit', false, $save_close_bottom_attributes);
                                submit_button(__('Cancel', "poll-maker"), 'ays-button ays_poll_cancel_bottom ays-bottom-menu-buttons', 'ays_poll_cancel', false, array());
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if($id === null): ?>
                <div class="ays_poll_layer_container">
                    <div class="ays_poll_layer_content">
                        <div class="ays-poll-close-type">
                            <a href="?page=poll-maker-ays">
                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/icons/cross.png">
                            </a>
                        </div>
                        <div class="ays_poll_layer_box">
                            <div class="ays-poll-close-layer">
                                <div class="ays-poll-choose-type">
                                    <p style="margin: 0;">Choose Your Poll Type</p>
                                </div>
                            </div>
                            <div class="ays_poll_layer_box_blocks">
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="choosing" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'choosing') ? 'checked' : '' ?>>                                        
                                    <div class="ays_poll_layer_item" >
                                        <div class="ays_poll_layer_item_logo" >
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_choosing" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/choosing.png' ?>"
                                                alt="<?= __('Choosing', "poll-maker") ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo __('Choosing', "poll-maker") ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/image-choosing/" style="font-size:14px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="rating" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'rating') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay
                                            ays_poll_layer_item_logo_overlay_rating">
                                            <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/rating.png' ?>"
                                            alt="<?= __('Rating', "poll-maker") ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Rating', "poll-maker") ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/rating-polls-rating-type/" style="font-size:14px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="text" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'text') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_text" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/Text.png' ?>"
                                                    alt="<?= __('Text', "poll-maker") ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Text', "poll-maker") ?><p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/open-ended-question-polls-text-type/" style="font-size:14px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="voting" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'text') ? 'voting' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_voting" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/voting.png' ?>" alt="<?= __('Voting', "poll-maker") ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                        <p style="margin:0px;"><?php echo  __('Voting', "poll-maker") ?><p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/voting-polls-voting-type/" style="font-size:14px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="dropdown" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'dropdown') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_dropdown" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/Dropdown.png' ?>" alt="<?= __('Dropdown', "poll-maker") ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Dropdown', "poll-maker") ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/anonymous-polls-dropdown-type/" style="font-size:14px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="range" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'range') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_range" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/range.png' ?>" alt="<?= __('Range', "poll-maker") ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Range', "poll-maker") ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/slider-rating-polls-slider-type/" style="font-size:14px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="versus" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'versus') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_versus" >
                                                <span>VS</span>
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Versus', "poll-maker") ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/versus-poll-versus-type/" style="font-size:14px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                            </div>
                            <div class="ays_poll_select_button_layer">
                                <div class="ays_poll_select_button_item">
                                    <input type="button" class="ays_poll_layer_button" name="" value="Next" data-type="<?php echo $poll['type']; ?>">
                                    <input type="hidden"  name="ays-poll-type" id="poll_choose_type" value="<?php echo $poll['type']; ?>" >
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php else: ?>
                   <input type="hidden"  name="ays-poll-type" id="poll_choose_type" value="<?php echo $poll['type']; ?>" >
            <?php endif; ?>
        </form>
    </div>
</div>