<?php
global $wpdb;
$action = (isset($_GET['action'])) ? sanitize_text_field($_GET['action']) : '';
$active_tab = (!empty($_GET['active-tab'])) ? sanitize_text_field($_GET['active-tab']) : 'tab1';
$heading = '';
$loader_iamge = '';

$id = (isset($_GET['poll'])) ? absint(intval($_GET['poll'])) : null;

if ($action == 'edit') {
    if ($id === null || $id === 0) {
        $url = esc_url_raw(remove_query_arg(array('action', 'poll')));
        wp_redirect($url);
    }
}

$user_id = get_current_user_id();
$user = get_userdata($user_id);
$users_table = esc_sql( $wpdb->prefix . 'users' );
// $sql_users = "SELECT ID, display_name FROM {$users_table}";
// $ays_poll_wp_users = $wpdb->get_results($sql_users, "ARRAY_A");
$author = $user->ID;

$cat_list = get_categories(
    array(
        'hide_empty' => false
    )
);

$poll_message_vars = array(
    '%%user_name%%'                     => __("User Name", "poll-maker"),
    '%%user_email%%'                    => __("User Email", "poll-maker"),
    "%%user_phone%%"                    => __("User Phone", "poll-maker"),
    '%%poll_title%%'      				=> __("Poll title", "poll-maker"),
    '%%users_first_name%%'     			=> __("User's First Name", "poll-maker"),
    '%%users_last_name%%'       		=> __("User's Last Name", "poll-maker"),
    '%%creation_date%%'       			=> __("Creation date of the poll", "poll-maker"),
    '%%current_date%%'       			=> __("Current date", "poll-maker"),
    '%%current_poll_author%%'   		=> __("Author of the current poll", "poll-maker"),
    '%%user_wordpress_roles%%'  		=> __("User's Wordpress Roles", "poll-maker"),    
    "%%user_wordpress_email%%"  		=> __("User's WordPress profile email", "poll-maker"),
    '%%user_wordpress_website%%'   		=> __("User's Wordpress Website", "poll-maker"),
    '%%user_display_name%%'    			=> __("User's Display Name", "poll-maker"),
    '%%user_nickname%%'    				=> __("User's Nick Name", "poll-maker"),
    '%%user_ip_address%%'    			=> __("User's IP address", "poll-maker"),
    '%%poll_pass_count%%'    			=> __("Polls pass count", "poll-maker"),
    '%%passed_poll_count_per_user%%'   	=> __("Passed polls count per user", "poll-maker"),
    '%%current_poll_page_link%%'   		=> __("Current polls posted link", "poll-maker"),
);

$poll_message_vars_html = $this->ays_poll_generate_message_vars_html( $poll_message_vars );

$poll            = array(
    'author_id'   => $author,
    'title'       => 'Default title',
    'description' => '',
    'categories'  => array(),
    'image'       => '',
    'question'    => '',
    'type'        => 'choosing',
    'view_type'   => '',
    'answers'     => array(),
    'show_title'  => 1,
    'styles'      => '',
    'custom_css'  => '',
    'theme_id'    => 1,
);
$default_colors  = array(
    "main_color"       => "#0C6291",
    "text_color"       => "#0C6291",
    "icon_color"       => "#0C6291",
    "box_shadow_color" => "#000000",
    "bg_color"         => "#FBFEF9",
    "title_bg_color"   => "",
    "answer_bg_color"  => "#FBFEF9",
    "button_text_color"=> "#FBFEF9",
    "button_bg_color"  => "#0C6291",
    "border_color"     => "#0C6291",
);
$default_options = array(
    'randomize_answers'        => 'off',
    "icon_size"                => 24,
    "width"                    => 600,
    "width_for_mobile"         => '',
    "btn_text"                 => __('Vote', "poll-maker"),
    "see_res_btn_text"         => __('See Results', "poll-maker"),
    "border_style"             => "ridge",
    "border_radius"            => 0,
    "border_width"             => 1,
    "enable_box_shadow"        => "",
    "box_shadow_color"         => "#000000",
    "poll_box_shadow_x_offset" => 0,
    "poll_box_shadow_y_offset" => 0,
    "poll_box_shadow_z_offset" => 15,
    "bg_image"                 => "",
    "hide_results"             => 0,
    "hide_results_text"        => __("Thanks for your answer!", "poll-maker"),
    "allow_not_vote"           => 0,
    "show_social"              => 0,
    "poll_show_social_ln"      => "on",
	"poll_show_social_fb"      => "on",
	"poll_show_social_tr"      => "on",
	"poll_show_social_vk"      => "off",
    "load_effect"              => "load_gif",
    "load_gif"                 => "plg_pro1",
    'limit_users'              => 0,
    "limitation_message"       => __("You have already voted", "poll-maker"),
    'dont_show_poll_container_attempts' => 'off',
    'redirect_url'             => '',
    'redirection_delay'        => '',
    'attempts_count'           => 1,
    'user_role'                => 0,
    'enable_restriction_pass'  => 0,
    'restriction_pass_message' => __("You don't have permissions for passing the poll", "poll-maker"),
    'enable_logged_users'         => 0,
    'enable_logged_users_message' => __('You must sign in for passing the poll', "poll-maker"),
    'notify_email_on'             => 0,
    'notify_email'                => '',
    'result_sort_type'            => 'none',
    'redirect_after_submit'       => 0,
    'redirect_users'              => 0,
    'redirect_after_vote_url'     => '',
    'redirect_after_vote_delay'   => '',
    'published'                   => 1,
    'enable_pass_count'           => 'on',
    'create_date'                 => current_time( 'mysql' ),
    'activeInterval'              => '',
    'deactiveInterval'            => '',
    'activeIntervalSec'           => '',
    'deactiveIntervalSec'         => '',
    'enable_background_gradient'  => 'off',
    'background_gradient_color_1' => '#103251',
    'background_gradient_color_2' => '#607593',
    'poll_gradient_direction'     => 'vertical',
    'active_date_check'           => '',
    'active_date_message_soon'    => "<p style='text-align: center'>" . __("The poll will be available soon!", "poll-maker") . "</p>",
    'active_date_message'         => __("The poll has expired!", "poll-maker"),
    'enable_restart_button'       => 0,
    'enable_vote_btn'             => 1,
    'show_votes_count'            => 1,
    'allow_anonymity'             => 0,
    'edit_previous_submission'    => 'off',
    'show_res_percent'            => 1,
    'poll_direction'              => 'ltr',
    'poll_allow_multivote'        => 'off',
    'user_add_answer'             => 0,
    'result_in_rgba'              => 0,
    'enable_password'             => 'off',
    'password_poll'               => '',
    'poll_password_message'       => 'Please enter password',
    'poll_enable_password_visibility' => "off",
    'background_size'             => 'cover',
    'disable_answer_hover'        => 0,
    'enable_asnwers_sound'        => 'off',
    'poll_bg_image_position'      => 'center center',
    'poll_bg_img_in_finish_page'  => 'off',
    'ays_add_post_for_poll'       => 'off',
    'show_answer_message'         => 'off',
    'show_answers_caption'        => 'on',
    'answers_grid_column_mobile'  => 'on',
    'enable_vote_limitation'      => 'off',
    'vote_limitation'             => '',
    'limitation_time_period'      => '',
    'vote_notification_email_msg' => '',
    // 'vote_limit_message'          => '',
    'enable_tackers_count'        => 'off',
    'tackers_count'               => '',
    'show_answers_icon'           => 'off',
    'answer_icon'                 => 'radio',
    'enable_google_sheets'        => '',
    'spreadsheet_id'              => '',
    'answer_sort_type'            => 'default',
    'logo_image'                  => '',
    'allow_collect_user_info'     => 'off',
    'sendgrid_email_on'           => 'custom',
    'poll_sendgrid_email_from'    => '',
    'poll_sendgrid_template_id'   => '',
    'poll_sendgrid_email_name'    => '',
    'show_votes_before_voting'    => 'off',
    'show_votes_before_voting_by' => 'by_count',
    'dont_show_poll_cont'         => 'off',
    'see_result_button'           => 'on',
    'see_result_radio'            => 'ays_see_result_button',
    'loader_font_size'            => '64',
    'show_answers_numbering'      => 'none',    
    'question_font_size'          => '16', 
    'question_font_size_mobile'   => '16',
    'poll_question_image_object_fit' => "cover",  
    'poll_question_image_height'  => '',
    'poll_title_font_size'        => 18,
    'poll_title_font_size_mobile' => 20,
    'poll_title_alignment'        => "center",
    'poll_title_alignment_mobile' => "center",
    'poll_enable_answer_image_after_voting' => "off",
    'enable_poll_title_text_shadow' => 'off',
    'poll_title_text_shadow'        => 'rgba(255,255,255,0)',
    'poll_title_text_shadow_x_offset' => 2,
    'poll_title_text_shadow_y_offset' => 2,
    'poll_title_text_shadow_z_offset' => 0,

    // Text type options
    'poll_text_type_length_enable' => "off",
    'poll_text_type_limit_type'    => "characters",
    'poll_text_type_limit_length'  => "",
    'poll_text_type_limit_message' => "off",
    'poll_text_type_placeholder'   => 'Your answer',
    'poll_text_type_width'         => "",
    'poll_text_type_width_type'    => "percent",
    // PRO options
    'poll_send_mail_to_site_admin'           => 'on',
    'poll_email_configuration_from_email'    => '',
    'poll_email_configuration_from_name'     => '',
    'poll_email_configuration_from_subject'  => '',
    'poll_email_configuration_replyto_email' => '',
    'poll_email_configuration_replyto_name'  => '',
    'poll_admin_email_subject'               => '',
    // Answers styles
    'answers_padding'             => '10',
    'answers_margin'              => '10',
    'answers_border'              => 'on',
    'answers_border_width'        => '1',
    'answers_border_style'        => 'solid',
    'answers_border_color'        => '#444',
    'answers_box_shadow'          => 'off',
    'answers_box_shadow_color'    => '#000',
    'poll_answer_box_shadow_x_offset' => 0,
    'poll_answer_box_shadow_y_offset' => 0,
    'poll_answer_box_shadow_z_offset' => 10,
    'ans_img_height' => '150',
    'poll_answer_image_height_for_mobile' => '150',
    'ans_img_caption_style' => 'outside',
    'ans_img_caption_position'=> 'bottom',
    'answer_font_size' => '16',
    'poll_answer_font_size_mobile' => '16',
    'answers_object_fit' => 'cover',
    'answers_grid_column' => '2',
    'fake_votes' => 'off',
    'display_fields_labels' => 'off',
    'autofill_user_data' => 'off',
    'poll_create_author' => $user_id,
    'poll_main_url' => '',
    'poll_logo_url_new_tab' => 'off',
    'show_result_view' => 'google_bar_chart',
);

$settings_options = $this->settings_obj->ays_get_setting('options');
if($settings_options){
    $settings_options = json_decode($settings_options, true);
}else{
    $settings_options = array();
}

switch ( $action ) {
    case 'add':
        if (!$id) {
            $heading = __('Add new poll', "poll-maker");
            $options = array_merge($default_options, $default_colors);

            
            $poll_default_options = ($this->settings_obj->ays_get_setting('poll_default_options') === false) ? array() : $this->settings_obj->ays_get_setting('poll_default_options');
            if (!empty($poll_default_options)) {
                $options = json_decode($poll_default_options, true);
                $poll['theme_id'] = isset($options['theme_id']) && $options['theme_id'] != '' ? $options['theme_id'] : 1;
            }

            // Default category
            $poll_default_cat = isset($settings_options['default_category']) && $settings_options['default_category'] != '' ? explode("," , $settings_options['default_category']) : array("1");
            $poll['categories'] = $poll_default_cat;

            // Default type
            $poll_default_type = isset($settings_options['default_type']) && $settings_options['default_type'] != '' ? esc_attr($settings_options['default_type']) : "choosing";
            $poll['type'] = $poll_default_type;


            $poll_type = '';
            $ays_answer_message = '';
            $ays_check_post = ''; 
            break;
        }
    case 'edit':
        $heading = __('Edit poll', "poll-maker");
        $poll    = $this->polls_obj->get_poll_by_id($id);
        $poll_type = isset($poll) && isset($poll['type']) ? $poll['type'] : '';
        $post_id = !empty($poll) ? $poll['post_id'] : '';
        $ays_check_post = isset($poll['styles']['ays_add_post_for_poll']) ? $poll['styles']['ays_add_post_for_poll'] : 'off';
        $ays_answer_message = isset($poll['styles']['show_answer_message']) &&  $poll['styles']['show_answer_message'] == 'on' ? true : false;
        $ays_poll_view_post_url = get_permalink($post_id);
        $ays_poll_edit_post_url = get_edit_post_link($post_id);
        $poll_answer_messages = !empty($poll['answer_message']) ? json_decode($poll['answer_message'], true) : array();

        if (empty($poll)) {
            $url = esc_url_raw(remove_query_arg(array('action', 'poll')));
            wp_redirect($url);
        }
        if (isset($poll['styles']) && is_array($poll['styles']) && !empty($poll['styles'])) {
            $options = array_merge($default_options, $poll['styles']);
        } else {
            $options = $default_options;
        }
        break;
}
$loader_iamge = "<span class='display_none'><img class='ays-loader-img'src=".POLL_MAKER_AYS_ADMIN_URL."/images/loaders/loading.gif></span>";
$ays_super_admin_email = get_option('admin_email');
$wp_general_settings_url = admin_url( 'options-general.php' );

$author_id = isset($poll['author_id']) ? intval( $poll['author_id'] ) : "";
if($author_id != ""){
    $owner = false;
    if( $user_id == $author_id ){
        $owner = true;
    }
    
    if( current_user_can( 'manage_options' ) ){
        $owner = true;
    }
    
    if( !$owner ){
        $url = esc_url_raw( remove_query_arg( array('action', 'poll') ) );
        wp_redirect( $url );
    }
}

$enable_pass_count = (isset($options['enable_pass_count'])) ? $options['enable_pass_count'] : '';
$categories        = $this->polls_obj->get_categories();
global $wp_roles;
$ays_users_roles = $wp_roles->roles;

if (isset($_POST['ays_submit']) || isset($_POST['ays_submit_top'])) {
    $this->polls_obj->add_or_edit_polls($_POST, $id);
} elseif (isset($_POST['ays_apply_top']) || isset($_POST['ays_apply'])) {
    $this->polls_obj->add_or_edit_polls($_POST, $id, "apply");
} elseif(isset($_POST['ays_default'])){
    $_POST['ays_default_option'] = 'ays_default_option';
    $this->polls_obj->add_or_edit_polls($_POST , $id , "apply");    
} elseif (isset($_POST['ays_poll_cancel']) || isset($_POST['ays_poll_cancel_top']) ) {
    unset($_GET['page']);
    $url = remove_query_arg( array_keys($_GET) );
    wp_redirect( $url );
}


$image_text      = __('Add Image', "poll-maker");
$image_text_bg   = __('Add Image', "poll-maker");
$image_text_load = __('Add Image', "poll-maker");
$image_text_logo = __('Add Image', "poll-maker");

$poll_acordion_svg_html = '
<div class="ays-poll-accordion-arrow-box">
    <svg class="ays-poll-accordion-arrow ays-poll-accordion-arrow-active" version="1.2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" overflow="visible" preserveAspectRatio="none" viewBox="0 0 24 24" width="32" height="32">
        <g>
            <path xmlns:default="http://www.w3.org/2000/svg" d="M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z" fill="#c4c4c4" vector-effect="non-scaling-stroke" />
        </g>
    </svg>
</div>';

$style = "display: none;";
$style_bg = "display: none;";
$style_bg_options = "display: none;";
$style_load = "display: none;";
$style_logo = "display: none;";
$style_logo_check = false;
if (isset($poll['image']) && !empty($poll['image'])) {
    $style      = "display: block;";
    $image_text = __('Edit Image', "poll-maker");
}
if (isset($options['bg_image']) && !empty($options['bg_image'])) {
    $style_bg = "display: block;";
    $style_bg_options = "display: block;";
    $image_text_bg = __('Edit Image', "poll-maker");
}
if (isset($options['custom_load']) && !empty($options['custom_load'])) {
    $style_load      = "display: block;";
    $image_text_load = __('Edit Image', "poll-maker");
}
if (isset($options['logo_image']) && !empty($options['logo_image'])) {
    $style_logo      = "display: block;";
    $style_logo_check = true;
    $image_text_logo = __('Edit Image', "poll-maker");
}

if (!isset($options['info_form']) || (isset($options['anonymity']) && $options['anonymity'] == 0)) {
    $options['info_form'] = 0;
}

$all_fields = $this->get_all_formfields();
if (!isset($poll['fields'])) {
    $poll['fields'] = array(
        $all_fields[0],
        $all_fields[1],
        $all_fields[2],
    );
}
if (!isset($poll['required_fields'])) {
    $poll['required_fields'] = array(
        $all_fields[0],
        $all_fields[1],
        $all_fields[2],
    );
}
$fields          = $poll['fields'];
$required_fields = $poll['required_fields'];

$poll_fields_active_order = (isset($options['poll_fields_active_order']) && !empty($options['poll_fields_active_order'])) ? explode(',', $options['poll_fields_active_order']) : array();
$poll_fields_passive_order = (isset($options['poll_fields_passive_order']) && !empty($options['poll_fields_passive_order'])) ? explode(',', $options['poll_fields_passive_order']) : array();

$custom_fields_active = array();
$custom_fields_passive = array();
foreach ($all_fields as $field) {
    if (in_array($field, $fields)) {
        $custom_fields_active[] = $field;
    } else {
        $custom_fields_passive[] = $field;
    }
}
$slugToIndex_active = array_flip($poll_fields_active_order);
$slugToIndex_passive = array_flip($poll_fields_passive_order);

usort($custom_fields_active, function ($a, $b) use ($slugToIndex_active) {
    $indexA = isset($slugToIndex_active[$a['slug']]) ? $slugToIndex_active[$a['slug']] : PHP_INT_MAX;
    $indexB = isset($slugToIndex_active[$b['slug']]) ? $slugToIndex_active[$b['slug']] : PHP_INT_MAX;
    return $indexA - $indexB;
});
usort($custom_fields_passive, function ($a, $b) use ($slugToIndex_passive) {
    $indexA = isset($slugToIndex_passive[$a['slug']]) ? $slugToIndex_passive[$a['slug']] : PHP_INT_MAX;
    $indexB = isset($slugToIndex_passive[$b['slug']]) ? $slugToIndex_passive[$b['slug']] : PHP_INT_MAX;
    return $indexA - $indexB;
});
$theme_name = get_user_option('admin_color');

$admin_colors = array(
    '80s-kid',
    'default',
    'light',
    'aubergine',
    'blue',
    'coffee',
    'cruise',
    'ectoplasm',
    'flat',
    'lawn',
    'midnight',
    'ocean',
    'primary',
    'seashore',
    'sunrise',
    'vinyard'
);

$color_class = array_search($theme_name, $admin_colors) === false ? 'apm-default' : "apm-$theme_name";
if ((isset($options['published']) && $options['published'] == 1) || !(isset($options['published']))) {
    $published = 1;
} else {
    $published = 0;
}

$options['active_date_check'] = isset($options['active_date_check']) ? $options['active_date_check'] : '';
$active_date_check  = ( isset($options['active_date_check']) && !empty($options['active_date_check']) ) ? true : false;

if ( $active_date_check ) {
    $activateTime   =( isset($options['activeInterval']) && $options['activeInterval'] != '') ?  date('Y-m-d',strtotime($options['activeInterval'])) : date('Y-m-d');
    $activePoll     = $activateTime;
    $deactivateTime = (isset($options['deactiveInterval']) && $options['deactiveInterval'] != '') ? date('Y-m-d',strtotime($options['deactiveInterval'])) : date('Y-m-d');
    $deactivePoll   = $deactivateTime;
} else {
    $activePoll   = date('Y-m-d');
    $deactivePoll = date('Y-m-d');
}

// Theme ID
$poll_theme_id = (isset($poll['theme_id']) && $poll['theme_id'] != '') ? absint( intval( $poll['theme_id'] ) ) : 1;

// LIVE PREVIEW STYLES
switch ( $poll_theme_id ) {
    case 3:
    case 4:
        $poll_theme = 'ays-shape-theme';
        break;
    case 5:
        $poll_theme = 'ays-coffee-theme';
        if (empty($options['answer_bg_color'])) {
            $options['answer_bg_color'] = $this->polls_obj->hex2rgba($options['text_color'], 0.1);
        }
        break;
    case 6:
        $poll_theme = 'ays-aqua-theme';
        if (empty($options['title_bg_color'])) {
            $options['title_bg_color'] = $options['main_color'];
        }
        break;
    case 7:
        $poll_theme = 'ays-minimal-theme';
        if (empty($options['title_bg_color'])) {
            $options['title_bg_color'] = $options['main_color'];
        }
        if (empty($options['button_bg_color'])) {
            $options['button_bg_color'] = '#f1f1f1';
        }
        if (empty($options['button_text_color'])) {
            $options['button_text_color'] = $options['text_color'];
        }
        break;
    default:
        $poll_theme = 'ays-classic-theme';
        break;
}
$without_vote = isset($options['enable_vote_btn']) && $options['enable_vote_btn'] == 0 ? 'apm-answers-without-submit' : "";
$emoji        = array(
    "<i class='ays_poll_far ays_poll_fa-dizzy'></i>",
    "<i class='ays_poll_far ays_poll_fa-smile'></i>",
    "<i class='ays_poll_far ays_poll_fa-meh'></i>",
    "<i class='ays_poll_far ays_poll_fa-frown'></i>",
    "<i class='ays_poll_far ays_poll_fa-tired'></i>",
);

$activePollSec   = isset($options['activeIntervalSec']) && !empty($options['activeIntervalSec']) ? $options['activeIntervalSec'] : '';
$deactivePollSec = isset($options['deactiveIntervalSec']) && !empty($options['deactiveIntervalSec']) ? $options['deactiveIntervalSec'] : '';

$activePoll = $activePoll . " " . $activePollSec;
$deactivePoll = $deactivePoll . " " . $deactivePollSec;

$randomize_answers = (isset($options['randomize_answers']) && $options['randomize_answers'] == 'on') ? true : false;
// Show votes count
$options['show_votes_count'] = isset($options['show_votes_count']) ? $options['show_votes_count'] : 1;
$show_votes_count            = isset($options['show_votes_count']) && intval($options['show_votes_count']) == 1 ? true : false;

// Allow anonymity
$options['allow_anonymity'] = isset($options['allow_anonymity']) ? $options['allow_anonymity'] : 0;
$allow_anonymity            = isset($options['allow_anonymity']) && intval($options['allow_anonymity']) == 1 ? true : false;

// Allow  edit
$options['edit_previous_submission'] = isset($options['edit_previous_submission']) ? $options['edit_previous_submission'] : 'off';
$edit_previous_submission = (isset($options['edit_previous_submission'] ) && $options['edit_previous_submission'] == "on") ? true : false;

// Show result percent
$options['show_res_percent'] = isset($options['show_res_percent']) ? $options['show_res_percent'] : 1;
$show_res_percent = isset($options['show_res_percent']) && intval($options['show_res_percent']) == 1 ? true : false;

// Show result button after schedule
$options['show_result_btn_schedule'] = isset($options['show_result_btn_schedule']) ? $options['show_result_btn_schedule'] : 0;
$showresbtnschedule = isset($options['show_result_btn_schedule']) && intval($options['show_result_btn_schedule']) == 1 ? true : false;

$show_res_btn = isset($options['show_result_btn_see_schedule']) && !empty($options['show_result_btn_see_schedule']) ? $options['show_result_btn_see_schedule'] : 'with_see';

// Show login form for not logged in users
$options['show_login_form'] = isset($options['show_login_form']) ? $options['show_login_form'] : 'off';
$show_login_form = (isset($options['show_login_form'] ) && $options['show_login_form'] == "on") ? true : false;

// Redirect after voting
$options['redirect_users'] = isset($options['redirect_users']) ? $options['redirect_users'] : 0;
$redirect_users = (isset($options['redirect_users']) && $options['redirect_users'] == 1) ? true : false;

// Results notification by email
$options['notify_email_on'] = isset($options['notify_email_on']) ? $options['notify_email_on'] : 0;
$notify_email_on = (isset($options['notify_email_on']) && $options['notify_email_on'] == 1) ? true : false;

// Additional emails
$notify_email = (isset($options[ 'notify_email' ]) && $options[ 'notify_email' ] != '') ? stripslashes ( esc_attr( $options[ 'notify_email' ] ) ) : '';

// Background gradient Aro
$options['enable_background_gradient'] = (!isset($options['enable_background_gradient'])) ? 'off' : $options['enable_background_gradient'];
$enable_background_gradient = (isset($options['enable_background_gradient']) && $options['enable_background_gradient'] == 'on') ? true : false;

$background_gradient_color_1 = (isset($options['background_gradient_color_1']) && $options['background_gradient_color_1'] != '' && $enable_background_gradient) ? $options['background_gradient_color_1'] : '#103251';
$background_gradient_color_2 = (isset($options['background_gradient_color_2']) && $options['background_gradient_color_2'] != '' && $enable_background_gradient) ? $options['background_gradient_color_2'] : '#607593';
$poll_gradient_direction = (isset($options['poll_gradient_direction']) && $options['poll_gradient_direction'] != '') ? $options['poll_gradient_direction'] : 'vertical';

// Poll background size 
$background_size = (isset($options['background_size'])) ? $options['background_size'] : 'cover';

// Answers sound option
// $settings_options = $this->settings_obj->ays_get_setting('options');
// if($settings_options){
//     $settings_options = json_decode($settings_options, true);
// }else{
//     $settings_options = array();
// }
$asnwers_sound = (isset($settings_options['answers_sound']) && $settings_options['answers_sound'] != '') ? true : false;

$answer_default_count = (isset($settings_options['answer_default_count']) && $settings_options['answer_default_count'] != '') ? $settings_options['answer_default_count'] : 2;

$answers_sound_status = false;
if($asnwers_sound){
    $answers_sound_status = true;
}

$options['enable_asnwers_sound'] = isset($options['enable_asnwers_sound']) ? $options['enable_asnwers_sound'] : 'off';
$enable_asnwers_sound = (isset($options['enable_asnwers_sound']) && $options['enable_asnwers_sound'] == "on") ? true : false;

//INTEGRATIONS
$poll_settings = $this->settings_obj;

$mailchimp_res      = ($poll_settings->ays_get_setting('mailchimp') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('mailchimp');
$mailchimp          = json_decode($mailchimp_res, true);
$mailchimp_username = isset($mailchimp['username']) ? $mailchimp['username'] : '';
$mailchimp_api_key  = isset($mailchimp['apiKey']) ? $mailchimp['apiKey'] : '';
$mailchimp_lists    = $mailchimp_api_key ? $this->ays_get_mailchimp_lists($mailchimp_username, $mailchimp_api_key) : array();
$mailchimp_select   = array();
if (!empty($mailchimp_lists) && isset($mailchimp_lists['total_items']) && $mailchimp_lists['total_items'] > 0) {
        foreach ( $mailchimp_lists['lists'] as $list ) {
            $mailchimp_select[] = array(
                'listId'   => $list['id'],
                'listName' => $list['name']
            );
        }
} else {
    $mailchimp_select = __("There are no lists", "poll-maker");
}

// SendGrid
$sendgrid_enabled = false;
$sendgrid_templates = array();
$sendgrid_res      = ($poll_settings->ays_get_setting('sendgrid') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('sendgrid');
$sendgrid          = json_decode($sendgrid_res, true);
$sendgrid_api_key  = isset($sendgrid['apiKey']) ? $sendgrid['apiKey'] : '';
if($sendgrid_api_key != ''){
    $sendgrid_templates = $this->ays_poll_sendgrid_templates($sendgrid_api_key);
    if(isset($sendgrid_templates)){
        $sendgrid_enabled = array_key_exists('errors', $sendgrid_templates) ? false : true;
    }
}


$monitor_res     = ($poll_settings->ays_get_setting('monitor') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('monitor');
$monitor         = json_decode($monitor_res, true);
$monitor_client  = isset($monitor['client']) ? $monitor['client'] : '';
$monitor_api_key = isset($monitor['apiKey']) ? $monitor['apiKey'] : '';
$monitor_lists   = $this->ays_get_monitor_lists($monitor_client, $monitor_api_key);
$monitor_select  = !isset($monitor_lists['Code']) ? $monitor_lists : __("There are no lists", "poll-maker");


$slack_res           = ($poll_settings->ays_get_setting('slack') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('slack');
$slack               = json_decode($slack_res, true);
$slack_client        = isset($slack['client']) ? $slack['client'] : '';
$slack_secret        = isset($slack['secret']) ? $slack['secret'] : '';
$slack_token         = isset($slack['token']) ? $slack['token'] : '';
$slack_conversations = $this->ays_get_slack_conversations($slack_token);
$slack_select        = !isset($slack_conversations['Code']) ? $slack_conversations : __("There are no conversations", "poll-maker");

$active_camp_res               = ($poll_settings->ays_get_setting('active_camp') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('active_camp');
$active_camp                   = json_decode($active_camp_res, true);
$active_camp_url               = isset($active_camp['url']) ? $active_camp['url'] : '';
$active_camp_api_key           = isset($active_camp['apiKey']) ? $active_camp['apiKey'] : '';
$active_camp_lists             = $this->ays_get_active_camp_data('lists', $active_camp_url, $active_camp_api_key);
$active_camp_automations       = $this->ays_get_active_camp_data('automations', $active_camp_url, $active_camp_api_key);
$active_camp_list_select       = !isset($active_camp_lists['Code']) ? $active_camp_lists['lists'] : __("There are no lists", "poll-maker");
$active_camp_automation_select = !isset($active_camp_automations['Code']) ? $active_camp_automations['automations'] : __("There are no automations", "poll-maker");
$zapier_res  = ($poll_settings->ays_get_setting('zapier') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('zapier');
$zapier      = json_decode($zapier_res, true);
$zapier_hook = isset($zapier['hook']) ? $zapier['hook'] : '';

// Google sheet
$google_res           = ($poll_settings->ays_get_setting('google_sheet') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('google_sheet');
$google               = json_decode($google_res, true);
$google_client        = isset($google['client']) ? $google['client'] : '';
$google_secret        = isset($google['secret']) ? $google['secret'] : '';
$google_token         = isset($google['token']) ? $google['token'] : '';
$google_refresh_token = isset($google['refresh_token']) ? $google['refresh_token'] : '';

$poll_attributes = (isset($options['poll_attributes'])) ? $options['poll_attributes'] : array();

// MailChimp
$enable_mailchimp = (isset($options['enable_mailchimp']) && $options['enable_mailchimp'] == 'on') ? true : false;
$mailchimp_list = (isset($options['mailchimp_list'])) ? $options['mailchimp_list'] : '';

// Campaign Monitor
$enable_monitor = (isset($options['enable_monitor']) && $options['enable_monitor'] == 'on') ? true : false;
$monitor_list   = (isset($options['monitor_list'])) ? $options['monitor_list'] : '';

// Slack
$enable_slack       = (isset($options['enable_slack']) && $options['enable_slack'] == 'on') ? true : false;
$slack_conversation = (isset($options['slack_conversation'])) ? $options['slack_conversation'] : '';

// ActiveCampaign
$enable_active_camp     = (isset($options['enable_active_camp']) && $options['enable_active_camp'] == 'on') ? true : false;
$active_camp_list       = (isset($options['active_camp_list'])) ? $options['active_camp_list'] : '';
$active_camp_automation = (isset($options['active_camp_automation'])) ? $options['active_camp_automation'] : '';

// Zapier
$enable_zapier = (isset($options['enable_zapier']) && $options['enable_zapier'] == 'on') ? true : false;

// Mad Mimi
$mad_mimi_res  = ($poll_settings->ays_get_setting('mad_mimi') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('mad_mimi');
$mad_mimi      = json_decode($mad_mimi_res, true);
$mad_mimi_user_name = isset($mad_mimi['user_name']) ? $mad_mimi['user_name'] : '';
$mad_mimi_api_key   = isset($mad_mimi['api_key']) ? $mad_mimi['api_key'] : '';
$mad_mimi_lists = $this->ays_poll_mad_mimi_lists($mad_mimi_user_name , $mad_mimi_api_key);

// GetResponse
$getResponse_res = ($poll_settings->ays_get_setting('get_response') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('get_response');
$getResponse = json_decode($getResponse_res, true);
$getResponse_api_key = isset($getResponse['api_key']) ? $getResponse['api_key'] : '';
$getResponse_lists = $this->ays_poll_getResposne_lists($getResponse_api_key);
$getResponse_status  = isset($getResponse_lists['status']) && $getResponse_lists['status'] ? true : false; 
$getResponse_message = isset($getResponse_lists['message']) && $getResponse_lists['message'] ? esc_attr($getResponse_lists['message']) : __("Something went wrong", "poll-maker");

// mailerLite
$mailerLite_res     = ($poll_settings->ays_get_setting('mailerLite') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('mailerLite');
$mailerLite         = json_decode($mailerLite_res, true);
$mailerLite_api_key = isset($mailerLite['api_key']) && $mailerLite['api_key'] != "" ? esc_attr($mailerLite['api_key']) : '';
$mailerLite_groups  = $this->ays_poll_get_mailerLite_groups($mailerLite_api_key);

$mailerLite_get_groups      = isset($mailerLite_groups['groups']) && !empty($mailerLite_groups['groups']) ? $mailerLite_groups['groups'] : array();
$mailerLite_response_status = isset($mailerLite_groups['status']) && $mailerLite_groups['status'] ? true : false;

// reCAPTCHA
$recaptcha_res  = ($poll_settings->ays_get_setting('recaptcha') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('recaptcha');
$recaptcha      = json_decode($recaptcha_res, true);
$recaptcha_site_key = isset($recaptcha['site_key']) && $recaptcha['site_key'] != "" ? esc_attr($recaptcha['site_key']) : '';
$recaptcha_secret_key = isset($recaptcha['secret_key']) && $recaptcha['secret_key'] != "" ? esc_attr($recaptcha['secret_key']) : '';

// ConvertKit
$convertKit_res      = ($poll_settings->ays_get_setting('convertKit') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('convertKit');
$convertKit          = json_decode($convertKit_res, true);
$convertKit_api_key  = isset($convertKit['api_key']) && $convertKit['api_key'] != "" ? esc_attr($convertKit['api_key']) : '';
$convertKit_forms    = $this->ays_poll_get_convertKit_forms($convertKit_api_key);
$convertKit_forms_list = isset($convertKit_forms['forms']) && !empty($convertKit_forms['forms']) ? $convertKit_forms['forms'] : array();
$convertKit_response_status = isset($convertKit_forms['status']) && $convertKit_forms['status'] ? true : false;

// Redirect after submit
$options['redirect_after_submit'] = (!isset($options['redirect_after_submit'])) ? 0 : $options['redirect_after_submit'];
$redirect_after_submit = (isset($options['redirect_after_submit']) && $options['redirect_after_submit'] == 1) ? true : false;
$submit_redirect_url = isset($options['ays_submit_redirect_url']) ? $options['ays_submit_redirect_url'] : '';
$submit_redirect_url_dropdown = isset($options['ays_submit_redirect_url_dropdown']) ? $options['ays_submit_redirect_url_dropdown'] : '';

// Xcho Password for Poll
$enable_password  = isset($options['enable_password']) && $options['enable_password'] == 'on' ? $options['enable_password'] : '';
$password_poll  = isset($options['password_poll']) && $options['password_poll'] != '' ? $options['password_poll'] : '';
$poll_password_message = ( isset($options['poll_password_message']) && $options['poll_password_message'] != "" ) ?  stripslashes($options['poll_password_message']) : "Please enter password";
// Enable toggle password visibility
$options['poll_enable_password_visibility'] = isset($options['poll_enable_password_visibility']) ? $options['poll_enable_password_visibility'] : 'off';
$poll_enable_password_visibility = (isset($options['poll_enable_password_visibility']) && $options['poll_enable_password_visibility'] == 'on') ? true : false;


$options['enable_answer_style'] = isset($options['enable_answer_style']) ? $options['enable_answer_style'] : 'on';

if (isset($options['poll_allow_answer'])) {
    // Different name in free version
    $allow_custom_answer = $options['poll_allow_answer'] == 'on' ? true : false;
} else {
    $allow_custom_answer = (isset($options['user_add_answer']) && $options['user_add_answer'] == 1) ? true : false;
}

if (isset($options['poll_allow_answer_require'])) {
    // Different name in free version
    $require_admin_approval = $options['poll_allow_answer_require'] == 1 ? true : false;
} else {
    $require_admin_approval = (isset($options['add_answer_show_up']) && $options['add_answer_show_up'] == 1) ? true : false;
}

if (isset($options['show_chart_type'])) {
    // Different name in free version
    $show_result_view = $options['show_chart_type'] != '' ? $options['show_chart_type'] : 'google_bar_chart';
} else {
    $show_result_view = isset($options['show_result_view']) ? $options['show_result_view'] : 'google_bar_chart';
}
$show_chart_type_google_height = (isset($options['show_chart_type_google_height']) && $options['show_chart_type_google_height'] != "") ? $options['show_chart_type_google_height'] : 400;

// $poll_create_date = (isset($options['create_date']) && $options['create_date'] != '') ? $options['create_date'] : "0000-00-00 00:00:00";
$change_creation_date = (isset($options['create_date']) && $options['create_date'] != '') ? $options['create_date'] : current_time( 'mysql' );

// Bg image positioning
$poll_bg_image_position = (isset($options['poll_bg_image_position']) && $options['poll_bg_image_position'] != '') ? $options['poll_bg_image_position'] : "center center";

$poll_bg_img_in_finish_page = (isset($options['poll_bg_img_in_finish_page']) && $options['poll_bg_img_in_finish_page'] == "on") ? true : false;
/*
if(isset($options['author']) && $options['author'] != 'null'){
    $poll_author = $options['author'];
} else {
    $poll_author = array('name' => 'Unknown');
}*/
if(isset($poll['author_id']) && $poll['author_id'] != 'null'){
    $poll_author = $poll['author_id'];
} else {
    $poll_author = 0;
}

$show_create_date = (isset($options['show_create_date']) && $options['show_create_date'] == 1) ? true : false;
$show_author = (isset($options['show_author']) && $options['show_author'] == 1) ? true : false;

$custom_class = (isset($options['custom_class']) && $options['custom_class'] != "") ? $options['custom_class'] : '';

$schedule_show_timer = isset($options['ays_poll_show_timer']) && intval($options['ays_poll_show_timer']) == 1 ? true : false;

$show_timer_type = isset($options['ays_show_timer_type']) && !empty($options['ays_show_timer_type'])? $options['ays_show_timer_type'] : 'countdown';

$show_bottom_timer = isset($options['show_bottom_timer']) && intval($options['show_bottom_timer']) == 1 ? true : false;

//vote limitation start
$default_limit_time_period = array(
    'minute' => __('Minute(s)', "poll-maker"),
    'hour'   => __('Hour(s)', "poll-maker"),
    'day'    => __('Day(s)', "poll-maker"),
    'week'   => __('Week(s)', "poll-maker"),
    'month'  => __('Month(s)', "poll-maker")
);
$enable_vote_limitation  = (isset($options['enable_vote_limitation']) && $options['enable_vote_limitation'] == 'on') ? true : false;
$ays_vote_limitation     = (isset($options['vote_limitation']) && $options['vote_limitation'] != '') ? $options['vote_limitation'] : '';
$ays_vote_limitation_time_period = (isset($options['limitation_time_period']) && $options['limitation_time_period'] != '') ? $options['limitation_time_period'] : '';

// Limitation tackers of poll
$options['enable_tackers_count'] = !isset($options['enable_tackers_count']) ? 'off' : $options['enable_tackers_count'];
$enable_tackers_count = (isset($options['enable_tackers_count']) && $options['enable_tackers_count'] == 'on') ? true : false;
$tackers_count = (isset($options['tackers_count']) && $options['tackers_count'] != '') ? $options['tackers_count'] : '';

// Attempts count per user
$attempts_count = (isset($options['attempts_count']) && $options['attempts_count'] != '') ? $options['attempts_count'] : 1;

//Email notification
$enable_email_vote_note = (isset($options['ays_enable_mail_user']) && $options['ays_enable_mail_user'] == 'on') ? $options['ays_enable_mail_user'] : 'off';

// Show answers caption
$options['show_answers_caption'] = isset($options['show_answers_caption']) ? $options['show_answers_caption'] : 'on';
$show_answers_caption = (isset($options['show_answers_caption']) && $options['show_answers_caption'] == 'on') ? true : false;

$options['answers_grid_column_mobile'] = isset($options['answers_grid_column_mobile']) ? $options['answers_grid_column_mobile'] : 'on';
$answers_grid_column_mobile = (isset($options['answers_grid_column_mobile']) && $options['answers_grid_column_mobile'] == 'on') ? true : false;

// Show answers icon
if (isset($options['poll_answer_icon_check'])) {
    // Different name in free version
    $show_answers_icon = $options['poll_answer_icon_check'] == 'on' ? true : false;
} else {
    $options['show_answers_icon'] = isset($options['show_answers_icon']) ? $options['show_answers_icon'] : 'on';
    $show_answers_icon = (isset($options['show_answers_icon']) && $options['show_answers_icon'] == 'on') ? true : false;
}

if (isset($options['poll_answer_icon'])) {
    // Different name in free version
    $options['answers_icon'] = $options['poll_answer_icon'] != '' ? $options['poll_answer_icon'] : 'radio';
} else {
    $options['answers_icon'] = isset($options['answers_icon']) ? $options['answers_icon'] : 'radio';
}

// Ani =========== Buttons Styles Start ===========

// Buttons size
$buttons_size = (isset($options['buttons_size']) && $options['buttons_size'] != "") ? $options['buttons_size'] : 'medium';

// Buttons font size
$buttons_font_size = (isset($options['buttons_font_size']) && $options['buttons_font_size'] != "") ? $options['buttons_font_size'] : '17';

// Buttons mobile font size
$poll_buttons_mobile_font_size = (isset($options['poll_buttons_mobile_font_size']) && $options['poll_buttons_mobile_font_size'] != "") ? esc_attr($options['poll_buttons_mobile_font_size']) : '17';

// Buttons Left / Right padding
$buttons_left_right_padding = (isset($options['buttons_left_right_padding']) && $options['buttons_left_right_padding'] != '') ? $options['buttons_left_right_padding'] : '20';

// Buttons Top / Bottom padding
$buttons_top_bottom_padding = (isset($options['buttons_top_bottom_padding']) && $options['buttons_top_bottom_padding'] != '') ? $options['buttons_top_bottom_padding'] : '10';

// Buttons border radius
$buttons_border_radius = (isset($options['buttons_border_radius']) && $options['buttons_border_radius'] != "") ? $options['buttons_border_radius'] : '3';

// Buttons width
$poll_buttons_width = (isset($options['poll_buttons_width']) && $options['poll_buttons_width'] != "") ? $options['poll_buttons_width'] : '';

// =========== Buttons Styles End ===========

//dropdown type redirect url
$options['redirect_after_submit_drpdwn'] = (!isset($options['redirect_after_submit_drpdwn'])) ? 0 : $options['redirect_after_submit_drpdwn'];
$redirect_after_submit_dropdown = (isset($options['redirect_after_submit_drpdwn']) && $options['redirect_after_submit_drpdwn'] == 1) ? true : false;

if ( isset( $options['poll_allow_multivote'] ) && $options['poll_allow_multivote'] != '' ) {
    $enable_multivote_answer = (isset($options['poll_allow_multivote']) && $options['poll_allow_multivote'] == 'on') ? true : false;
} else {
    $enable_multivote_answer = (isset($options['allow_multivote']) && $options['allow_multivote'] == 'on') ? true : false;
}

if ( isset( $options['poll_allow_multivote_count'] ) && $options['poll_allow_multivote_count'] != '' ) {
    $multivote_answer_count = (isset($options['poll_allow_multivote_count']) && $options['poll_allow_multivote_count'] != '') ? intval(esc_attr($options['poll_allow_multivote_count'])) : '1';
} else {
    $multivote_answer_count = (isset($options['multivote_answer_count']) && $options['multivote_answer_count'] != '') ? intval(esc_attr($options['multivote_answer_count'])) : '1';
}

$poll_multivote_min_count = (isset($options['multivote_answer_min_count']) && $options['multivote_answer_min_count'] != '') ? intval(esc_attr($options['multivote_answer_min_count'])) : '1';

// enable Google sheet 
$enable_google_sheets = (isset($options['enable_google_sheets']) && $options['enable_google_sheets'] == 'on') ? true : false;

// Enable View more button
$options['enable_view_more_button'] = isset($options['enable_view_more_button']) ? $options['enable_view_more_button'] : 'off';
$enable_view_more_button = (isset($options['enable_view_more_button']) && $options['enable_view_more_button'] == 'on' ) ? true : false;
$poll_view_more_button_count = (isset($options['poll_view_more_button_count']) && $options['poll_view_more_button_count'] != '' ) ? absint(intval($options['poll_view_more_button_count'])) : 0;

// Poll Min Height
$poll_min_height = (isset($options['poll_min_height']) && $options['poll_min_height'] != '') ? absint(intval($options['poll_min_height'])) : '';

// Hide results
$options['hide_results'] = isset($options['hide_results']) ? $options['hide_results'] : 0;
$hide_results = (isset($options['hide_results']) && $options['hide_results'] == 1) ? true : false;

// Hide question text
$options['hide_results_questions'] = isset($options['hide_results_questions']) ? $options['hide_results_questions'] : 0;
$hide_results_questions = (isset($options['hide_results_questions']) && $options['hide_results_questions'] == 1) ? true : false;

// Result Message 
$options['hide_result_message'] = isset($options['hide_result_message']) ? $options['hide_result_message'] : 0;
$hide_result_message = (isset($options['hide_result_message']) && $options['hide_result_message'] == 1) ? true : false;

// Poll show passed users 
$poll_show_passed_users = isset($options['show_passed_users']) ? esc_html($options['show_passed_users']) : 'off';
$poll_show_passed_users_checked = isset($poll_show_passed_users) && $poll_show_passed_users == 'on' ? 'checked' : '';
$poll_show_passed_users_count = isset($options['poll_show_passed_users_count']) && $options['poll_show_passed_users_count'] != "" ? intval(esc_attr($options['poll_show_passed_users_count'])) : 3;

// Poll Logo image
$poll_logo_image = isset($options['logo_image']) && $options['logo_image'] != '' ? esc_url($options['logo_image']) : '';
$poll_check_logo = isset($poll_logo_image) && $poll_logo_image != '' ? true : false;
$poll_logo_img = $poll_check_logo ? 'ays_logo_image_on' : 'display_none';
$poll_logo_for_live_container = $poll_check_logo ? 'ays_logo_cont_image_on' : '';

// Allow to collect user info
$poll_allow_collect_info = (isset($options['allow_collect_user_info']) && $options['allow_collect_user_info'] == 'on') ? 'checked' : '';

// Send mail type Custom / SendGrid
$poll_send_mail_type = (isset($options['poll_send_mail_type']) && $options['poll_send_mail_type'] != '') ? sanitize_text_field( $options['poll_send_mail_type'] ) : 'custom';

// SendGrid email name
$poll_sendgrid_email_name = (isset($options['poll_sendgrid_email_name']) && $options['poll_sendgrid_email_name'] != '') ? sanitize_text_field( $options['poll_sendgrid_email_name'] ) : '';

// SendGrid email from
$poll_sendgrid_email_from = (isset($options['poll_sendgrid_email_from']) && $options['poll_sendgrid_email_from'] != '') ? sanitize_email( $options['poll_sendgrid_email_from'] ) : '';

// SendGrid template id
$poll_sendgrid_template_id = (isset($options['poll_sendgrid_template_id']) && $options['poll_sendgrid_template_id'] != '') ? $options['poll_sendgrid_template_id'] : '';

// Mad Mimi
$enable_mad_mimi  = (isset($options['enable_mad_mimi']) && $options['enable_mad_mimi'] == 'on') ? true : false;
$mad_mimi_db_list = (isset($options['mad_mimi_list'])) ? $options['mad_mimi_list'] : '';

// GetResponse
$enable_getResponse = (isset($options['enable_getResponse']) && $options['enable_getResponse'] == 'on') ? true : false;
$getResponse_db_list = (isset($options['getResponse_list']) && $options['getResponse_list'] != '') ? $options['getResponse_list'] : "";

// mailerLite
$enable_mailerLite = (isset($options['enable_mailerLite']) && $options['enable_mailerLite'] == 'on') ? true : false;
$mailerLite_group_id = (isset($options['mailerLite_group_id']) && $options['mailerLite_group_id'] != '') ? $options['mailerLite_group_id'] : "";

// reCaptcha
$enable_recaptcha = (isset($options['enable_recaptcha']) && $options['enable_recaptcha'] == 'on') ? true : false;

// CovertKit
$enable_convertKit  = (isset($options['enable_convertKit']) && $options['enable_convertKit'] == 'on') ? true : false;
$convertKit_form_id = (isset($options['poll_convertKit_form_id']) && $options['poll_convertKit_form_id'] != '') ? esc_attr($options['poll_convertKit_form_id']) : "";


// limit user by country
$options['enable_limit_by_country'] = isset($options['enable_limit_by_country']) ? $options['enable_limit_by_country'] : 'off';
$enable_limit_by_country = (isset($options['enable_limit_by_country']) && $options['enable_limit_by_country'] == 'on' ) ? true : false;
$limit_countrys = (isset($options['limit_countrys']) && $options['limit_countrys'] != "") ? json_decode(stripslashes($options['limit_countrys']), true) : '';

// ===== Default Setting tab ======
// Poll direction
$poll_direction = isset($options['poll_direction']) && $options['poll_direction'] != '' ? $options['poll_direction'] : 'ltr';
// ===== Default Setting tab end ======

// ===== Default Results Setting tab ======
// Poll load effect
$loading_effect = isset($options['load_effect']) && $options['load_effect'] != '' ? $options['load_effect'] : 'load_gif';
$loading_gif = isset($options['load_gif']) && $options['load_gif'] != '' ? $options['load_gif'] : 'plg_pro1';
// ===== Default Results Setting tab end ======

// ===== Default Styles tab ======
$main_color_s        = (isset($options['main_color']) && $options['main_color'] != '' ) ? $options['main_color'] : '#B00101';
$bg_color_s          = (isset($options['bg_color']) && $options['bg_color'] != '' ) ? $options['bg_color'] : '#1B1B1E';
$text_color_s        = (isset($options['text_color']) && $options['text_color'] != '' ) ? $options['text_color'] : '#FAA916';
$button_text_color_s = (isset($options['button_text_color']) && $options['button_text_color'] != '' ) ? $options['button_text_color'] : '#0C6291';
$button_bg_color_s   = (isset($options['button_bg_color']) && $options['button_bg_color'] != '' ) ? $options['button_bg_color'] : '#B00101';
$icon_color_s        = (isset($options['icon_color']) && $options['icon_color'] != '' ) ? $options['icon_color'] : '#FAA916';
$width_s             = (isset($options['width']) && $options['width'] != '' ) ? $options['width'] : 600;
$border_s            = (isset($options['border_style']) && $options['border_style'] != '' ) ? $options['border_style'] : "ridge";
$icon_size_s         = (isset($options['icon_size']) && $options['icon_size'] != '' ) ? $options['icon_size'] : 24;
$title_bg_color_s    = (isset($options['title_bg_color']) && $options['title_bg_color'] != '' ) ? $options['title_bg_color'] : "rgba(255,255,255,0)";
$dis_answer_hover_s  = (isset($options['disable_answer_hover']) && $options['disable_answer_hover'] != '' ) ? $options['disable_answer_hover'] : 0;
$answer_bg_color_s   = (isset($options['answer_bg_color']) && $options['answer_bg_color'] != '' ) ? $options['answer_bg_color'] : 'rgba(255,255,255,0)';
$border_radius_s     = (isset($options['border_radius']) && $options['border_radius'] != '' ) ? intval($options['border_radius']) . 'px' : 0;
$border_width_s      = (isset($options['border_width']) && $options['border_width'] != '') ? intval($options['border_width']) . 'px' : '2px';
$bg_image_s          = (isset($options['bg_image']) && !empty($options['bg_image'])) ? "url({$options['bg_image']})" : "unset";

$enable_box_shadow_s = (!empty($options['enable_box_shadow']) && $options['enable_box_shadow'] == 'on' && !empty($options['box_shadow_color'])) ? $options['box_shadow_color'] . ' 0px 0px 15px 0px' : 'none';
$enable_box_shadow_box = isset($options['enable_box_shadow']) && $options['enable_box_shadow'] == "on" ? "" : "display_none";

// Box shadow coords
//  Box Shadow X offset
$poll_box_shadow_x_offset = (isset($options['poll_box_shadow_x_offset']) && $options['poll_box_shadow_x_offset'] != '' && $options['poll_box_shadow_x_offset'] != 0 ) ? intval( esc_attr( $options['poll_box_shadow_x_offset'] ) ) : 0;

//  Box Shadow Y offset
$poll_box_shadow_y_offset = (isset($options['poll_box_shadow_y_offset']) && $options['poll_box_shadow_y_offset'] != '' && $options['poll_box_shadow_y_offset'] != 0 ) ? intval( esc_attr( $options['poll_box_shadow_y_offset'] ) ) : 0;

//  Box Shadow Z offset
$poll_box_shadow_z_offset = (isset($options['poll_box_shadow_z_offset']) && $options['poll_box_shadow_z_offset'] != '' && $options['poll_box_shadow_z_offset'] != 0 ) ? intval( esc_attr( $options['poll_box_shadow_z_offset'] ) ) : 15;

// ===== Default Styles end ======

// ===== Colors for inputs start ======
 $main_color_inp = isset($options['main_color']) ? $options['main_color'] : '#0C6291';
 $bg_color_inp = (isset($options['bg_color'])) ? $options['bg_color'] : '#FBFEF9';
// ===== Colors for inputs end ======

// =========== Answer Styles start == / Ani / =========

// Answers padding option
if (isset($options['poll_answer_padding'])) {
    // Different name in free version
    $answers_padding = $options['poll_answer_padding'] !== '' ? $options['poll_answer_padding'] : '10';
} else {
    $answers_padding = (isset($options['answers_padding']) && $options['answers_padding'] !== '') ? $options['answers_padding'] : '10';
}

// Answers margin option
if (isset($options['poll_answer_margin'])) {
    // Different name in free version
    $answers_margin = $options['poll_answer_margin'] != '' ? $options['poll_answer_margin'] : '10';
} else {
    $answers_margin = (isset($options['answers_margin']) && $options['answers_margin'] != '') ? $options['answers_margin'] : '10';
}

// Answers border options
$options['answers_border'] = (isset($options['answers_border'])) ? $options['answers_border'] : 'on';
$answers_border = (isset($options['answers_border']) && $options['answers_border'] == 'on') ? true : false;
$answers_border_width = (isset($options['answers_border_width']) && $options['answers_border_width'] != '') ? $options['answers_border_width'] : '1';
$answers_border_style = (isset($options['answers_border_style']) && $options['answers_border_style'] != '') ? $options['answers_border_style'] : 'solid';
$answers_border_color = (isset($options['answers_border_color']) && $options['answers_border_color'] != '') ? $options['answers_border_color'] : '#444';

if (isset($options['poll_answer_enable_box_shadow'])) {
    $answers_box_shadow = $options['poll_answer_enable_box_shadow'] == 'on' ? true : false;
} else {
    $answers_box_shadow = (isset($options['answers_box_shadow']) && $options['answers_box_shadow'] == 'on') ? true : false;
}

if (isset($options['poll_answer_box_shadow_color'])) {
    $answers_box_shadow_color = $options['poll_answer_box_shadow_color'] != '' ? $options['poll_answer_box_shadow_color'] : '#000';
} else {
    $answers_box_shadow_color = (isset($options['answers_box_shadow_color']) && $options['answers_box_shadow_color'] != '') ? $options['answers_box_shadow_color'] : '#000';
}
// Poll answer box shadow parameters
$poll_answer_box_shadow_x_offset  = (isset($options['poll_answer_box_shadow_x_offset']) && $options['poll_answer_box_shadow_x_offset'] != "") ? intval($options['poll_answer_box_shadow_x_offset']) : 0;

$poll_answer_box_shadow_y_offset  = (isset($options['poll_answer_box_shadow_y_offset']) && $options['poll_answer_box_shadow_y_offset'] != "") ? intval($options['poll_answer_box_shadow_y_offset']) : 0;

$poll_answer_box_shadow_z_offset  = (isset($options['poll_answer_box_shadow_z_offset']) && $options['poll_answer_box_shadow_z_offset'] != "") ? intval($options['poll_answer_box_shadow_z_offset']) : 10;

$answers_box_shadow_box = $answers_box_shadow ? "" : "display_none";

// Answers image options
if (isset($options['poll_answer_image_height'])) {
    // Different name in free version
    $ans_img_height = $options['poll_answer_image_height'] != '' ? $options['poll_answer_image_height'] : '150';
} else {

    $ans_img_height = (isset($options['ans_img_height']) && $options['ans_img_height'] != '') ? $options['ans_img_height'] : '150';
}

// Poll answer image height for mobile
$poll_answer_image_height_for_mobile = (isset($options['poll_answer_image_height_for_mobile']) && $options['poll_answer_image_height_for_mobile'] != "") ? esc_attr($options['poll_answer_image_height_for_mobile']) : "150";
$ans_img_caption_style = (isset($options['ans_img_caption_style']) && $options['ans_img_caption_style'] != '') ? $options['ans_img_caption_style'] : 'outside';
$ans_img_caption_position = (isset($options['ans_img_caption_position']) && $options['ans_img_caption_position'] != '') ? $options['ans_img_caption_position'] : 'bottom';

// Poll answer image border radius
$poll_answer_image_border_radius = (isset($options['poll_answer_image_border_radius']) && $options['poll_answer_image_border_radius'] != "") ? esc_attr($options['poll_answer_image_border_radius']) : 0;

// Question font size
$question_font_size = (isset($options['question_font_size']) && $options['question_font_size'] != '') ? $options['question_font_size'] : '16';

// Question font size
$question_font_size_mobile = (isset($options['question_font_size_mobile']) && $options['question_font_size_mobile'] != '') ? $options['question_font_size_mobile'] : '16';

// Poll question image height
$poll_question_image_height = isset($options['poll_question_image_height']) && $options['poll_question_image_height'] != "" ? esc_attr($options['poll_question_image_height']) : ""; 

// Answers font size
$answers_font_size = (isset($options['answer_font_size']) && $options['answer_font_size'] != '') ? $options['answer_font_size'] : 16;

// Answers image object fit
if (isset($options['poll_answer_object_fit'])) {
    // Different name in free version
    $answers_image_object_fit = $options['poll_answer_object_fit'] != '' ? esc_attr( stripslashes($options['poll_answer_object_fit']) ) : 'cover';
} else {
    $answers_image_object_fit = $options['answers_object_fit'] != '' ? esc_attr( stripslashes($options['answers_object_fit']) ) : 'cover';
}

// Answers grid column
$answers_grid_column = (isset($options['answers_grid_column']) && $options['answers_grid_column'] != '') ? $options['answers_grid_column'] : '2';

// Answers border radius
if (isset($options['poll_answer_border_radius'])) {
    // Different name in free version
    $answers_border_radius = $options['poll_answer_border_radius'] != '' ? $options['poll_answer_border_radius'] : '0';
} else {
    $answers_border_radius = (isset($options['answers_border_radius']) && $options['answers_border_radius'] != '') ? $options['answers_border_radius'] : '0';
}

// =========== Answer Styles End == / Ani / =========

// Show votes count per answers before voting
$options['show_votes_before_voting'] = isset($options['show_votes_before_voting']) ? $options['show_votes_before_voting'] : 'off';
$show_votes_before_voting = (isset($options['show_votes_before_voting']) && $options['show_votes_before_voting'] == 'on') ? true : false;
$show_votes_before_voting_by = (isset($options['show_votes_before_voting_by']) && $options['show_votes_before_voting_by'] != '') ? $options['show_votes_before_voting_by'] : 'by_count';

$vote_button         = (isset($options['btn_text']) && $options['btn_text'] != '') ? stripslashes($options['btn_text']) : __('Vote', "poll-maker");

// fake votes
$fake_votes          = (isset($options['fake_votes']) && $options['fake_votes'] == 'on') ? 'checked' : '';
$fake_votes_check    = (isset($options['fake_votes']) && $options['fake_votes'] == 'on') ? true : false;
// $fake_votes_values   = (isset($options['fake_votes']) && $options['fake_votes'] == 'on') ? true : false;

// ==== ADDED NEW ====
// Poll schedule container on/off
$poll_check_exp_cont = (isset($options['dont_show_poll_cont']) && $options['dont_show_poll_cont'] == 'on') ? 'checked' : '';

// Poll see results button in limitations
$poll_see_result_button = (isset($options['see_result_button']) && $options['see_result_button'] == 'on') ? 'checked' : '';
$poll_see_result_button_check = (isset($options['see_result_button']) && $options['see_result_button'] == 'on') ? true : false;
$poll_see_result_button_cont = (isset($options['see_result_button']) && $options['see_result_button'] != 'on') ? 'ays_poll_display_none' : '';
$poll_see_result_radio = (isset($options['see_result_radio']) && $options['see_result_radio'] != '') ? esc_attr($options['see_result_radio']) : 'ays_see_result_button';
$poll_see_result_botton_show = isset($poll_see_result_radio) && $poll_see_result_radio == 'ays_see_result_button' ? 'checked' : '';
$poll_see_result_immediately = isset($poll_see_result_radio) && $poll_see_result_radio == 'ays_see_result_immediately' ? 'checked' : '';

// Loader font size
$poll_loader_font_size = (isset($options['loader_font_size']) && $options['loader_font_size'] != '') ? esc_attr($options['loader_font_size']) : '64';
$poll_loader_size_enable = isset($options['load_effect']) && $options['load_effect'] == "load_gif" ? "" : "display_none";
$poll_loader_size_line_enable = isset($options['load_effect']) && $options['load_effect'] == "load_gif" ? "" : "ays_hr_display_none";

// Show answers numbering
$show_answers_numbering = (isset($options['show_answers_numbering']) && sanitize_text_field( $options['show_answers_numbering'] ) != '') ? sanitize_text_field( $options['show_answers_numbering'] ) : 'none';

// Poll question image object fit
$poll_question_image_object_fit = (isset($options['poll_question_image_object_fit']) && $options['poll_question_image_object_fit'] != "") ? esc_attr($options['poll_question_image_object_fit']) : "cover";

// Default border color
$main_color = isset($options['main_color']) && $options['main_color'] != "" ? $options['main_color'] : $default_colors['main_color'];
$default_border = isset($options['border_color']) && $options['border_color'] != "" ? $options['border_color'] : $main_color;

// Poll load effect message
$poll_effect_message = isset($options['effect_message']) && $options['effect_message'] != "" ? $options['effect_message'] : "";

// ==== ====


// Poll Type 
$ays_poll_enable_answer_style_type = isset($poll['type']) && ($poll['type'] == "choosing" || $poll['type'] == "text") ? "" : "ays_enable_answer_style_for_type";
if($ays_poll_enable_answer_style_type != ""){
    if(isset($options['enable_answer_style'])){
        $options['enable_answer_style'] = "off";
    }
}

// Send mail to super Admin
$options['poll_send_mail_to_site_admin'] = isset($options['poll_send_mail_to_site_admin']) ? $options['poll_send_mail_to_site_admin'] : 'on';
$poll_send_mail_to_site_admin = (isset($options['poll_send_mail_to_site_admin']) && $options['poll_send_mail_to_site_admin'] == 'on') ? true : false;

//Email Message
$poll_mail_message_admin = (isset($options['poll_mail_message_admin']) && $options['poll_mail_message_admin'] != '') ? wpautop(stripslashes($options['poll_mail_message_admin'])) : '';

//Admin Subject
$poll_admin_email_subject = (isset($options[ 'poll_admin_email_subject' ]) && $options[ 'poll_admin_email_subject' ] != '') ? stripslashes ( esc_attr( $options[ 'poll_admin_email_subject' ] ) ) : '';

//---- Email configuration Start  ---- //

// From email 
$poll_email_configuration_from_email = (isset($options[ 'poll_email_configuration_from_email' ]) &&  $options[ 'poll_email_configuration_from_email' ] != '') ? stripslashes( sanitize_email( $options[ 'poll_email_configuration_from_email' ] ) ) : '';

// From name
$poll_email_configuration_from_name = (isset($options[ 'poll_email_configuration_from_name' ]) && $options[ 'poll_email_configuration_from_name' ] != '') ? stripslashes ( esc_attr( $options[ 'poll_email_configuration_from_name' ] ) ) : '';

// Subject
$poll_email_configuration_from_subject = (isset($options[ 'poll_email_configuration_from_subject' ]) && $options[ 'poll_email_configuration_from_subject' ] != '') ? stripslashes ( esc_attr( $options[ 'poll_email_configuration_from_subject' ] ) ) : '';

// Reply to email
$poll_email_configuration_replyto_email = (isset($options[ 'poll_email_configuration_replyto_email' ]) &&  $options[ 'poll_email_configuration_replyto_email' ] != '') ? stripslashes( sanitize_email( $options[ 'poll_email_configuration_replyto_email' ] ) ) : '';

// Reply to name
$poll_email_configuration_replyto_name = (isset($options[ 'poll_email_configuration_replyto_name' ]) && $options[ 'poll_email_configuration_replyto_name' ] != '') ? stripslashes ( esc_attr( $options[ 'poll_email_configuration_replyto_name' ] ) ) : '';

//---- Email configuration End ---- //

// Poll logo image url
$poll_logo_image_url = isset($options['poll_logo_url']) && $options['poll_logo_url'] != "" ? esc_attr($options['poll_logo_url']) : ""; 
$poll_logo_image_url_check = isset($options['poll_enable_logo_url']) && $options['poll_enable_logo_url'] == "on" ? true : false;

// Poll container max-width for mobile
$poll_mobile_max_width = (isset($options['poll_mobile_max_width']) && $options['poll_mobile_max_width'] != "") ? esc_attr($options['poll_mobile_max_width']) : '';

// Poll title font size
$poll_title_font_size    = (isset($options['poll_title_font_size']) && $options['poll_title_font_size'] != "") ? absint(intval(esc_attr($options['poll_title_font_size']))) : "18";

// Poll title font size for mobile
$poll_title_font_size_mobile    = (isset($options['poll_title_font_size_mobile']) && $options['poll_title_font_size_mobile'] != "") ? absint(intval(esc_attr($options['poll_title_font_size_mobile']))) : "20";


// Poll title alignment
$poll_title_alignment    = ( isset($options['poll_title_alignment']) && $options['poll_title_alignment'] != "" ) ? esc_attr($options['poll_title_alignment']) : "center";

// Poll title alignment mobile
$poll_title_alignment_mobile    = ( isset($options['poll_title_alignment_mobile']) && $options['poll_title_alignment_mobile'] != "" ) ? esc_attr($options['poll_title_alignment_mobile']) : $poll_title_alignment;

// Poll view type
$poll_view_type_for_text    = ( isset($poll['view_type']) && $poll['view_type'] == "paragraph" ) ? "paragraph" : "short_text";

// ===== Poll text type options start =====
$poll_text_type_length_enable = ( isset($options['poll_text_type_length_enable']) && $options['poll_text_type_length_enable'] == "on" ) ? true : false;
$poll_text_type_limit_type    = ( isset($options['poll_text_type_limit_type']) && $options['poll_text_type_limit_type'] != "" ) ? esc_attr($options['poll_text_type_limit_type']) : "characters";
$poll_text_type_limit_length  = ( isset($options['poll_text_type_limit_length']) && $options['poll_text_type_limit_length'] != "" ) ? esc_attr($options['poll_text_type_limit_length']) : "";
$poll_text_type_limit_message = ( isset($options['poll_text_type_limit_message']) && $options['poll_text_type_limit_message'] == "on" ) ?  true : false;
$poll_text_type_placeholder   = ( isset($options['poll_text_type_placeholder']) && $options['poll_text_type_placeholder'] != "" ) ?  stripslashes(esc_attr($options['poll_text_type_placeholder'])) : "";
$poll_text_type_width         = ( isset($options['poll_text_type_width']) && $options['poll_text_type_width'] != "" ) ?  stripslashes(esc_attr($options['poll_text_type_width'])) : "";
$poll_text_type_width_type    = ( isset($options['poll_text_type_width_type']) && $options['poll_text_type_width_type'] != "" ) ?  esc_attr($options['poll_text_type_width_type']) : "percent";
// ===== Poll text type options end =====

// Poll answers font size on mobile
$poll_answer_font_size_mobile  = (isset($options['poll_answer_font_size_mobile']) && $options['poll_answer_font_size_mobile'] != '') ? esc_attr($options['poll_answer_font_size_mobile']) : '16';

// Show Answers image after voting
$poll_enable_answer_image_after_voting = isset($options['poll_enable_answer_image_after_voting']) && $options['poll_enable_answer_image_after_voting'] == "on" ? true : false; 

$poll_social_buttons = isset($options['show_social']) && $options['show_social'] ? true : false;
$poll_social_buttons_heading = ( isset( $options[ 'poll_social_buttons_heading' ] ) && $options[ 'poll_social_buttons_heading' ] != '' ) ? stripslashes( wpautop( $options[ 'poll_social_buttons_heading' ] ) ) : '';
$poll_show_social_ln = isset($options['poll_show_social_ln']) && $options['poll_show_social_ln'] == "on" ? true : false;
$poll_show_social_fb = isset($options['poll_show_social_fb']) && $options['poll_show_social_fb'] == "on" ? true : false;
$poll_show_social_tr = isset($options['poll_show_social_tr']) && $options['poll_show_social_tr'] == "on" ? true : false;
$poll_show_social_vk = isset($options['poll_show_social_vk']) && $options['poll_show_social_vk'] == "on" ? true : false;

// Title text shadow
$options['enable_poll_title_text_shadow'] = (isset($options['enable_poll_title_text_shadow']) && $options['enable_poll_title_text_shadow'] == 'on') ? 'on' : 'off'; 
$enable_poll_title_text_shadow = (isset($options['enable_poll_title_text_shadow']) && $options['enable_poll_title_text_shadow'] == 'on') ? true : false; 
$poll_title_text_shadow = (isset($options['poll_title_text_shadow']) && $options['poll_title_text_shadow'] != '') ? stripslashes( esc_attr( $options['poll_title_text_shadow'] ) ) : 'rgba(255,255,255,0)';

$poll_title_text_shadow_x_offset = (isset($options['poll_title_text_shadow_x_offset']) && $options['poll_title_text_shadow_x_offset'] != '') ? stripslashes( esc_attr( $options['poll_title_text_shadow_x_offset'] ) ) : 2;

$poll_title_text_shadow_y_offset = (isset($options['poll_title_text_shadow_y_offset']) && $options['poll_title_text_shadow_y_offset'] != '') ? stripslashes( esc_attr( $options['poll_title_text_shadow_y_offset'] ) ) : 2;

$poll_title_text_shadow_z_offset = (isset($options['poll_title_text_shadow_z_offset']) && $options['poll_title_text_shadow_z_offset'] != '') ? stripslashes( esc_attr( $options['poll_title_text_shadow_z_offset'] ) ) : 0;

// Display form fields labels
$options['display_fields_labels'] = isset($options['display_fields_labels']) ? sanitize_text_field($options['display_fields_labels']) : 'off';
$display_fields_labels = (isset($options['display_fields_labels']) && $options['display_fields_labels'] == 'on') ? true : false;

// Autofill user data
$options['autofill_user_data'] = isset($options['autofill_user_data']) ? sanitize_text_field($options['autofill_user_data']) : 'off';
$autofill_user_data = (isset($options['autofill_user_data']) && $options['autofill_user_data'] == 'on') ? true : false;

// Change the author of the current poll
$change_poll_create_author = (isset($options['poll_create_author']) && $options['poll_create_author'] != '') ? absint( sanitize_text_field( $options['poll_create_author'] ) ) : $user_id;
$get_current_poll_author_data = get_userdata($change_poll_create_author);

// Poll main url
$poll_main_url = (isset($options['poll_main_url']) &&  $options['poll_main_url'] != '') ? stripslashes( esc_url($options['poll_main_url']) ) : '';

//Open logo URL in new tab
$poll_logo_image_url_check_new_tab = (isset($options['poll_logo_url_new_tab' ]) &&  $options['poll_logo_url_new_tab' ] == 'on') ? "checked" : "";

//Poll Logo title
$poll_logo_title = (isset( $options['poll_logo_title' ] ) && $options['poll_logo_title' ] != '') ? esc_attr( $options['poll_logo_title' ] ) : '';

// WP Editor height
$poll_wp_editor_height = (isset($settings_options['poll_wp_editor_height']) && $settings_options['poll_wp_editor_height'] != '') ? absint( sanitize_text_field($settings_options['poll_wp_editor_height']) ) : 100 ;

//Poll mobile width
$width_for_mobile = (isset($options['width_for_mobile' ]) && $options['width_for_mobile' ] != '') ? $options['width_for_mobile' ] : '';

// Social Media links
$enable_social_links = (isset($options['enable_social_links']) && $options['enable_social_links'] == "on") ? true : false;
$social_links = (isset($options['social_links'])) ? $options['social_links'] : array(
    'linkedin_link' => '',
    'facebook_link' => '',
    'twitter_link' => '',
    'vkontakte_link' => '',
    'instagram_link' => '',
    'youtube_link' => '',
);
$linkedin_link = isset($social_links['linkedin_link']) && $social_links['linkedin_link'] != '' ? $social_links['linkedin_link'] : '';
$facebook_link = isset($social_links['facebook_link']) && $social_links['facebook_link'] != '' ? $social_links['facebook_link'] : '';
$twitter_link = isset($social_links['twitter_link']) && $social_links['twitter_link'] != '' ? $social_links['twitter_link'] : '';
$vkontakte_link = isset($social_links['vkontakte_link']) && $social_links['vkontakte_link'] != '' ? $social_links['vkontakte_link'] : '';
$youtube_link = isset($social_links['youtube_link']) && $social_links['youtube_link'] != '' ? $social_links['youtube_link'] : '';
$poll_social_links_heading = ( isset( $options[ 'poll_social_links_heading' ] ) && $options[ 'poll_social_links_heading' ] != '' ) ? stripslashes( wpautop( $options[ 'poll_social_links_heading' ] ) ) : '';

$next_poll_id = "";
$prev_poll_id = '';
if ( isset( $id ) && !is_null( $id ) ) {
    $next_poll = $this->get_next_or_prev_row_by_id( $id, "next", "ayspoll_polls" );
    $next_poll_id = (isset( $next_poll['id'] ) && $next_poll['id'] != "") ? absint( $next_poll['id'] ) : null;

    $prev_poll = $this->get_next_or_prev_row_by_id( $id, "prev", "ayspoll_polls" );
    $prev_poll_id = (isset( $prev_poll['id'] ) && $prev_poll['id'] != "") ? absint( $prev_poll['id'] ) : null;

}

// Don't show poll
$dont_show_poll_container_attempts = (isset($options[ 'dont_show_poll_container_attempts' ]) && $options[ 'dont_show_poll_container_attempts' ] == 'on') ? true : false;
