<?php
    global $wpdb;
    $poll_id = isset($_GET['poll']) ? intval($_GET['poll']) : null;
    if($poll_id === null){
        wp_redirect( admin_url('admin.php') . '?page=' . $this->plugin_name . '-ays-results' );
    }

    if (isset($_REQUEST['ays_poll_tab_results'])) {
        $ays_poll_tab = sanitize_text_field($_REQUEST['ays_poll_tab_results']);
    } else {
        $ays_poll_tab = 'tab1';
    }

    $count_of_answer_by_country = $this->each_results_obj->get_country_of_result();

    wp_localize_script( $this->plugin_name . '-admin-js', 'PollChartData', array( 
        'poll_id'                    => $poll_id,
        'count_of_answer_by_country' => $count_of_answer_by_country
    ));

?>
<script>
    (function ($) {
        $('#adminmenu').find('li>a[href$="poll-maker-ays-results"]')
            .addClass('current')
            .parent()
            .addClass('current')
            .parent().parent()
            .removeClass('wp-not-current-submenu').addClass('wp-has-current-submenu').addClass('wp-menu-open')
            .find('a.wp-has-submenu')
            .removeClass('wp-not-current-submenu').addClass('wp-has-current-submenu').addClass('wp-menu-open');
    })(jQuery)
</script>
<div class="wrap ays-poll-list-table ays_polls_each_results_list_table">
    <div class="ays-poll-heading-box">
        <div class="ays-poll-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank" style="text-decoration: none;font-size: 13px;">
                <i class="ays_poll_fas ays_fa_file_text"></i>
                <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "poll-maker"); ?></span>
            </a>
        </div>
    </div>
    <h1 class="wp-heading-inline">
        <div class="ays-poll-each-results-heading-inline">
            <?php
            global $wpdb;
            $poll_id = isset($_GET['poll']) ? intval($_GET['poll']) : null;
            if($poll_id === null){
                wp_redirect( admin_url('admin.php') . '?page=' . $this->plugin_name . '-ays-results' );
            }

            $polls_table = $wpdb->prefix . 'ayspoll_polls';
            $sql = "SELECT * FROM {$polls_table} WHERE id =". $poll_id;
            $poll = $wpdb->get_row( $sql, 'ARRAY_A' );

            $user_id = get_current_user_id();
            $author_id = intval( $poll['author_id'] );
            $owner = false;
            if( $user_id == $author_id ){
                $owner = true;
            }

            if( current_user_can( 'manage_options' ) ){
                $owner = true;
            }

            if( !$owner ){
                $url = esc_url_raw( remove_query_arg( array( 'page', 'poll', 'title' ) ) ) . "?page=poll-maker-ays-results";
                wp_redirect( $url );
            }

            echo sprintf('<a href="?page=%s" class="forArrow"><img src="' . POLL_MAKER_AYS_ADMIN_URL . '/images/icons/arrow-left.svg"></a>', esc_attr(rtrim($_REQUEST['page'], '-each')));
            echo esc_html(stripslashes($_GET['title']));
            ?>
        </div>
    </h1>
    <div class="nav-tab-wrapper">
        <a href="#statistics" class="ays-poll-google-chart nav-tab <?php echo ($ays_poll_tab == 'tab1') ? 'nav-tab-active' : ''; ?>" data-tab="tab1"><?= __('Statistics', "poll-maker"); ?></a>
        <a href="#poststuff" class="nav-tab <?php echo ($ays_poll_tab == 'tab2') ? 'nav-tab-active' : ''; ?>" data-tab="tab2"><?= __('Results', "poll-maker"); ?></a>
    </div>
    <div id="poststuff" class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab2') ? 'ays-poll-tab-content-active' : ''; ?>">
        <div id="post-body" class="metabox-holder">
            <div id="post-body-content">
                <div class="meta-box-sortables ui-sortable">
                    <form method="post">
                        <input type="hidden" name="ays_poll_tab_results" value="<?php echo htmlentities($ays_poll_tab); ?>" id="ays_poll_active_tab_settings">
	                    <?php
                            $this->each_results_obj->prepare_items();
                            $search = __("Search" , "poll-maker");
                            $this->each_results_obj->search_box($search, $this->plugin_name);
                            $this->each_results_obj->display();                        
	                    ?>
                    </form>
                </div>
            </div>
        </div>
        <br class="clear">
    </div>
    <div id="statistics" class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab1') ? 'ays-poll-tab-content-active' : ''; ?>">
        <div class="form-group row">
            <div class="col-md-12 p-4">
                <h2>
	                <?= __("Poll rate count", "poll-maker"); ?>
                </h2>
            </div>
            <div id="chartdiv"></div>
        </div>
        <div class="form-group row">
            <div class="col-md-12 p-4">
                <h2>
	                <?= __("Poll chart", "poll-maker"); ?>
                </h2>
            </div>
            <div id="piechartdiv"></div>
        </div>
        <div class="form-group row">
            <h1 style="text-align:center;"><?php echo __("Reports count by country", "poll-maker"); ?></h1>
            <div id="poll_chart_div_<?php echo $poll_id; ?>" style="width: 900px; height: 500px" class="chart_div"></div>
        </div>
    </div>
    <div id="ays-results-modal" class="ays-modal">
        <div class="ays-modal-content">
            <div class="ays-poll-preloader">
                <img class="loader" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/loaders/tail-spin.svg">
            </div>
            <div class="ays-modal-header">
                <h2><?php echo __("Details report", "poll-maker"); ?></h2>
                <span class="ays-close-results" id="ays-close-results">&times;</span>
            </div>
            <div class="ays-modal-body" id="ays-results-body">
                <table id="ays-results-table">
                </table>
            </div>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="col">
	        <?= (isset($stat_filter_id) && $stat_filter_id > 0) ? "<h5 class='text-center'>{$all_data[0][0]['title']}</h5><div id='piechartdiv'></div>" : ''; ?>
        </div>
    </div>
</div>

<script>
	<?php
	$pie_data = $this->each_results_obj->get_poll_data_pie($_GET['poll']);
	?>
    var pie_data =  <?= !empty($pie_data) ? json_encode($pie_data) : 0 ?>;

    jQuery(function () {
        var chart = am4core.create("chartdiv", am4charts.XYChart);
        chart.data = [
            <?php  $i = 30;
            while ($i >= 0) {
            $day = date('Y-m-d', strtotime("today - $i days"));
            $data_day = $this->each_results_obj->get_poll_data_by_day($day, $_GET['poll']);
            $day_value = "0";
            if (!empty($data_day)) {
                 $day_value = $data_day['polling_count'];
            }
            ?>
            {
                "date": "<?php echo date('Y-m-d', strtotime("today - $i days")); ?>",
                "value": "<?php echo $day_value; ?>"
            },
            <?php $i--; } ?>
        ];

        // Set input format for the dates
        chart.dateFormatter.inputDateFormat = "yyyy-MM-dd";

        // Create axes
        var dateAxis = chart.xAxes.push(new am4charts.DateAxis());
        var valueAxis = chart.yAxes.push(new am4charts.ValueAxis());
        // Create series
        var series = chart.series.push(new am4charts.LineSeries());
        series.dataFields.valueY = "value";
        series.dataFields.dateX = "date";
        series.tooltipText = "{value}";
        series.strokeWidth = 2;
        series.minBulletDistance = 15;

        // Drop-shaped tooltips
        series.tooltip.background.cornerRadius = 0;
        series.tooltip.background.strokeOpacity = 0;
        series.tooltip.pointerOrientation = "vertical";
        series.tooltip.label.minWidth = 40;
        series.tooltip.label.minHeight = 40;
        series.tooltip.label.textAlign = "middle";
        series.tooltip.label.textValign = "middle";

        // Make bullets grow on hover
        var bullet = series.bullets.push(new am4charts.CircleBullet());
        bullet.circle.strokeWidth = 1;
        bullet.circle.radius = 4;
        bullet.circle.fill = am4core.color("#fff");

        var bullethover = bullet.states.create("hover");
        bullethover.properties.scale = 1.3;

        // Make a panning cursor
        chart.cursor = new am4charts.XYCursor();
        chart.cursor.behavior = "panXY";
        chart.cursor.xAxis = dateAxis;
        chart.cursor.snapToSeries = series;


        // Create a horizontal scrollbar with previe and place it underneath the date axis
        chart.scrollbarX = new am4charts.XYChartScrollbar();
        chart.scrollbarX.series.push(series);
        chart.scrollbarX.parent = chart.bottomAxesContainer;

        chart.events.on("ready", function () {
            dateAxis.zoom({start: 0, end: 1});
        });
    });
</script>