<?php
$actions = $this->settings_obj;
$poll_actions = $this->polls_obj;

if (isset($_REQUEST['ays_submit'])) {
	$actions->store_data($_REQUEST);
}
if (isset($_GET['ays_poll_tab'])) {
	$ays_poll_tab = sanitize_text_field($_GET['ays_poll_tab']);
} else {
	$ays_poll_tab = 'tab1';
}
$db_data = $actions->get_db_data();

global $wp_roles;
$ays_users_roles    = $wp_roles->role_names;
$user_roles         = json_decode($actions->ays_get_setting('user_roles'), true);
$mailchimp_res      = ($actions->ays_get_setting('mailchimp') === false) ? json_encode(array()) : $actions->ays_get_setting('mailchimp');
$mailchimp          = json_decode($mailchimp_res, true);
$mailchimp_username = isset($mailchimp['username']) ? $mailchimp['username'] : '';
$mailchimp_api_key  = isset($mailchimp['apiKey']) ? $mailchimp['apiKey'] : '';

$monitor_res     = ($actions->ays_get_setting('monitor') === false) ? json_encode(array()) : $actions->ays_get_setting('monitor');
$monitor         = json_decode($monitor_res, true);
$monitor_client  = isset($monitor['client']) ? $monitor['client'] : '';
$monitor_api_key = isset($monitor['apiKey']) ? $monitor['apiKey'] : '';

$zapier_res  = ($actions->ays_get_setting('zapier') === false) ? json_encode(array()) : $actions->ays_get_setting('zapier');
$zapier      = json_decode($zapier_res, true);
$zapier_hook = isset($zapier['hook']) ? $zapier['hook'] : '';

$active_camp_res     = ($actions->ays_get_setting('active_camp') === false) ? json_encode(array()) : $actions->ays_get_setting('active_camp');
$active_camp         = json_decode($active_camp_res, true);
$active_camp_url     = isset($active_camp['url']) ? $active_camp['url'] : '';
$active_camp_api_key = isset($active_camp['apiKey']) ? $active_camp['apiKey'] : '';

$slack_res    = ($actions->ays_get_setting('slack') === false) ? json_encode(array()) : $actions->ays_get_setting('slack');
$slack        = json_decode($slack_res, true);
$slack_client = isset($slack['client']) ? $slack['client'] : '';
$slack_secret = isset($slack['secret']) ? $slack['secret'] : '';
$slack_token = isset($slack['token']) ? $slack['token'] : '';
$slack_oauth  = !empty($_GET['oauth']) && $_GET['oauth'] == 'slack';
if ($slack_oauth) {
    $slack_temp_code = !empty($_GET['code']) ? $_GET['code'] : "";
    $slack_client    = !empty($_GET['state']) ? $_GET['state'] : "";
    $ays_poll_tab    = 'tab2';
}

$leadboard_res = ($actions->ays_get_setting('leaderboard') === false) ? json_encode(array()) : $actions->ays_get_setting('leaderboard');
$leadboard = json_decode($leadboard_res, true);

// Global leadboard
$glob_leadboard_count = isset($leadboard['global']['count']) ? $leadboard['global']['count'] : '5' ;
$glob_leadboard_width = isset($leadboard['global']['width']) ? $leadboard['global']['width'] : '0' ;
$glob_leadboard_orderby = isset($leadboard['global']['orderby']) ? $leadboard['global']['orderby'] : 'id' ;
$glob_leadboard_sort = isset($leadboard['global']['sort']) ? $leadboard['global']['sort'] : 'avg' ;
$glob_leadboard_color = isset($leadboard['global']['color']) ? $leadboard['global']['color'] : '#99BB5A' ;
$glob_leadboard_suctom_css = (isset($leadboard['global']['gleadboard_custom_css']) && $leadboard['global']['gleadboard_custom_css'] != '') ? $leadboard['global']['gleadboard_custom_css'] : '';

$options_res = ($actions->ays_get_setting('options') === false) ? json_encode(array()) : $actions->ays_get_setting('options');
$options        = json_decode($options_res, true);
$show_result_view = isset($options['show_result_view']) ? $options['show_result_view'] : 'standart';

$answers_sound = isset($options['answers_sound']) ? $options['answers_sound'] : '';
$show_cat_title = isset($options['show_cat_title']) && $options['show_cat_title'] == 'on' ? 'checked' : '';

// Get Google sheets from DB
$google_res          = ($actions->ays_get_setting('google_sheet') === false) ? json_encode(array()) : $actions->ays_get_setting('google_sheet');
$google_sheets       = json_decode($google_res, true);
$google_client       = isset($google_sheets['client']) ? $google_sheets['client'] : '';
$google_secret       = isset($google_sheets['secret']) ? $google_sheets['secret'] : '';
$google_token        = isset($google_sheets['token']) ? $google_sheets['token'] : '';
$google_redirect_url = home_url()."/wp-admin/admin.php?page=poll-maker-ays-settings";

$google_code  = !empty($_GET['code']) ? $_GET['code'] : "";
$google_code_check  = !empty($_GET['code']) && !isset($_GET['oauth']) ? true : false;
// Google sheets end

// SendGrid Start
$sendgrid_res      = ($actions->ays_get_setting('sendgrid') === false) ? json_encode(array()) : $actions->ays_get_setting('sendgrid');
$sendgrid          = json_decode($sendgrid_res, true);
$sendgrid_api_key  = isset($sendgrid['apiKey']) ? $sendgrid['apiKey'] : '';
// SendGrid End

//Poll title length
$poll_title_length = (isset($options['poll_title_length']) && intval($options['poll_title_length']) != 0) ? absint(intval($options['poll_title_length'])) : 5;

//Poll Category title length
 $poll_category_title_length = (isset($options['poll_category_title_length']) && intval($options['poll_category_title_length']) != 0) ? absint(intval($options['poll_category_title_length'])) : 5;

//Poll Results title length
$poll_results_title_length = (isset($options['poll_results_title_length']) && intval($options['poll_results_title_length']) != 0) ? absint(intval($options['poll_results_title_length'])) : 5;

// Poll auto approve user request
$check_approve = (isset($options['enable_auto_approve']) && $options['enable_auto_approve'] == 'on') ? 'checked' : '';

// Poll expired and unpublished message
$all_shortcode_message = isset($options['all_shortcode_message'])  && $options['all_shortcode_message'] != '' ? esc_attr($options['all_shortcode_message']) : '';

// Default Category for poll
$ays_default_cat_db =  isset($options['default_category']) && $options['default_category'] != "" ? explode("," , $options['default_category']) : array("1");
$poll_get_all_cats = $poll_actions->get_categories();

// Poll Types
$poll_default_types = array(
    "choosing" => "Choosing",
    "rating"   => "Rating",
    "voting"   => "Voting",
    "dropdown" => "Dropdown",
    "versus"   => "Versus",
    "range"    => "Range",
    "text"     => "Text",
);
$ays_default_type =  isset($options['default_type']) && $options['default_type'] != "" ? esc_attr($options['default_type']) : "choosing";

// Mad mimi
$mad_mimi_options = ($actions->ays_get_setting('mad_mimi') === false) ? json_encode(array()) : $actions->ays_get_setting('mad_mimi');
$mad_mimi_options = json_decode($mad_mimi_options, true);
$mad_mimi_user_name = isset($mad_mimi_options['user_name']) && $mad_mimi_options['user_name'] != "" ? esc_attr($mad_mimi_options['user_name']) : '';
$mad_mimi_api_key   = isset($mad_mimi_options['api_key']) && $mad_mimi_options['api_key'] != "" ? esc_attr($mad_mimi_options['api_key']) : '';

// GetResponse
$getResponse_res  = ($actions->ays_get_setting('get_response') === false) ? json_encode(array()) : $actions->ays_get_setting('get_response');
$getResponse      = json_decode($getResponse_res, true);
$getResponse_api_key = isset($getResponse['api_key']) ? $getResponse['api_key'] : '';

// GetResponse
$mailerLite_res  = ($actions->ays_get_setting('mailerLite') === false) ? json_encode(array()) : $actions->ays_get_setting('mailerLite');
$mailerLite      = json_decode($mailerLite_res, true);
$mailerLite_api_key = isset($mailerLite['api_key']) ? $mailerLite['api_key'] : '';

// ConvertKit
$convertKit_res         = ($actions->ays_get_setting('convertKit') === false) ? json_encode(array()) : $actions->ays_get_setting('convertKit');
$convertKit             = json_decode($convertKit_res, true);
$convertKit_account_id  = isset($convertKit['api_key']) ? esc_attr($convertKit['api_key']) : '';

// reCAPTCHA
$recaptcha_options = ($actions->ays_get_setting('recaptcha') === false) ? json_encode(array()) : $actions->ays_get_setting('recaptcha');
$recaptcha_options = json_decode($recaptcha_options, true);
$recaptcha_site_key = isset($recaptcha_options['site_key']) && $recaptcha_options['site_key'] != "" ? esc_attr($recaptcha_options['site_key']) : '';
$recaptcha_secret_key = isset($recaptcha_options['secret_key']) && $recaptcha_options['secret_key'] != "" ? esc_attr($recaptcha_options['secret_key']) : '';
$recaptcha_language = isset($recaptcha_options['language']) && $recaptcha_options['language'] != "" ? esc_attr($recaptcha_options['language']) : '';
$recaptcha_theme = isset($recaptcha_options['theme']) && $recaptcha_options['theme'] != "" ? esc_attr($recaptcha_options['theme']) : 'light';

//  Poll Cat Leaderboard
$category_leaderboard_res = ($actions->ays_get_setting('category_leaderboard') === false) ? json_encode(array()) : $actions->ays_get_setting('category_leaderboard');
$category_leaderboard     = json_decode($category_leaderboard_res, true);

$ays_poll_cat_glob_leadboard_count      = (isset($category_leaderboard['cat_global']['cat_count']) && $category_leaderboard['cat_global']['cat_count'] != '') ? esc_attr($category_leaderboard['cat_global']['cat_count']) : '5' ;
$ays_poll_cat_glob_leadboard_width      = (isset($category_leaderboard['cat_global']['cat_width']) && $category_leaderboard['cat_global']['cat_width'] != '') ? esc_attr($category_leaderboard['cat_global']['cat_width']) : '0' ;
$ays_poll_cat_glob_leadboard_orderby    = (isset($category_leaderboard['cat_global']['cat_orderby']) && $category_leaderboard['cat_global']['cat_orderby'] != '') ? esc_attr($category_leaderboard['cat_global']['cat_orderby']) : 'id' ;
$ays_poll_cat_glob_leadboard_color      = (isset($category_leaderboard['cat_global']['cat_color']) && $category_leaderboard['cat_global']['cat_color'] != '') ? esc_attr($category_leaderboard['cat_global']['cat_color']) : '#99BB5A' ;
$ays_poll_cat_glob_leadboard_suctom_css = (isset($category_leaderboard['cat_global']['cat_gleadboard_custom_css']) && $category_leaderboard['cat_global']['cat_gleadboard_custom_css'] != '') ? $category_leaderboard['cat_global']['cat_gleadboard_custom_css'] : '';

//User History Page shortcode
$default_ays_poll_user_page_columns = array(
    'poll_name'  => 'poll_name',
    'vote_date'  => 'vote_date',
    'vote_answer'=> 'vote_answer'
);

$options['ays_poll_user_page_columns'] = !isset( $options['ays_poll_user_page_columns'] ) ? $default_ays_poll_user_page_columns : $options['ays_poll_user_page_columns'];

$ays_poll_user_page_columns       = (isset( $options['ays_poll_user_page_columns'] ) && !empty($options['ays_poll_user_page_columns']) ) ? $options['ays_poll_user_page_columns'] : array();
$ays_poll_user_page_columns_order = (isset( $options['ays_poll_user_page_columns_order'] ) && !empty($options['ays_poll_user_page_columns_order']) ) ? $options['ays_poll_user_page_columns_order'] : $default_ays_poll_user_page_columns;

foreach( $default_ays_poll_user_page_columns as $key => $value ){
    if( !isset( $user_page_columns[$key] ) ){
        $user_page_columns[$key] = '';
    }

    if( !isset( $ays_poll_user_page_columns_order[$key] ) ){
        $ays_poll_user_page_columns_order[$key] = $key;
    }
}

foreach( $ays_poll_user_page_columns_order as $key => $value ){
    if( !isset( $user_page_columns[$key] ) ){
        if( isset( $user_page_columns[$value] ) ){
            $ays_poll_user_page_columns_order[$value] = $value;
        }
        unset( $ays_poll_user_page_columns_order[$key] );
    }
}

$default_user_page_column_names = array(
    "poll_name"   => __( 'Poll name', "poll-maker" ),
    "vote_date"   => __( 'Vote date', "poll-maker" ),
    "vote_answer" => __( 'Vote answer', "poll-maker" ),
);

$ays_poll_results_inherit = (isset( $options['ays_poll_results_inherit'] ) && $options['ays_poll_results_inherit'] == "on" ) ? "checked" : "";

//All results shortcode
//default all results column
$default_ays_poll_all_results_columns = array(
    'user_name'      => 'user_name',
    'poll_name'      => 'poll_name',
    'vote_date'      => 'vote_date',
    'vote_answer'    => 'vote_answer'
);

$options['poll_all_results_columns'] = !isset( $options['poll_all_results_columns'] ) || empty( $options['poll_all_results_columns'] ) ? $default_ays_poll_all_results_columns : $options['poll_all_results_columns'];
$poll_all_results_columns = (isset( $options['poll_all_results_columns'] ) && !empty($options['poll_all_results_columns']) ) ? $options['poll_all_results_columns'] : array();
$poll_all_results_columns_order = (isset( $options['poll_all_results_columns_order'] ) && !empty($options['poll_all_results_columns_order']) ) ? $options['poll_all_results_columns_order'] : $default_ays_poll_all_results_columns;

$poll_all_results_columns_order_arr = $poll_all_results_columns_order;

foreach( $default_ays_poll_all_results_columns as $key => $value ){
    if( !isset( $poll_all_results_columns[$key] ) ){
        $poll_all_results_columns[$key] = '';
    }

    if( !isset( $poll_all_results_columns_order[$key] ) ){
        $poll_all_results_columns_order[$key] = $key;
    }

    if ( ! in_array( $key , $poll_all_results_columns_order_arr) ) {
        $poll_all_results_columns_order_arr[] = $key;
    }
}

foreach( $poll_all_results_columns_order as $key => $value ){
    if( !isset( $poll_all_results_columns[$key] ) ){
        if( isset( $poll_all_results_columns[$value] ) ){
            $poll_all_results_columns_order[$value] = $value;
        }
        unset( $poll_all_results_columns_order[$key] );
    }
}

foreach ($poll_all_results_columns_order_arr  as $key => $value) {
    if( isset( $poll_all_results_columns_order[$value] ) ){
        $poll_all_results_columns_order_arr[$value] = $value;
    }

    if ( is_int( $key ) ) {
        unset( $poll_all_results_columns_order_arr[$key] );
    }
}

$poll_all_results_columns_order = $poll_all_results_columns_order_arr;

$default_all_results_column_names = array(
    "user_name"   => __( 'User name', "poll-maker"),
    "poll_name"   => __( 'Poll name', "poll-maker" ),
    "vote_date"   => __( 'Vote date',"poll-maker" ),
    "vote_answer" => __( 'Vote answer', "poll-maker" ),
);

// Show publicly ( All Results )
$options['poll_all_results_show_publicly'] = isset($options['poll_all_results_show_publicly']) ? $options['poll_all_results_show_publicly'] : 'off';
$all_poll_results_show_publicly = (isset($options['poll_all_results_show_publicly']) && $options['poll_all_results_show_publicly'] == "on") ? true : false;

// Default cats for request form
$ays_poll_request_default_cat =  isset($options['ays_poll_request_cats']) && $options['ays_poll_request_cats'] != "" ? explode("," , $options['ays_poll_request_cats']) : array("1");

// Fields placeholders | Start

$fields_placeholders_res      = ($actions->ays_get_setting('fields_placeholders') === false) ? json_encode(array()) : $actions->ays_get_setting('fields_placeholders');
$fields_placeholders          = json_decode(  $fields_placeholders_res  , true);

$poll_fields_placeholder_name  = (isset($fields_placeholders['poll_fields_placeholder_name']) && $fields_placeholders['poll_fields_placeholder_name'] != '') ? stripslashes( esc_attr( $fields_placeholders['poll_fields_placeholder_name'] ) ) : __('Name', "poll-maker");

$poll_fields_placeholder_email = (isset($fields_placeholders['poll_fields_placeholder_email']) && $fields_placeholders['poll_fields_placeholder_email'] != '') ? stripslashes( esc_attr( $fields_placeholders['poll_fields_placeholder_email'] ) ) : __('E-mail', "poll-maker");

$poll_fields_placeholder_phone = (isset($fields_placeholders['poll_fields_placeholder_phone']) && $fields_placeholders['poll_fields_placeholder_phone'] != '') ? stripslashes( esc_attr( $fields_placeholders['poll_fields_placeholder_phone'] ) ) : __('Phone', "poll-maker");

// Fields placeholders | End

// Fields labels | Start

$poll_fields_label_name  = (isset($fields_placeholders['poll_fields_label_name']) && $fields_placeholders['poll_fields_label_name'] != '') ? stripslashes( esc_attr( $fields_placeholders['poll_fields_label_name'] ) ) : __('Name', "poll-maker");

$poll_fields_label_email = (isset($fields_placeholders['poll_fields_label_email']) && $fields_placeholders['poll_fields_label_email'] != '') ? stripslashes( esc_attr( $fields_placeholders['poll_fields_label_email'] ) ) : __('E-mail', "poll-maker");

$poll_fields_label_phone = (isset($fields_placeholders['poll_fields_label_phone']) && $fields_placeholders['poll_fields_label_phone'] != '') ? stripslashes( esc_attr( $fields_placeholders['poll_fields_label_phone'] ) ) : __('Phone', "poll-maker");

// Fields labels | End

// Animation Top 
$poll_animation_top = (isset($options['poll_animation_top']) && $options['poll_animation_top'] != '') ? absint(intval($options['poll_animation_top'])) : 100 ;
$options['poll_enable_animation_top'] = isset($options['poll_enable_animation_top']) ? $options['poll_enable_animation_top'] : 'on';
$poll_enable_animation_top = (isset($options['poll_enable_animation_top']) && $options['poll_enable_animation_top'] == "on") ? true : false;

// General CSS File
$options['poll_exclude_general_css'] = isset($options['poll_exclude_general_css']) ? esc_attr( $options['poll_exclude_general_css'] ) : 'off';
$poll_exclude_general_css = (isset($options['poll_exclude_general_css']) && esc_attr( $options['poll_exclude_general_css'] ) == "on") ? true : false;

// WP Editor height
$poll_wp_editor_height = (isset($options['poll_wp_editor_height']) && $options['poll_wp_editor_height'] != '' && $options['poll_wp_editor_height'] != 0) ? absint( sanitize_text_field($options['poll_wp_editor_height']) ) : 100 ;

?>
<div class="wrap" style="position:relative;">
    <div class="container-fluid">
        <form method="post" id="ays-poll-general-settings-form">
            <div class="ays-poll-heading-box">
                <div class="ays-poll-wordpress-user-manual-box">
                    <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank" style="text-decoration: none;font-size: 13px;">
                        <i class="ays_poll_fas ays_fa_file_text"></i>
                        <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "poll-maker"); ?></span>
                    </a>
                </div>
            </div>
            <input type="hidden" name="ays_poll_tab" value="<?php echo $ays_poll_tab; ?>" id="ays_poll_active_tab_results">
            <h1 class="wp-heading-inline">
				<?php
				echo __('Settings', "poll-maker");
				?>
            </h1>
			<?php
			if (isset($_REQUEST['status'])) {
				$actions->poll_settings_notices($_REQUEST['status']);
			}
			?>
            <hr/>
            <div class="ays-settings-wrapper">
                <div>
                    <div class="nav-tab-wrapper" style="position:sticky; top:35px;">
                        <a href="#tab1" data-tab="tab1"
                           class="nav-tab <?php echo ($ays_poll_tab == 'tab1') ? 'nav-tab-active' : ''; ?>">
							<?php echo __("General", "poll-maker"); ?>
                        </a>
                        <a href="#tab2" data-tab="tab2"
                           class="nav-tab <?php echo ($ays_poll_tab == 'tab2') ? 'nav-tab-active' : ''; ?>">
							<?php echo __("Integrations", "poll-maker"); ?>
                        </a>
                        <a href="#tab3" data-tab="tab3"
                           class="nav-tab <?php echo ($ays_poll_tab == 'tab3') ? 'nav-tab-active' : ''; ?>">
                            <?php echo __("Shortcodes", "poll-maker"); ?>
                        </a>
                        <a href="#tab4" data-tab="tab4"
                           class="nav-tab <?php echo ($ays_poll_tab == 'tab4') ? 'nav-tab-active' : ''; ?>">
                            <?php echo __("Extra Shortcodes", "poll-maker"); ?>
                        </a>
                        <a href="#tab5" data-tab="tab5"
                           class="nav-tab <?php echo ($ays_poll_tab == 'tab5') ? 'nav-tab-active' : ''; ?>">
                            <?php echo __("Fields placeholders", "poll-maker"); ?>
                        </a>
                        <a href="#tab6" data-tab="tab6"
                           class="nav-tab <?php echo ($ays_poll_tab == 'tab5') ? 'nav-tab-active' : ''; ?>">
                            <?php echo __("Message variables", "poll-maker"); ?>
                        </a>
                    </div>
                </div>
                <div class="ays-poll-tabs-wrapper">
                    <div id="tab1"
                         class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab1') ? 'ays-poll-tab-content-active' : ''; ?>">
                        <p class="ays-subtitle"><?php echo __('General Settings', "poll-maker") ?></p>
                        <hr/>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fa ays_poll_fa_globe"></i></strong>
                                <h5><?php echo __('Who will have permission to Poll menu',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_user_roles">
    									<?php echo __("Select user role", "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Control and manage who can have access to the plugin from the dashboard.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <select name="ays_user_roles[]" id="ays_user_roles" class="ays-select" multiple>
    									<?php
    									foreach ( $ays_users_roles as $role => $role_name ) {
    										$selected = in_array($role, $user_roles) ? 'selected' : '';
    										echo "<option " . $selected . " value='" . $role . "'>" . $role_name . "</option>";
    									}
    									?>
                                    </select>
                                </div>
                            </div>
                            <blockquote>
    							<?php echo __("Ability to manage Poll Maker plugin for selected user roles.", "poll-maker"); ?>
                            </blockquote>
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fas ays_poll_fa_text"></i></strong>
                                <h5><?php echo __('Excerpt words count in list tables',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_title_length">
                                        <?php echo __( "Polls list table", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Determine the length of the polls to be shown in the Polls List Table by putting your preferred count of words in the following field. For example: if you put 10,  you will see the first 10 words of each poll in the Polls page of your dashboard.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number" name="ays_poll_title_length" id="ays_poll_title_length" class="ays-text-input" value="<?php echo $poll_title_length; ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_category_title_length">
                                        <?php echo __( "Categories list table", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Determine the length of the category to be shown in the Category List Table by putting your preferred count of words in the following field. For example: if you put 10,  you will see the first 10 words of each poll in the Polls page of your dashboard.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number" name="ays_poll_category_title_length" id="ays_poll_category_title_length" class="ays-text-input" value="<?php echo $poll_category_title_length; ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_results_title_length">
                                        <?php echo __( "Results list table", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Determine the length of the results to be shown in the Results List Table by putting your preferred count of words in the following field. For example: if you put 10,  you will see the first 10 words of each poll in the Polls page of your dashboard.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number" name="ays_poll_results_title_length" id="ays_poll_results_title_length" class="ays-text-input" value="<?php echo $poll_results_title_length; ?>">
                                </div>
                            </div>
                        </fieldset>
                        <hr>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fa ays_poll_fa_trash"></i></strong>
                                <h5><?php echo __('Erase Poll data',"poll-maker")?></h5>
                            </legend>
                            <?php if( isset( $_GET['del_stat'] ) ): ?>
                            <blockquote style="border-color:#46b450;background: rgba(70, 180, 80, 0.2);">
                                <?php echo __("Results up to a", "poll-maker") . " " . $_GET['mcount'] . " " . __("month ago deleted successfully.", "poll-maker"); ?>
                            </blockquote>
                            <hr>
                            <?php endif; ?>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_delete_results_by">
                                        <?php echo __( "Delete results older then 'X' the month", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify count of months and save changes. Attention! it will remove submissions older than specified months permanently.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-4">
                                    <input type="number" name="ays_delete_results_by" id="ays_delete_results_by" class="ays-text-input">
                                </div>
                                <div class="col-sm-4">
                                    <input type="submit" name="ays_submit" id="ays_submit" class="button button-primary ays-button" value="Apply changes">
                                </div>
                            </div>
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_fa ays_poll_fa_question_circle"></i></strong>
                                <h5><?php echo __('Default parameters for Poll',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_disable_ip_storing">
                                        <?= __('Disable IP Storing', "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip"
                                           data-placement="top"
                                           title="<?= __("After enabling this option, the IP address of the users will not be stored in the database.  Note: If this option is enabled, then the Limitation options connected with IP will not work.", "poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="checkbox"
                                           name="ays_disable_ip_storing"
                                           id="ays_disable_ip_storing"
                                           value="on" <?php echo (isset($options['disable_ip_storing']) && $options['disable_ip_storing'] == 'on') ? 'checked' : ''; ?>
                                    >
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_answer_default_count">
                                        <?= __('Answer Default Count', "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip"
                                           data-placement="top"
                                           title="<?= __("Define the default count for the answers which will be displayed in the Add new poll page. (This will work only with choosing type.)", "poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number"
                                           class="ays-text-input"
                                           name="ays_answer_default_count"
                                           min="2"
                                           id="ays_answer_default_count"
                                           value="<?php echo isset($options['answer_default_count']) ? $options['answer_default_count'] : 2; ?>"
                                    >
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_default_cat">
                                        <?= __('Polls default categories', "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip"
                                           data-placement="top"
                                           title="<?= __("Choose categories of the poll which will be selected by default each time you create a poll by the Add New button.", "poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <select id="ays_poll_default_cat" name="ays_poll_default_cat[]" multiple>
                                            <?php
                                                $cat_content = "";
                                                $cat_selected = "";
                                                foreach($poll_get_all_cats as $key => $value){
                                                    $cat_id       = isset($value['id']) && $value['id'] != "" ? esc_attr($value['id']) : "";
                                                    $cat_title    = isset($value['title']) && $value['title'] != "" ? esc_attr($value['title']) : "";
                                                    $cat_selected = in_array($cat_id , $ays_default_cat_db)  ? "selected" : "";
                                                    $cat_content .= "<option value=".$cat_id." ".$cat_selected.">".$cat_title."</option>";
                                                }
                                                echo $cat_content;
                                            ?>
                                    </select>
                                </div>
                            </div> <!-- Default Category -->
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_default_type">
                                        <?= __('Polls default type', "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip"
                                           data-placement="top"
                                           title="<?= __("Choose the type of the poll which will be selected by default each time you create a poll by the Add New button.", "poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <select id="ays_poll_default_type" name="ays_poll_default_type">
                                            <?php
                                                $type_content = "";
                                                $type_selected = "";
                                                foreach($poll_default_types as $type_key => $type_value){
                                                    $type_id       = isset($type_key) && $type_key != "" ? $type_key : "";
                                                    $type_title    = isset($type_value) && $type_value != "" ? $type_value : "";
                                                    $type_selected = ($ays_default_type == $type_id) ? "selected" : "";
                                                    $type_content .= "<option value=".$type_id." ".$type_selected.">".$type_title."</option>";
                                                }
                                                echo $type_content;
                                            ?>
                                    </select>
                                </div>
                            </div> <!-- Default Type -->    
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_wp_editor_height">
                                        <?php echo __( "WP Editor height", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Give the default value to the height of the WP Editor. It will apply to all WP Editors within the plugin on the dashboard.',"poll-maker"); ?>">
                                            <i class="ays_fa ays_fa_info_circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number" name="ays_poll_wp_editor_height" id="ays_poll_wp_editor_height" class="ays-text-input" value="<?php echo $poll_wp_editor_height; ?>">
                                </div>
                            </div><!-- WP Editor Height -->                        
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fa ays_poll_fa_music"></i></strong>
                                <h5><?php echo __('Poll answers sound',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_questions_default_type">
                                        <?php echo __( "Sound for answers", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The selected sound will be played in the poll if the Enable answers sound option is enabled from the particular poll settings.',"poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <div class="ays-bg-music-container">
                                        <a class="add-poll-bg-music" href="javascript:void(0);"><?php echo __("Select sound", "poll-maker"); ?></a>
                                        <audio controls src="<?php echo $answers_sound; ?>"></audio>
                                        <input type="hidden" name="ays_poll_answers_sound" class="ays_poll_bg_music" value="<?php echo $answers_sound; ?>">
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fas ays_poll_fa-check"></i></strong>
                                <h5><?php echo __("Auto approve user's request","poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_auto_approve">
                                        <?php echo __( "Enable auto-approve", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('If the option is enabled, the user requests from the Request Form shortcode will automatically be approved and added to the Polls page.',"poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <div class="ays-poll-auto-approve">                                        
                                        <input type="checkbox" name="ays_poll_auto_approve" class="" id="ays_poll_auto_approve" value="on" <?php echo $check_approve;?>>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                        <hr>
                        <fieldset class="ays_toggle_parent">
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fas ays_poll_fa-check"></i></strong>
                                <h5>Send automatic email reporting to admin(s)</h5>
                            </legend>
                            <div class="form-group row" style="margin: 0px;">
                                <div class="col-sm-12 only_pro" style="padding:20px;">
                                    <div class="pro_features" style="justify-content:flex-end;">
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_email_to_admins">
                                                Send automatic email reporting per session
                                                <a class="ays_help ays-poll-zindex-for-pro-tooltip" data-toggle="tooltip" title="Set up automatic email reporting to inform yourself or anyone else, about the votes of polls. It will indicate the times of votes all poll will have at that given moment, will send a table which will include the names of all polls and the number of votes each one will have and will show the statistics of the growth/decline of the votes in percentage.">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <div class="ays-poll-email-to-admins">                                        
                                                <input type="checkbox" disabled class="ays_toggle_checkbox" id="ays_poll_email_to_admins" value="on">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_admin_email_session">
                                                Session period
                                                <a class="ays_help ays-poll-zindex-for-pro-tooltip" data-toggle="tooltip" title="Specify the time for one session and the provided email(s) will receive an automatic email notification once during the period.">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <div class="ays-poll-email-to-admins">                                        
                                                <select disabled id="ays_poll_admin_email_session">
                                                    <option selected>1 Hour</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_admins_emails">
                                                Email addresses
                                                <a class="ays_help ays-poll-zindex-for-pro-tooltip" data-toggle="tooltip" title="Provide emails to which you need to send the poll vote's statistics. Insert emails comma separated.">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <div class="ays-poll-email-to-admins">                                        
                                                <input type="email" disabled class="" id="ays_poll_admins_emails" placeholder="Admins email" style="width:100%">
                                            </div>
                                        </div>
                                    </div>
                                    <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                                        <div class="ays-poll-new-upgrade-button-box">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                            </div>
                                            <div class="ays-poll-new-upgrade-button">Upgrade to Developer</div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <span style="display:block;text-align:right" class="ays_poll_small_hint_text">Note: The option works via WP-Cron functionality. It will not work in offline mode.</span>
                        </fieldset>
                        <hr>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fas ays_poll_fa-code"></i></strong>
                                <h5><?php echo __('Animation Top',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_enable_animation_top">
                                        <?php echo __( "Enable animation", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable animation of the scroll offset of the poll container. It works when the poll container is visible on the screen partly and the user starts the poll and moves from one question to another.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="checkbox" name="ays_poll_enable_animation_top" id="ays_poll_enable_animation_top" value="on" <?php echo $poll_enable_animation_top ? 'checked' : ''; ?>>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_animation_top">
                                        <?php echo __( "Scroll offset(px)", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the scroll offset of the poll container after the animation starts. It works when the poll container is visible on the screen partly and the user starts the poll and moves from one question to another.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number" name="ays_poll_animation_top" id="ays_poll_animation_top" class="ays-text-input" value="<?php echo $poll_animation_top; ?>">
                                </div>
                            </div>                            
                        </fieldset> <!-- Animation Top -->
                        <hr>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_poll_fa ays_fa_file_code"></i></strong>
                                <h5><?php echo __('General CSS File',"poll-maker"); ?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_exclude_general_css">
                                        <?php echo __( "Exclude general CSS file from home page", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('If the option is enabled, then the poll general CSS file will not be applied to the home page. Please note, that if you have inserted the poll on the home page, then the option must be disabled so that the CSS File can normally work for that poll.',"poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="checkbox" name="ays_poll_exclude_general_css" id="ays_poll_exclude_general_css" value="on" <?php echo $poll_exclude_general_css ? 'checked' : ''; ?>>
                                </div>
                            </div>
                        </fieldset> <!-- Exclude General CSS -->
                        <hr>
                    </div>
                    <div id="tab2"
                         class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab2') ? 'ays-poll-tab-content-active' : ''; ?>">
                        <p class="ays-subtitle"><?php echo __('Integrations', "poll-maker") ?></p>
                        <hr/>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mailchimp_logo.png" alt="">
                                <h5><?php echo __('MailChimp',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_mailchimp_username">
                                                <?php echo __('MailChimp Username',"poll-maker")?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_mailchimp_username"
                                                   name="ays_mailchimp_username"
                                                   value="<?php echo $mailchimp_username; ?>"
                                            />
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_mailchimp_api_key">
                                                <?php echo __('MailChimp API Key',"poll-maker")?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_mailchimp_api_key"
                                                   name="ays_mailchimp_api_key"
                                                   value="<?php echo $mailchimp_api_key; ?>"
                                            />
                                        </div>
                                    </div>
                                    <blockquote>
                                        <?php echo sprintf( __( "You can get your API key from your ", "poll-maker" ) . "<a href='%s' target='_blank'> %s.</a>", "https://us20.admin.mailchimp.com/account/api/", "Account Extras menu" ); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/campaignmonitor_logo.png" alt="">
                                <h5><?php echo __('Campaign Monitor',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_monitor_client">
                                                Campaign Monitor <?= __('Client ID', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_monitor_client"
                                                   name="ays_monitor_client"
                                                   value="<?= $monitor_client; ?>"
                                            >
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_monitor_api_key">
                                                Campaign Monitor <?= __('API Key', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_monitor_api_key"
                                                   name="ays_monitor_api_key"
                                                   value="<?= $monitor_api_key; ?>"
                                            >
                                        </div>
                                    </div>
                                    <blockquote>
                                        <?= __("You can get your API key and Client ID from your Account Settings page", "poll-maker"); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/zapier_logo.png" alt="">
                                <h5><?php echo __('Zapier',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_zapier_hook">
                                                <?= __('Zapier Webhook URL', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_zapier_hook"
                                                   name="ays_zapier_hook"
                                                   value="<?= $zapier_hook; ?>"
                                            >
                                        </div>
                                    </div>
                                    <blockquote>
                                    <?php 
                                        /* translators: anchor tag URL */
                                        echo sprintf(__("If you do not have any ZAP created, go <a href='%s' target='_blank'>here</a>. Remember to choose Webhooks by Zapier as Trigger App.", "poll-maker"), "https://zapier.com/app/editor/"); 
                                    ?>
                                    </blockquote>
                                    <blockquote>
                                        <?= __("We will send you all data from poll information form with \"AysPoll\" key by POST method", "poll-maker"); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/activecampaign_logo.png" alt="">
                                <h5><?php echo __('ActiveCampaign',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_active_camp_url">
                                                <?= __('API Access URL', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_active_camp_url"
                                                   name="ays_active_camp_url"
                                                   value="<?= $active_camp_url; ?>"
                                            >
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_active_camp_api_key">
                                                <?= __('API Access Key', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_active_camp_api_key"
                                                   name="ays_active_camp_api_key"
                                                   value="<?= $active_camp_api_key; ?>"
                                            >
                                        </div>
                                    </div>
                                    <blockquote>
                                        <?= __("Your API URL and Key can be found in your account on the My Settings page under the \"Developer\" tab", "poll-maker"); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset>
                        <hr/>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/slack_logo.png" alt="">
                                <h5><?php echo __('Slack',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <?php if (!$slack_oauth): ?>
                                        <div class="form-group row" aria-describedby="aaa">
                                            <div class="col-sm-3">
                                                <button id="slackInstructionsPopOver" type="button" class="btn btn-info"
                                                        data-toggle="popover"
                                                        title="<?= __("Slack Integration Setup Instructions", "poll-maker") ?>"><?= __("Instructions", "poll-maker") ?></button>
                                                <div class="d-none" id="slackInstructions">
                                                    <p>
                                                    <?php
                                                        /* translators: anchor tag URL */
                                                        echo sprintf(__("1. You will need to <a href='%s' target='_blank'>create</a> new Slack App.", "poll-maker"), "https://api.slack.com/apps?new_app=1");
                                                    ?>
                                                    </p>
                                                    <p><?= __("2. Complete Project creation for get App credentials.", "poll-maker") ?></p>
                                                    <p><?= __("3. Next, go to the Features > OAuth & Permissions > Redirect URLs section.", "poll-maker") ?></p>
                                                    <p><?= __("4. Click Add a new Redirect URL.", "poll-maker") ?></p>
                                                    <p><?= __("5. In the shown input field, put this value below", "poll-maker") ?></p>
                                                    <p>
                                                        <code><?= ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443 ? "https://" : "http://") . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] . "&oauth=slack" ?></code>
                                                    </p>
                                                    <p><?= __("6. Then click the Add button.", "poll-maker") ?></p>
                                                    <p><?= __("7. Then click the Save URLs button.", "poll-maker") ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_slack_client">
                                                <?= __('App Client ID', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_slack_client"
                                                   name="ays_slack_client"
                                                   value="<?= $slack_client; ?>"
                                            >
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_slack_oauth">
                                                <?= __('Slack Authorization', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <?php if ($slack_oauth): ?>
                                                <span class="btn btn-success pointer-events-none">
                                                <?= __("Authorized", "poll-maker") ?></span>
                                            <?php else: ?>
                                                <button type="button" id="slackOAuth2"
                                                        class="btn btn-outline-secondary disabled">
                                                    <?= __("Authorize", "poll-maker") ?>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_slack_secret">
                                                <?= __('App Client Secret', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_slack_secret"
                                                   name="ays_slack_secret"
                                                   value="<?= $slack_secret; ?>" <?= $slack_oauth ?: "readonly" ?>
                                            >
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_slack_oauth">
                                                <?= __('App Access Token', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <?php if ($slack_oauth): ?>
                                                <button type="button"
                                                        data-code="<?= !empty($slack_temp_code) ? $slack_temp_code : "" ?>"
                                                        id="slackOAuthGetToken"
                                                        data-success="<?= __("Access granted", "poll-maker") ?>"
                                                        class="btn btn-outline-secondary disabled"><?= __("Get it", "poll-maker") ?></button>
                                            <?php else: ?>
                                                <button type="button"
                                                        class="btn btn-outline-secondary disabled"><?= __("Need Authorization", "poll-maker") ?>
                                                </button>
                                            <?php endif; ?>
                                            <input type="hidden" id="ays_slack_token" name="ays_slack_token" value="<?= $slack_token; ?>">
                                        </div>
                                    </div>
                                    <blockquote>
                                        <?= __("You can get your App Client ID and Client Secret from your App's the Basic Information page", "poll-maker"); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset>
                        <hr>
                        <!-- Google Sheets start -->
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/sheets_logo.png" alt="">
                                <h5><?php echo __('Google sheets',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <button id="googleInstructionsPopOver" type="button" class="btn btn-info" data-toggle="popover" title="" data-original-title="Google Integration Setup Instructions" aria-describedby="popover188544">Instructions</button>
                                            <div class="d-none" id="googleInstructions">
                                                <p>1. <a href="https://console.developers.google.com/apis/credentials" target="_blank">Create</a> new Google Oauth cliend ID credentials (if you do not still have).</p>
                                                <p>2. Choose the application type as <b>Web application</b></p>
                                                <p>3. Add the following link in the <b>Authorized redirect URIs</b> field</p>
                                                <p>
                                                    <code><?php echo $google_redirect_url?></code>
                                                </p>
                                                <p>4. Click on the <b>Create</b> button</p>
                                                <p>5. Copy the <b>Your Cliend ID</b> from the opened popup and paste it in the Google Client ID field.Then click on the Sign In button to complete authorization</p>
                                                <p>6. After the successful authorization,copy the <b>Your Client ID</b> and paste it in the Google Client ID field again. Also, copy the <b>Your Client Secret</b> and paste it in the Google Client Secret field.</p>
                                                <p>7. Then click <b>Get token</b> button to get your token</p>
                                                <p>8. If the token is given successfully, click on the <b>Save Changes</b> button.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_google_client">
                                                <?= __('Google Client ID', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_poll_google_client"
                                                   name="ays_poll_google_client"
                                                   value="<?php echo $google_client; ?>"
                                            >
                                        </div>
                                    </div>
                                    <hr/>                               
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_googleOAuth2">
                                                <?= __('Google Sign in', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">                                       
                                                <button type="button" id="ays_poll_googleOAuth2"
                                                        class="btn btn-outline-secondary" >
                                                    <?= __("Sign in", "poll-maker") ?>
                                                </button>                                       
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_google_secret">
                                                <?= __('Google Client Secret', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input <?php echo $google_code_check ? 'ays_enable_secret' : '';?>"
                                                   id="ays_poll_google_secret"
                                                   name="ays_poll_google_secret"
                                                   value="<?php echo $google_secret?>" readonly>
                                            <input type="hidden"                                               
                                                   id="ays_poll_google_redirect"
                                                   name="ays_poll_google_redirect"
                                                   value="<?php echo $google_redirect_url;?>">
                                        </div>
                                    </div>                                
                                    <hr/>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_get_token">
                                                <?= __('Get token', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">                                       
                                            <input type="hidden" id="ays_poll_get_token" name="ays_poll_get_token" value="">
                                            <input type="hidden" id="ays_poll_get_refresh_token" name="ays_poll_get_refresh_token" value="">
                                            <button type="button" id="ays_poll_google_get_token"
                                                        class="btn btn-outline-secondary">
                                                    <?= __("Get token", "poll-maker") ?>
                                            </button>
                                            <input type="hidden" id="ays_poll_google_token" name="ays_poll_google_token" value="<?= $google_code; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                        <hr/>                        
                        <!-- Google Sheets end -->
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/sendgrid_logo.png" alt="">
                                <h5><?php echo __('SendGrid',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_sendgrid_username">
                                                <?php echo __('SendGrid API Key',"poll-maker")?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                   class="ays-text-input"
                                                   id="ays_sendgrid_api_key"
                                                   name="ays_sendgrid_api_key"
                                                   value="<?php echo $sendgrid_api_key; ?>"
                                            />
                                        </div>
                                    </div>
                                    <hr/>                                    
                                    <blockquote>
                                        <?php echo sprintf( __( "You can get your API key from ", "poll-maker" ) . "<a href='%s' target='_blank'> %s.</a>", "https://app.sendgrid.com/settings/api_keys", "sendgrid.com" ); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset> <!-- SendGrid -->
                        <hr/>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/gamipress_logo.png" alt="">
                                <h5><?php echo __('GamiPress',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">     
                                    <blockquote>
                                        <?php echo __( "Install the GamiPress plugin to use the integration. Configure the settings from the Automatic Points Awards section from the GamiPres plugin.", "poll-maker" ); ?>
                                        <br>
                                        <?php echo __( "After enabling the integration, the Poll Maker will automatically be added to the event list.", "poll-maker" ); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset> <!-- GamiPress -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mad-mimi-logo-min.png" alt="">
                                <h5><?php echo __('Mad Mimi',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_mad_mimi_user_name">
                                                <?= __('Username', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_poll_mad_mimi_user_name" name="ays_poll_mad_mimi_user_name" value="<?= $mad_mimi_user_name; ?>" >
                                        </div>
                                    </div>
                                    <hr/>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_mad_mimi_api_key">
                                                <?= __('API Key', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_poll_mad_mimi_api_key" name="ays_poll_mad_mimi_api_key" value="<?= $mad_mimi_api_key; ?>" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset><!-- MAD MIMI -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/get_response.png" alt="">
                                <h5><?php echo __('GetResponse',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_getresponse_api_key">
                                                <?= __('GetResponse API Key', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                    class="ays-text-input"
                                                    id="ays_poll_getresponse_api_key"
                                                    name="ays_poll_getresponse_api_key"
                                                    value="<?= $getResponse_api_key; ?>"
                                            >
                                        </div>
                                    </div>
                                    <blockquote>
                                        <?php 
                                            /* translators: anchor tag URL */
                                            echo sprintf(__("You can get your API key from your <a href='%s' target='_blank'>account</a>.", "poll-maker"), "https://app.getresponse.com/api"); 
                                        ?>
                                    </blockquote>
                                    <blockquote>
                                        <?php echo __("For security reasons, unused API keys expire after 90 days. When that happens, you’ll need to generate a new key.", "poll-maker") ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset><!-- GET RESPONSE -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mailerlite.png" alt="">
                                <h5><?php echo __('MailerLite',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_mailerlite_api_key">
                                                <?= __('MailerLite API Key', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                    class="ays-text-input"
                                                    id="ays_poll_mailerlite_api_key"
                                                    name="ays_poll_mailerlite_api_key"
                                                    value="<?= $mailerLite_api_key; ?>"
                                            >
                                        </div>
                                    </div>
                                    <blockquote>
                                        <?php
                                            /* translators: anchor tag URL */
                                            echo sprintf(__("You can get your API key from your <a href='%s' target='_blank'>account</a>.", "poll-maker"), "https://app.mailerlite.com/integrations/api");
                                        ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset><!-- MAILERLITE -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/convertkit_logo.png" alt="">
                                <h5><?php echo __('ConvertKit',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row" aria-describedby="aaa">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_convert_kit">
                                                ConvertKit <?= __('API Key', "poll-maker") ?>
                                            </label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text"
                                                class="ays-text-input"
                                                id="ays_poll_convert_kit"
                                                name="ays_poll_convert_kit"
                                                value="<?= $convertKit_account_id; ?>"
                                            >
                                        </div>
                                    </div>                                
                                    <blockquote>
                                        <?php echo sprintf( __( "You can get your API Key from your ", "poll-maker" ) . "<a href='%s' target='_blank'> %s.</a>", "https://app.convertkit.com/account/edit", "Account" ); ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset><!-- CONVERT KIT -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/recaptcha_logo.png" alt="">
                                <h5><?php echo __('reCAPTCHA',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_recaptcha_site_key"><?php echo __('reCAPTCHA v2 Site Key', "poll-maker") ?></label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_poll_recaptcha_site_key" name="ays_poll_recaptcha_site_key" value="<?php echo $recaptcha_site_key ?>" >
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_recaptcha_secret_key"><?php echo __('reCAPTCHA v2 Secret Key', "poll-maker") ?></label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_poll_recaptcha_secret_key" name="ays_poll_recaptcha_secret_key" value="<?php echo $recaptcha_secret_key ?>" >
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_recaptcha_language"><?php echo __('reCAPTCHA Language', "poll-maker") ?></label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_poll_recaptcha_language" name="ays_poll_recaptcha_language" value="<?php echo $recaptcha_language ?>" >
                                            <span class="ays_poll_small_hint_text">
                                                <span>
                                                    <?php 
                                                        /* translators: 1: opening anchor tag, 2: closing anchor tag */
                                                        echo sprintf(__( "e.g. en, de - Language used by reCAPTCHA. To get the code for your language click %1\$s here %2\$s", "poll-maker" ),
                                                            '<a href="https://developers.google.com/recaptcha/docs/language" target="_blank">',
                                                            "</a>"
                                                    )
                                                    ?>
                                                </span>
                                            </span>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_recaptcha_theme"><?php echo __('reCAPTCHA Theme', "poll-maker") ?></label>
                                        </div>
                                        <div class="col-sm-9">
                                            <select class="ays-text-input" id="ays_poll_recaptcha_theme" name="ays_poll_recaptcha_theme" >
                                                <option value="light" <?php echo ( $recaptcha_theme == 'light' ? 'selected' : '' )  ?> ><?php echo __('Light', "poll-maker")  ?> </option>
                                                <option value="dark" <?php echo ( $recaptcha_theme == 'dark' ? 'selected' : '' )  ?> ><?php echo __('Dark', "poll-maker")  ?> </option>
                                            </select>
                                        </div>
                                    </div>
                                    <blockquote>
                                        <?php
                                            /* translators: 1: opening anchor tag, 2: closing anchor tag */
                                            echo sprintf(__("You need to set up reCAPTCHA in your Google account to generate the required keys and get them by %1\$s Google's reCAPTCHA admin console %2\$s.", "poll-maker"),"<a href='https://www.google.com/recaptcha/admin/create' target='_blank'>", "</a>");
                                        ?>
                                    </blockquote>
                                </div>
                            </div>
                        </fieldset>
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/aweber-logo.png" alt="">
                                <h5><?php echo __('Aweber', "poll-maker") ?></h5>
                            </legend>
                            <div class="form-group row" style="margin:0">
                                <div class="col-sm-12 only_pro" style="padding:10px 0 0 10px;">
                                    <div class="pro_features" style="justify-content:flex-end;">
                                    </div>
                                    <div class="form-group-row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <div class="col-sm-3">
                                                    <button id="aweberInstructionsPopOver" type="button" class="btn btn-info" data-original-title="Aweber Integration Setup Instructions" ><?php echo __('Instructions', "poll-maker"); ?></button>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <div class="col-sm-3">
                                                    <label for="ays_poll_aweber_client_id"><?php echo  __('Client ID', "poll-maker"); ?></label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" class="ays-text-input" id="ays_poll_aweber_client_id" name="ays_poll_aweber_client_id">
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="form-group row">
                                                <div class="col-sm-3">
                                                    <label for="ays_poll_aweber_client_secret"><?php echo  __('Client Secret', "poll-maker"); ?></label>
                                                </div>
                                                <div class="col-sm-9">
                                                    <input type="text" class="ays-text-input" id="ays_poll_aweber_client_secret" name="ays_poll_aweber_client_secret">
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="form-group row">
                                                <div class="col-sm-3"></div>
                                                <div class="col-sm-9">
                                                    <button type="submit" id="pollAweberOauth2" class="btn btn-outline-info"><?php echo __("Connect", "poll-maker"); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                                        <div class="ays-poll-new-upgrade-button-box">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                            </div>
                                            <div class="ays-poll-new-upgrade-button"><?php echo __("Upgrade to Agency", "poll-maker"); ?></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </fieldset> <!-- Aweber -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mail_poet.png" alt="">
                                <h5><?php echo __('Mailpoet', "poll-maker") ?></h5>
                            </legend>
                            <div class="form-group row" style="margin:0">
                                <div class="col-sm-12 only_pro" style="padding:10px 0 0 10px;">
                                    <div class="pro_features" style="justify-content:flex-end;">
                                    </div>
                                    <div class="form-group row">
                                        <blockquote class="error_message" style="width:95%;">
                                            <?php echo __('To enable the integration, please install the MailPoet plugin.' , "poll-maker");?>
                                        </blockquote>
                                    </div>
                                    <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                                        <div class="ays-poll-new-upgrade-button-box">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                            </div>
                                            <div class="ays-poll-new-upgrade-button"><?php echo __("Upgrade to Agency", "poll-maker"); ?></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </fieldset> <!-- Mailpoet -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mycred_icon.png" alt="">
                                <h5><?php echo __('MyCred', "poll-maker") ?></h5>
                            </legend>
                            <div class="form-group row" style="margin:0">
                                <div class="col-sm-12 only_pro" style="padding:10px 0 0 10px;">
                                    <div class="pro_features" style="justify-content:flex-end;">
                                    </div>
                                    <div class="form-group row">
                                        <blockquote class="error_message" style="width:95%;"> <?php echo __('To enable the integration, please install the MyCred plugin.' , "poll-maker"); ?> </blockquote>
                                    </div>
                                    <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                                        <div class="ays-poll-new-upgrade-button-box">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                            </div>
                                            <div class="ays-poll-new-upgrade-button"><?php echo __("Upgrade to Agency", "poll-maker"); ?></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </fieldset> <!-- MyCred -->
                        <hr>
                        <fieldset>
                            <legend>
                                <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/klaviyo-logo.png" alt="">
                                <h5><?php echo __('Klaviyo', "poll-maker") ?></h5>
                            </legend>
                            <div class="form-group row" style="margin:0">
                                <div class="col-sm-12 only_pro" style="padding:10px;">
                                    <div class="pro_features" style="justify-content:flex-end;">
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-sm-3">
                                            <label for="ays_poll_klaviyo_api_key"><?php echo __('API Key', "poll-maker")?></label>
                                        </div>
                                        <div class="col-sm-9">
                                            <input type="text" class="ays-text-input" id="ays_poll_klaviyo_api_key" >
                                        </div>
                                    </div>
                                    <a href="https://ays-pro.com/wordpress/poll-maker" target="_blank" class="ays-poll-new-upgrade-button-link">
                                        <div class="ays-poll-new-upgrade-button-box">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/locked_24x24.svg'?>">
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL.'/images/icons/pro-features-icons/unlocked_24x24.svg'?>" class="ays-poll-new-upgrade-button-hover">
                                            </div>
                                            <div class="ays-poll-new-upgrade-button"><?php echo __("Upgrade to Agency", "poll-maker"); ?></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </fieldset> <!-- Klaviyo -->
                    </div>
                    <div id="tab3"
                         class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab3') ? 'ays-poll-tab-content-active' : ''; ?>">
                        <p class="ays-subtitle"><?php echo __('Shortcodes', "poll-maker") ?></p>
                        <hr/>
                        <fieldset>
                             <legend>
                                    <strong style="font-size:30px;">[ ]</strong>
                                    <h5 class="ays-subtitle"><?php echo __('Shortcode for all polls',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="all_ays_poll_shortcodes">
                                        <?php echo __("Shortcode", "poll-maker"); ?>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" name="all_ays_poll_shortcodes" id="all_ays_poll_shortcodes" onclick="this.setSelectionRange(0, this.value.length)"readonly="" class="ays-text-input" value="[ays_poll_all display='all' count='5' layout='list' sorting='date_asc']">
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_all_polls_shortcodes">
                                        <?php echo __("Message", "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The notification message will be appeared when all polls of the given category expires or becomes unpublished.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" name="ays_poll_all_polls_shortcodes" id="ays_poll_all_polls_shortcodes" class="ays-text-input" value="<?php echo $all_shortcode_message?>">                                        
                                </div>
                            </div>
                            <hr>
                            <blockquote>
                                <ul>
                                    <li>
                                        <b><?php echo  __('Display (all/random)',"poll-maker");  ?></b>
                                        <?php echo  __(' - Choose the method of displaying. Example:display="random".',"poll-maker");  ?>  
                                        <ul class='ays_poll_shorcode_methodes'>
                                            <li>
                                                <b><?php echo  __('All',"poll-maker"); ?></b>
                                                <?php echo  __(' - If you set the method as All, it will show all polls from the given category.',"poll-maker");  ?></li>
                                            <li>
                                                <b><?php echo  __('Random',"poll-maker");  ?></b>
                                                <?php echo  __(' - If you set the method as Random, please give a value to count option too, and it will randomly display that given amount of polls from the given category.',"poll-maker");  ?></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <b><?php echo  __('Layout(list/grid)',"poll-maker");  ?></b>
                                        <?php echo  __(' - Choose the design of the layout. Example:layout=grid.',"poll-maker");  ?>
                                        <ul class='ays_poll_shorcode_methodes'>
                                            <li>
                                            <b><?php echo  __('List',"poll-maker");  ?></b>
                                            <?php echo  __(' - Choose the design of the layout as list․',"poll-maker");  ?></li>
                                            <li>
                                            <b><?php echo  __('Grid',"poll-maker");  ?></b>
                                            <?php echo  __(' - Choose the design of the layout as grid․',"poll-maker");  ?></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <b><?php echo  __('Sorting (date_asc|date_desc|popular_asc|popular_desc)',"poll-maker");  ?></b>
                                        <?php echo  __(' - Choose the method of sorting.  Example:sorting=date_desc.',"poll-maker");  ?>
                                        <ul class='ays_poll_shorcode_methodes'>
                                            <li>
                                            <b><?php echo  __('Date_asc:',"poll-maker");  ?></b>
                                            <?php echo  __(' The earliest created polls will appear at first.',"poll-maker");  ?>
                                            </li>
                                            <li>
                                            <b><?php echo  __('Date_desc:',"poll-maker");  ?></b>
                                            <?php echo  __(' The latest created polls will appear at first.',"poll-maker");  ?>
                                            </li>
                                            <li>
                                            <b><?php echo  __('Popular_asc:',"poll-maker");  ?></b>
                                            <?php echo  __(' The most voted polls will appear at first.',"poll-maker");  ?>
                                            </li>
                                            <li> 
                                            <b><?php echo  __('Popular_desc:',"poll-maker");  ?></b>   
                                            <?php echo  __(' The most voted polls will appear in the end.',"poll-maker");  ?>
                                            </li>
                                        </ul>
                                    </li>
                                </ul>
                            </blockquote>
                            <hr>
                            <blockquote>
                                <?php echo __("Paste the shortcode into any of your posts to show all polls together. Note: Expired and unpublished polls will not be included in the list.", "poll-maker"); ?>
                            </blockquote>
                        </fieldset>
                        <hr/>
                        <fieldset>
                             <legend>
                                    <strong style="font-size:30px;">[ ]</strong>
                                    <h5 class="ays-subtitle"><?php echo __('Shortcode result by ID',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_shortcodes_by_id">
                                        <?php echo __("Shortcode", "poll-maker"); ?>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                <input type="text" name="ays_poll_shortcodes_by_id" id="ays_poll_shortcodes_by_id" onclick="this.setSelectionRange(0, this.value.length)"readonly="" class="ays-text-input" value='[ayspoll_results id="Your_Poll_ID" recent="true/false"]'>
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label>
                                        <?php echo __('Show results by',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Select the way of displaying the results: Bar chart or Pie chart.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                   <div class="d-flex">
                                        <div class="form-check form-check-inline ays_poll_loader">
                                            <label class="form-check-label ays_poll_check_label"
                                                   for="ays_poll_show_res_standart_general"> <?= __('Bar Chart', "poll-maker"); ?> </label>
                                            <input type="radio" id="ays_poll_show_res_standart_general" name="ays_poll_show_result_view_general"
                                                   value="standart" <?= ($show_result_view == 'standart') ? 'checked' : ''; ?> />
                                        </div>
                                        <div class="form-check form-check-inline ays_poll_loader">
                                            <label class="form-check-label ays_poll_check_label"
                                                   for="ays_poll_show_res_pie_chart_general"> <?= __('Pie Chart', "poll-maker"); ?> </label>
                                            <input type="radio" id="ays_poll_show_res_pie_chart_general" name="ays_poll_show_result_view_general"
                                                   value="pie_chart" <?= ($show_result_view == 'pie_chart') ? 'checked' : ''; ?> />
                                        </div>
                                        <div class="form-check form-check-inline ays_poll_loader">
                                            <label class="form-check-label ays_poll_check_label"
                                                   for="ays_poll_show_res_column_chart_general"> <?= __('Column Chart', "poll-maker"); ?> </label>
                                            <input type="radio" id="ays_poll_show_res_column_chart_general" name="ays_poll_show_result_view_general"
                                                   value="column_chart" <?= ($show_result_view == 'column_chart') ? 'checked' : ''; ?> />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_shortcodes_by_id_inherit">
                                        <?php echo __("Apply poll options", "poll-maker"); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Tick the checkbox if you want to apply poll options to this shortcode such as Hide results, Share button, and so on.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="checkbox" name="ays_poll_shortcodes_by_id_inherit" id="ays_poll_shortcodes_by_id_inherit" value="on" <?php echo $ays_poll_results_inherit;?>>                                            
                                </div>
                            </div>
                            <hr>
                            <blockquote>
                                <?php echo __("This shortcode will help you to get the recent submitted poll. You will need to add the ID of the poll into the shortcode or choose the true option in the recent (in this case the ID will not be essential). By default it will be false.", "poll-maker"); ?>
                            </blockquote>
                        </fieldset>
                        <!-- Aro Start -->
                        <hr/>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_fa ays_poll_fa-list"></i></strong>
                                <h5><?php echo __('Poll Categories',"poll-maker")?></h5>
                            </legend>                            
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_invidLead">
                                        <?php echo __( "Poll category shortcode", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Copy the following shortcode, configure it based on your preferences and paste it into the post. Put the shortcode of your preferred category,  choose the method of displaying (all/random), and the design of the layout(list/grid). If you set the method as All, it will show all polls from the given category, if you set the method as Random, please give a value to count option too, and it will randomly display that given amount of polls from the given category.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <hr/>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_invidLead" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_cat id="Your_Poll_Cat_ID" display="all" count="5" layout="list" sorting="date_asc"]'>
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for='cat_show_title'>
                                        <?= __('Show category title', "poll-maker"); ?>
                                        <a  class="ays_help" 
                                            data-toggle="tooltip"
                                            data-placement="top"
                                            title="<?= __("Show or hide the name of the category poll", "poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a></label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="checkbox" name="ays_poll_show_cat_title" id="cat_show_title"
                                           value="on" <?= $show_cat_title ?>>
                                </div>
                            </div>
                            <hr/>
                            <blockquote>
                                <ul>
                                    <li>
                                        <b><?php echo  __('Display (all/random)',"poll-maker");  ?></b>
                                        <?php echo  __(' - Choose the method of displaying. Example:display="random".',"poll-maker");  ?>  
                                        <ul class='ays_poll_shorcode_methodes'>
                                            <li>
                                                <b><?php echo  __('All',"poll-maker"); ?></b>
                                                <?php echo  __(' - If you set the method as All, it will show all polls from the given category.',"poll-maker");  ?></li>
                                            <li>
                                                <b><?php echo  __('Random',"poll-maker");  ?></b>
                                                <?php echo  __(' - If you set the method as Random, please give a value to count option too, and it will randomly display that given amount of polls from the given category.',"poll-maker");  ?></li>
                                        </ul>
                                    </li>
                                    <li>
                                    <b><?php echo  __('Layout(list/grid)',"poll-maker");  ?></b>
                                    <?php echo  __(' - Choose the design of the layout. Example:layout=grid.',"poll-maker");  ?>
                                        <ul class='ays_poll_shorcode_methodes'>
                                            <li>
                                            <b><?php echo  __('List',"poll-maker");  ?></b>
                                            <?php echo  __(' - Choose the design of the layout as list․',"poll-maker");  ?></li>
                                            <li>
                                            <b><?php echo  __('Grid',"poll-maker");  ?></b>
                                            <?php echo  __(' - Choose the design of the layout as grid․',"poll-maker");  ?></li>
                                        </ul>
                                    </li>
                                    <li>
                                    <b><?php echo  __('Sorting (date_asc|date_desc|popular_asc|popular_desc)',"poll-maker");  ?></b>
                                    <?php echo  __(' - Choose the method of sorting.  Example:sorting=date_desc.',"poll-maker");  ?>
                                        <ul class='ays_poll_shorcode_methodes'>
                                            <li>
                                            <b><?php echo  __('Date_asc:',"poll-maker");  ?></b>
                                            <?php echo  __(' The earliest created polls will appear at first.',"poll-maker");  ?>
                                            </li>
                                            <li>
                                            <b><?php echo  __('Date_desc:',"poll-maker");  ?></b>
                                            <?php echo  __(' The latest created polls will appear at first.',"poll-maker");  ?>
                                            </li>
                                            <li>
                                            <b><?php echo  __('Popular_asc:',"poll-maker");  ?></b>
                                            <?php echo  __(' The most voted polls will appear at first.',"poll-maker");  ?>
                                            </li>
                                            <li> 
                                            <b><?php echo  __('Popular_desc:',"poll-maker");  ?></b>   
                                            <?php echo  __(' The most voted polls will appear in the end.',"poll-maker");  ?>
                                            </li>
                                        </ul>
                                    </li>
                                </ul>
                            </blockquote>
                            <hr>
                            <blockquote>
                                <p style="margin:0;"><?php echo __( "Paste the shortcode into any of your posts to show all/random polls from the given category by list/grid view.", "poll-maker" ); ?></p>
                            </blockquote>
                        </fieldset>
                        <hr>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;">[ ]</strong>
                                <h5 class="ays-subtitle"><?php echo __('Global Leaderboard Settings',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_globLead">
                                        <?php echo __( "Global Leaderboard shortcode", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('You can copy the shortcode and paste it to any post/page to see the list of the top user’s who passed any poll.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_globLead" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_gleaderboard from="Y-m-d H:i:s" to="Y-m-d H:i:s"]'>
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_gleadboard_count">
                                        <?php echo __('Users count',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('How many users’ results will be shown in the leaderboard.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number"
                                        class="ays-text-input"                 
                                        id="ays_gleadboard_count" 
                                        name="ays_gleadboard_count"
                                        value="<?php echo $glob_leadboard_count; ?>"
                                    />
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_gleadboard_width">
                                        <?php echo __('Width',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The width of the Leaderboard box. It accepts only numeric values. For 100% leave it blank.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number"
                                        class="ays-text-input"                 
                                        id="ays_gleadboard_width" 
                                        name="ays_gleadboard_width"
                                        value="<?php echo $glob_leadboard_width; ?>"
                                    />
                                    <span style="display:block;" class="ays_poll_small_hint_text"><?php echo __("For 100% leave blank", "poll-maker");?></span>
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label>
                                        <?php echo __('Users group by',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Select the way for grouping the results. If you want to make Leaderboard for logged in users, then choose ID. It will collect results by WP user ID. If you want to make Leaderboard for guests, then you need to choose Email and enable Information Form and Email, Name options from poll settings. It will group results by emails and display guests Names.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <label class="ays_poll_loader">
                                        <input type="radio" name="ays_gleadboard_orderby" value="id" <?php echo $glob_leadboard_orderby == "id" ? "checked" : ""; ?> />
                                        <span><?php echo __( "ID", "poll-maker"); ?></span>
                                    </label>
                                    <label class="ays_poll_loader">
                                        <input type="radio" name="ays_gleadboard_orderby" value="email" <?php echo $glob_leadboard_orderby == "email" ? "checked" : ""; ?> />
                                        <span><?php echo __( "Email", "poll-maker"); ?></span>
                                    </label>
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_gleadboard_color">
                                        <?php echo __('Color',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Top color of the leaderboard',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_gleadboard_color" name="ays_gleadboard_color" data-alpha="true" value="<?php echo $glob_leadboard_color; ?>" />
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_gleadboard_custom_css">
                                        <?php echo __('Custom CSS',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Field for entering your own CSS code',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <textarea class="ays-textarea" id="ays_gleadboard_custom_css" name="ays_gleadboard_custom_css" cols="30"
                                          rows="10" style="height: 80px;"><?php echo $glob_leadboard_suctom_css; ?></textarea>
                                </div>
                            </div>
                            <hr>                            
                            <blockquote>
                                <?php echo __( "Paste the shortcode into any of your posts to show the list of the top users who have passed your polls.", "poll-maker" ); ?>
                            </blockquote>
                            <blockquote>
                                <ul class="ays-poll-general-settings-blockquote-ul">
                                    <li>
                                        <?php
                                            echo sprintf(
                                                /* translators: 1: opening b tag, 2: closing b tag */
                                                __( "%1\$sFrom%2\$s", "poll-maker" ) . ' - ' . __( 'Specify the start date to display the leaderboard (e.g. 2021-01-01 00:00:00)', "poll-maker" ),
                                                '<b>',
                                                '</b>'
                                            );
                                        ?>
                                    </li>
                                    <li>
                                        <?php
                                            echo sprintf(
                                                /* translators: 1: opening b tag, 2: closing b tag */
                                                __( "%1\$sTo%2\$s", "poll-maker" ) . ' - ' . __( 'Specify the end date to display the leaderboard
                                                (e.g. 2021-01-31 00:00:00)', "poll-maker" ),
                                                '<b>',
                                                '</b>'
                                            );
                                        ?>
                                    </li>
                                </ul>
                            </blockquote>
                        </fieldset>
                        <!-- Custom global leadboard CSS -->
                        <hr/>
                        <!-- Aro END -->
                        <!-- Ani Start -->
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;">[ ]</strong>
                                <h5 class="ays-subtitle"><?php echo __('Global Leaderboard By Category Settings',"poll-maker")?></h5>
                            </legend>
                            <!-- shortcode  -->
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_cat_globLead">
                                        <?php echo __( "Shortcode", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Paste the shortcode into any of your posts or pages to show the list of the top users who have voted your polls. It will print the attempts count of each poll participant, as well.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_poll_cat_globLead" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_cat_gleaderboard id="Your_Poll_Category_ID" from="Y-m-d H:i:s" to="Y-m-d H:i:s"]'>
                                </div>
                            </div>
                            <hr/>
                            <!-- users count  -->
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_cat_gleadboard_count">
                                        <?php echo __('Users count',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify how many users’ results to be shown on the leaderboard.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number"
                                        class="ays-text-input"                 
                                        id="ays_poll_cat_gleadboard_count" 
                                        name="ays_poll_cat_gleadboard_count"
                                        value="<?php echo $ays_poll_cat_glob_leadboard_count; ?>"
                                    />
                                </div>
                            </div>
                            <hr/>
                            <!-- witdth  -->
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_cat_gleadboard_width">
                                        <?php echo __('Width',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Set the width of the leaderboard's box. It accepts only numeric values. For 100%, leave the field blank.","poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="number"
                                        class="ays-text-input"                 
                                        id="ays_poll_cat_gleadboard_width" 
                                        name="ays_poll_cat_gleadboard_width"
                                        value="<?php echo $ays_poll_cat_glob_leadboard_width; ?>"
                                    />
                                    <span style="display:block;" class="ays_poll_small_hint_text"><?php echo __("For 100% leave blank", "poll-maker");?></span>
                                </div>
                            </div>
                            <hr/>
                            <!-- users group by  -->
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label>
                                        <?php echo __('Group users by',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Select the way for grouping the results.
                                        By ID - Choose by ID if you want to make a leaderboard for logged-in users. It will collect results by WordPress user ID.
                                        By  Email - Choose by email if you want to make the leaderboard for guests. In this case,  do not forget to activate the Information Form of the given polls.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <label class="ays_poll_loader">
                                        <input type="radio" name="ays_poll_cat_gleadboard_orderby" value="id" <?php echo $ays_poll_cat_glob_leadboard_orderby == "id" ? "checked" : ""; ?> />
                                        <span><?php echo __( "ID", "poll-maker"); ?></span>
                                    </label>
                                    <label class="ays_poll_loader">
                                        <input type="radio" name="ays_poll_cat_gleadboard_orderby" value="email" <?php echo $ays_poll_cat_glob_leadboard_orderby == "email" ? "checked" : ""; ?> />
                                        <span><?php echo __( "Email", "poll-maker"); ?></span>
                                    </label>
                                </div>
                            </div>
                            <hr/>
                            <!-- color  -->
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_cat_gleadboard_color">
                                        <?php echo __('Color',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __("Choose the color of the leaderboard's box.","poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_poll_cat_gleadboard_color" name="ays_poll_cat_gleadboard_color" data-alpha="true" value="<?php echo $ays_poll_cat_glob_leadboard_color; ?>" />
                                </div>
                            </div>
                            <hr/>
                            <!-- custom css  -->
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_cat_gleadboard_custom_css">
                                        <?php echo __('Custom CSS',"poll-maker")?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enter your own custom CSS code.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <textarea class="ays-textarea" id="ays_poll_cat_gleadboard_custom_css" name="ays_poll_cat_gleadboard_custom_css" cols="30"
                                          rows="10" style="height: 80px;"><?php echo $ays_poll_cat_glob_leadboard_suctom_css; ?></textarea>
                                </div>
                            </div>
                            <hr>                            
                            <blockquote>
                                <?php echo __( "Paste the shortcode into any of your posts or pages to show the list of the top users who have voted your polls. It will print the attempts count of each poll participant, as well.", "poll-maker" ); ?>
                            </blockquote>
                            <blockquote>
                                <ul class="ays-poll-general-settings-blockquote-ul">
                                    <li>
                                        <?php
                                            echo sprintf(
                                                /* translators: 1: opening b tag, 2: closing b tag */
                                                __( "%1\$sFrom%2\$s", "poll-maker" ) . ' - ' . __( 'Specify the start date to display the leaderboard (e.g. 2021-01-01 00:00:00)', "poll-maker" ),
                                                '<b>',
                                                '</b>'
                                            );
                                        ?>
                                    </li>
                                    <li>
                                        <?php
                                            echo sprintf(
                                                /* translators: 1: opening b tag, 2: closing b tag */
                                                __( "%1\$sTo%2\$s", "poll-maker" ) . ' - ' . __( 'Specify the end date to display the leaderboard
                                                (e.g. 2021-01-31 00:00:00)', "poll-maker" ),
                                                '<b>',
                                                '</b>'
                                            );
                                        ?>
                                    </li>
                                </ul>
                            </blockquote>
                        </fieldset><!-- Global leaderboard by category--> 
                        <hr/>
                        <!-- Ani end -->
                        <fieldset>
                        <legend>
                            <strong style="font-size:30px;">[ ]</strong>
                            <h5 class="ays-subtitle"><?php echo __('User Leaderboard Position Settings',"poll-maker")?></h5>
                        </legend>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_user_leaderboard_position">
                                    <?php echo __( "Shortcode", "poll-maker" ); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Copy the shortcode and paste it to any post/page to see the leaderboard position of the current user. It works with Global Leaderboard shortcode options.',"poll-maker")?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" id="ays_user_leaderboard_position" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_leaderboard_position]'>
                            </div>
                        </div>
                    </fieldset>
                    <hr>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;"><i class="ays_fa ays_poll_fa-poll"></i></strong>
                                <h5><?php echo __( 'Request Form' , "poll-maker" )?></h5>
                            </legend>                            
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_glob_lead">
                                        <?php echo __( "Shortcode", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Copy the following shortcode and paste it into your desired post. It will allow users to send a request for building a poll with simple settings (Poll title, question, answers). Find the list of the requests in the Requests page, which is located on the Poll Maker left navbar. For accepting the request, the admin needs to click on the Approve button next to the given poll.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_glob_lead" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_request_form]'>
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_default_cat_for_request">
                                        <?php echo __( "Categories", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose those categories, that you want to be shown in the request form.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <select id="ays_poll_default_cat_for_request" name="ays_poll_default_cat_for_request[]" multiple>
                                        <?php
                                            $cat_request_content = "";
                                            $cat_request_selected = "";
                                            foreach($poll_get_all_cats as $key => $value){
                                                $cat_request_id       = isset($value['id']) && $value['id'] != "" ? esc_attr($value['id']) : "";
                                                $cat_request_title    = isset($value['title']) && $value['title'] != "" ? esc_attr($value['title']) : "";
                                                $cat_request_selected = in_array($cat_request_id , $ays_poll_request_default_cat)  ? "selected" : "";
                                                $cat_request_content .= "<option value=".$cat_request_id." ".$cat_request_selected.">".$cat_request_title."</option>";
                                            }
                                            echo $cat_request_content;
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <hr/>
                            <blockquote>
                                <p style="margin:0;"><?php echo __( "Ability to allow users to create a poll from the front-end.", "poll-maker" ); ?></p>
                            </blockquote>
                        </fieldset>
                        <hr>
                        <!-- Ani Start -->
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;">[ ]</strong>
                                <h5><?php echo __('User History Settings',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_user_history">
                                        <?php echo __( "Shortcode", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Paste the shortcode into any of your posts or pages to show the current user’s votes history. Each user will see individually presented content based on their taken polls.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_poll_user_history" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_history]'>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <label>
                                        <?php echo __( "User history results table columns", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('You can sort table columns and select which columns must display on the front-end.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                    <div class="ays-show-user-history-table-wrap">
                                        <ul class="ays-show-user-history-table">
                                            <?php
                                                foreach ($ays_poll_user_page_columns_order as $key => $val) {
                                                    $checked = '';
                                                    if(isset($ays_poll_user_page_columns[$key]) && $ays_poll_user_page_columns[$key] != ''){
                                                        $checked = 'checked';
                                                    }
                                                    ?>
                                                    <li class="ays-user-history-option-row ui-state-default">
                                                        <input type="hidden" value="<?php echo $key; ?>" name="ays_poll_user_history_columns_order[<?php echo $key; ?>]"/>
                                                        <input type="checkbox" id="ays_show_<?php echo $key; ?>" value="<?php echo $key; ?>" class="ays-checkbox-input" name="ays_poll_user_history_columns[<?php echo $key; ?>]" <?php echo $checked; ?>/>
                                                        <label for="ays_show_<?php echo $key; ?>">
                                                            <?php echo $default_user_page_column_names[$key]; ?>
                                                        </label>
                                                    </li>
                                                    <?php
                                                }
                                            ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </fieldset><!-- User history shortcode -->
                        <!-- Ani end -->
                        <hr>
                        <fieldset>
                            <legend>
                                    <strong style="font-size:30px;">[ ]</strong>
                                    <h5 class="ays-subtitle"><?php echo __('Recent Polls Settings',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_poll_shortcodes_recent_by_id">
                                        <?php echo __("Shortcode", "poll-maker"); ?>
                                    </label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" name="ays_poll_shortcodes_recent_by_id" id="ays_poll_shortcodes_recent_by_id" onclick="this.setSelectionRange(0, this.value.length)"readonly="" class="ays-text-input" value='[ays_display_polls orderby="random/recent" count="5"]'>
                                        
                                </div>
                            </div>
                            <blockquote>
                                <ul class="ays-poll-general-settings-blockquote-ul">
                                    <li>
                                        <?php echo __("Copy the following shortcode, configure it based on your preferences and paste it into the post.", "poll-maker"); ?>
                                    </li>
                                    <ul class="ays-poll-general-settings-ul">
                                        <li>
                                            <?php
                                                echo sprintf(
                                                    /* translators: 1: opening b tag, 2: closing b tag */
                                                    __( "%1\$sRandom%2\$s", "poll-maker" ) . ' - ' . __( 'If you set the ordering method as random and gave a value to count option, then it will randomly display that given amount of polls from your created polls.', "poll-maker" ),
                                                    '<b>',
                                                    '</b>'
                                                );
                                            ?>
                                        </li>
                                        <li>
                                            <?php
                                                echo sprintf(
                                                    /* translators: 1: opening b tag, 2: closing b tag */
                                                    __( "%1\$sRecent%2\$s", "poll-maker" ) . ' - ' . __( 'If you set the ordering method as recent and gave a value to count option, then it will display that given amount of polls from your recently created polls.', "poll-maker" ),
                                                    '<b>',
                                                    '</b>'
                                                );
                                            ?>
                                        </li>
                                    </ul>
                                </ul>
                            </blockquote>
                        </fieldset><!-- Shortcode for showing random or recent polls --> 
                        <hr>
                        <!-- Show all result start -->
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;">[ ]</strong>
                                <h5><?php echo __('All Results Settings',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_all_results">
                                        <?php echo __( "Shortcode", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('You can copy the shortcode and insert it to any post to show all results.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="ays_all_results" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_all_results]'>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_poll_all_results_show_publicly">
                                        <?php echo __( "Show to guests too", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Show the All results table to guests as well. By default, it is displayed only for logged-in users. If this option is disabled, then only the logged-in users will be able to see the table. Note: Despite the fact of showing the table to the guests, the table will contain only info of the logged-in users.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="checkbox" class="ays-checkbox-input" id="ays_poll_all_results_show_publicly" name="ays_poll_all_results_show_publicly" value="on" <?php echo $all_poll_results_show_publicly ? 'checked' : ''; ?> />
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <label>
                                        <?php echo __( "All results tables columns", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('You can sort table columns and select which columns must display on the front-end.',"poll-maker")?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                    <div class="ays-poll-all-results-table-wrap">
                                        <ul class="ays-poll-all-results-table">
                                            <?php
                                                foreach ($poll_all_results_columns_order as $key => $val) {
                                                    $checked = '';
                                                    if(isset($poll_all_results_columns[$val]) &&$poll_all_results_columns[$val] != ''){
                                                        $checked = 'checked';
                                                    }

                                                    $default_all_results_column_names_label = '';
                                                    if( isset( $default_all_results_column_names[$val] ) && $default_all_results_column_names[$val] != '' ){
                                                        $default_all_results_column_names_label = $default_all_results_column_names[$val];
                                                    }

                                                    if( $default_all_results_column_names_label == '' ){
                                                        continue;
                                                    }

                                                    ?>
                                                    <li class="ays-poll-all-results-table-row ui-state-default">
                                                        <input type="hidden" value="<?php echo $val; ?>" name="ays_poll_all_results_columns_order[]"/>
                                                        <input type="checkbox" id="ays_show_result<?php echo $val; ?>" value="<?php echo $val; ?>" class="ays-checkbox-input" name="ays_poll_all_results_columns[<?php echo $val; ?>]" <?php echo $checked; ?>/>
                                                        <label for="ays_show_result<?php echo $val; ?>">
                                                            <?php echo $default_all_results_column_names_label; ?>
                                                        </label>
                                                    </li>
                                                    <?php
                                                }
                                             ?>
                                        </ul>
                                   </div>
                                </div>
                            </div>
                        </fieldset>
                        <!-- Show all result end -->
                        <hr>                       
                        <fieldset>
                            <legend>
                                    <strong style="font-size:30px;">[ ]</strong>
                                    <h5 class="ays-subtitle"><?php echo __('Frontend Statistics',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_poll_frontend_statictics">
                                        <?php echo __("Shortcode", "poll-maker"); ?>
                                    </label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" name="ays_poll_shortcodes_recent_by_id" id="ays_poll_frontend_statictics" onclick="this.setSelectionRange(0, this.value.length)"readonly="" class="ays-text-input" value='[ays_poll_frontend_statistics id="Your_Poll_ID"]'>
                                </div>
                            </div>
                            <blockquote>
                                <ul class="ays-poll-general-settings-blockquote-ul">
                                    <li>
                                        <?php echo __("Copy and paste this shortcode into any post or page, and insert the Poll ID, which statistics you want to display.", "poll-maker"); ?>
                                    </li>
                                </ul>
                            </blockquote>
                        </fieldset>
                        <!-- Shortcode for Frontend Statistics -->
                        <hr>
                        <fieldset>
                            <legend>
                                    <strong style="font-size:30px;">[ ]</strong>
                                    <h5 class="ays-subtitle"><?php echo __('User Activity Per Day',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_poll_user_activity_per_day">
                                        <?php echo __("Shortcode", "poll-maker"); ?>
                                    </label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" name="ays_poll_user_activity_per_day" id="ays_poll_user_activity_per_day" onclick="this.setSelectionRange(0, this.value.length)"readonly="" class="ays-text-input" value='[ays_poll_user_activity_per_day]'>
                                </div>
                            </div>
                            <blockquote>
                                <ul class="ays-poll-general-settings-blockquote-ul">
                                    <li>
                                        <?php echo __("Copy the shortcode and insert it into any post. It will show all the activity of the user per day.", "poll-maker"); ?>
                                    </li>
                                </ul>
                            </blockquote>
                        </fieldset>
                        <!-- Shortcode for User Activity Per Day -->
                        <hr>                                             
                        <fieldset>
                            <legend>
                                    <strong style="font-size:30px;">[ ]</strong>
                                    <h5 class="ays-subtitle"><?php echo __('Poll Activity Per Day',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_poll_poll_activity_per_day">
                                        <?php echo __("Shortcode", "poll-maker"); ?>
                                    </label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" name="ays_poll_shortcodes_recent_by_id" id="ays_poll_poll_activity_per_day" onclick="this.setSelectionRange(0, this.value.length)"readonly="" class="ays-text-input" value='[ays_poll_activity_per_day id="Your_Poll_ID"]'>
                                </div>
                            </div>
                            <blockquote>
                                <ul class="ays-poll-general-settings-blockquote-ul">
                                    <li>
                                         <?php echo __("Copy the shortcode and insert it into any post. It shows the level
                                          of engagement for a particular poll by quantifying the number of times all participants
                                          take the poll daily. It displays the progress in the form of a chart. Put the corresponding poll ID instead of Your_Poll_ID part.", "poll-maker"); ?>
                                    </li>
                                </ul>
                            </blockquote>
                        </fieldset>
                        <hr>
                        <fieldset>
                            <legend>
                                    <strong style="font-size:30px;">[ ]</strong>
                                    <h5 class="ays-subtitle"><?php echo __('Most Popular Poll',"poll-maker")?></h5>
                            </legend>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_poll_most_popular">
                                        <?php echo __( "Shortcode", "poll-maker" ); ?>
                                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Designed to show the most popular poll that is passed most commonly by users.',"poll-maker"); ?>">
                                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                        </a>
                                    </label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" name="ays_poll_shortcodes_recent_by_id" id="ays_poll_most_popular" onclick="this.setSelectionRange(0, this.value.length)"readonly="" class="ays-text-input" value='[ays_poll_most_popular count="1"]'>
                                </div>
                            </div>
                            <!-- <blockquote>
                                <ul class="ays-poll-general-settings-blockquote-ul">
                                    <li>
                                         <?php //echo __("Copy and paste this shortcode into any post or page, and insert the Poll ID, which statistics you want to display.", "poll-maker"); ?>
                                    </li>
                                </ul>
                            </blockquote> -->
                        </fieldset>    
                        <!-- Shortcode for Most Popular Quiz Showing -->
                    </div>
                    <div id="tab4" class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab4') ? 'ays-poll-tab-content-active' : ''; ?>">
                    <p class="ays-subtitle"><?php echo __('Extra Shortcodes', "poll-maker") ?></p>
                        <hr/>
                        <fieldset>
                            <legend>
                                <strong style="font-size:30px;">[ ]</strong>
                                <h5><?php echo __('Extra shortcodes',"poll-maker"); ?></h5>
                            </legend>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_quiz_passed_users_count">
                                                <?php echo __( "Passed users count", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Copy the following shortcode and paste it in posts. Insert the Poll ID to receive the number of participants of the poll.',"poll-maker"); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_quiz_passed_users_count" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_passed_users_count id="Your_Poll_ID"]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_first_name">
                                                <?php echo __( "Show User First Name", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("Shows the logged-in user's First Name. If the user is not logged-in, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_first_name" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_first_name]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_last_name">
                                                <?php echo __( "Show User Last Name", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("Shows the logged-in user's Last Name. If the user is not logged-in, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_last_name" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_last_name]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_nick_name">
                                                <?php echo __( "Show User Nick Name", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("Shows the logged-in user's Nick Name. If the user is not logged-in, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_nick_name" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_nick_name]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_display_name">
                                                <?php echo __( "Show User Display name", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("Shows the logged-in user's Display name. If the user is not logged-in, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_display_name" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_display_name]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_email">
                                                <?php echo __( "Show User Email", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("Shows the logged-in user's Email. If the user is not logged-in, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_email" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_email]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_email">
                                                <?php echo __( "Show poll creation date", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("You need to insert Your Poll ID in the shortcode. It will show the creation date of the particular poll. If there is no poll available/found with that particular Poll ID, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_email" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_creation_date id="Your_Poll_ID"]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_passed_polls_count">
                                                <?php echo __( "Passed polls count per user", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("Shows the number of passed polls of the current user. For instance, the current user has passed 20 polls. If the user is not logged in shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_passed_polls_count" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_passed_polls_count]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_user_all_passed_polls_count">
                                                <?php echo __( "All passed polls count per user", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("Shows the total sum of how many times the particular user has passed all the polls. For instance, the current user has passed 20 polls 500 times in total. If the user is not logged in shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_user_all_passed_polls_count" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_user_all_passed_polls_count]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_category_description">
                                                <?php echo __( "Show poll categories descriptions", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("You need to insert Your Poll ID in the shortcode. It will show categories descriptions of the particular poll. If there is no poll available/found with that particular Poll ID, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_categories_descriptions" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_categories_descriptions id="Your_POLL_ID"]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_category_title">
                                                <?php echo __( "Show poll categories titles", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("You need to insert Your Poll ID in the shortcode. It will show categories titles of the particular poll. If there is no poll available/found with that particular Poll ID, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_categories_titles" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_categories_titles id="Your_POLL_ID"]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_current_author">
                                                <?php echo __( "Show current poll author", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("You need to insert Your Poll ID in the shortcode. It will show the current author of the particular poll. If there is no poll or questions available/found with that particular Poll ID, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_current_author" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_current_author id="Your_POLL_ID"]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="form-group row" style="padding:0px;margin:0;">
                                <div class="col-sm-12" style="padding:20px;">
                                    <div class="form-group row">
                                        <div class="col-sm-4">
                                            <label for="ays_poll_answers_count">
                                                <?php echo __( "Show poll answers count", "poll-maker" ); ?>
                                                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr( __("You need to insert Your Poll ID in the shortcode. It will show the total count of answers in particular poll. If there is no poll available/found with that particular Poll ID, the shortcode will be empty.","poll-maker") ); ?>">
                                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                                </a>
                                            </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <input type="text" id="ays_poll_answers_count" class="ays-text-input" onclick="this.setSelectionRange(0, this.value.length)" readonly="" value='[ays_poll_answers_count id="Your_POLL_ID"]'>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset> <!-- Extra shortcodes -->
                    </div>
                    <div id="tab5" class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab5') ? 'ays-poll-tab-content-active' : ''; ?>">
                        <p class="ays-subtitle">
                            <?php echo __('Fields placeholders',"poll-maker")?>
                            <a class="ays_help" data-toggle="tooltip" data-html="true" title="<p style='margin-bottom:3px;'><?php echo __( 'If you make a change here, these words will not be translated either.', "poll-maker" ); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </p>
                        <blockquote>
                            <p>
                                <?php echo __( "With the help of this section, you can change the fields' placeholders of the Information form. Find the available fields in the User data tab of your polls.", "poll-maker" ); ?>
                                <span class="ays-poll-blockquote-span"><?php echo __( "Note: If you make a change here, these words will not be translated either.", "poll-maker" ); ?></span>
                            </p>

                        </blockquote>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-2"></div>
                            <div class="col-sm-3">
                                <span class="ays_poll_title_fields_placeholders"><?php echo __( "Placeholders", "poll-maker" ); ?></span>
                            </div>
                            <div class="col-sm-7">
                                <span class="ays_poll_title_fields_placeholders"><?php echo __( "Labels", "poll-maker" ); ?></span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-2">
                                <label for="ays_poll_fields_placeholder_name">
                                    <?php echo __( "Name", "poll-maker" ); ?>
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input type="text" id="ays_poll_fields_placeholder_name" name="ays_poll_fields_placeholder_name" class="ays-text-input ays-text-input-short"  value='<?php echo $poll_fields_placeholder_name; ?>'>
                                <span class="ays_poll_small_hint_text ays_poll_small_hint_fields_placeholders">Placeholder</span>
                            </div>
                            <div class="col-sm-7">
                                <input type="text" id="ays_poll_fields_label_name" name="ays_poll_fields_label_name" class="ays-text-input ays-text-input-short"  value='<?php echo $poll_fields_label_name; ?>'>
                                <span class="ays_poll_small_hint_text ays_poll_small_hint_fields_placeholders">Label</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-2">
                                <label for="ays_poll_fields_placeholder_email">
                                    <?php echo __( "Email", "poll-maker" ); ?>
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input type="text" id="ays_poll_fields_placeholder_email" name="ays_poll_fields_placeholder_email" class="ays-text-input ays-text-input-short"  value='<?php echo $poll_fields_placeholder_email; ?>'>
                                <span class="ays_poll_small_hint_text ays_poll_small_hint_fields_placeholders">Placeholder</span>
                            </div>
                            <div class="col-sm-7">
                                <input type="text" id="ays_poll_fields_label_email" name="ays_poll_fields_label_email" class="ays-text-input ays-text-input-short"  value='<?php echo $poll_fields_label_email; ?>'>
                                <span class="ays_poll_small_hint_text ays_poll_small_hint_fields_placeholders">Label</span>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-2">
                                <label for="ays_poll_fields_placeholder_phone">
                                    <?php echo __( "Phone", "poll-maker" ); ?>
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input type="text" id="ays_poll_fields_placeholder_phone" name="ays_poll_fields_placeholder_phone" class="ays-text-input ays-text-input-short"  value='<?php echo $poll_fields_placeholder_phone; ?>'>
                                <span class="ays_poll_small_hint_text ays_poll_small_hint_fields_placeholders">Placeholder</span>
                            </div>
                            <div class="col-sm-7">
                                <input type="text" id="ays_poll_fields_label_phone" name="ays_poll_fields_label_phone" class="ays-text-input ays-text-input-short"  value='<?php echo $poll_fields_label_phone; ?>'>
                                <span class="ays_poll_small_hint_text ays_poll_small_hint_fields_placeholders">Label</span>
                            </div>
                        </div>
                    </div>
                    <div id="tab6" class="ays-poll-tab-content <?php echo ($ays_poll_tab == 'tab6') ? 'ays-poll-tab-content-active' : ''; ?>">
                        <p class="ays-subtitle">
                            <?php echo __('Message variables',"poll-maker")?>
                            <a class="ays_help" data-toggle="tooltip" data-html="true" title="<p><?php echo __( 'You can copy these variables and paste them in the following options from the poll settings', "poll-maker" ); ?>:</p>
                                <ul class='ays_tooltop_ul'>
                                    <li><?php echo __( 'Result Message', "poll-maker" ); ?></li>
                                    <li><?php echo __( 'Hide results', "poll-maker" ); ?></li>
                                    <li><?php echo __( 'Send Mail to User', "poll-maker" ); ?></li>
                                </ul>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </p>
                        <blockquote>
                            <p><?php echo __( "You can copy these variables and paste them in the following options from the poll settings", "poll-maker" ); ?>:</p>
                            <p style="text-indent:10px;margin:0;">- <?php echo __( "Result Message", "poll-maker" ); ?></p>
                            <p style="text-indent:10px;margin:0;">- <?php echo __( "Hide results", "poll-maker" ); ?></p>
                            <p style="text-indent:10px;margin:0;">- <?php echo __( "Send Mail to User", "poll-maker" ); ?></p>
                        </blockquote>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-12">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_name%%"  class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays-poll-message-variables-text-divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The name the user entered into information form", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_email%%"  class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays-poll-message-variables-text-divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The E-mail the user entered into information form", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">                                
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_phone%%"  class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays-poll-message-variables-text-divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The phone the user entered into information form", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%poll_title%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The title of the poll", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%users_first_name%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's first name that was filled in their WordPress site during registration.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%users_last_name%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's last name that was filled in their WordPress site during registration.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%creation_date%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The creation date of the poll.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%current_date%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays-poll-message-variables-text-divider"> - </span>
                                    <span class="ays-poll-message-variables-hint-text">
                                        <?php echo __( "The date of the submission poll.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_email%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's email that was filled either in the Information Form or in their WordPress site during registration.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_answer%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The answer given by the user while passing the poll.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%current_poll_author%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "It will show the author of the current poll.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_wordpress_roles%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's role(s) when logged-in. In case the user is not logged-in, the field will be empty.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_wordpress_email%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's email that was filled in their WordPress profile.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_display_name%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's display name that was filled in their WordPress profile.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_nickname%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's nickname that was filled in their WordPress profile.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%poll_pass_count%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The poll's pass count.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%passed_poll_count_per_user%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "Passed polls count per user.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%current_poll_page_link%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "Prints the webpage link where the current poll is posted.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays-poll-message-variables-text-divider-for-mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_wordpress_website%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays-poll-message-variables-text-divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's website that was filled in their WordPress profile.", "poll-maker"); ?>
                                    </span>
                                </p>
                                <hr class="ays_poll_message_variables_text_divider_for_mobile">
                                <p class="vmessage">
                                    <strong>
                                        <input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="%%user_ip_address%%" class='ays-poll-message-variables-inputs'/>
                                    </strong>
                                    <span class="ays_poll_message_variables_text_divider"> - </span>
                                    <span class="ays_poll_message_variables_hint_text">
                                        <?php echo __( "The user's IP address.", "poll-maker"); ?>
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr/>
			<?php
			wp_nonce_field('settings_action', 'settings_action');
			$other_attributes = array(
                'id' => 'ays_submit',
                'title' => 'Ctrl + s',
                'data-toggle' => 'tooltip',
                'data-delay'=> '{"show":"1000"}'
            );
			submit_button(__('Save changes', "poll-maker"), 'primary ays-button ays-apply-all', 'ays_submit', true, $other_attributes);
			?>
        </form>
    </div>
</div>