(function ($) {
    'use strict';
    $(document).ready(function(){ 
		function forFrontendStat( Data, ID ) {
            var votes = Data['votes'];
            var unique = [];
            var dataTypes = [];
            var count = 0;
            for(var i in votes){
                dataTypes[count] = [];
                dataTypes[count].push(new Date([i]));
                for(var j in votes[i]){
                    if (!unique.includes(j)) {
                        unique.push(j);
                    }
                    dataTypes[count].push(votes[i][j]);
                }
                count++;
            }	
            
            google.charts.load('current', {'packages':['corechart']});
            google.charts.setOnLoadCallback(drawChart);

            function drawChart() {
                var data = new google.visualization.DataTable();

                data.addColumn('date', 'Days');
                for (var index = 0; index < unique.length; index++) {
                    data.addColumn('number', unique[index]);
                }
                data.addRows(dataTypes);

                var options = {
                    // title: 'Company Performance',
                    curveType: 'function',
                    legend: { position: 'bottom' }
                };

                var chart = new google.visualization.LineChart(document.getElementById(ID));

                chart.draw(data, options);
            }
        }

        function forOverlAllStat( overAllData, ID ) {
            var votes = overAllData.votes;
            var chartData = [];
            for(var i in votes){
                chartData.push([i, votes[i]]);
            }

            google.charts.load('current', {'packages':['bar']});
            google.charts.setOnLoadCallback(drawChart);

            function drawChart() {
                var data = new google.visualization.DataTable();
                data.addColumn('string', 'Answers');
                data.addColumn('number', 'Count');
                
                data.addRows(chartData);
                var options = {
                    chart: {
                        // title: 'Company Performance',
                        // subtitle: 'Sales, Expenses, and Profit: 2014-2017',
                    }
                };

                var chart = new google.charts.Bar(document.getElementById(ID));

                chart.draw(data, google.charts.Bar.convertOptions(options));
            }
        }
        
        if($(document).find('div[id^="ays_poll_fs_tab_content_"] a.ays-poll-frontend-statistics-tabs').parents('.ays-poll-frontend-statistics-container').length > 0){
            var uniqueId = $(document).find('div[id^="ays_poll_fs_tab_content_"] a.ays-poll-frontend-statistics-tabs').parents('.ays-poll-frontend-statistics-container').data('unique');
            var aysPollFrontendStatistics = JSON.parse( atob( window.aysPollFrontendStatistics[ uniqueId ] ) );
            var contentID = 'ays_poll_fs_daily_chart_content_'+aysPollFrontendStatistics.id;

            if(aysPollFrontendStatistics.result != ''){
                forFrontendStat( aysPollFrontendStatistics.result, contentID );
            }else{
                $(document).find('#'+contentID+'>p').remove();
                $(document).find('#'+contentID).append('<p>'+aysPollFrontendStatisticsChart.emptyResult+'</p>');
            }
        }

        $(document).find('div[id^="ays_poll_fs_tab_content_"] a.ays-poll-frontend-statistics-tabs').on('click', function (e) {
            var $_this = $(this);
            if(! $(this).hasClass('no-js')){
                var elemenetID = $(this).attr('href');
                $(document).find('div[id^="ays_poll_fs_tab_content_"] a.ays-poll-frontend-statistics-tabs').each(function () {
                    if ($(this).hasClass('active')) {
                        $(this).removeClass('active');
                    }
                });

                $(this).addClass('active');
                var chartContentWrap = $(this).parents('.ays-poll-frontend-statistics-container').find('.ays-poll-frontend-statistics-chart-content-wrap');
                var chartContent = chartContentWrap.find('.ays-poll-frontend-statistics-content');
                chartContent.each(function () {
                    $(this).css('display', 'none');
                });
    
                $('.ays-poll-frontend-statistics-content-' + elemenetID).css('display', 'block');                
                e.preventDefault();
            }              

            var pollID = $(this).parents('.ays-poll-frontend-statistics-container').data('id');

            var contentID = 'ays_poll_fs_daily_chart_content_'+pollID;

            var tab = $_this.data('time');

            var data = {
                action: 'ays_poll_fs_draw_chart',
                poll_id: pollID,
                tab: tab,
            };
            $.ajax({
                url: aysPollFrontendStatisticsChart.ajax_url,
                dataType: 'json',
                method: "post",
                data: data,
                success: function(response) {
                    if(response.status){
                        switch (tab) {
                            case 'weekly':
                                contentID = 'ays_poll_fs_weekly_chart_content_'+pollID;
                                forFrontendStat( response.result, contentID );
                                break;
                            case 'monthly':
                                contentID = 'ays_poll_fs_monthly_chart_content_'+pollID;
                                forFrontendStat( response.result, contentID );
                                break;
                            case 'overall':
                                contentID = 'ays_poll_fs_overall_chart_content_'+pollID;
                                forOverlAllStat( response.result, contentID );
                                break;
                            case 'daily':
                                contentID = 'ays_poll_fs_daily_chart_content_'+pollID;
                                forFrontendStat( response.result, contentID );
                                break;
                            default: 
                                contentID = 'ays_poll_fs_daily_chart_content_'+pollID;
                                forFrontendStat( response.result, contentID );
                                break;
                        }
                    }else{
                        chartContentWrap.find('p').remove();
                        chartContentWrap.append('<p>'+response.result+'</p>');
                    }
                }
            });
        });        
    });
})(jQuery);