(function($){
    'use strict';
    $(document).ready(function(){

        // ===============================================================
        // ========================= Prefixes ============================
        // ===============================================================

        var $name_prefix       = 'ays_poll_';
        var $html_class_prefix = '.ays-poll-user-activity-per-day-';
        var $html_id_prefix    = '#ays-poll-user-activity-';

        // ===============================================================
        // ========================= Prefixes ============================
        // ===============================================================

        if (typeof google != undefined) {
            google.charts.load('current', {packages: ['corechart']});
            google.charts.setOnLoadCallback(initAnalyticsCharts);
        }

        $(document).find( $html_class_prefix + 'container' ).hover( function(e){
            var _this  = $(this);

            var circle = _this.find('svg circle');
            if (circle.length == 1) {
                circle.attr('r',5);
                circle.attr('fill-opacity',1);
            }

        }, function(e) {
            var _this  = $(this);

            var circle = _this.find('svg circle');
            if (circle.length == 1) {
                circle.attr('r',5);
                circle.attr('fill-opacity',1);
            }
        });
        
        function initAnalyticsCharts() {

            var pollUserActivityPerDayConainter = $(document).find( $html_class_prefix + 'container');

            pollUserActivityPerDayConainter.each( function( e, i ) {
                var _this = $(this);

                var uniqueId = _this.attr( 'data-id' );

                var thisAysPollUserActivityChartData = JSON.parse( atob( window.aysPollUserActivityPerDayData[ uniqueId ] ) );

                var divId    = $html_id_prefix + 'per-day-chart-' + uniqueId;
                var divClass = $html_class_prefix + 'box';

                var chartDivId     = _this.find( divId );
                var chartDivIdAttr = _this.find( divClass ).attr('id');

                //Reports count per day
                var perData = thisAysPollUserActivityChartData;

                var data = new google.visualization.DataTable();

                data.addColumn('date', 'Date');
                data.addColumn('number','Count');

                for (var l = 0; l < perData.length; l++) {
                    perData[l] = new Array(
                        new Date(
                            perData[l][0]
                        ),
                        perData[l][1]
                    );
                }

                data.addRows(perData);

                var populationRange = data.getColumnRange(1);

                var logOptions = {
                    height: 400,
                    fontSize: 14,
                    interpolateNulls: true,
                    hAxis: {
                        title: 'Date',
                        format: 'MMM d Y',
                        gridlines: {count: 15}
                    },
                    vAxis: {
                        title: 'Count'
                    },
                    viewWindow: {
                        min: thisAysPollUserActivityChartData[0],
                        max: thisAysPollUserActivityChartData[ thisAysPollUserActivityChartData.length - 1 ]
                    },
                    legend: {position: 'none'}
                };

                var logChart = new google.visualization.LineChart(document.getElementById( chartDivIdAttr ));
                logChart.draw(data, logOptions);

                if (thisAysPollUserActivityChartData.length == 1) {
                    setTimeout(function(){
                        var chartCircle = chartDivId.find( 'svg circl e' );
                        chartCircle.attr('r',5);
                        chartCircle.attr('fill-opacity',1);
                    },500);
                }
            });
        }
    });
})(jQuery);