jQuery(document).ready(function($){
    if (!$.fn.DataTable.isDataTable('#ays-poll-all-result-score-page')) {
        $.fn.dataTable.ext.type.order['customDate-pre'] = function(data) {
            if (!data) {
                return 0;
            }
            
            const parts = data.split(' ');
            if (parts.length !== 4) {
                return 0;
            }
            
            const time = parts[0].split(':');
            const month = parts[1];
            const day = parseInt(parts[2].replace(',', ''));
            const year = parseInt(parts[3]);
            
            const months = {
                'Jan': 0, 'Feb': 1, 'Mar': 2, 'Apr': 3, 'May': 4, 'Jun': 5,
                'Jul': 6, 'Aug': 7, 'Sep': 8, 'Oct': 9, 'Nov': 10, 'Dec': 11
            };
            
            const date = new Date(year, months[month], day, 
                                parseInt(time[0]), parseInt(time[1]), parseInt(time[2]));
            
            return date.getTime();
        };

        $('#ays-poll-all-result-score-page').DataTable({
            "paging": true,
            "pagingType": "full_numbers",
            "pageLength": 10,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Все"]],
            
            "ordering": true,
            "order": [[2, 'desc']], 
            
            "searching": true,
            
            "language": pollLangDataTableObj,
            
            "responsive": true,
            
            "columnDefs": [
                {
                    "targets": 2, 
                    "type": "customDate" 
                }
            ],
            
            "scrollX": true
        });
    }
});