(function($) {
    'use strict';

    function AysPollPopupsPlugin(element, options){
        this.el = element;
        this.$el = $(element);
        this.htmlClassPrefix = 'ays-poll-';
        this.ajaxAction = 'ays_poll_ajax';
        this.dbOptions = undefined;
        this.popupId = undefined;
        this.confirmBeforeUnload = false;

        this.init();

        return this;
    }

    AysPollPopupsPlugin.prototype.init = function() {
        var _this = this;

        _this.popupId = _this.$el.data('id');
        
        if( typeof window.aysPollPopupsOptions != 'undefined' ){
            _this.dbOptions = JSON.parse( atob( window.aysPollPopupsOptions[ _this.popupId ] ) );
        }
        
        _this.setEvents();
    };

    AysPollPopupsPlugin.prototype.setEvents = function(e){
        var _this = this;

        _this.popupSelectorClick( _this.$el, _this);

        _this.$el.on('click', '.' + _this.htmlClassPrefix + 'popup-btn-close', function(e){
            _this.$el.css('display', 'none');
            if (document.fullscreenElement) {
                _this.aysPollFullScreenWindowDeactivator();
            }
        });

        _this.$el.on('click', '.ays_finish_poll', function(){
            var hidePopupAfterSubmit = typeof _this.dbOptions.hidePopup != 'undefined' && _this.dbOptions.hidePopup == 'on' ? true : false;
            if( hidePopupAfterSubmit ){
                $.ajax({
                    url: aysPollMakerPopupsAjaxPublic.ajaxUrl,
                    method: 'post',
                    dataType: 'json',
                    data: {
                        action: _this.ajaxAction,
                        function: 'ays_poll_popup_set_cookie',
                        id: _this.popupId,
                    }
                });
            }
        });
        
        _this.$el.find('.ays-poll-popup-close-full-screen, .ays-poll-popup-open-full-screen').on('click', function() {
            _this.toggleFullscreen(_this.el);
        });

        _this.aysPollFullScreenDeactivateAll();

    }
    
    AysPollPopupsPlugin.prototype.toggleFullscreen = function (elem) {
        var _this = this;
        elem = elem || document.documentElement;
        if (!document.fullscreenElement && !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement) {
            _this.aysPollFullScreenActivate( elem );
            _this.aysPollFullScreenWindowActivator( elem );
        }else{
            _this.aysPollFullScreenDeactivate( elem );
            _this.aysPollFullScreenWindowDeactivator();
        }
    }

    AysPollPopupsPlugin.prototype.aysPollFullScreenActivate = function (elem) {
        $(elem).find('.ays-poll-popup-full-screen-mode .ays-poll-popup-close-full-screen').css({'display':'inline'});
        $(elem).find('.ays-poll-popup-full-screen-mode .ays-poll-popup-open-full-screen').css('display','none');
        $(elem).find('.ays-poll-popup-full-screen-mode').css({'padding-right':'25px'});
        $(elem).find('.ays-poll-popup-btn-close').css({'top':'0','right' : '0'});
        $(elem).css({'overflow':'auto'});
    }

    AysPollPopupsPlugin.prototype.aysPollFullScreenDeactivate = function (elem) {
        $(elem).find('.ays-poll-popup-full-screen-mode .ays-poll-popup-open-full-screen').css({'display':'inline'});
        $(elem).find('.ays-poll-popup-full-screen-mode .ays-poll-popup-close-full-screen').css('display','none');        
        $(elem).find('.ays-poll-popup-full-screen-mode').css({'padding-right':'0'});
        $(elem).find('.ays-poll-popup-btn-close').css({'top':'-16px','right' : '-16px'});
        $(elem).css({'overflow':'initial'});
    }

    AysPollPopupsPlugin.prototype.aysPollFullScreenDeactivateAll = function (elem) {
        var _this = this;
        document.addEventListener('fullscreenchange', function(event) {
            if (!document.fullscreenElement) {
                var eventTarget = event.target;
                if( $( eventTarget ).hasClass('ays-poll-popup-poll-window') ){
                    _this.aysPollFullScreenDeactivate( eventTarget );
                }
            }
        }, false);
    }

    AysPollPopupsPlugin.prototype.aysPollFullScreenWindowActivator = function (elem) {
        if (elem.requestFullscreen) {
            elem.requestFullscreen();
        }else if (elem.msRequestFullscreen) {
            elem.msRequestFullscreen();
        }else if (elem.mozRequestFullScreen) {
            elem.mozRequestFullScreen();
        }else if (elem.webkitRequestFullscreen) {
            elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
        }
    }

    AysPollPopupsPlugin.prototype.aysPollFullScreenWindowDeactivator = function () {
        if(document.exitFullscreen) {
            document.exitFullscreen();
        }else if (document.msExitFullscreen) {
            document.msExitFullscreen();
        }else if (document.mozCancelFullScreen) {
            document.mozCancelFullScreen();
        }else if (document.webkitExitFullscreen) {
            document.webkitExitFullscreen();
        }
    }

    AysPollPopupsPlugin.prototype.popupSelectorClick = function (elem, _this) {
        var popupTriggerType = _this.dbOptions.popup_trigger;
        var popupSelector = _this.dbOptions.popup_selector;

        if(popupTriggerType == 'on_click'){

            $(document).find(popupSelector).on('click', function(){

                elem.css('display','block');
                
            });
        }else if(popupTriggerType == 'on_exit'){ 
            $(document).one("mouseleave", function(event){  
                if (event.clientY <= 0 || event.clientX <= 0 || (event.clientX >= window.innerWidth || event.clientY >= window.innerHeight)) {  
                    elem.css('display','block');
                } 
            });
        }
    }

    
    /**
     * @return {string}
     */
    AysPollPopupsPlugin.prototype.GetFullDateTime = function() {
        var now = new Date();
        var strDateTime = [[now.getFullYear(), AddZero(now.getMonth() + 1), AddZero(now.getDate())].join("-"), [AddZero(now.getHours()), AddZero(now.getMinutes()), AddZero(now.getSeconds())].join(":")].join(" ");
        return strDateTime;
    }

    /**
     * @return {string}
     */
    AysPollPopupsPlugin.prototype.AddZero = function (num) {
        return (num >= 0 && num < 10) ? "0" + num : num + "";
    }

    /**
     * @return {string}
     */
    function AddZero(num) {
        return (num >= 0 && num < 10) ? "0" + num : num + "";
    }

    $.fn.AysPollMakerPopups = function(options) {
        return this.each(function() {
            if (!$.data(this, 'AysPollMakerPopups')) {
                $.data(this, 'AysPollMakerPopups', new AysPollPopupsPlugin(this, options));
            } else {
                try {
                    $(this).data('AysPollMakerPopups').init();
                } catch (err) {
                    console.error('AysPollMakerPopups has not initiated properly');
                }
            }
        });
    };
    
    $(document).find('.ays-poll-popup-poll-window').AysPollMakerPopups();
})(jQuery);
