<?php
    class Poll_Maker_Frontent_Statistics{
        /**
         * The ID of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string $plugin_name The ID of this plugin.
         */
        protected $plugin_name;

        /**
         * The version of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string $version The current version of this plugin.
         */
        private $version;

        private $html_class_prefix = 'ays-poll-frontend-statistics-';
        private $html_name_prefix = 'ays-poll-';
        private $name_prefix = 'ays_poll_';
        private $unique_id;
        private $unique_id_in_class;

        /**
         * Initialize the class and set its properties.
         *
         * @since    1.0.0
         * @param      string $plugin_name The name of the plugin.
         * @param      string $version The version of this plugin.
         */
        public function __construct($plugin_name, $version){

            $this->plugin_name = $plugin_name;
            $this->version = $version;

            add_shortcode('ays_poll_frontend_statistics', array($this, 'ays_generate_frontend_statistics'));
        }

            /**
         * Register the stylesheets for the public-facing side of the site.
         *
         * @since    1.0.0
         */
	    public function enqueue_styles() {

            /**
             * This function is provided for demonstration purposes only.
             *
             * An instance of this class should be passed to the run() function
             * defined in Poll_Maker_Ays_Loader as all of the hooks are defined
             * in that particular class.
             *
             * The Poll_Maker_Ays_Loader will then create the relationship
             * between the defined hooks and the functions defined in this
             * class.
             */
            wp_enqueue_style( $this->plugin_name. '-frontend-statistics', POLL_MAKER_AYS_PUBLIC_URL . '/css/partials/poll-maker-ays-frontend-statistics.css', array(), $this->version, 'all');
	    }

        /**
         * Register the JavaScript for the public-facing side of the site.
         *
         * @since    1.0.0
         */
	    public function enqueue_scripts() {

            /**
             * This function is provided for demonstration purposes only.
             *
             * An instance of this class should be passed to the run() function
             * defined in Poll_Maker_Ays_Loader as all of the hooks are defined
             * in that particular class.
             *
             * The Poll_Maker_Ays_Loader will then create the relationship
             * between the defined hooks and the functions defined in this
             * class.
             */
            wp_enqueue_script(  $this->plugin_name . '-frontend-statistics', POLL_MAKER_AYS_PUBLIC_URL . '/js/partials/poll-maker-ays-frontend-statistics.js', array('jquery'), $this->version, true);
            wp_enqueue_script( $this->plugin_name . '-charts-google', POLL_MAKER_AYS_ADMIN_URL . '/js/google-chart.js', array('jquery'), $this->version, true);
            wp_localize_script( $this->plugin_name . '-frontend-statistics', 'aysPollFrontendStatisticsChart', array(
                'ajax_url' => admin_url('admin-ajax.php'),
                'emptyResult' =>  __('There is no result yet.', "poll-maker"),
                'answers'  => __('admin-ajax.php', "poll-maker"),
                'percent' => __('admin-ajax.php', "poll-maker"),
            ) );
            
	    }

        public function ays_generate_frontend_statistics( $attr ){
            $this->enqueue_styles();
            $this->enqueue_scripts();
                
            $id = ( isset( $attr['id'] ) && $attr['id'] != "" ) ? absint( $attr['id'] ) : '';

            $unique_id = uniqid();
            $this->unique_id = $unique_id;
            $this->unique_id_in_class = $unique_id;

            $frontend_statistics_html = "";
            if($id != null){
                $frontend_statistics_html = $this->ays_generate_frontend_statistics_html( $id );
            }
            return str_replace(array("\r\n", "\n", "\r"), "\n", $frontend_statistics_html);
        }

        public function ays_generate_frontend_statistics_html( $id ){
            $content = array();
            if($id != null){

                $collected_data = $this->ays_poll_fs_collected_data($id, $tab = 'daily');
                
                if(!empty($collected_data)){
                    $data = array(
                        'id' => $id,
                        'result' => $collected_data,
                    );
                }else{
                    $data = array(
                        'id' => $id,
                        'result' => '',
                    );
                }
                $script = '<script type="text/javascript">';
                    $script .= "
                        if(typeof aysPollFrontendStatistics === 'undefined'){
                            var aysPollFrontendStatistics = [];
                        }
                        aysPollFrontendStatistics['" . $this->unique_id . "']  = '" . base64_encode( json_encode( $data ) ) . "';";
                $script .= '</script>';
    
                $content[] = '<div class="'.$this->html_class_prefix.'container" id="ays_poll_fs_'.$this->unique_id.'" data-unique="'.$this->unique_id.'" data-id="'.$id.'">';
    
                    // Tab Content
                    $content[] = '<div class="'.$this->html_class_prefix.'tab-content" id="ays_poll_fs_tab_content_'.$id.'">';
                        $content[] = '<a class="'.$this->html_class_prefix.'tabs active" data-tab="tab1" data-time="daily" href="tab1" >';
                            $content[] =  __( 'Daily', "poll-maker" );     
                        $content[] = '</a>';
                        $content[] = '<a class="'.$this->html_class_prefix.'tabs" data-tab="tab2" data-time="weekly"  href="tab2">';
                            $content[] =  __( 'Weekly', "poll-maker" );
                        $content[] = '</a>';
                        $content[] = '<a class="'.$this->html_class_prefix.'tabs" data-tab="tab3" data-time="monthly"  href="tab3">';
                            $content[] =  __( 'Monthly', "poll-maker" );
                        $content[] = '</a>';
                        $content[] = '<a class="'.$this->html_class_prefix.'tabs" data-tab="tab4" data-time="overall"  href="tab4">';
                            $content[] =  __( 'Overall', "poll-maker" );
                        $content[] ='</a>';
                    $content[] ='</div>';
    
                    // Chart Content
                    $content[] ='<div class="'.$this->html_class_prefix.'chart-content-wrap" id="ays_poll_fs_chart_content_wrap_'.$id.'">';
                        $content[] ='<div class="'.$this->html_class_prefix.'content '.$this->html_class_prefix.'content-tab1" id="ays_poll_fs_daily_chart_content_'.$id.'">';
                            
                        $content[] ='</div>';
                        $content[] ='<div class="'.$this->html_class_prefix.'content '.$this->html_class_prefix.'content-tab2" id="ays_poll_fs_weekly_chart_content_'.$id.'">';
                            
                        $content[] ='</div>';
                        $content[] ='<div class="'.$this->html_class_prefix.'content '.$this->html_class_prefix.'content-tab3" id="ays_poll_fs_monthly_chart_content_'.$id.'">';
                            
                        $content[] ='</div>';
                        $content[] ='<div class="'.$this->html_class_prefix.'content '.$this->html_class_prefix.'content-tab4" id="ays_poll_fs_overall_chart_content_'.$id.'">';
                             
                        $content[] ='</div>';
                    $content[] ='</div>';
                $content[] = '</div>';
    
                $content[] = $script;
    
                $content = implode('', $content);
            }

            return $content;
        }

        public function ays_poll_fs_draw_chart(){
            if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'ays_poll_fs_draw_chart') {
                $id = (isset($_REQUEST['poll_id']) && $_REQUEST['poll_id'] != null) ? absint(intval($_REQUEST['poll_id'])) : null;
                $tab = (isset($_REQUEST['tab']) && $_REQUEST['tab'] != '') ? sanitize_text_field($_REQUEST['tab']) : 'daily';
                if ($id == null) {
                    $result = array(
                        'status' => false,
                        'result' => '',
                    );
                    ob_end_clean();
                    $ob_get_clean = ob_get_clean();
                    echo json_encode($result);
                    wp_die();
                }
                $collected_data = $this->ays_poll_fs_collected_data($id, $tab);

                if(empty($collected_data)){
                    $result = array(
                        'status' => false,
                        'result' => __('There is no result yet', "poll-maker"),
                    );
                }else{
                    $result = array(
                        'status' => true,
                        'result' => $collected_data,
                    );
                }

                ob_end_clean();
                $ob_get_clean = ob_get_clean();
                echo json_encode($result);
                wp_die();
            }
        }

        public function ays_poll_fs_get_data( $id, $tab ){
            global $wpdb;

            $reports_table  = $wpdb->prefix."ayspoll_reports";
            $answers_table  = $wpdb->prefix."ayspoll_answers";
            $polls_table  = $wpdb->prefix."ayspoll_polls";

            $results = '';

            if($id != null){
                $sql = "";
                $date = "";
                $where = "";
                switch ($tab) {
                    case 'daily':
                        $date = "DATE(r.`vote_date`)";
                        $where = "AND DATE(r.`vote_date`) >= (DATE(NOW()) - INTERVAL 10 DAY)";
                        break;
                    case 'weekly':
                        $date = "str_to_date(CONCAT(YEARWEEK(r.`vote_date`), 'monday'), '%X%V %W')";
                        $where = "AND DATE(r.`vote_date`) >= (DATE(NOW()) - INTERVAL 70 DAY)";
                        break;
                    case 'monthly':
                        $date = "DATE_FORMAT(r.`vote_date`, '%Y-%m')";
                        $where = "AND DATE(r.`vote_date`) >= (DATE(NOW()) - INTERVAL 10 MONTH)";
                        break;
                    case 'overall':
                        $date = "DATE_FORMAT(r.`vote_date`, '%Y-%m-%d')";
                        $where = "";
                        break;
                    default:
                        $date = "DATE(r.`vote_date`)";
                        $where = "AND DATE(r.`vote_date`) >= (DATE(NOW()) - INTERVAL 10 DAY)";
                        break;
                }

                $sql .= "SELECT {$date} AS 'date',
                            COUNT(r.`id`) AS 'vote_count',
                            a.`answer`, r.`answer_value`, p.`type`
                            FROM {$reports_table} AS r
                            LEFT JOIN {$answers_table} AS a
                            ON r.`answer_id` = a.`id`
                            LEFT JOIN {$polls_table} AS p
                            ON p.`id` = r.`poll_id`
                            WHERE r.`poll_id` = {$id}
                            {$where}
                            GROUP BY r.`answer_id`,r.`vote_date`";
                $results = $wpdb->get_results($sql, 'ARRAY_A');
            }

            return $results;
        }

        public function get_poll_answers( $id ){
            global $wpdb;
            $answers_table = $wpdb->prefix."ayspoll_answers";
            
            $ans_sql = "SELECT `answer` FROM {$answers_table} WHERE poll_id =".$id;
            $ans_results = $wpdb->get_results( $ans_sql, 'ARRAY_A' );
            
            $poll_answers = (isset($ans_results) && !empty($ans_results)) ? $ans_results : array();

            return $poll_answers;
        }
        
        public function get_date_interval( $tab ){

            $days = array();
            switch ($tab) {
                case 'daily':
                    $m  = date("m");
                    $de = date("d");
                    $y  = date("Y");

                    for($i=0; $i <= 10; $i++){
                        $days[] = date('F d, Y', mktime(0,0,0,$m,($de-$i),$y)); 
                    }
                    break;
                case 'weekly':
                    $nextMonday = new DateTime(date('F-m-d') . ' previous Monday');
                    $lastMonday = $nextMonday->format('F d, Y');

                    $days[] = $lastMonday;
                    for ($i=1 ; $i <= 9; ++ $i) {
                        $nextMonday->sub(new DateInterval('P7D'));
                        $days[] = $nextMonday->format('F d, Y');
                    }
                    break;
                case 'monthly':
                    for ($i = 1; $i <= 10; $i++) {
                        $days[] = date("F d, Y", strtotime( date( 'Y-m-01' )." -$i months"));
                    }
                    break;
                default:
                    $m  = date("m");
                    $de = date("d");
                    $y  = date("Y");

                    for($i=0; $i<=10; $i++){
                        $days[] = date('F d, Y',mktime(0,0,0,$m,($de-$i),$y)); 
                    }
                    break;
            }
            return $days;
        }

        //All Collected Data
        public function ays_poll_fs_collected_data( $id, $tab = 'daily' ){
            if($id == null){
                $results = array();
            }else{
                //Get Data
                $statistics    = $this->ays_poll_fs_get_data( $id, $tab );
                $poll_answers  = $this->get_poll_answers( $id );
                $date_interval = $this->get_date_interval( $tab );
                /*
                ==========================================
                    Results | Start
                ==========================================
                */
    
                //Collect data
                $results_arr = array();
                $v_answers_overall = array();
                foreach ($statistics as $key => $statistic) {
                    $vote_date = ( isset($statistic['date']) && $statistic['date'] != '' ) ?  $statistic['date']  : '';
                    $vote_count = ( isset($statistic['vote_count']) && $statistic['vote_count'] != '' ) ? intval( $statistic['vote_count'] ) : '';
                    $vote_answer = ( isset($statistic['answer']) && $statistic['answer'] != '' ) ? stripslashes( $statistic['answer'] ) : '';
                    $vote_answer_val = ( isset($statistic['answer_value']) && $statistic['answer_value'] != '' ) ? stripslashes( $statistic['answer_value'] ) : '';
                    $type = ( isset($statistic['type']) && $statistic['type'] != '' ) ? stripslashes( $statistic['type'] ) : '';
    
                    $results_arr[$vote_date]['type'] = $type;
                    $v_answers_overall['type'][] = $type;
                    if($type != 'range'){
                        $v_answers_overall['votes'][] = $vote_answer;
                        
                        if( in_array( $vote_date, $statistic ) ){
                            $results_arr[$vote_date]['vote_count'][] = $vote_count;
                            $results_arr[$vote_date]['vote_answer'][] = $vote_answer;
                        }
                    }else{
                        $v_answers_overall['votes'][] = $vote_answer_val;
                        $results_arr[$vote_date]['vote_answer_val'][] = $vote_answer_val;
                    }
                }
                $results = array();
                if($tab == 'overall'){
                        $poll_answers_overall = array();
                        if( !( in_array( 'range', $v_answers_overall['type'] ) ) ){
                            $votes_count_overall = array_count_values( $v_answers_overall['votes'] );
                            foreach ($poll_answers as $key => $poll_answer) {
                                if(! array_key_exists($poll_answer['answer'], $votes_count_overall) ){
                                    $votes_count_overall[$poll_answer['answer']] = 0;
                                }
                                $poll_answers_overall[] = $poll_answer['answer'];
                            }
                            $results['answers'] = $poll_answers_overall;
                            $results['votes'] = $votes_count_overall;
                        }else{
                            $results['answers'] = array_unique($v_answers_overall['votes']);
                            $results['votes'] = array_count_values($v_answers_overall['votes']);
                        }
                }else{  
                    //Get final data
                    foreach ($results_arr as $results_key => $result) {
                        $fs_vote_date = ( isset( $results_key ) && $results_key != '' ) ? date_i18n( get_option( 'date_format' ), strtotime(  $results_key )) : '';
                        if($result['type'] != 'range'){
                            if($result['type'] !=  'range'){                        
                                $v_count = ( isset($result['vote_count']) && !empty( $result['vote_count'] ) ) ? $result['vote_count'] : array();
                                $v_answer = ( isset($result['vote_answer']) && !empty( $result['vote_answer'] ) ) ? $result['vote_answer'] : array();
                                $fs_vote_count = array_count_values($v_count);
                                $fs_vote_answer = array_count_values($v_answer);
                
                                $answers = array();
                                foreach ($poll_answers as $poll_answer_key => $poll_answer) {
                                    if(! array_key_exists($poll_answer['answer'], $fs_vote_answer) ){
                                        $fs_vote_answer[$poll_answer['answer']] = 0;
                                    }
                                }
                            }
                            
                            $results['votes'][$fs_vote_date] = $fs_vote_answer;
                            $results['type'][$fs_vote_date] = $result['type'];
                        }else{
                            $results['votes'][$fs_vote_date] = array_count_values($result['vote_answer_val']);
                        }
                        
                    }   
                    
                    foreach ($date_interval as $key => $date) {
                        $res_date = date_i18n( get_option( 'date_format' ), strtotime(  $date ));
                        if(isset($results['votes'])){
                            if(! array_key_exists($res_date, $results['votes'])){
                                if($result['type'] != 'range'){
                                    foreach ($poll_answers as $poll_answer_key => $poll_answer) {
                                        $results['votes'][$res_date][$poll_answer['answer']] = 0;
                                    }
                                }else{
                                    foreach ($results['votes'][$fs_vote_date] as $key => $res) {
                                        $results['votes'][$res_date][$key] = 0;
                                    }
                                }
                            }
                        }
                    }
                }
                /*
                ==========================================
                    Results | End
                ==========================================
                */
            }

            return $results;
        }
    }

?>