<?php
	if ( ! defined( 'AYS_POLL_URL' ) ) {
		define( 'AYS_POLL_URL', plugins_url( plugin_basename( dirname( __FILE__ ) ) ) );
	}

	class Poll_Maker_Widget extends WP_Widget {
		private $plugin_name;
		public $poll_maker_ays;

		public function __construct() {
			$this->plugin_name = POLL_MAKER_AYS_NAME;
			$widget_ops        = array(
				'classname'   => 'poll_maker_ays',
				'description' => 'Poll Maker Widget',
			);
			parent::__construct( 'poll_maker_ays', 'Poll Maker Widget', $widget_ops );
		}

		public function form( $instance ) {

			// Check values
			if ( $instance ) {
				// $width   = esc_attr( $instance['poll_maker_ays_width'] );
				$poll_id = esc_attr( $instance['poll_maker_ays_id'] );
			} else {
				// $width   = 0;
				$poll_id = 0;
			}
			global $wpdb;
			$polls = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}ayspoll_polls", 'ARRAY_A' );

			?>
            <p>
                <select class="widefat" id="<?= $this->get_field_id( 'ays-polls' ); ?>"
                        name="<?= $this->get_field_name( 'poll_maker_ays_id' ); ?>">
                    <option value="0" selected disabled>Select poll</option>
					<?php
						foreach ( $polls as $poll ) { ?>
                            <option value="<?= $poll['id']; ?>" <?= $poll['id'] == $poll_id ? "selected" : ""; ?> >
								<?= $poll['title']; ?>
                            </option>
						<?php }
					?>
                </select>
            </p>
			<?php
		}

		public function update( $new_instance, $old_instance ) {
			$instance = $old_instance;
			// Fields
			//$instance['poll_maker_ays_id']    = absint( $new_instance['poll_maker_ays_id'] );
			//$instance['poll_maker_ays_width'] = absint( $new_instance['poll_maker_ays_width'] );

			if(isset($new_instance['poll_maker_ays_id'])){
				$instance['poll_maker_ays_id']    = absint( $new_instance['poll_maker_ays_id'] );				
			}

			return $instance;
		}

		public function widget( $args, $instance ) {

			/*$id    = $instance['poll_maker_ays_id'];
			$width = $instance['poll_maker_ays_width'];

			//Get instance of public object and generate poll
            $content = Poll_Maker_Ays_Public::get_instance()->ays_poll_generate_html($id, false, $width);*/
            $id  = $instance['poll_maker_ays_id'];

			echo $args['before_widget'];
			echo do_shortcode("[ays_poll id='".$id."']");
			echo $args['after_widget'];
		}

	}