var $jq = jQuery.noConflict();
$jq(document).ready(function() {
    // IDs do formulário
    var cep = '#user-form-apm_text_1';
    var bairro = '#user-form-apm_text_2';
    var cidade = '#user-form-apm_text_3';
    var uf = '#user-form-apm_text_4';
    var rua = '#user-form-apm_text_5';
    var regiao = '#user-form-apm_text_6'; // Campo para armazenar a região
    var formSubmit = 'button.ays-poll-btn[name="ays_finish_poll"]';
    
    // Variável para controlar quando estamos no meio de uma busca automática
    var buscaAutomatica = false;
    
// Mapeamento de bairros para regiões
 var regioes = {
        "Região 01": ["Jardim Casqueiro", "Vila Ponte Nova", "Vila Bandeirantes", "Vila dos Pescadores", "Vila Pelicas", "Parque São Luis", "Sítio São Luiz", "Rubens Lara", "São Judas Tadeu", "Vila Caraguata", "Vila São Pedro", "Vila São Benedito", "Projeto São José", "Projeto Nhapium"],
        "Região 02": ["Jardim Nova República", "Conjunto Residencial Papa João Paulo II", "Jardim Real"],
        "Região 03": ["Vila Natal", "Vila Costa Muniz", "Caminho 02", "Conjunto Residencial Mário Covas", "Vale Verde", "Vila Esperança", "Sítio Novo", "Ilha Bela", "Morro do Índio", "Imigrantes", "Vila Noel", "Morro do Pica-Pau", "Pica-Pau"],
        "Região 04": ["Vila Santa Rosa", "Vila Couto", "Vila Padre Manoel da Nóbrega", "Vila Paulista", "Vila Nova", "Curtume", "Jardim Trinta e Um de Março", "Vila São José"],
        "Região 05": ["Vila Elizabeth", "Sítio Cafezal", "Parque Fernando Jorge", "Vila Santa Tereza", "Vila Santa Úrsula", "Vila Canadá", "Três Marias", "Jardim das Américas", "Jardim das Indústrias", "Conjunto Marechal Rondon", "Jardim Costa e Silva", "Jardim Anchieta", "Jardim São Francisco", "Conjunto Afonso Schmidt", "Jardim Nossa Senhora de Fátima", "Centro"],
        "Região 06": ["Fabril", "Vila Light", "Pinhal do Miranda", "Cota 200", "Pilões", "Água Fria"],
        "Região 07": ["Mantiqueira", "Posto Paulínia", "Areais", "Zona Industrial"],
        "Região 08": ["Outras Localidades e de outras cidades"]
    };

 // Função para calcular a similaridade entre duas strings (Levenshtein distance)
function calcularSimilaridade(str1, str2) {
    // Remove acentos e coloca em minúsculas para comparação
    str1 = str1.normalize('NFD').replace(/[\u0300-\u036f]/g, '').toLowerCase();
    str2 = str2.normalize('NFD').replace(/[\u0300-\u036f]/g, '').toLowerCase();
    
    // Se uma string está contida na outra, consideramos alta similaridade
    if (str1.includes(str2) || str2.includes(str1)) {
        return 0.9;
    }
    
    // Implementação simplificada da distância de Levenshtein
    const len1 = str1.length;
    const len2 = str2.length;
    
    const matrix = [];
    for (let i = 0; i <= len1; i++) {
        matrix[i] = [i];
    }
    for (let j = 0; j <= len2; j++) {
        matrix[0][j] = j;
    }
    
    for (let i = 1; i <= len1; i++) {
        for (let j = 1; j <= len2; j++) {
            const cost = str1[i - 1] === str2[j - 1] ? 0 : 1;
            matrix[i][j] = Math.min(
                matrix[i - 1][j] + 1,     // deleção
                matrix[i][j - 1] + 1,     // inserção
                matrix[i - 1][j - 1] + cost // substituição
            );
        }
    }
    
    // Calcula a similaridade baseada na distância
    const distance = matrix[len1][len2];
    const maxLength = Math.max(len1, len2);
    return 1 - (distance / maxLength);
}

// Função para encontrar o bairro mais similar na lista
// Função para normalizar abreviações e números antes da comparação
function normalizarTexto(texto) {
    // Substitui abreviações com ou sem ponto
    texto = texto.replace(/\bav\.?\b/gi, 'Avenida');
    texto = texto.replace(/\bpq\.?\b/gi, 'Parque');
    texto = texto.replace(/\bpe\.?\b/gi, 'Padre');
    texto = texto.replace(/\bconj\.?\b/gi, 'Conjunto');
    
    // Converte outros bairros escrito incorretamente
    texto = texto.replace(/\bJardim 31 de Março\b/gi, 'Jardim Trinta e Um de Março');
    texto = texto.replace(/\bJd 31 de Março\b/gi, 'Jardim Trinta e Um de Março');
    texto = texto.replace(/\bJd. 31 de Março\b/gi, 'Jardim Trinta e Um de Março');
    texto = texto.replace(/\bJardim Carqueiro\b/gi, 'Jardim Casqueiro');
    
    return texto;
}

// Função para encontrar o bairro mais similar na lista (atualizada)
//e para normalizar abreviações e números antes da comparação
function encontrarBairroSimilar(bairroDigitado, regioes) {
    const bairroNormalizado = normalizarTexto(bairroDigitado);
    let melhorCorrespondencia = null;
    let maiorSimilaridade = 0.6; // Limiar mínimo de similaridade (60%)
    
    // Percorre todas as regiões e bairros
    for (const regiao in regioes) {
        for (const bairro of regioes[regiao]) {
            const similaridade = calcularSimilaridade(bairroNormalizado, bairro);
            
            // Se encontrou uma correspondência perfeita, retorna imediatamente
            if (similaridade === 1) {
                return bairro;
            }
            
            // Atualiza a melhor correspondência se encontrar uma mais similar
            if (similaridade > maiorSimilaridade) {
                maiorSimilaridade = similaridade;
                melhorCorrespondencia = bairro;
            }
        }
    }
    
    return melhorCorrespondencia;
}

// Modificação da função definirRegiao para usar a correspondência aproximada
function definirRegiao(bairroDigitado) {
    if (!bairroDigitado) return;
    
    // Primeiro tenta encontrar uma correspondência exata
    for (var regiaoNome in regioes) {
        if (regioes[regiaoNome].some(function(b) {
            return bairroDigitado.toLowerCase().includes(b.toLowerCase()) || 
                   b.toLowerCase().includes(bairroDigitado.toLowerCase());
        })) {
            setValorCampo(regiao, regiaoNome);
            console.log("Região definida (correspondência exata):", regiaoNome, "para bairro:", bairroDigitado);
            return;
        }
    }
    
    // Se não encontrou correspondência exata, tenta a aproximada
    const bairroCorrigido = encontrarBairroSimilar(bairroDigitado, regioes);
    if (bairroCorrigido) {
        // Encontra a região do bairro corrigido
        for (var regiaoNome in regioes) {
            if (regioes[regiaoNome].includes(bairroCorrigido)) {
                setValorCampo(regiao, regiaoNome);
                setValorCampo(bairro, bairroCorrigido); // Corrige o bairro digitado
                console.log("Região definida (correspondência aproximada):", regiaoNome, 
                           "para bairro digitado:", bairroDigitado, 
                           "corrigido para:", bairroCorrigido);
                return;
            }
        }
    }
    
    // Se não encontrou, define como Região 08 (padrão)
    setValorCampo(regiao, "Região 08");
    console.log("Nenhuma região específica encontrada para:", bairroDigitado, "- definindo como Região 08");
}
    

    // Desabilita o botão de envio inicialmente
    $jq(formSubmit).prop('disabled', true).css('opacity', '0.5');

    // Função para limpar campos específicos
    function limparCampos(incluirCEP = false) {
        if (incluirCEP) {
            $jq(cep).val('');
        }
        $jq(rua).val('');
        $jq(bairro).val('');
        $jq(cidade).val('');
        $jq(uf).val('');
        $jq(regiao).val(''); // Limpa a região também
        $jq(formSubmit).prop('disabled', true).css('opacity', '0.5');
    }
    
    // Função para obter valor real de campos que podem ter seletores múltiplos
    function getValorCampo(seletor) {
        var valor = '';
        seletor.split(',').forEach(function(sel) {
            var v = $jq(sel.trim()).val();
            if (v && v.trim() !== '') {
                valor = v.trim();
                return false; // Sai do loop forEach quando encontrar um valor
            }
        });
        return valor;
    }
    
    // Função para definir valor em campos que podem ter seletores múltiplos
    function setValorCampo(seletor, valor) {
        if (!seletor) return; // Evita erros se o seletor não existir
        
        seletor.split(',').forEach(function(sel) {
            try {
                $jq(sel.trim()).val(valor);
            } catch (e) {
                console.error("Erro ao definir valor para", sel, ":", e);
            }
        });
    }
    
    // Função para habilitar o botão de envio se todos os campos necessários estiverem preenchidos
    function verificarCampos() {
        var ruaVal = getValorCampo(rua);
        var bairroVal = getValorCampo(bairro);
        var cidadeVal = getValorCampo(cidade);
        var ufVal = getValorCampo(uf);
        var cepVal = getValorCampo(cep);
        
        if (ruaVal !== '' && bairroVal !== '' && 
            cidadeVal !== '' && ufVal !== '' && 
            cepVal !== '') {
            $jq(formSubmit).prop('disabled', false).css('opacity', '1');
            return true;
        } else {
            $jq(formSubmit).prop('disabled', true).css('opacity', '0.5');
            return false;
        }
    }

    // Evento ao digitar CEP
    $jq(cep).blur(function() {
        if (buscaAutomatica) return; // Evita loops de busca automática
        
        var cepDigitado = $jq(this).val().replace(/\D/g, '');
        
        // Se o CEP estiver vazio, não faz nada (permitirá o fluxo pelo bairro/rua)
        if (cepDigitado === '') {
            return;
        }
        
        // Valida formato do CEP
        if (cepDigitado.length !== 8) {
            alert('CEP inválido. Digite 8 números.');
            $jq(this).val('');
            limparCampos();
            return;
        }

        // Consulta ViaCEP
        buscaAutomatica = true;
        consultarCEP(cepDigitado);
    });
    
    // Função para consultar o CEP
    function consultarCEP(cepDigitado) {
        $jq.getJSON('https://viacep.com.br/ws/' + cepDigitado + '/json/?callback=?')
            .done(function(dados) {
                if (!dados.erro) {
                    // Preenche campos automaticamente
                    setValorCampo(rua, dados.logradouro || '');
                    setValorCampo(bairro, dados.bairro || '');
                    setValorCampo(cidade, dados.localidade || '');
                    setValorCampo(uf, dados.uf || '');
                    
                    // Define a região com base no bairro
                    definirRegiao(dados.bairro || '');
                    
                    verificarCampos();
                } else {
                    alert('CEP não encontrado.');
                    $jq(cep).val('');
                    limparCampos();
                }
                buscaAutomatica = false;
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.error("Erro na consulta do CEP:", textStatus, errorThrown);
                alert('Erro na consulta do CEP. Tente novamente.');
                $jq(cep).val('');
                limparCampos();
                buscaAutomatica = false;
            });
    }
    
    // Evento ao digitar e sair do campo bairro
    $jq(bairro.split(',')[0]).blur(function() {
        if (buscaAutomatica) return; // Evita loops de busca automática
        
        var bairroDigitado = getValorCampo(bairro);
        var cidadeDigitada = getValorCampo(cidade);
        var ufDigitada = getValorCampo(uf);
        var cepPreenchido = getValorCampo(cep);
        
        // Define a região sempre que o bairro for alterado
        definirRegiao(bairroDigitado);
        
        // Se o bairro estiver vazio ou o CEP já estiver preenchido, não faz busca
        if (bairroDigitado === '' || cepPreenchido !== '') {
            return;
        }
        
        // Se tiver cidade e UF preenchidas, tenta buscar o CEP genérico
        if (cidadeDigitada !== '' && ufDigitada !== '') {
            buscaAutomatica = true;
            buscarCEPGenericoBairro(ufDigitada, cidadeDigitada, bairroDigitado);
        }
    });
    
    // Evento para o campo rua
    $jq(rua).blur(function() {
        if (buscaAutomatica) return; // Evita loops de busca automática
        
        var ruaDigitada = getValorCampo(rua);
        var bairroDigitado = getValorCampo(bairro);
        var cidadeDigitada = getValorCampo(cidade);
        var ufDigitada = getValorCampo(uf);
        var cepPreenchido = getValorCampo(cep);
        
        // Se o bairro já estiver preenchido, verifica a região
        if (bairroDigitado !== '') {
            definirRegiao(bairroDigitado);
        }
        
        // Se a rua estiver vazia ou o CEP já estiver preenchido, não faz nada
        if (ruaDigitada === '' || cepPreenchido !== '') {
            return;
        }
        
        // Se tiver cidade e UF preenchidas, tenta buscar por rua
        if (cidadeDigitada !== '' && ufDigitada !== '') {
            buscaAutomatica = true;
            buscarCEPPorRua(ufDigitada, cidadeDigitada, ruaDigitada, bairroDigitado);
        }
    });
    
    // Evento para cidade e UF (buscar CEP quando outro campo já estiver preenchido)
    $jq(cidade).blur(function() {
        if (buscaAutomatica) return;
        tentarBuscarCEP();
    });
    
    $jq(uf).blur(function() {
        if (buscaAutomatica) return;
        tentarBuscarCEP();
    });
    
    // Função para tentar buscar CEP com os dados disponíveis
    function tentarBuscarCEP() {
        var bairroDigitado = getValorCampo(bairro);
        var ruaDigitada = getValorCampo(rua);
        var cidadeDigitada = getValorCampo(cidade);
        var ufDigitada = getValorCampo(uf);
        var cepPreenchido = getValorCampo(cep);
        
        // Se o bairro já estiver preenchido, verifica a região
        if (bairroDigitado !== '') {
            definirRegiao(bairroDigitado);
        }
        
        // Se o CEP já estiver preenchido, não faz nada
        if (cepPreenchido !== '') {
            return;
        }
        
        // Verifica se temos cidade e UF
        if (cidadeDigitada === '' || ufDigitada === '') {
            return;
        }
        
        // Prioriza busca por bairro
        if (bairroDigitado !== '') {
            buscaAutomatica = true;
            buscarCEPGenericoBairro(ufDigitada, cidadeDigitada, bairroDigitado);
        }
        // Se não tiver bairro mas tiver rua, busca por rua
        else if (ruaDigitada !== '') {
            buscaAutomatica = true;
            buscarCEPPorRua(ufDigitada, cidadeDigitada, ruaDigitada, "");
        }
    }
    
    // Função para buscar CEP genérico do bairro (ViaCEP API)
    function buscarCEPGenericoBairro(uf, cidade, bairroNome) {
        // Formata os parâmetros da URL
        uf = formatarParaURL(uf);
        cidade = formatarParaURL(cidade);
        bairroNome = formatarParaURL(bairroNome);
        
        var url = 'https://viacep.com.br/ws/' + uf + '/' + cidade + '/' + bairroNome + '/json/';
        
        $jq.getJSON(url + '?callback=?')
            .done(function(dados) {
                if (dados && dados.length > 0) {
                    // Encontrou um ou mais CEPs para o bairro
                    var dadosCEP = dados[0]; // Pega o primeiro CEP encontrado para o bairro
                    setValorCampo(cep, dadosCEP.cep.replace(/\D/g, ''));
                    
                    // Se a rua ainda não estiver preenchida, preenche com o logradouro genérico
                    if (getValorCampo(rua) === '') {
                        setValorCampo(rua, dadosCEP.logradouro || 'Logradouro não especificado');
                    }
                    
                    // Define a região
                    definirRegiao(bairroNome);
                    
                    verificarCampos();
                }
                buscaAutomatica = false;
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.error("Erro na busca por bairro:", textStatus, errorThrown);
                buscaAutomatica = false;
            });
    }
    
    // Função para buscar CEP pela rua (ViaCEP API)
    function buscarCEPPorRua(uf, cidade, ruaNome, bairroNome) {
        // Formata os parâmetros da URL
        uf = formatarParaURL(uf);
        cidade = formatarParaURL(cidade);
        ruaNome = formatarParaURL(ruaNome);
        
        var url = 'https://viacep.com.br/ws/' + uf + '/' + cidade + '/' + ruaNome + '/json/';
        
        $jq.getJSON(url + '?callback=?')
            .done(function(dados) {
                if (dados && dados.length > 0) {
                    // Se temos o bairro preenchido, tentamos filtrar pelo bairro especificado
                    var dadosCEPFiltrado = null;
                    
                    if (bairroNome) {
                        // Tenta encontrar um CEP que coincida com o bairro informado
                        for (var i = 0; i < dados.length; i++) {
                            if (dados[i].bairro.toUpperCase().includes(bairroNome.toUpperCase()) || 
                                bairroNome.toUpperCase().includes(dados[i].bairro.toUpperCase())) {
                                dadosCEPFiltrado = dados[i];
                                break;
                            }
                        }
                    }
                    
                    // Se não encontrou filtrado pelo bairro ou não tinha bairro informado, usa o primeiro resultado
                    var dadosCEP = dadosCEPFiltrado || dados[0];
                    
                    setValorCampo(cep, dadosCEP.cep.replace(/\D/g, ''));
                    
                    // Se o bairro ainda não estiver preenchido ou se encontramos um melhor
                    if (getValorCampo(bairro) === '' || dadosCEPFiltrado) {
                        var novoBairro = dadosCEP.bairro || bairroNome || 'Bairro não especificado';
                        setValorCampo(bairro, novoBairro);
                        definirRegiao(novoBairro);
                    }
                    
                    verificarCampos();
                }
                buscaAutomatica = false;
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                console.error("Erro na busca por rua:", textStatus, errorThrown);
                buscaAutomatica = false;
            });
    }
    
    // Função para formatar texto para URL (remover acentos e espaços extras)
    function formatarParaURL(texto) {
        // Remove acentos
        texto = texto.normalize('NFD').replace(/[\u0300-\u036f]/g, '');
        // Remove espaços extras e caracteres especiais
        texto = texto.trim().replace(/\s+/g, ' ');
        // Codifica para URL
        return encodeURIComponent(texto);
    }

    // Validação antes do envio
    $jq('form').submit(function(e) {
        if (!verificarCampos()) {
            e.preventDefault();
            alert('Preencha todos os campos de endereço corretamente antes de enviar.');
        }
    });
});


/****letras maiúsculas caso o usuário digite com letras minúsculas a rua e o bairro:*****/
document.addEventListener("DOMContentLoaded", function () {
    // Lista de preposições que devem permanecer minúsculas
    const preposicoes = ["do", "da", "de", "dos", "das", "para", "e", "com", "atrás"];

    // Lista de correções automáticas
     const correcoesEspecificas = {
        "SãO": "São",
		 "Ii": "II",
        "De": "de",
        "Travessa SãO Francisco De Assis": "Travessa São Francisco de Assis",
        "Rua SãO Francisco De Assis": "Rua São Francisco de Assis",
        "cubatao": "Cubatão",
        "cubatão": "Cubatão" // Garante que mesmo se o usuário digitar com erro parcial, será corrigido
    };
    // Captura os campos pelo ID
    const campos = [
         document.getElementById("user-form-apm_text_3"),// Cidade
        document.getElementById("user-form-apm_text_5"), // Rua
        document.getElementById("user-form-apm_text_2")  // Bairro
    ];

    // Função para capitalizar o texto corretamente e aplicar correções específicas
    function capitalizarTexto(event) {
        let palavras = event.target.value.toLowerCase().split(" ");

        event.target.value = palavras
            .map((palavra, index) => {
                // Se a palavra estiver na lista de correções, substitui pelo valor correto
                if (correcoesEspecificas[palavra]) {
                    return correcoesEspecificas[palavra];
                }
                // Se a palavra estiver na lista de preposições e não for a primeira, mantém minúscula
                return preposicoes.includes(palavra) && index !== 0 
                    ? palavra 
                    : palavra.charAt(0).toUpperCase() + palavra.slice(1);
            })
            .join(" ");
    }

    // Adiciona o evento para cada campo
    campos.forEach(campo => {
        if (campo) {
            campo.addEventListener("input", capitalizarTexto);
        }
    });
});


/**** Função para autocompletar as ruas***/

// Mapeamento bidirecional das ruas
const streetMap = {};
const cepMap = {};

// Lista de pares de ruas (formatada para evitar problemas com tabs e espaços)
const streetData = `
Rua Daniel Benes / Rua das Primaveras\t11.538-090
Rua Profº Oswaldo S. Soares / Rua das Flores\t11.538-080
Avenida Marginal Imigrantes / Av Principal\t11.540-200
Beco do Maguila / Av Principal\t11.540-200
Caminho Airton Sena / Av Principal\t11.540-200
Caminho Antonio Divino / Av Principal\t11.540-200
Caminho Arciza / Av Principal\t11.540-200
Caminho Baiana / Av Principal\t11.540-200
Caminho Barreto / Av Principal\t11.540-200
Caminho Barriga / Av Principal\t11.540-200
Caminho Benon / Av Principal\t11.540-200
Caminho Bezerra / Av Principal\t11.540-200
Caminho Bispo / Av Principal\t11.540-200
Caminho Cirilo / Av Principal\t11.540-200
Caminho Congregação do Brasil / Av Principal\t11.540-200
Caminho Chaves / Av Principal\t11.540-200
Caminho da Paz / Av Principal\t11.540-200
Caminho da Santa / Av Principal\t11.540-200
Caminho da Zezé / Av Principal\t11.540-200
Caminho Danilo Ferreira / Av Principal\t11.540-200
Caminho das Neves / Av Principal\t11.540-200
Caminho das Rosas / Av Principal\t11.540-200
Caminho de Lurdes / Av Principal\t11.540-200
Caminho Dedé / Av Principal\t11.540-200
Caminho do Amor / Av Principal\t11.540-200
Caminho do Bahia / Av Principal\t11.540-200
Caminho do Careca / Av Principal\t11.540-200
Caminho do Coqueiro / Av Principal\t11.540-200
Caminho do Gato / Av Principal\t11.540-200
Caminho do Jair / Av Principal\t11.540-200
Caminho do Mãozinha / Av Principal\t11.540-200
Caminho do Mar / Av Principal\t11.540-200
Caminho do Miro / Av Principal\t11.540-200
Caminho do Valdo / Av Principal\t11.540-200
Caminho do Xexeu / Av Principal\t11.540-200
Caminho dos Amores / Av Principal\t11.540-200
Caminho Duarte / Av Principal\t11.540-200
Caminho Edmundo / Av Principal\t11.540-200
Caminho Espírito Santo / Av Principal\t11.540-200
Caminho Firmino / Av Principal\t11.540-200
Caminho Frei Damião / Av Principal\t11.540-200
Caminho Frei Galvão / Av Principal\t11.540-200
Caminho General Osorio / Av Principal\t11.540-200
Caminho Guará Vermelho / Av Principal\t11.540-200
Caminho Ivanildo / Av Principal\t11.540-200
Caminho Liro / Av Principal\t11.540-200
Caminho Manoel Buchim / Av Principal\t11.540-200
Caminho Manoel Tenório Da Silva / Av Principal\t11.540-200
Caminho Maranhão / Av Principal\t11.540-200
Caminho Maria Araújo Trindade / Av Principal\t11.540-200
Caminho Maria Glória / Av Principal\t11.540-200
Caminho Maria José dos Santos / Av Principal\t11.540-200
Caminho Minas Gerais / Av Principal\t11.540-200
Caminho Mineirinho / Av Principal\t11.540-200
Caminho Moarir Franco / Av Principal\t11.540-200
Caminho Natal / Av Principal\t11.540-200
Caminho Neuza / Av Principal\t11.540-200
Caminho Oliveira / Av Principal\t11.540-200
Caminho Paraíba / Av Principal\t11.540-200
Caminho Paraíso / Av Principal\t11.540-200
Caminho Paraná / Av Principal\t11.540-200
Caminho Pedro Antonio / Av Principal\t11.540-200
Caminho Ponto Certo / Av Principal\t11.540-200
Caminho Raimundo / Av Principal\t11.540-200
Caminho Rio de Janeiro / Av Principal\t11.540-200
Caminho Santa Catarina / Av Principal\t11.540-200
Caminho Santa Filomena / Av Principal\t11.540-200
Caminho Santa Helena / Av Principal\t11.540-200
Caminho Santa Paula / Av Principal\t11.540-200
Caminho Santo André / Av Principal\t11.540-200
Caminho Santo Antonio / Av Principal\t11.540-200
Caminho São Braz / Av Principal\t11.540-200
Caminho São Carlos / Av Principal\t11.540-200
Caminho São Francisco / Av Principal\t11.540-200
Caminho São Genaro / Av Principal\t11.540-200
Caminho São José / Av Principal\t11.540-200
Caminho São Judas / Av Principal\t11.540-200
Caminho São Luiz / Av Principal\t11.540-200
Caminho São Manoel / Av Principal\t11.540-200
Caminho São Paulo / Av Principal\t11.540-200
Caminho São Pedro / Av Principal\t11.540-200
Caminho São Sebastião / Av Principal\t11.540-200
Caminho Sociedade / Av Principal\t11.540-200
Caminho Sossego / Av Principal\t11.540-200
Caminho Silvio Santos / Av Principal\t11.540-200
Caminho Zé do Rio / Av Principal\t11.540-200
Caminho Zezita / Av Principal\t11.540-200
Rua Beira Mar / Av Principal\t11.540-200
Rua Larissa Cockner / Av Principal\t11.540-200
Rua Larissa Rockiver / Av Principal\t11.540-200
Rua Santa Bárbara / Av Principal\t11.540-200
Rua Santa Cecília / Av Principal\t11.540-200
Rua Santa Clara / Av Principal\t11.540-200
Rua Santa Efigênia / Av Principal\t11.540-200
Rua Santa Filomena / Av Principal\t11.540-200
Rua Santa Luzia / Av Principal\t11.540-200
Rua Santa Monica / Av Principal\t11.540-200
Rua São Geraldo / Av Principal\t11.540-200
Travessa Santa Bárbara / Av Principal\t11.540-200    
Tv Santa Bárbara / Av Principal\t11.540-200
Viela B / Av Principal\t11.540-200
Viela C / Av Principal\t11.540-200
Viela D / Av Principal\t11.540-200
Viela E / Av Principal\t11.540-200
Viela F / Av Principal\t11.540-200
Viela G / Av Principal\t11.540-200
Viela I / Av Principal\t11.540-200
Viela J / Av Principal\t11.540-200
Viela L / Av Principal\t11.540-200
Viela M / Av Principal\t11.540-200
Viela N / Av Principal\t11.540-200
Viela P / Av Principal\t11.540-200
Viela Q / Av Principal\t11.540-200
Viela R / Av Principal\t11.540-200
Travessa Nossa Senhora Aparecida / Rua Nossa Senhora Aparecida\t11.523-030
Travessa Santo Antonio de Pádua / Rua Santo Antonio de Pádua\t11.523-020
Travessa São Francisco de Assis / Rua São Francisco de Assis\t11.523-000
Av. Principal / Avenida Bernardo Geisel Filho\t11.555-901
Rua Rio Grande do Sul / Avenida Bernardo Geisel Filho\t11.555-901
Rua Amazonas / Avenida Bernardo Geisel Filho\t11.555-901
Rua Pará / Avenida Bernardo Geisel Filho\t11.555-901
Rua Goias / Avenida Bernardo Geisel Filho\t11.555-901
Rua Maranhão / Avenida Bernardo Geisel Filho\t11.555-901
Rua Bahia / Avenida Bernardo Geisel Filho\t11.555-901
Rua Guanabara / Avenida Bernardo Geisel Filho\t11.555-901
Rua Parana / Avenida Bernardo Geisel Filho\t11.555-901
Rua Paraiba / Avenida Bernardo Geisel Filho\t11.555-901
Rua Minas Gerais / Avenida Bernardo Geisel Filho\t11.555-901
Rua Acre / Avenida Bernardo Geisel Filho\t11.555-901
Rua Mato Grosso / Avenida Bernardo Geisel Filho\t11.555-901
Rua Santa Catarina / Avenida Bernardo Geisel Filho\t11.555-901
Rua da Capelinha / Caminho dos Pilões\t11.543-000
Rua Direita / Rua do Alojamento\t11.543-100
Rua do Clube / Rua do Alojamento\t11.543-100
Rua do Trevo / Rua do Alojamento\t11.543-100
Rua Josef Heingrube / Rua do Alojamento\t11.543-100
Estrada de Serviços da Rffsa / Rua União\t11.570-120
`;

// Processar cada linha para preencher os mapas
streetData.trim().split('\n').forEach(line => {
    const parts = line.split('\t');
    if (parts.length === 2) {
        const streets = parts[0].trim().split(' / ');
        const cep = parts[1].trim();
        
        if (streets.length === 2) {
            streetMap[streets[0]] = streets[1];
            streetMap[streets[1]] = streets[0];
            
            cepMap[streets[0]] = cep;
            cepMap[streets[1]] = cep;
        }
    }
});

// Configurar o evento de input no campo 'rua'
document.getElementById('user-form-apm_text_5').addEventListener('input', function(e) {
    const input = this.value.trim();
    if (input.includes(' / ')) return;
    
    if (streetMap[input]) {
        this.value = `${input} / ${streetMap[input]}`;
        document.getElementById('user-form-apm_text_1').value = cepMap[input] || '';
    }
});