<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'hello-elementor','hello-elementor','hello-elementor-theme-style','hello-elementor-header-footer' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 20 );

//Função para limitar caracteres do título dos posts na home e archive
function limitar_titulo_posts($titulo, $limite = 57) {
    if (!is_single()) {
        if (mb_strlen($titulo, 'UTF-8') > $limite) {
            $titulo = mb_substr($titulo, 0, $limite, 'UTF-8') . '...';
        }
    }
    return $titulo;
}

function exibir_titulo_limitado($titulo) {
    return limitar_titulo_posts($titulo);
}
add_filter('the_title', 'exibir_titulo_limitado', 10, 1);

/*** Função para traduzir Resultado de busca ***/
function traduzir_busca_para_portugues($text) {
    $translations = array(
        'Search Results for' => 'Resultados da busca para',
        'Nothing Found' => 'Nada encontrado',
        'Sorry, but nothing matched your search terms. Please try again with some different keywords.' => 'Desculpe, mas nada correspondeu aos seus termos de busca. Por favor, tente novamente com outras palavras-chave.',
        'Search' => 'Buscar',
		'Page' => 'Página',
        'Search for:' => 'Buscar por:',
        'Search Results' => 'Resultados da Busca'
    );

    return strtr($text, $translations);
}

add_filter('gettext', 'traduzir_busca_para_portugues');
add_filter('ngettext', 'traduzir_busca_para_portugues');

/** Shortcode de minutos de leitura **/
function custom_reading_time_shortcode() {
    add_shortcode('reading_time', 'generate_reading_time');
}
add_action('init', 'custom_reading_time_shortcode');

function generate_reading_time($atts) {   
    $words_per_minute = 200; 
    $atts = shortcode_atts(array(
        'words_per_minute' => $words_per_minute
    ), $atts);     
    $content = get_the_content();       
    $content = wp_strip_all_tags($content);       
    $word_count = str_word_count($content);        
    $reading_time = ceil($word_count / $atts['words_per_minute']);       
    $reading_time_text = $reading_time . ' minutos';    
    return $reading_time_text;
}
/** Option Settings do ACF**/
//Options do ACF
if( function_exists('acf_add_options_page') ) {    
    acf_add_options_page(array(
        'page_title'    => 'Enquetes e Votações',
        'menu_title'    => 'Enquetes e Votações',
        'menu_slug'     => 'theme-general-settings',
        
    ));    
    acf_add_options_sub_page(array(
        'page_title'    => 'Enquetes e Votações',
        'menu_title'    => 'Enquetes e Votações',
        'parent_slug'   => 'theme-general-settings',
   ));   
 }

// Registrar a página de opções
/*if (function_exists('acf_add_options_page')) {
    acf_add_options_page(array(
        'page_title'    => 'Configurações da Enquete',
        'menu_title'    => 'CEPs Permitidos',
        'menu_slug'     => 'ceps-permitidos',
        'capability'    => 'edit_theme_options',
        'redirect'      => false
    ));
}
if (function_exists('acf_add_options_page')) {
    acf_add_options_page(array(
        'page_title'    => 'CEPs Permitidos - Cubatão',
        'menu_title'    => 'CEPs Permitidos',
        'menu_slug'     => 'ceps-permitidos',
        'capability'    => 'manage_options',
        'redirect'      => false
    ));
}
add_action('acf/init', 'registrar_campos_ceps');
function registrar_campos_ceps() {
    acf_add_local_field_group(array(
        'key' => 'grupo_ceps_permitidos',
        'title' => 'CEPs Autorizados',
        'fields' => array(
            array(
                'key' => 'campo_rep_ceps',
                'label' => 'Adicionar CEPs',
                'name' => 'ceps_permitidos',
                'type' => 'repeater',
                'layout' => 'block',
                'sub_fields' => array(
                    array(
                        'key' => 'campo_cep_permitido',
                        'label' => 'CEP (5 primeiros dígitos)',
                        'name' => 'cep',
                        'type' => 'text',
                        'instructions' => 'Ex: 11500 (sem hífen)',
                        'required' => 1,
                        'maxlength' => 5
                    )
                )
            )
        ),
        'location' => array(
            array(
                array(
                    'param' => 'options_page',
                    'operator' => '==',
                    'value' => 'ceps-permitidos',
                ),
            ),
        ),
    ));
}
// Passar dados para o JavaScript
function enqueue_scripts_cep() {
    wp_enqueue_script(
        'validacao-cep-script',
        get_template_directory_uri() . '/js/validacao-cep.js',
        array('jquery'),
        '1.0',
        true
    );

    // Obter CEPs do ACF
    $ceps_permitidos = array();
    if (have_rows('ceps_permitidos', 'option')) {
        while (have_rows('ceps_permitidos', 'option')) {
            the_row();
            $cep = sanitize_text_field(get_sub_field('cep'));
            if (!empty($cep)) $ceps_permitidos[] = $cep;
        }
    }

    wp_localize_script(
        'validacao-cep-script',
        'dadosCubatao',
        array(
            'cepsPermitidos' => $ceps_permitidos,
            'mensagens' => array(
                'cep_invalido' => esc_js('Formato de CEP inválido.'),
                'nao_encontrado' => esc_js('CEP não encontrado.'),
                'restrito' => esc_js('Sua região não está elegível para participar da enquete.')
            )
        )
    );
}
add_action('wp_enqueue_scripts', 'enqueue_scripts_cep');*/


// função para adicionar o arquivo script.js ao tema filho
function adicionar_meu_script() {
    wp_enqueue_script(
        'meu-script', // nome único para o script
        get_stylesheet_directory_uri() . '/app.js', // caminho para o arquivo
        array(), // dependências, se houver
        '1.0', // versão do script
        true // carregar no footer (true) ou no header (false)
    );
}
add_action('wp_enqueue_scripts', 'adicionar_meu_script');

//Função para listar posts do tipo "orcamento" filtrados por ano
include_once get_stylesheet_directory() . '/inc/filter.php';


// ======================================================
// 1. Página de administração e exportação
// ======================================================
add_action('admin_menu', 'adicionar_pagina_admin_respostas');
add_action('admin_post_exportar_respostas_csv', 'exportar_respostas_csv');

function adicionar_pagina_admin_respostas() {
    add_menu_page(
        'Respostas dos Usuários',
        'Pesquisa antiga',
        'manage_options',
        'respostas-usuarios',
        'exibir_tabela_respostas'
    );
}

function exibir_tabela_respostas() {
    $tabela = new Custom_Data_Table();
    echo '<div class="wrap">';
    echo '<h1>Respostas dos Usuários</h1>';
    echo '<a href="' . admin_url('admin-post.php?action=exportar_respostas_csv') . '" class="button-primary">Exportar para CSV</a>';
    $tabela->prepare_items();
    $tabela->display();
    echo '</div>';
}

// ======================================================
// 2. Função de exportação para CSV
// ======================================================
function exportar_respostas_csv() {
    if (!current_user_can('manage_options')) {
        wp_die('Acesso negado!');
    }

    global $wpdb;
    
    $dados = $wpdb->get_results("
        SELECT 
            u.nome,
            u.data,
            u.ip,
            u.cep,
            CONCAT(u.endereco, ', ', u.numero) AS endereco,
            u.bairro,
            u.cidade,
            u.estado,
            MAX(CASE WHEN r.peso = 1 THEN r.resposta END) AS prioridade1,
            MAX(CASE WHEN r.peso = 2 THEN r.resposta END) AS prioridade2,
            MAX(CASE WHEN r.peso = 3 THEN r.resposta END) AS prioridade3
        FROM 
            usuarios u
        INNER JOIN 
            respostasdousuario r
        ON 
            u.codorcamento = r.codorcamento 
            AND u.id = CAST(r.usuario AS UNSIGNED)
        GROUP BY u.id
    ", ARRAY_A);

    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=respostas_priorizadas_' . date('Y-m-d_H-i') . '.csv');
    
    $output = fopen('php://output', 'w');
    
    fputcsv($output, [
        'Nome', 'Data', 'IP', 'CEP', 'Endereço',
        'Bairro', 'Cidade', 'Estado', 
        'Prioridade 1', 'Prioridade 2', 'Prioridade 3'
    ], ';');
    
    foreach ($dados as $linha) {
        $linha['data'] = date('d/m/Y', strtotime($linha['data']));
        $linha['cep'] = preg_replace('/(\d{5})(\d{3})/', '$1-$2', $linha['cep']);
        
        fputcsv($output, [
            $linha['nome'],
            $linha['data'],
            $linha['ip'],
            $linha['cep'],
            $linha['endereco'],
            $linha['bairro'],
            $linha['cidade'],
            $linha['estado'],
            '"' . str_replace('"', '""', $linha['prioridade1'] ?? '—') . '"',
            '"' . str_replace('"', '""', $linha['prioridade2'] ?? '—') . '"',
            '"' . str_replace('"', '""', $linha['prioridade3'] ?? '—') . '"'
        ], ';');
    }
    
    fclose($output);
    exit;
}

// ======================================================
// 3. Classe da tabela com prioridades separadas
// ======================================================
if (!class_exists('WP_List_Table')) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class Custom_Data_Table extends WP_List_Table {

    public function get_columns() {
        return [
            'nome'          => 'Nome',
            'data'          => 'Data',
            'ip'            => 'IP',
            'cep'           => 'CEP',
            'endereco'      => 'Endereço',
            'bairro'        => 'Bairro',
            'cidade'        => 'Cidade',
            'estado'        => 'Estado',
            'prioridade1'   => '<span style="color:#d63638">Prioridade 1</span>',
            'prioridade2'   => '<span style="color:#ffb900">Prioridade 2</span>',
            'prioridade3'   => '<span style="color:#00a32a">Prioridade 3</span>'
        ];
    }

    public function prepare_items() {
        global $wpdb;

        $this->_column_headers = [
            $this->get_columns(),
            [],
            $this->get_sortable_columns()
        ];

        $data = $wpdb->get_results("
            SELECT 
                u.nome,
                u.data,
                u.ip,
                u.cep,
                CONCAT(u.endereco, ', ', u.numero) AS endereco,
                u.bairro,
                u.cidade,
                u.estado,
                MAX(CASE WHEN r.peso = 1 THEN r.resposta END) AS prioridade1,
                MAX(CASE WHEN r.peso = 2 THEN r.resposta END) AS prioridade2,
                MAX(CASE WHEN r.peso = 3 THEN r.resposta END) AS prioridade3
            FROM 
                usuarios u
            INNER JOIN 
                respostasdousuario r
            ON 
                u.codorcamento = r.codorcamento 
                AND u.id = CAST(r.usuario AS UNSIGNED)
            GROUP BY u.id
        ", ARRAY_A);

        $per_page = 20;
        $current_page = $this->get_pagenum();
        $total_items = count($data);

        $this->set_pagination_args([
            'total_items' => $total_items,
            'per_page'    => $per_page
        ]);

        $this->items = array_slice($data, (($current_page - 1) * $per_page), $per_page);
    }

    public function column_default($item, $column_name) {
        switch ($column_name) {
            case 'cep':
                return preg_replace('/(\d{5})(\d{3})/', '$1-$2', $item[$column_name]);
            case 'data':
                return date('d/m/Y', strtotime($item[$column_name]));
            case 'prioridade1':
                return '<span style="color:#d63638">' . ($item[$column_name] ?? '—') . '</span>';
            case 'prioridade2':
                return '<span style="color:#ffb900">' . ($item[$column_name] ?? '—') . '</span>';
            case 'prioridade3':
                return '<span style="color:#00a32a">' . ($item[$column_name] ?? '—') . '</span>';
            default:
                return $item[$column_name] ?? '—';
        }
    }

    public function get_sortable_columns() {
        return [
            'nome' => ['nome', false],
            'data' => ['data', true]
        ];
    }
}