<?php
function filtrar_orcamento_por_ano() {
    ob_start();
    
    // Obtém os anos disponíveis no post type "orcamento"
    global $wpdb;
    $anos = $wpdb->get_col("SELECT DISTINCT YEAR(post_date) FROM $wpdb->posts WHERE post_type = 'orcamento' AND post_status = 'publish' ORDER BY post_date DESC");
    
    ?>
    <main>
    <aside class="orcamento-sidebar">
          <div class="orcamento-space"></div>
          <form id="filtro-orcamento">
                <select id="filtro-ano">
                    <option value="">Selecione um ano</option>
                    <?php foreach ($anos as $ano) : ?>
                        <option value="<?php echo esc_attr($ano); ?>"><?php echo esc_html($ano); ?></option>
                    <?php endforeach; ?>
                </select>
            </form>
    </aside>  
    <div class="orcamento-container">
        <div class="orcamento-main">
            <div id="resultado-orcamento" data-paged="1">
                <?php echo listar_orcamentos_por_ano(); ?>
            </div>
        </div>
           
    </div>
    </main>
  
    
    <script>
    document.getElementById('filtro-ano').addEventListener('change', function() {
        carregarOrcamentos(1);
    });
    
    function carregarOrcamentos(paged) {
        var ano = document.getElementById('filtro-ano').value;
        var xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php echo admin_url('admin-ajax.php'); ?>', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4 && xhr.status === 200) {
                document.getElementById('resultado-orcamento').innerHTML = xhr.responseText;
                document.getElementById('resultado-orcamento').setAttribute('data-paged', paged);
            }
        };
        xhr.send('action=filtrar_orcamento&ano=' + ano + '&paged=' + paged);
    }
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('filtrar_orcamento', 'filtrar_orcamento_por_ano');

// Função para listar posts do tipo "orcamento" filtrados por ano com paginação
function listar_orcamentos_por_ano($ano = '', $paged = 1) {
    $posts_per_page = 9;
    $args = array(
        'post_type' => 'orcamento',
        'posts_per_page' => $posts_per_page,
        'post_status' => 'publish',
        'paged' => $paged
    );
    
    if (!empty($ano)) {
        $args['date_query'] = array(
            array(
                'year' => $ano
            )
        );
    }
    
    $query = new WP_Query($args);
    
    ob_start();
    if ($query->have_posts()) {
        echo '<div class="orcamento-list">';
        while ($query->have_posts()) {
            $query->the_post();
            echo '<div class="orcamento-item">';
            echo '<h3><a href="' . get_permalink() . '">' . get_the_title() . '</a></h3>';
            //echo '<p><strong>Autor:</strong> ' . get_the_author() . '</p>';
            echo '<p class="the-date"><strong>Data:</strong> ' . get_the_date('d/m/Y') . '</p>';
            //echo '<p><strong>Categorias:</strong> ' . get_the_category_list(', ') . '</p>';
            if (has_post_thumbnail()) {
                echo '<div>' . get_the_post_thumbnail(get_the_ID(), 'medium') . '</div>';
            }
            echo '<p>' . wp_trim_words(get_the_excerpt(), 30, '[...]') . '</p>';
            echo '</div>';
        }
        echo '</div>';
        
        // Paginação
        $total_pages = $query->max_num_pages;
        if ($total_pages > 1) {
            echo '<div class="custom-pagination">';
            if ($paged > 1) {
                echo '<button class="previous-page"  onclick="carregarOrcamentos(' . ($paged - 1) . ')">Anterior</button> ';
            }
            for ($i = 1; $i <= $total_pages; $i++) {
                echo '<button  onclick="carregarOrcamentos(' . $i . ')">' . $i . '</button> ';
            }
            if ($paged < $total_pages) {
                echo '<button class="next-page"  onclick="carregarOrcamentos(' . ($paged + 1) . ')">Próximo</button>';
            }
            echo '</div>';
        }
    } else {
        echo '<p>Nenhum orçamento encontrado.</p>';
    }
    wp_reset_postdata();
    return ob_get_clean();
}

// Função AJAX para filtrar os orçamentos com paginação
function ajax_filtrar_orcamento() {
    $ano = isset($_POST['ano']) ? sanitize_text_field($_POST['ano']) : '';
    $paged = isset($_POST['paged']) ? intval($_POST['paged']) : 1;
    echo listar_orcamentos_por_ano($ano, $paged);
    wp_die();
}
add_action('wp_ajax_filtrar_orcamento', 'ajax_filtrar_orcamento');
add_action('wp_ajax_nopriv_filtrar_orcamento', 'ajax_filtrar_orcamento');