<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\LoginLog;
use Symfony\Component\HttpFoundation\Response;

class LoginLogMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        // Só registra se for uma tentativa de login
        if ($request->is('login') && $request->isMethod('POST')) {
            $email = $request->input('email');
            $user = Auth::user();

            // Se o usuário está autenticado, foi um sucesso
            if ($user) {
                LoginLog::logAttempt($email, 'success', $user);
            } else {
                // Verifica se foi bloqueado por muitas tentativas
                $isIpBlocked = LoginLog::isIpBlocked($request->ip());
                $isEmailBlocked = LoginLog::isEmailBlocked($email);
                
                if ($isIpBlocked || $isEmailBlocked) {
                    LoginLog::logAttempt($email, 'blocked', null, 'Muitas tentativas falhadas');
                } else {
                    // Falha normal
                    $failureReason = 'Credenciais inválidas';
                    LoginLog::logAttempt($email, 'failed', null, $failureReason);
                }
            }
        }

        return $response;
    }
}
