<?php

use App\Models\SystemSetting;

if (!function_exists('setting')) {
    /**
     * Helper function para buscar configurações do sistema
     * 
     * @param string $key Chave da configuração
     * @param mixed $default Valor padrão se não encontrar
     * @return mixed
     */
    function setting(string $key, $default = null)
    {
        return SystemSetting::getValue($key, $default);
    }
}

if (!function_exists('set_setting')) {
    /**
     * Helper function para definir configurações do sistema
     * 
     * @param string $key Chave da configuração
     * @param mixed $value Valor da configuração
     * @param string|null $description Descrição da configuração
     * @param string $type Tipo do valor (text, number, boolean, url, email)
     * @return bool
     */
    function set_setting(string $key, $value, string $description = null, string $type = 'text'): bool
    {
        return SystemSetting::setValue($key, $value, $description, $type);
    }
} 