<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique()->comment('Chave única da configuração');
            $table->text('value')->nullable()->comment('Valor da configuração');
            $table->string('description')->nullable()->comment('Descrição da configuração');
            $table->string('type')->default('text')->comment('Tipo do valor: text, number, boolean, url, email');
            $table->boolean('is_active')->default(true)->comment('Se a configuração está ativa');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_settings');
    }
};
