<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('login_logs', function (Blueprint $table) {
            $table->id();
            $table->string('email')->comment('E-mail usado na tentativa de login');
            $table->string('ip_address')->nullable()->comment('Endereço IP do usuário');
            $table->string('user_agent')->nullable()->comment('User agent do navegador');
            $table->enum('status', ['success', 'failed', 'blocked'])->comment('Status da tentativa de login');
            $table->text('failure_reason')->nullable()->comment('Motivo da falha (se aplicável)');
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade')->comment('ID do usuário (se login bem-sucedido)');
            $table->timestamp('attempted_at')->useCurrent()->comment('Data/hora da tentativa');
            $table->timestamps();
            
            // Índices para melhor performance
            $table->index(['email', 'status']);
            $table->index(['ip_address', 'status']);
            $table->index('attempted_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('login_logs');
    }
};
