<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\SystemSetting;

class SystemSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            [
                'key' => 'jira_url',
                'value' => 'https://jira.exemplo.com',
                'description' => 'URL do sistema Jira para abertura de chamados',
                'type' => 'url'
            ],
            [
                'key' => 'support_email',
                'value' => 'suporte@exemplo.com',
                'description' => 'E-mail de contato do suporte técnico',
                'type' => 'email'
            ],
            [
                'key' => 'company_name',
                'value' => 'Sua Empresa',
                'description' => 'Nome da empresa',
                'type' => 'text'
            ],
            [
                'key' => 'system_version',
                'value' => '1.0.0',
                'description' => 'Versão atual do sistema',
                'type' => 'text'
            ]
        ];

        foreach ($settings as $setting) {
            SystemSetting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
