# Guia de Deploy para Hostinger

## 📁 Pastas e Arquivos que NÃO devem ser enviados

### **Pastas Principais:**
```
/node_modules/          # Dependências do Node.js (serão instaladas no servidor)
/vendor/               # Dependências do Composer (serão instaladas no servidor)
/storage/              # Arquivos temporários e logs (será criada no servidor)
/bootstrap/cache/      # Cache do Laravel (será criada no servidor)
/.git/                 # Controle de versão (não necessário no servidor)
/.idea/                # Configurações do IDE
/.vscode/              # Configurações do VS Code
/tests/                # Testes automatizados
```

### **Arquivos de Configuração Local:**
```
.env                   # Configurações locais (criar novo no servidor)
.env.backup            # Backup de configurações
.env.production        # Configurações de produção
.env.local             # Configurações locais
.env.development       # Configurações de desenvolvimento
.env.testing           # Configurações de teste
```

### **Arquivos de Sistema:**
```
*.log                  # Arquivos de log
*.cache                # Arquivos de cache
*.tmp                  # Arquivos temporários
*.bak                  # Arquivos de backup
*.sqlite               # Bancos SQLite locais
*.sqlite3              # Bancos SQLite locais
composer.phar          # Executável do Composer
```

## 🚀 Processo de Deploy

### **1. Preparação Local**

```bash
# Limpar caches
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear

# Otimizar para produção
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Gerar chave da aplicação (se não existir)
php artisan key:generate
```

### **2. Arquivos para Enviar**

**Envie apenas estas pastas e arquivos:**
```
/app/
/bootstrap/app.php
/bootstrap/providers.php
/config/
/database/
/lang/
/public/
/resources/
/routes/
/storage/ (apenas a estrutura, não o conteúdo)
/artisan
/composer.json
/composer.lock
/package.json (se usar Node.js)
```

### **3. Configuração no Servidor**

#### **A. Criar arquivo .env**
```bash
# Copie o .env.example para .env
cp .env.example .env

# Configure as variáveis de ambiente
APP_NAME="Seu Sistema"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://seudominio.com

# Banco de dados
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=seu_banco
DB_USERNAME=seu_usuario
DB_PASSWORD=sua_senha

# Cache e sessão
CACHE_DRIVER=file
SESSION_DRIVER=file
QUEUE_CONNECTION=sync

# Mail (se usar)
MAIL_MAILER=smtp
MAIL_HOST=mail.seudominio.com
MAIL_PORT=587
MAIL_USERNAME=seu_email
MAIL_PASSWORD=sua_senha
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=seu_email
MAIL_FROM_NAME="${APP_NAME}"
```

#### **B. Instalar dependências**
```bash
# Instalar dependências do PHP
composer install --optimize-autoloader --no-dev

# Se usar Node.js
npm install --production
npm run build
```

#### **C. Configurar permissões**
```bash
# Dar permissões de escrita
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
chmod 755 public/

# Se necessário, ajustar proprietário
chown -R www-data:www-data storage/
chown -R www-data:www-data bootstrap/cache/
```

#### **D. Executar migrações**
```bash
# Executar migrações
php artisan migrate --force

# Se necessário, popular dados
php artisan db:seed --force
```

#### **E. Otimizar para produção**
```bash
# Cache de configurações
php artisan config:cache

# Cache de rotas
php artisan route:cache

# Cache de views
php artisan view:cache

# Limpar caches desnecessários
php artisan config:clear
php artisan cache:clear
```

### **4. Configuração do Hostinger**

#### **A. Configurar domínio**
- Aponte o domínio para a pasta `public/`
- Configure o Document Root para: `/public_html/public/`

#### **B. Configurar .htaccess**
Crie/edite o arquivo `.htaccess` na raiz do projeto:
```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteRule ^(.*)$ public/$1 [L]
</IfModule>
```

#### **C. Configurar PHP**
- PHP 8.1 ou superior
- Extensões necessárias: `mbstring`, `openssl`, `pdo`, `tokenizer`, `xml`, `ctype`, `json`, `bcmath`

## 🔧 Comandos Úteis para Manutenção

### **Atualizar aplicação:**
```bash
# Baixar alterações
git pull origin main

# Instalar dependências
composer install --optimize-autoloader --no-dev

# Limpar caches
php artisan config:clear
php artisan cache:clear
php artisan view:clear

# Reotimizar
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### **Verificar logs:**
```bash
# Ver logs de erro
tail -f storage/logs/laravel.log

# Ver logs de login (se implementado)
php artisan tinker
App\Models\LoginLog::latest()->take(10)->get();
```

### **Backup do banco:**
```bash
# Backup manual
php artisan db:backup

# Ou usar mysqldump
mysqldump -u usuario -p banco > backup.sql
```

## ⚠️ Segurança

### **Arquivos sensíveis que NUNCA devem ser enviados:**
- `.env` (criar novo no servidor)
- `storage/logs/` (conteúdo)
- `storage/framework/cache/` (conteúdo)
- `storage/framework/sessions/` (conteúdo)
- `storage/framework/views/` (conteúdo)
- `composer.phar`
- `node_modules/`
- `vendor/`
- `.git/`

### **Configurações de segurança:**
```php
// config/app.php
'debug' => false,
'env' => 'production',

// .env
APP_DEBUG=false
APP_ENV=production
```

## 📋 Checklist de Deploy

- [ ] Arquivos sensíveis removidos
- [ ] Dependências instaladas (`composer install --no-dev`)
- [ ] Arquivo `.env` configurado
- [ ] Permissões configuradas
- [ ] Migrações executadas
- [ ] Caches otimizados
- [ ] Domínio configurado
- [ ] SSL configurado (se necessário)
- [ ] Backup realizado
- [ ] Testes realizados

## 🆘 Troubleshooting

### **Erro 500:**
- Verificar logs em `storage/logs/laravel.log`
- Verificar permissões das pastas
- Verificar configuração do `.env`

### **Erro de permissão:**
```bash
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
```

### **Erro de banco:**
- Verificar credenciais no `.env`
- Verificar se as migrações foram executadas
- Verificar se o banco existe

### **Página em branco:**
- Verificar se o Document Root está correto
- Verificar se o `.htaccess` está configurado
- Verificar logs de erro do servidor 