<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Estatísticas de Login') }}
            </h2>
            <a href="{{ route('admin.login-logs.index') }}" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                Voltar aos Logs
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Estatísticas Gerais -->
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg mb-6">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">Estatísticas Gerais</h3>
                    <div class="grid grid-cols-2 md:grid-cols-6 gap-4">
                        <div class="text-center p-4 bg-gray-50 rounded-lg">
                            <div class="text-3xl font-bold text-gray-900">{{ $stats['total'] }}</div>
                            <div class="text-sm text-gray-600">Total de Tentativas</div>
                        </div>
                        <div class="text-center p-4 bg-green-50 rounded-lg">
                            <div class="text-3xl font-bold text-green-600">{{ $stats['success'] }}</div>
                            <div class="text-sm text-gray-600">Sucessos</div>
                            @if($stats['total'] > 0)
                                <div class="text-xs text-gray-500">{{ number_format(($stats['success'] / $stats['total']) * 100, 1) }}%</div>
                            @endif
                        </div>
                        <div class="text-center p-4 bg-red-50 rounded-lg">
                            <div class="text-3xl font-bold text-red-600">{{ $stats['failed'] }}</div>
                            <div class="text-sm text-gray-600">Falhas</div>
                            @if($stats['total'] > 0)
                                <div class="text-xs text-gray-500">{{ number_format(($stats['failed'] / $stats['total']) * 100, 1) }}%</div>
                            @endif
                        </div>
                        <div class="text-center p-4 bg-orange-50 rounded-lg">
                            <div class="text-3xl font-bold text-orange-600">{{ $stats['blocked'] }}</div>
                            <div class="text-sm text-gray-600">Bloqueados</div>
                            @if($stats['total'] > 0)
                                <div class="text-xs text-gray-500">{{ number_format(($stats['blocked'] / $stats['total']) * 100, 1) }}%</div>
                            @endif
                        </div>
                        <div class="text-center p-4 bg-blue-50 rounded-lg">
                            <div class="text-3xl font-bold text-blue-600">{{ $stats['unique_ips'] }}</div>
                            <div class="text-sm text-gray-600">IPs Únicos</div>
                        </div>
                        <div class="text-center p-4 bg-purple-50 rounded-lg">
                            <div class="text-3xl font-bold text-purple-600">{{ $stats['unique_emails'] }}</div>
                            <div class="text-sm text-gray-600">E-mails Únicos</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Top IPs -->
                <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold mb-4">Top 10 IPs com Mais Tentativas</h3>
                        @if($stats['top_ips']->count() > 0)
                            <div class="space-y-3">
                                @foreach($stats['top_ips'] as $ip)
                                    <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                                        <div>
                                            <div class="font-mono text-sm">{{ $ip->ip_address }}</div>
                                            <div class="text-xs text-gray-500">{{ $ip->attempts }} tentativas</div>
                                        </div>
                                        <div class="text-right">
                                            <a href="{{ route('admin.login-logs.index', ['ip' => $ip->ip_address]) }}" class="text-blue-600 hover:text-blue-800 text-sm">
                                                Ver Logs
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <p class="text-gray-500 text-center py-4">Nenhum dado disponível.</p>
                        @endif
                    </div>
                </div>

                <!-- Top E-mails -->
                <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold mb-4">Top 10 E-mails com Mais Tentativas</h3>
                        @if($stats['top_emails']->count() > 0)
                            <div class="space-y-3">
                                @foreach($stats['top_emails'] as $email)
                                    <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                                        <div>
                                            <div class="text-sm">{{ $email->email }}</div>
                                            <div class="text-xs text-gray-500">{{ $email->attempts }} tentativas</div>
                                        </div>
                                        <div class="text-right">
                                            <a href="{{ route('admin.login-logs.index', ['email' => $email->email]) }}" class="text-blue-600 hover:text-blue-800 text-sm">
                                                Ver Logs
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <p class="text-gray-500 text-center py-4">Nenhum dado disponível.</p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Gráfico de Tentativas por Hora -->
            @if($stats['hourly_attempts']->count() > 0)
                <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg mt-6">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold mb-4">Tentativas por Hora (Últimas 24h)</h3>
                        <div class="h-64 flex items-end justify-between space-x-1">
                            @for($hour = 0; $hour < 24; $hour++)
                                @php
                                    $hourData = $stats['hourly_attempts']->where('hour', $hour)->first();
                                    $attempts = $hourData ? $hourData->attempts : 0;
                                    $maxAttempts = $stats['hourly_attempts']->max('attempts');
                                    $height = $maxAttempts > 0 ? ($attempts / $maxAttempts) * 100 : 0;
                                @endphp
                                <div class="flex-1 flex flex-col items-center">
                                    <div class="w-full bg-blue-200 rounded-t" style="height: {{ $height }}%"></div>
                                    <div class="text-xs text-gray-500 mt-1">{{ $hour }}h</div>
                                    <div class="text-xs font-semibold">{{ $attempts }}</div>
                                </div>
                            @endfor
                        </div>
                    </div>
                </div>
            @endif

            <!-- Alertas de Segurança -->
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg mt-6">
                <div class="p-6">
                    <h3 class="text-lg font-semibold mb-4">Alertas de Segurança</h3>
                    <div class="space-y-4">
                        @if($stats['blocked'] > 0)
                            <div class="flex items-center p-4 bg-orange-50 border border-orange-200 rounded-lg">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-orange-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-orange-800">
                                        {{ $stats['blocked'] }} tentativas foram bloqueadas
                                    </h3>
                                    <div class="mt-2 text-sm text-orange-700">
                                        <p>Isso indica possíveis tentativas de força bruta ou ataques automatizados.</p>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if($stats['failed'] > $stats['success'])
                            <div class="flex items-center p-4 bg-red-50 border border-red-200 rounded-lg">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-red-800">
                                        Taxa de falha alta detectada
                                    </h3>
                                    <div class="mt-2 text-sm text-red-700">
                                        <p>Mais tentativas falharam do que tiveram sucesso. Considere revisar as políticas de segurança.</p>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if($stats['unique_ips'] > 50)
                            <div class="flex items-center p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-yellow-800">
                                        Muitos IPs únicos detectados
                                    </h3>
                                    <div class="mt-2 text-sm text-yellow-700">
                                        <p>{{ $stats['unique_ips'] }} IPs únicos podem indicar tráfego anormal ou ataques distribuídos.</p>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if($stats['total'] == 0)
                            <div class="flex items-center p-4 bg-blue-50 border border-blue-200 rounded-lg">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-blue-800">
                                        Nenhuma tentativa de login registrada
                                    </h3>
                                    <div class="mt-2 text-sm text-blue-700">
                                        <p>O sistema de logs está funcionando, mas ainda não há dados para análise.</p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout> 