@section('title', 'Login')
<x-guest-layout>
    <div class="min-h-screen flex items-stretch">
        <!-- Lado esquerdo: Formulário -->
        <div class="w-full md:w-1/3 flex flex-col justify-center items-center bg-white p-8">
            <!-- Logo Placeholder -->
            <div class="mb-8 flex flex-col items-center">
                <!-- <img src="https://via.placeholder.com/80x80?text=LOGO" alt="Logo" class="mb-2 rounded-full shadow" /> -->
                <span class="text-3xl font-bold tracking-widest">L O G O</span>
            </div>
            <div class="w-full max-w-xs sm:max-w-sm md:max-w-md lg:max-w-lg">
                <x-validation-errors class="mb-4" />
                @session('status')
                    <div class="mb-4 font-medium text-sm text-green-600">
                        {{ $value }}
                    </div>
                @endsession
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    <div>
                        <x-label for="email" value="{{ __('E-mail') }}" />
                        <x-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" />
                    </div>
                    <div class="mt-4">
                        <x-label for="password" value="{{ __('Senha') }}" />
                        <x-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="current-password" />
                    </div>
                    <div class="block mt-4">
                        <label for="remember_me" class="flex items-center">
                            <x-checkbox id="remember_me" name="remember" />
                            <span class="ms-2 text-sm text-gray-600">{{ __('Manter-me conectado') }}</span>
                        </label>
                    </div>
                    <div class="flex items-center justify-between mt-4">
                        @if (Route::has('password.request'))
                            <a class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-700" href="{{ route('password.request') }}">
                                {{ __('Esqueceu sua senha?') }}
                            </a>
                        @endif
                        <button type="submit" class="ms-4 px-6 py-2 bg-green-700 text-white rounded hover:bg-green-800 focus:outline-none focus:ring-2 focus:ring-green-700">
                            {{ __('Acessar') }}
                        </button>
                    </div>
                </form>
                <!-- Texto explicativo e link para o Jira -->
                <div class="mt-8 text-sm text-gray-600">
                    Para abrir um chamado, acesse nosso <a href="{{ setting('jira_url', 'https://jira.exemplo.com') }}" target="_blank" class="text-green-700 underline hover:text-green-800">Jira</a>.<br>
                    Em caso de dúvidas, entre em contato com o suporte.
                </div>
            </div>
        </div>
        <!-- Lado direito: Imagem -->
        <div class="hidden md:flex md:w-2/3 bg-gray-100 items-center justify-center">
            <img src="https://images.unsplash.com/photo-1519389950473-47ba0277781c?auto=format&fit=crop&w=1200&q=80" alt="Imagem institucional" class="object-cover w-full h-full" />
        </div>
    </div>
</x-guest-layout>
