<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\LoginLogController;

Route::get('/', function () {
    return redirect()->route('login');
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    // Rotas administrativas para logs de login
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('/login-logs', [LoginLogController::class, 'index'])->name('login-logs.index');
        Route::get('/login-logs/stats', [LoginLogController::class, 'stats'])->name('login-logs.stats');
        Route::get('/login-logs/export', [LoginLogController::class, 'export'])->name('login-logs.export');
        Route::post('/login-logs/clear', [LoginLogController::class, 'clear'])->name('login-logs.clear');
    });
});
